/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.comparators;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.FieldComparator;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003DEFB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0016J\u0018\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0010\u0010<\u001a\u00020=2\u0006\u0010:\u001a\u00020;H\u0016J\u0015\u0010+\u001a\u0002032\u0006\u0010>\u001a\u00020\u0002H\u0017\u00a2\u0006\u0002\b?J\u0010\u0010>\u001a\u00020\u00022\u0006\u0010@\u001a\u00020\u0004H\u0016J\u0018\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u00022\u0006\u0010C\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001e\"\u0004\b(\u0010 R\u001c\u0010)\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R\u001a\u0010,\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001e\"\u0004\b.\u0010 R\u000e\u0010/\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator;", "Lorg/gnit/lucenekmp/search/FieldComparator;", "Lorg/gnit/lucenekmp/util/BytesRef;", "numHits", "", "field", "", "sortMissingLast", "", "reverse", "pruning", "Lorg/gnit/lucenekmp/search/Pruning;", "<init>", "(ILjava/lang/String;ZZLorg/gnit/lucenekmp/search/Pruning;)V", "ords", "", "getOrds", "()[I", "values", "", "getValues", "()[Lorg/gnit/lucenekmp/util/BytesRef;", "[Lorg/gnit/lucenekmp/util/BytesRef;", "tempBRs", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "[Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "readerGen", "getReaderGen", "currentReaderGen", "getCurrentReaderGen", "()I", "setCurrentReaderGen", "(I)V", "bottomValue", "getBottomValue", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setBottomValue", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "bottomSlot", "getBottomSlot", "setBottomSlot", "topValue", "getTopValue", "setTopValue", "missingSortCmp", "getMissingSortCmp", "setMissingSortCmp", "singleSort", "canSkipDocuments", "hitsThresholdReached", "disableSkipping", "", "setSingleSort", "compare", "slot1", "slot2", "getSortedDocValues", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "getLeafComparator", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "value", "setTopValueKt", "slot", "compareValues", "val1", "val2", "TermOrdValLeafComparator", "PostingsEnumAndOrd", "CompetitiveIterator", "core"})
public class TermOrdValComparator
extends FieldComparator<BytesRef> {
    @NotNull
    private final String field;
    private final boolean sortMissingLast;
    private final boolean reverse;
    @NotNull
    private final int[] ords;
    @NotNull
    private final BytesRef[] values;
    @NotNull
    private final BytesRefBuilder[] tempBRs;
    @NotNull
    private final int[] readerGen;
    private int currentReaderGen;
    @Nullable
    private BytesRef bottomValue;
    private int bottomSlot;
    @Nullable
    private BytesRef topValue;
    private int missingSortCmp;
    private boolean singleSort;
    private boolean canSkipDocuments;
    private boolean hitsThresholdReached;

    public TermOrdValComparator(int numHits, @NotNull String field, boolean sortMissingLast, boolean reverse, @NotNull Pruning pruning) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)pruning), (String)"pruning");
        this.field = field;
        this.sortMissingLast = sortMissingLast;
        this.reverse = reverse;
        this.currentReaderGen = -1;
        this.bottomSlot = -1;
        this.canSkipDocuments = pruning != Pruning.NONE;
        this.ords = new int[numHits];
        this.values = new BytesRef[numHits];
        this.tempBRs = new BytesRefBuilder[numHits];
        this.readerGen = new int[numHits];
        this.missingSortCmp = this.sortMissingLast ? 1 : -1;
    }

    @NotNull
    public final int[] getOrds() {
        return this.ords;
    }

    @NotNull
    public final BytesRef[] getValues() {
        return this.values;
    }

    @NotNull
    public final int[] getReaderGen() {
        return this.readerGen;
    }

    public final int getCurrentReaderGen() {
        return this.currentReaderGen;
    }

    public final void setCurrentReaderGen(int n) {
        this.currentReaderGen = n;
    }

    @Nullable
    public final BytesRef getBottomValue() {
        return this.bottomValue;
    }

    public final void setBottomValue(@Nullable BytesRef bytesRef) {
        this.bottomValue = bytesRef;
    }

    public final int getBottomSlot() {
        return this.bottomSlot;
    }

    public final void setBottomSlot(int n) {
        this.bottomSlot = n;
    }

    @Nullable
    public final BytesRef getTopValue() {
        return this.topValue;
    }

    @Override
    public final void setTopValue(@Nullable BytesRef bytesRef) {
        this.topValue = bytesRef;
    }

    public final int getMissingSortCmp() {
        return this.missingSortCmp;
    }

    public final void setMissingSortCmp(int n) {
        this.missingSortCmp = n;
    }

    @Override
    public void disableSkipping() {
        this.canSkipDocuments = false;
    }

    @Override
    public void setSingleSort() {
        this.singleSort = true;
    }

    @Override
    public int compare(int slot1, int slot2) {
        if (this.readerGen[slot1] == this.readerGen[slot2]) {
            return this.ords[slot1] - this.ords[slot2];
        }
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return this.missingSortCmp;
        }
        if (val2 == null) {
            return -this.missingSortCmp;
        }
        return val1.compareTo(val2);
    }

    @NotNull
    protected final SortedDocValues getSortedDocValues(@NotNull LeafReaderContext context, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return DocValues.INSTANCE.getSorted(context.reader(), field);
    }

    @Override
    @NotNull
    public LeafFieldComparator getLeafComparator(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int n = this.currentReaderGen;
        this.currentReaderGen = n + 1;
        return new TermOrdValLeafComparator(context, this.getSortedDocValues(context, this.field));
    }

    @JvmName(name="setTopValueKt")
    public void setTopValueKt(@NotNull BytesRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.topValue = value;
    }

    @Override
    @NotNull
    public BytesRef value(int slot) {
        BytesRef bytesRef = this.values[slot];
        Intrinsics.checkNotNull((Object)bytesRef);
        return bytesRef;
    }

    @Override
    public int compareValues(@NotNull BytesRef val1, @NotNull BytesRef val2) {
        Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
        Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
        return val1.compareTo(val2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rJ\u0016\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator$CompetitiveIterator;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "field", "", "dense", "", "docValuesTerms", "Lorg/gnit/lucenekmp/index/TermsEnum;", "<init>", "(Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator;Lorg/gnit/lucenekmp/index/LeafReaderContext;Ljava/lang/String;ZLorg/gnit/lucenekmp/index/TermsEnum;)V", "MAX_TERMS", "", "maxDoc", "doc", "postings", "Lkotlin/collections/ArrayDeque;", "Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator$PostingsEnumAndOrd;", "docsWithField", "disjunction", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "docID", "nextDoc", "advance", "target", "intoBitSet", "", "upTo", "bitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "offset", "cost", "", "update", "minOrd", "maxOrd", "init", "core"})
    @SourceDebugExtension(value={"SMAP\nTermOrdValComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermOrdValComparator.kt\norg/gnit/lucenekmp/search/comparators/TermOrdValComparator$CompetitiveIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,584:1\n1#2:585\n*E\n"})
    private final class CompetitiveIterator
    extends DocIdSetIterator {
        @NotNull
        private final LeafReaderContext context;
        @NotNull
        private final String field;
        private final boolean dense;
        @NotNull
        private final TermsEnum docValuesTerms;
        private final int MAX_TERMS;
        private final int maxDoc;
        private int doc;
        @Nullable
        private ArrayDeque<PostingsEnumAndOrd> postings;
        @Nullable
        private DocIdSetIterator docsWithField;
        @Nullable
        private PriorityQueue<PostingsEnumAndOrd> disjunction;

        public CompetitiveIterator(@NotNull LeafReaderContext context, String field, @NotNull boolean dense, TermsEnum docValuesTerms) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)docValuesTerms, (String)"docValuesTerms");
            this.context = context;
            this.field = field;
            this.dense = dense;
            this.docValuesTerms = docValuesTerms;
            this.MAX_TERMS = 1024;
            this.maxDoc = this.context.reader().maxDoc();
            this.doc = -1;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID() + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            int n;
            if (target >= this.maxDoc) {
                int n2;
                int it = n2 = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n2;
            }
            if (this.disjunction == null) {
                int n3;
                if (this.docsWithField != null) {
                    int n4;
                    if (!(!this.dense)) {
                        String it = "Failed requirement.";
                        throw new IllegalArgumentException(it.toString());
                    }
                    DocIdSetIterator docIdSetIterator = this.docsWithField;
                    Intrinsics.checkNotNull((Object)docIdSetIterator);
                    int it = n4 = docIdSetIterator.advance(target);
                    boolean bl = false;
                    this.doc = it;
                    return n4;
                }
                int it = n3 = target;
                boolean bl = false;
                this.doc = it;
                return n3;
            }
            PriorityQueue<PostingsEnumAndOrd> priorityQueue = this.disjunction;
            Intrinsics.checkNotNull(priorityQueue);
            PostingsEnumAndOrd top = priorityQueue.top();
            if (top == null) {
                int n5;
                int it = n5 = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n5;
            }
            while (true) {
                PostingsEnumAndOrd postingsEnumAndOrd = top;
                Intrinsics.checkNotNull((Object)postingsEnumAndOrd);
                if (postingsEnumAndOrd.getPostings().docID() >= target) break;
                top.getPostings().advance(target);
                PriorityQueue<PostingsEnumAndOrd> priorityQueue2 = this.disjunction;
                Intrinsics.checkNotNull(priorityQueue2);
                top = priorityQueue2.updateTop();
            }
            int it = n = top.getPostings().docID();
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public void intoBitSet(int upTo, @NotNull FixedBitSet bitSet, int offset) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
            int upTo2 = upTo;
            if (upTo2 <= this.doc) {
                return;
            }
            if (this.disjunction == null) {
                if (this.docsWithField != null) {
                    DocIdSetIterator docIdSetIterator = this.docsWithField;
                    Intrinsics.checkNotNull((Object)docIdSetIterator);
                    docIdSetIterator.intoBitSet(upTo2, bitSet, offset);
                    DocIdSetIterator docIdSetIterator2 = this.docsWithField;
                    Intrinsics.checkNotNull((Object)docIdSetIterator2);
                    this.doc = docIdSetIterator2.docID();
                } else {
                    upTo2 = Math.min(upTo2, this.maxDoc);
                    bitSet.set(this.doc - offset, upTo2 - offset);
                    this.doc = upTo2;
                }
            } else {
                super.intoBitSet(upTo2, bitSet, offset);
            }
        }

        @Override
        public long cost() {
            return this.context.reader().maxDoc();
        }

        /*
         * Unable to fully structure code
         */
        public final void update(int minOrd, int maxOrd) throws IOException {
            block10: {
                block11: {
                    block9: {
                        maxTerms = Math.min(this.MAX_TERMS, IndexSearcher.Companion.getMaxClauseCount());
                        size = Math.max(0, maxOrd - minOrd + 1);
                        if (size <= maxTerms) break block9;
                        if (!this.dense && this.docsWithField == null) {
                            this.docsWithField = TermOrdValComparator.this.getSortedDocValues(this.context, this.field);
                        }
                        break block10;
                    }
                    if (this.postings != null) break block11;
                    this.init(minOrd, maxOrd);
                    break block10;
                }
                v0 = this.postings;
                Intrinsics.checkNotNull(v0);
                if (size >= v0.size()) break block10;
                v1 = this.postings;
                Intrinsics.checkNotNull(v1);
                if (v1.isEmpty()) ** GOTO lbl-1000
                v2 = this.postings;
                Intrinsics.checkNotNull(v2);
                if (((PostingsEnumAndOrd)v2.first()).getOrd() <= minOrd) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                if (!v3) {
                    var5_5 = "Failed requirement.";
                    throw new IllegalArgumentException(var5_5.toString());
                }
                while (true) {
                    v4 = this.postings;
                    Intrinsics.checkNotNull(v4);
                    if (v4.isEmpty()) break;
                    v5 = this.postings;
                    Intrinsics.checkNotNull(v5);
                    if (((PostingsEnumAndOrd)v5.first()).getOrd() >= minOrd) break;
                    v6 = this.postings;
                    Intrinsics.checkNotNull(v6);
                    v6.removeFirst();
                }
                v7 = this.postings;
                Intrinsics.checkNotNull(v7);
                if (v7.isEmpty()) ** GOTO lbl-1000
                v8 = this.postings;
                Intrinsics.checkNotNull(v8);
                if (((PostingsEnumAndOrd)v8.last()).getOrd() >= maxOrd) lbl-1000:
                // 2 sources

                {
                    v9 = true;
                } else {
                    v9 = false;
                }
                if (!v9) {
                    var5_6 = "Failed requirement.";
                    throw new IllegalArgumentException(var5_6.toString());
                }
                while (true) {
                    v10 = this.postings;
                    Intrinsics.checkNotNull(v10);
                    if (v10.isEmpty()) break;
                    v11 = this.postings;
                    Intrinsics.checkNotNull(v11);
                    if (((PostingsEnumAndOrd)v11.last()).getOrd() <= maxOrd) break;
                    v12 = this.postings;
                    Intrinsics.checkNotNull(v12);
                    v12.removeLast();
                }
                v13 = this.disjunction;
                Intrinsics.checkNotNull(v13);
                v13.clear();
                v14 = this.disjunction;
                Intrinsics.checkNotNull(v14);
                v15 = this.postings;
                Intrinsics.checkNotNull(v15);
                v14.addAll((Collection)v15);
            }
        }

        public final void init(int minOrd, int maxOrd) throws IOException {
            int n = 0;
            int n2 = maxOrd - minOrd + 1;
            int size2 = Math.max(n, n2);
            this.postings = new ArrayDeque(size2);
            if (size2 > 0) {
                this.docValuesTerms.seekExact(minOrd);
                BytesRef bytesRef = this.docValuesTerms.term();
                Intrinsics.checkNotNull((Object)bytesRef);
                BytesRef minTerm = bytesRef;
                Terms terms = this.context.reader().terms(this.field);
                Intrinsics.checkNotNull((Object)terms);
                TermsEnum terms2 = terms.iterator();
                if (!terms2.seekExact(minTerm)) {
                    boolean $i$a$-check-TermOrdValComparator$CompetitiveIterator$init$22 = false;
                    String $i$a$-check-TermOrdValComparator$CompetitiveIterator$init$22 = "Term " + minTerm + " exists in doc values but not in the terms index";
                    throw new IllegalStateException($i$a$-check-TermOrdValComparator$CompetitiveIterator$init$22.toString());
                }
                ArrayDeque<PostingsEnumAndOrd> arrayDeque = this.postings;
                Intrinsics.checkNotNull(arrayDeque);
                arrayDeque.add((Object)new PostingsEnumAndOrd(terms2.postings(null, 0), minOrd));
                int ord = minOrd + 1;
                if (ord <= maxOrd) {
                    while (true) {
                        BytesRef next;
                        if ((next = terms2.next()) == null) {
                            boolean bl = false;
                            String string = "Terms have more than " + ord + " unique terms while doc values have exactly " + ord + " terms";
                            throw new IllegalStateException(string.toString());
                        }
                        if (!(this.docValuesTerms.seekExact(next) && this.docValuesTerms.ord() == (long)ord)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        ArrayDeque<PostingsEnumAndOrd> arrayDeque2 = this.postings;
                        Intrinsics.checkNotNull(arrayDeque2);
                        arrayDeque2.add((Object)new PostingsEnumAndOrd(terms2.postings(null, 0), ord));
                        if (ord == maxOrd) break;
                        ++ord;
                    }
                }
            }
            this.disjunction = new PriorityQueue<PostingsEnumAndOrd>(size2){

                public boolean lessThan(PostingsEnumAndOrd a, PostingsEnumAndOrd b) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    return a.getPostings().docID() < b.getPostings().docID();
                }
            };
            PriorityQueue<PostingsEnumAndOrd> priorityQueue = this.disjunction;
            Intrinsics.checkNotNull(priorityQueue);
            ArrayDeque<PostingsEnumAndOrd> arrayDeque = this.postings;
            Intrinsics.checkNotNull(arrayDeque);
            priorityQueue.addAll((Collection)arrayDeque);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator$PostingsEnumAndOrd;", "", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "ord", "", "<init>", "(Lorg/gnit/lucenekmp/index/PostingsEnum;I)V", "getPostings", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "getOrd", "()I", "core"})
    private static final class PostingsEnumAndOrd {
        @NotNull
        private final PostingsEnum postings;
        private final int ord;

        public PostingsEnumAndOrd(@NotNull PostingsEnum postings, int ord) {
            Intrinsics.checkNotNullParameter((Object)postings, (String)"postings");
            this.postings = postings;
            this.ord = ord;
        }

        @NotNull
        public final PostingsEnum getPostings() {
            return this.postings;
        }

        public final int getOrd() {
            return this.ord;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012H\u0016J\u0018\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012H\u0016J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0012H\u0016J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012H\u0016J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0016J\u0006\u00101\u001a\u00020'J\b\u0010 \u001a\u000202H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u001a\u0010\u001a\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\u0014\u0010 \u001a\b\u0018\u00010!R\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator$TermOrdValLeafComparator;", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "values", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "<init>", "(Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator;Lorg/gnit/lucenekmp/index/LeafReaderContext;Lorg/gnit/lucenekmp/index/SortedDocValues;)V", "termsIndex", "getTermsIndex", "()Lorg/gnit/lucenekmp/index/SortedDocValues;", "bottomSameReader", "", "getBottomSameReader", "()Z", "setBottomSameReader", "(Z)V", "bottomOrd", "", "getBottomOrd", "()I", "setBottomOrd", "(I)V", "topSameReader", "getTopSameReader", "setTopSameReader", "topOrd", "getTopOrd", "setTopOrd", "missingOrd", "getMissingOrd", "setMissingOrd", "competitiveIterator", "Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator$CompetitiveIterator;", "Lorg/gnit/lucenekmp/search/comparators/TermOrdValComparator;", "dense", "getOrdForDoc", "doc", "setHitsThresholdReached", "", "compareBottom", "copy", "slot", "setBottom", "bottom", "compareTop", "setScorer", "scorer", "Lorg/gnit/lucenekmp/search/Scorable;", "updateCompetitiveIterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "core"})
    @SourceDebugExtension(value={"SMAP\nTermOrdValComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermOrdValComparator.kt\norg/gnit/lucenekmp/search/comparators/TermOrdValComparator$TermOrdValLeafComparator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,584:1\n1#2:585\n*E\n"})
    private final class TermOrdValLeafComparator
    implements LeafFieldComparator {
        @NotNull
        private final SortedDocValues termsIndex;
        private boolean bottomSameReader;
        private int bottomOrd;
        private boolean topSameReader;
        private int topOrd;
        private int missingOrd;
        @Nullable
        private CompetitiveIterator competitiveIterator;
        private boolean dense;

        public TermOrdValLeafComparator(@NotNull LeafReaderContext context, SortedDocValues values2) {
            CompetitiveIterator competitiveIterator2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            this.termsIndex = values2;
            int n = this.missingOrd = TermOrdValComparator.this.sortMissingLast ? Integer.MAX_VALUE : -1;
            if (TermOrdValComparator.this.getTopValue() != null) {
                BytesRef bytesRef = TermOrdValComparator.this.getTopValue();
                Intrinsics.checkNotNull((Object)bytesRef);
                int ord = this.termsIndex.lookupTerm(bytesRef);
                if (ord >= 0) {
                    this.topSameReader = true;
                    this.topOrd = ord;
                } else {
                    this.topSameReader = false;
                    this.topOrd = -ord - 2;
                }
            } else {
                this.topOrd = this.missingOrd;
                this.topSameReader = true;
            }
            if (TermOrdValComparator.this.getBottomSlot() != -1) {
                this.setBottom(TermOrdValComparator.this.getBottomSlot());
            }
            boolean enableSkipping = false;
            if (!TermOrdValComparator.this.canSkipDocuments) {
                this.dense = false;
                enableSkipping = false;
            } else {
                FieldInfo fieldInfo = context.reader().getFieldInfos().fieldInfo(TermOrdValComparator.this.field);
                if (fieldInfo == null) {
                    boolean bl = this.termsIndex.getValueCount() == 0;
                    TermOrdValComparator termOrdValComparator = TermOrdValComparator.this;
                    if (!bl) {
                        boolean bl2 = false;
                        String string = "Field [" + termOrdValComparator.field + "] cannot be found in field infos";
                        throw new IllegalStateException(string.toString());
                    }
                    this.dense = false;
                    enableSkipping = true;
                } else if (fieldInfo.getIndexOptions() == IndexOptions.NONE) {
                    this.dense = false;
                    enableSkipping = false;
                } else {
                    Terms terms = context.reader().terms(TermOrdValComparator.this.field);
                    boolean bl = this.dense = terms != null && terms.getDocCount() == context.reader().maxDoc();
                    boolean bl3 = this.dense || TermOrdValComparator.this.getTopValue() != null ? true : (enableSkipping = TermOrdValComparator.this.reverse != TermOrdValComparator.this.sortMissingLast);
                }
            }
            if (enableSkipping) {
                String string = TermOrdValComparator.this.field;
                TermsEnum termsEnum = values2.termsEnum();
                Intrinsics.checkNotNull((Object)termsEnum);
                competitiveIterator2 = new CompetitiveIterator(context, string, this.dense, termsEnum);
            } else {
                competitiveIterator2 = null;
            }
            this.competitiveIterator = competitiveIterator2;
            this.updateCompetitiveIterator();
        }

        @NotNull
        public final SortedDocValues getTermsIndex() {
            return this.termsIndex;
        }

        public final boolean getBottomSameReader() {
            return this.bottomSameReader;
        }

        public final void setBottomSameReader(boolean bl) {
            this.bottomSameReader = bl;
        }

        public final int getBottomOrd() {
            return this.bottomOrd;
        }

        public final void setBottomOrd(int n) {
            this.bottomOrd = n;
        }

        public final boolean getTopSameReader() {
            return this.topSameReader;
        }

        public final void setTopSameReader(boolean bl) {
            this.topSameReader = bl;
        }

        public final int getTopOrd() {
            return this.topOrd;
        }

        public final void setTopOrd(int n) {
            this.topOrd = n;
        }

        public final int getMissingOrd() {
            return this.missingOrd;
        }

        public final void setMissingOrd(int n) {
            this.missingOrd = n;
        }

        public final int getOrdForDoc(int doc) throws IOException {
            return this.termsIndex.advanceExact(doc) ? this.termsIndex.ordValue() : -1;
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            TermOrdValComparator.this.hitsThresholdReached = true;
            this.updateCompetitiveIterator();
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            if (!(TermOrdValComparator.this.getBottomSlot() != -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int docOrd = this.getOrdForDoc(doc);
            if (docOrd == -1) {
                docOrd = this.missingOrd;
            }
            return this.bottomSameReader ? this.bottomOrd - docOrd : (this.bottomOrd >= docOrd ? 1 : -1);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            int ord = this.getOrdForDoc(doc);
            if (ord == -1) {
                ord = this.missingOrd;
                TermOrdValComparator.this.getValues()[slot] = null;
            } else {
                if (!(ord >= 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (TermOrdValComparator.this.tempBRs[slot] == null) {
                    ((TermOrdValComparator)TermOrdValComparator.this).tempBRs[slot] = new BytesRefBuilder();
                }
                BytesRefBuilder bytesRefBuilder = TermOrdValComparator.this.tempBRs[slot];
                Intrinsics.checkNotNull((Object)bytesRefBuilder);
                BytesRef bytesRef = this.termsIndex.lookupOrd(ord);
                Intrinsics.checkNotNull((Object)bytesRef);
                bytesRefBuilder.copyBytes(bytesRef);
                BytesRef[] bytesRefArray = TermOrdValComparator.this.getValues();
                BytesRefBuilder bytesRefBuilder2 = TermOrdValComparator.this.tempBRs[slot];
                Intrinsics.checkNotNull((Object)bytesRefBuilder2);
                bytesRefArray[slot] = bytesRefBuilder2.get();
            }
            TermOrdValComparator.this.getOrds()[slot] = ord;
            TermOrdValComparator.this.getReaderGen()[slot] = TermOrdValComparator.this.getCurrentReaderGen();
        }

        @Override
        public void setBottom(int bottom) throws IOException {
            TermOrdValComparator.this.setBottomSlot(bottom);
            TermOrdValComparator.this.setBottomValue(TermOrdValComparator.this.getValues()[TermOrdValComparator.this.getBottomSlot()]);
            if (TermOrdValComparator.this.getCurrentReaderGen() == TermOrdValComparator.this.getReaderGen()[TermOrdValComparator.this.getBottomSlot()]) {
                this.bottomOrd = TermOrdValComparator.this.getOrds()[TermOrdValComparator.this.getBottomSlot()];
                this.bottomSameReader = true;
            } else if (TermOrdValComparator.this.getBottomValue() == null) {
                if (!(TermOrdValComparator.this.getOrds()[TermOrdValComparator.this.getBottomSlot()] == this.missingOrd)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.bottomOrd = this.missingOrd;
                this.bottomSameReader = true;
                TermOrdValComparator.this.getReaderGen()[TermOrdValComparator.this.getBottomSlot()] = TermOrdValComparator.this.getCurrentReaderGen();
            } else {
                BytesRef bytesRef = TermOrdValComparator.this.getBottomValue();
                Intrinsics.checkNotNull((Object)bytesRef);
                int ord = this.termsIndex.lookupTerm(bytesRef);
                if (ord < 0) {
                    this.bottomOrd = -ord - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = ord;
                    this.bottomSameReader = true;
                    TermOrdValComparator.this.getReaderGen()[TermOrdValComparator.this.getBottomSlot()] = TermOrdValComparator.this.getCurrentReaderGen();
                    TermOrdValComparator.this.getOrds()[TermOrdValComparator.this.getBottomSlot()] = this.bottomOrd;
                }
            }
            this.updateCompetitiveIterator();
        }

        @Override
        public int compareTop(int doc) throws IOException {
            int ord = this.getOrdForDoc(doc);
            if (ord == -1) {
                ord = this.missingOrd;
            }
            return this.topSameReader ? this.topOrd - ord : (ord <= this.topOrd ? 1 : -1);
        }

        @Override
        public void setScorer(@NotNull Scorable scorer2) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        }

        public final void updateCompetitiveIterator() throws IOException {
            if (this.competitiveIterator == null || !TermOrdValComparator.this.hitsThresholdReached || TermOrdValComparator.this.getBottomSlot() == -1) {
                return;
            }
            int minOrd = 0;
            int maxOrd = 0;
            if (!TermOrdValComparator.this.reverse) {
                int n = TermOrdValComparator.this.getTopValue() != null ? (this.topSameReader ? this.topOrd : this.topOrd + 1) : (minOrd = TermOrdValComparator.this.sortMissingLast || this.dense ? 0 : -1);
                maxOrd = this.bottomOrd == this.missingOrd ? (TermOrdValComparator.this.singleSort ? this.termsIndex.getValueCount() - 1 : Integer.MAX_VALUE) : (this.bottomSameReader ? (TermOrdValComparator.this.singleSort ? this.bottomOrd - 1 : this.bottomOrd) : this.bottomOrd);
            } else {
                int n = this.bottomOrd == this.missingOrd ? (TermOrdValComparator.this.singleSort ? 0 : -1) : (this.bottomSameReader ? (TermOrdValComparator.this.singleSort ? this.bottomOrd + 1 : this.bottomOrd) : (minOrd = this.bottomOrd + 1));
                int n2 = TermOrdValComparator.this.getTopValue() != null ? this.topOrd : (maxOrd = !TermOrdValComparator.this.sortMissingLast || this.dense ? this.termsIndex.getValueCount() - 1 : Integer.MAX_VALUE);
            }
            if (minOrd == -1 || maxOrd == Integer.MAX_VALUE) {
                return;
            }
            if (!(minOrd >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(maxOrd < this.termsIndex.getValueCount())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            CompetitiveIterator competitiveIterator2 = this.competitiveIterator;
            Intrinsics.checkNotNull((Object)competitiveIterator2);
            competitiveIterator2.update(minOrd, maxOrd);
        }

        @Override
        @NotNull
        public DocIdSetIterator competitiveIterator() {
            CompetitiveIterator competitiveIterator2 = this.competitiveIterator;
            Intrinsics.checkNotNull((Object)competitiveIterator2);
            return competitiveIterator2;
        }
    }
}

