/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.knn;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.AbstractKnnCollector;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.util.hnsw.BlockingFloatHeap;
import org.gnit.lucenekmp.util.hnsw.FloatHeap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\rJ\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/search/knn/MultiLeafKnnCollector;", "Lorg/gnit/lucenekmp/search/KnnCollector$Decorator;", "k", "", "greediness", "", "interval", "globalSimilarityQueue", "Lorg/gnit/lucenekmp/util/hnsw/BlockingFloatHeap;", "subCollector", "Lorg/gnit/lucenekmp/search/AbstractKnnCollector;", "<init>", "(IFILorg/gnit/lucenekmp/util/hnsw/BlockingFloatHeap;Lorg/gnit/lucenekmp/search/AbstractKnnCollector;)V", "(ILorg/gnit/lucenekmp/util/hnsw/BlockingFloatHeap;Lorg/gnit/lucenekmp/search/AbstractKnnCollector;)V", "nonCompetitiveQueue", "Lorg/gnit/lucenekmp/util/hnsw/FloatHeap;", "updatesQueue", "updatesScratch", "", "kResultsCollected", "", "cachedGlobalMinSim", "collect", "docId", "similarity", "minCompetitiveSimilarity", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMultiLeafKnnCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiLeafKnnCollector.kt\norg/gnit/lucenekmp/search/knn/MultiLeafKnnCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class MultiLeafKnnCollector
extends KnnCollector.Decorator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingFloatHeap globalSimilarityQueue;
    @NotNull
    private final FloatHeap nonCompetitiveQueue;
    @NotNull
    private final FloatHeap updatesQueue;
    @NotNull
    private final float[] updatesScratch;
    private final int interval;
    private boolean kResultsCollected;
    private float cachedGlobalMinSim;
    @NotNull
    private final AbstractKnnCollector subCollector;
    private static final float DEFAULT_GREEDINESS = 0.9f;
    private static final int DEFAULT_INTERVAL = 255;

    public MultiLeafKnnCollector(int k, float greediness, int interval, @NotNull BlockingFloatHeap globalSimilarityQueue, @NotNull AbstractKnnCollector subCollector) {
        Intrinsics.checkNotNullParameter((Object)globalSimilarityQueue, (String)"globalSimilarityQueue");
        Intrinsics.checkNotNullParameter((Object)subCollector, (String)"subCollector");
        super(subCollector);
        this.cachedGlobalMinSim = Float.NEGATIVE_INFINITY;
        if (!(!(greediness < 0.0f) && !(greediness > 1.0f))) {
            boolean $i$a$-require-MultiLeafKnnCollector$32 = false;
            String $i$a$-require-MultiLeafKnnCollector$32 = "greediness must be in [0,1]";
            throw new IllegalArgumentException($i$a$-require-MultiLeafKnnCollector$32.toString());
        }
        if (!(interval > 0)) {
            boolean bl = false;
            String string = "interval must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        this.interval = interval;
        this.subCollector = subCollector;
        this.globalSimilarityQueue = globalSimilarityQueue;
        this.nonCompetitiveQueue = new FloatHeap(java.lang.Math.max(1, Math.INSTANCE.round((1.0f - greediness) * (float)k)));
        this.updatesQueue = new FloatHeap(k);
        this.updatesScratch = new float[k];
    }

    public MultiLeafKnnCollector(int k, @NotNull BlockingFloatHeap globalSimilarityQueue, @NotNull AbstractKnnCollector subCollector) {
        Intrinsics.checkNotNullParameter((Object)globalSimilarityQueue, (String)"globalSimilarityQueue");
        Intrinsics.checkNotNullParameter((Object)subCollector, (String)"subCollector");
        this(k, 0.9f, 255, globalSimilarityQueue, subCollector);
    }

    @Override
    public boolean collect(int docId, float similarity) {
        int len;
        boolean firstKResultsCollected;
        boolean localSimUpdated = this.subCollector.collect(docId, similarity);
        boolean bl = firstKResultsCollected = !this.kResultsCollected && this.subCollector.numCollected() == this.k();
        if (firstKResultsCollected) {
            this.kResultsCollected = true;
        }
        this.updatesQueue.offer(similarity);
        boolean globalSimUpdated = this.nonCompetitiveQueue.offer(similarity);
        if (this.kResultsCollected && (firstKResultsCollected || (this.subCollector.visitedCount() & (long)this.interval) == 0L) && (len = this.updatesQueue.size()) > 0) {
            for (int i = 0; i < len; ++i) {
                this.updatesScratch[i] = this.updatesQueue.poll();
            }
            if (!(this.updatesQueue.size() == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.cachedGlobalMinSim = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Float>, Object>(this, len, null){
                int label;
                final /* synthetic */ MultiLeafKnnCollector this$0;
                final /* synthetic */ int $len;
                {
                    this.this$0 = $receiver;
                    this.$len = $len;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = MultiLeafKnnCollector.access$getGlobalSimilarityQueue$p(this.this$0).offer(MultiLeafKnnCollector.access$getUpdatesScratch$p(this.this$0), this.$len, (Continuation<? super Float>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Float> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null)).floatValue();
            globalSimUpdated = true;
        }
        return localSimUpdated || globalSimUpdated;
    }

    @Override
    public float minCompetitiveSimilarity() {
        if (!this.kResultsCollected) {
            return Float.NEGATIVE_INFINITY;
        }
        return java.lang.Math.max(this.subCollector.minCompetitiveSimilarity(), java.lang.Math.min(this.nonCompetitiveQueue.peek(), this.cachedGlobalMinSim));
    }

    @NotNull
    public String toString() {
        return "MultiLeafKnnCollector[subCollector=" + this.subCollector + "]";
    }

    public static final /* synthetic */ BlockingFloatHeap access$getGlobalSimilarityQueue$p(MultiLeafKnnCollector $this) {
        return $this.globalSimilarityQueue;
    }

    public static final /* synthetic */ float[] access$getUpdatesScratch$p(MultiLeafKnnCollector $this) {
        return $this.updatesScratch;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/knn/MultiLeafKnnCollector$Companion;", "", "<init>", "()V", "DEFAULT_GREEDINESS", "", "DEFAULT_INTERVAL", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

