/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.knn;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.search.TopKnnCollector;
import org.gnit.lucenekmp.search.knn.KnnCollectorManager;
import org.gnit.lucenekmp.search.knn.KnnSearchStrategy;
import org.gnit.lucenekmp.search.knn.MultiLeafKnnCollector;
import org.gnit.lucenekmp.util.hnsw.BlockingFloatHeap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/knn/TopKnnCollectorManager;", "Lorg/gnit/lucenekmp/search/knn/KnnCollectorManager;", "k", "", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "<init>", "(ILorg/gnit/lucenekmp/search/IndexSearcher;)V", "globalScoreQueue", "Lorg/gnit/lucenekmp/util/hnsw/BlockingFloatHeap;", "newCollector", "Lorg/gnit/lucenekmp/search/KnnCollector;", "visitedLimit", "searchStrategy", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "core"})
public final class TopKnnCollectorManager
implements KnnCollectorManager {
    private final int k;
    @Nullable
    private final BlockingFloatHeap globalScoreQueue;

    public TopKnnCollectorManager(int k, @NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        boolean isMultiSegments = indexSearcher.getIndexReader().leaves().size() > 1;
        this.k = k;
        this.globalScoreQueue = isMultiSegments ? new BlockingFloatHeap(k) : null;
    }

    @Override
    @NotNull
    public KnnCollector newCollector(int visitedLimit, @NotNull KnnSearchStrategy searchStrategy, @NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)searchStrategy, (String)"searchStrategy");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.globalScoreQueue == null ? (KnnCollector)new TopKnnCollector(this.k, visitedLimit, searchStrategy) : (KnnCollector)new MultiLeafKnnCollector(this.k, this.globalScoreQueue, new TopKnnCollector(this.k, visitedLimit, searchStrategy));
    }
}

