/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.Lock;
import org.gnit.lucenekmp.store.LockFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/store/BaseDirectory;", "Lorg/gnit/lucenekmp/store/Directory;", "lockFactory", "Lorg/gnit/lucenekmp/store/LockFactory;", "<init>", "(Lorg/gnit/lucenekmp/store/LockFactory;)V", "isOpen", "", "()Z", "setOpen", "(Z)V", "getLockFactory", "()Lorg/gnit/lucenekmp/store/LockFactory;", "obtainLock", "Lorg/gnit/lucenekmp/store/Lock;", "name", "", "ensureOpen", "", "toString", "core"})
public abstract class BaseDirectory
extends Directory {
    private volatile boolean isOpen;
    @NotNull
    private final LockFactory lockFactory;

    protected BaseDirectory(@NotNull LockFactory lockFactory) {
        Intrinsics.checkNotNullParameter((Object)lockFactory, (String)"lockFactory");
        this.isOpen = true;
        this.lockFactory = lockFactory;
    }

    protected final boolean isOpen() {
        return this.isOpen;
    }

    protected final void setOpen(boolean bl) {
        this.isOpen = bl;
    }

    @NotNull
    protected final LockFactory getLockFactory() {
        return this.lockFactory;
    }

    @Override
    @NotNull
    public Lock obtainLock(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.lockFactory.obtainLock(this, name);
    }

    @Override
    public void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + " lockFactory=" + this.lockFactory;
    }
}

