/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\nJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/store/ByteArrayDataOutput;", "Lorg/gnit/lucenekmp/store/DataOutput;", "bytes", "", "<init>", "([B)V", "offset", "", "len", "([BII)V", "()V", "value", "position", "getPosition", "()I", "limit", "reset", "", "writeByte", "b", "", "writeBytes", "length", "writeShort", "i", "", "writeInt", "writeLong", "", "core"})
@SourceDebugExtension(value={"SMAP\nByteArrayDataOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteArrayDataOutput.kt\norg/gnit/lucenekmp/store/ByteArrayDataOutput\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,76:1\n3#2,8:77\n3#2,8:86\n3#2,8:95\n3#2,8:104\n3#2,8:113\n10#3:85\n10#3:94\n10#3:103\n10#3:112\n10#3:121\n*S KotlinDebug\n*F\n+ 1 ByteArrayDataOutput.kt\norg/gnit/lucenekmp/store/ByteArrayDataOutput\n*L\n42#1:77,8\n47#1:86,8\n59#1:95,8\n65#1:104,8\n71#1:113,8\n42#1:85\n47#1:94\n59#1:103\n65#1:112\n71#1:121\n*E\n"})
public final class ByteArrayDataOutput
extends DataOutput {
    private byte[] bytes;
    private int position;
    private int limit;

    public final int getPosition() {
        return this.position;
    }

    public ByteArrayDataOutput(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteArrayDataOutput.reset$default(this, bytes, 0, 0, 6, null);
    }

    public ByteArrayDataOutput(@NotNull byte[] bytes, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.reset(bytes, offset, len);
    }

    public ByteArrayDataOutput() {
        ByteArrayDataOutput.reset$default(this, BytesRef.Companion.getEMPTY_BYTES(), 0, 0, 6, null);
    }

    @JvmOverloads
    public final void reset(@NotNull byte[] bytes, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.position = offset;
        this.limit = offset + len;
    }

    public static /* synthetic */ void reset$default(ByteArrayDataOutput byteArrayDataOutput, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteArrayDataOutput.reset(byArray, n, n2);
    }

    @Override
    public void writeByte(byte b) {
        boolean condition$iv = this.position < this.limit;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        int n = this.position;
        this.position = n + 1;
        byArray[n] = b;
    }

    @Override
    public void writeBytes(@NotNull byte[] b, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        boolean condition$iv = this.position + length <= this.limit;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        System.INSTANCE.arraycopy(b, offset, byArray, this.position, length);
        this.position += length;
    }

    @Override
    public void writeShort(short i) {
        boolean condition$iv = this.position + 2 <= this.limit;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        BitUtil.VH_LE_SHORT.INSTANCE.set(byArray, this.position, i);
        this.position += 2;
    }

    @Override
    public void writeInt(int i) {
        boolean condition$iv = this.position + 4 <= this.limit;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        BitUtil.VH_LE_INT.INSTANCE.set(byArray, this.position, i);
        this.position += 4;
    }

    @Override
    public void writeLong(long i) {
        boolean condition$iv = this.position + 8 <= this.limit;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        byte[] byArray = this.bytes;
        if (this.bytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            byArray = null;
        }
        BitUtil.VH_LE_LONG.INSTANCE.set(byArray, this.position, i);
        this.position += 8;
    }

    @JvmOverloads
    public final void reset(@NotNull byte[] bytes, int offset) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteArrayDataOutput.reset$default(this, bytes, offset, 0, 4, null);
    }

    @JvmOverloads
    public final void reset(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteArrayDataOutput.reset$default(this, bytes, 0, 0, 6, null);
    }
}

