/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.ArrayDequeExtKt;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.UnicodeUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u000b\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0002ABBI\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u001aJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\bJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u001fJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u001aJ\u0018\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eH\u0016J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0001J\u0006\u0010*\u001a\u00020\u000eJ\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0004H\u0016J\u0010\u00101\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u000eH\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u0010.\u001a\u00020,H\u0016J\u001c\u00103\u001a\u00020\n2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,05H\u0016J\u0016\u00106\u001a\u00020\n2\f\u00107\u001a\b\u0012\u0004\u0012\u00020,08H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0006\u00109\u001a\u00020\nJ\b\u0010:\u001a\u00020\u0004H\u0002J\b\u0010;\u001a\u00020\nH\u0002J\u0010\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0018\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020,H\u0002R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "Lorg/gnit/lucenekmp/store/DataOutput;", "Lorg/gnit/lucenekmp/util/Accountable;", "minBitsPerBlock", "", "maxBitsPerBlock", "blockAllocate", "Lkotlin/Function1;", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "blockReuse", "", "<init>", "(IILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "expectedSize", "", "(J)V", "blockBits", "blocks", "Lkotlin/collections/ArrayDeque;", "ramBytesUsed", "currentBlock", "writeByte", "b", "", "writeBytes", "src", "", "offset", "length", "buffer", "toBufferList", "", "toWriteableBufferList", "toDataInput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "toArrayCopy", "copyBytes", "input", "Lorg/gnit/lucenekmp/store/DataInput;", "numBytes", "copyTo", "output", "size", "toString", "", "writeShort", "v", "", "writeInt", "writeLong", "writeString", "writeMapOfStrings", "map", "", "writeSetOfStrings", "set", "", "reset", "blockSize", "appendBlock", "rewriteToBlockSize", "targetBlockBits", "writeLongString", "byteLen", "s", "ByteBufferRecycler", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nByteBuffersDataOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBuffersDataOutput.kt\norg/gnit/lucenekmp/store/ByteBuffersDataOutput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n1#2:543\n1869#3,2:544\n*S KotlinDebug\n*F\n+ 1 ByteBuffersDataOutput.kt\norg/gnit/lucenekmp/store/ByteBuffersDataOutput\n*L\n409#1:544,2\n*E\n"})
public final class ByteBuffersDataOutput
extends DataOutput
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxBitsPerBlock;
    @NotNull
    private final Function1<Integer, ByteBuffer> blockAllocate;
    @NotNull
    private final Function1<ByteBuffer, Unit> blockReuse;
    private int blockBits;
    @NotNull
    private final ArrayDeque<ByteBuffer> blocks;
    private long ramBytesUsed;
    @NotNull
    private ByteBuffer currentBlock;
    @NotNull
    private static final ByteBuffer EMPTY = ByteBuffer.Companion.allocate(0).order(ByteOrder.Companion.getLITTLE_ENDIAN());
    @NotNull
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @NotNull
    private static final Function1<Integer, ByteBuffer> ALLOCATE_BB_ON_HEAP = ByteBuffersDataOutput::ALLOCATE_BB_ON_HEAP$lambda$7;
    @NotNull
    private static final Function1<ByteBuffer, Unit> NO_REUSE = ByteBuffersDataOutput::NO_REUSE$lambda$8;
    public static final int DEFAULT_MIN_BITS_PER_BLOCK = 10;
    public static final int DEFAULT_MAX_BITS_PER_BLOCK = 26;
    public static final int LIMIT_MIN_BITS_PER_BLOCK = 1;
    public static final int LIMIT_MAX_BITS_PER_BLOCK = 31;
    public static final int MAX_BLOCKS_BEFORE_BLOCK_EXPANSION = 100;
    private static final int MAX_CHARS_PER_WINDOW = 1024;
    private static final int COPY_BUFFER_SIZE = 8192;

    @JvmOverloads
    public ByteBuffersDataOutput(int minBitsPerBlock, int maxBitsPerBlock, @NotNull Function1<? super Integer, ? extends ByteBuffer> blockAllocate, @NotNull Function1<? super ByteBuffer, Unit> blockReuse) {
        Intrinsics.checkNotNullParameter(blockAllocate, (String)"blockAllocate");
        Intrinsics.checkNotNullParameter(blockReuse, (String)"blockReuse");
        this.blocks = new ArrayDeque();
        this.currentBlock = EMPTY;
        if (!(minBitsPerBlock >= 1)) {
            boolean $i$a$-require-ByteBuffersDataOutput$42 = false;
            String $i$a$-require-ByteBuffersDataOutput$42 = "minBitsPerBlock (" + minBitsPerBlock + ") too small, must be at least 1";
            throw new IllegalArgumentException($i$a$-require-ByteBuffersDataOutput$42.toString());
        }
        if (!(maxBitsPerBlock <= 31)) {
            boolean $i$a$-require-ByteBuffersDataOutput$52 = false;
            String $i$a$-require-ByteBuffersDataOutput$52 = "maxBitsPerBlock (" + maxBitsPerBlock + ") too large, must not exceed 31";
            throw new IllegalArgumentException($i$a$-require-ByteBuffersDataOutput$52.toString());
        }
        if (!(minBitsPerBlock <= maxBitsPerBlock)) {
            boolean bl = false;
            String string = "minBitsPerBlock (" + minBitsPerBlock + ") cannot exceed maxBitsPerBlock (" + maxBitsPerBlock + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxBitsPerBlock = maxBitsPerBlock;
        this.blockBits = minBitsPerBlock;
        this.blockAllocate = blockAllocate;
        this.blockReuse = blockReuse;
    }

    public /* synthetic */ ByteBuffersDataOutput(int n, int n2, Function1 function1, Function1 function12, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 10;
        }
        if ((n3 & 2) != 0) {
            n2 = 26;
        }
        if ((n3 & 4) != 0) {
            function1 = ALLOCATE_BB_ON_HEAP;
        }
        if ((n3 & 8) != 0) {
            function12 = NO_REUSE;
        }
        this(n, n2, function1, function12);
    }

    public ByteBuffersDataOutput(long expectedSize) {
        this(ByteBuffersDataOutput.Companion.computeBlockSizeBitsFor(expectedSize), 26, ALLOCATE_BB_ON_HEAP, NO_REUSE);
    }

    @Override
    public void writeByte(byte b) {
        if (!this.currentBlock.hasRemaining()) {
            this.appendBlock();
        }
        this.currentBlock.put(b);
    }

    @Override
    public void writeBytes(@NotNull byte[] src, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int offset2 = offset;
        int length2 = length;
        if (!(length2 >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (length2 > 0) {
            if (!this.currentBlock.hasRemaining()) {
                this.appendBlock();
            }
            int chunk = java.lang.Math.min(this.currentBlock.remaining(), length2);
            this.currentBlock.put(src, offset2, chunk);
            length2 -= chunk;
            offset2 += chunk;
        }
    }

    @Override
    public void writeBytes(@NotNull byte[] b, int length) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.writeBytes(b, 0, length);
    }

    public final void writeBytes(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.writeBytes(b, 0, b.length);
    }

    public final void writeBytes(@NotNull ByteBuffer buffer) {
        int chunk;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer buffer2 = buffer;
        buffer2 = buffer2.duplicate();
        for (int length = buffer2.remaining(); length > 0; length -= chunk) {
            if (!this.currentBlock.hasRemaining()) {
                this.appendBlock();
            }
            chunk = java.lang.Math.min(this.currentBlock.remaining(), length);
            buffer2.limit(buffer2.getPosition() + chunk);
            this.currentBlock.put(buffer2);
        }
    }

    @NotNull
    public final List<ByteBuffer> toBufferList() {
        List result = new ArrayList(java.lang.Math.max(this.blocks.size(), 1));
        if (this.blocks.isEmpty()) {
            result.add(EMPTY);
        } else {
            Iterator iterator2 = this.blocks.iterator();
            while (iterator2.hasNext()) {
                ByteBuffer bb;
                ByteBuffer bb2 = bb = (ByteBuffer)iterator2.next();
                bb2 = bb2.asReadOnlyBuffer().flip().order(ByteOrder.Companion.getLITTLE_ENDIAN());
                result.add(bb2);
            }
        }
        return result;
    }

    @NotNull
    public final List<ByteBuffer> toWriteableBufferList() {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>(java.lang.Math.max(this.blocks.size(), 1));
        if (this.blocks.isEmpty()) {
            result.add(EMPTY);
        } else {
            Iterator iterator2 = this.blocks.iterator();
            while (iterator2.hasNext()) {
                ByteBuffer bb;
                ByteBuffer bb2 = bb = (ByteBuffer)iterator2.next();
                bb2 = bb2.duplicate().flip();
                result.add(bb2);
            }
        }
        return result;
    }

    @NotNull
    public final ByteBuffersDataInput toDataInput() {
        return new ByteBuffersDataInput(this.toBufferList());
    }

    @NotNull
    public final byte[] toArrayCopy() {
        if (this.blocks.isEmpty()) {
            return EMPTY_BYTE_ARRAY;
        }
        long size2 = this.size();
        if (size2 > Integer.MAX_VALUE) {
            throw new RuntimeException("Data exceeds maximum size of a single byte array: " + size2);
        }
        byte[] arr = new byte[Math.INSTANCE.toIntExact(this.size())];
        int offset = 0;
        for (ByteBuffer bb : this.toBufferList()) {
            int len = bb.remaining();
            bb.get(arr, offset, len);
            offset += len;
        }
        return arr;
    }

    @Override
    public void copyBytes(@NotNull DataInput input, long numBytes) throws IOException {
        int toCopy;
        long remaining;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(numBytes >= 0L)) {
            boolean bl = false;
            String string = "numBytes must be non-negative: " + numBytes;
            throw new IllegalArgumentException(string.toString());
        }
        if (numBytes == 0L) {
            return;
        }
        byte[] tempBuffer = new byte[java.lang.Math.min(8192, (int)remaining)];
        for (remaining = numBytes; remaining > 0L; remaining -= (long)toCopy) {
            if (!this.currentBlock.hasRemaining()) {
                this.appendBlock();
            }
            toCopy = java.lang.Math.min((int)remaining, java.lang.Math.min(tempBuffer.length, this.currentBlock.remaining()));
            input.readBytes(tempBuffer, 0, toCopy);
            this.currentBlock.put(tempBuffer, 0, toCopy);
        }
    }

    public final void copyTo(@NotNull DataOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        for (ByteBuffer bb : this.blocks) {
            ByteBuffer readView = bb.asReadOnlyBuffer().flip();
            Object[] objectArray = new ByteBuffer[]{readView};
            output.copyBytes(new ByteBuffersDataInput(CollectionsKt.mutableListOf((Object[])objectArray)), readView.remaining());
        }
    }

    public final long size() {
        long size2 = 0L;
        int blockCount = this.blocks.size();
        if (blockCount >= 1) {
            long fullBlockSize = ((long)blockCount - 1L) * (long)this.blockSize();
            long lastBlockSize = ArrayDequeExtKt.getLast(this.blocks).getPosition();
            size2 = fullBlockSize + lastBlockSize;
        }
        return size2;
    }

    @NotNull
    public String toString() {
        return this.size() + " bytes, block size: " + this.blockSize() + ", blocks: " + this.blocks.size();
    }

    @Override
    public void writeShort(short v) {
        try {
            if (this.currentBlock.remaining() >= 2) {
                this.currentBlock.putShort(v);
            } else {
                super.writeShort(v);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeInt(int v) {
        try {
            if (this.currentBlock.remaining() >= 4) {
                this.currentBlock.putInt(v);
            } else {
                super.writeInt(v);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeLong(long v) {
        try {
            if (this.currentBlock.remaining() >= 8) {
                this.currentBlock.putLong(v);
            } else {
                super.writeLong(v);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeString(@NotNull String v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        try {
            ByteBuffer currentBlock;
            int charCount = v.length();
            int byteLen = UnicodeUtil.INSTANCE.calcUTF16toUTF8Length(v, 0, charCount);
            this.writeVInt(byteLen);
            ByteBuffer byteBuffer = currentBlock = this.currentBlock;
            Intrinsics.checkNotNull((Object)byteBuffer);
            if (byteBuffer.hasArray() && currentBlock.remaining() >= byteLen) {
                int startingPos = currentBlock.getPosition();
                UnicodeUtil.INSTANCE.UTF16toUTF8(v, 0, charCount, currentBlock.array(), currentBlock.arrayOffset() + startingPos);
                currentBlock.position(startingPos + byteLen);
            } else {
                this.writeLongString(byteLen, v);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeMapOfStrings(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        try {
            super.writeMapOfStrings(map2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeSetOfStrings(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        try {
            super.writeSetOfStrings(set);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long ramBytesUsed() {
        long l;
        Iterable iterable = (Iterable)this.blocks;
        long l2 = this.ramBytesUsed;
        long l3 = 0L;
        for (Object t : iterable) {
            void obj;
            ByteBuffer byteBuffer = (ByteBuffer)t;
            l = l3;
            boolean bl = false;
            long l4 = obj.getCapacity();
            l3 = l + l4;
        }
        l = l3;
        if (!(l2 == l + (long)this.blocks.size() * (long)4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.ramBytesUsed;
    }

    /*
     * WARNING - void declaration
     */
    public final void reset() {
        if (this.blockReuse != NO_REUSE) {
            void $this$forEach$iv;
            Iterable iterable = (Iterable)this.blocks;
            Function1<ByteBuffer, Unit> action$iv = this.blockReuse;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action$iv.invoke(element$iv);
            }
        }
        this.blocks.clear();
        this.ramBytesUsed = 0L;
        this.currentBlock = EMPTY;
    }

    private final int blockSize() {
        return 1 << this.blockBits;
    }

    private final void appendBlock() {
        if (this.blocks.size() >= 100 && this.blockBits < this.maxBitsPerBlock) {
            this.rewriteToBlockSize(this.blockBits + 1);
            if (ArrayDequeExtKt.getLast(this.blocks).hasRemaining()) {
                return;
            }
        }
        int requiredBlockSize = 1 << this.blockBits;
        this.currentBlock = ((ByteBuffer)this.blockAllocate.invoke((Object)requiredBlockSize)).order(ByteOrder.Companion.getLITTLE_ENDIAN());
        if (!(this.currentBlock.getCapacity() == requiredBlockSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.blocks.add((Object)this.currentBlock);
        this.ramBytesUsed += (long)(4 + this.currentBlock.getCapacity());
    }

    private final void rewriteToBlockSize(int targetBlockBits) {
        if (!(targetBlockBits <= this.maxBitsPerBlock)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBuffersDataOutput cloned = new ByteBuffersDataOutput(targetBlockBits, targetBlockBits, this.blockAllocate, NO_REUSE);
        while (ArrayDequeExtKt.pollFirst(this.blocks) != null) {
            ByteBuffer block2;
            block2.flip();
            cloned.writeBytes(block2);
            if (this.blockReuse == NO_REUSE) continue;
            this.blockReuse.invoke((Object)block2);
        }
        if (!this.blocks.isEmpty()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.blockBits = targetBlockBits;
        this.blocks.addAll((Collection)cloned.blocks);
        this.ramBytesUsed = cloned.ramBytesUsed;
    }

    private final void writeLongString(int byteLen, String s) throws IOException {
        int step;
        byte[] buf = new byte[java.lang.Math.min(byteLen, 3072)];
        int end = s.length();
        for (int i = 0; i < end; i += step) {
            step = java.lang.Math.min(end - i, 1023);
            if (i + step < end && Character.Companion.isHighSurrogate(s.charAt(i + step - 1))) {
                ++step;
            }
            int upTo = UnicodeUtil.INSTANCE.UTF16toUTF8(s, i, step, buf);
            this.writeBytes(buf, 0, upTo);
        }
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public ByteBuffersDataOutput(int minBitsPerBlock, int maxBitsPerBlock, @NotNull Function1<? super Integer, ? extends ByteBuffer> blockAllocate) {
        Intrinsics.checkNotNullParameter(blockAllocate, (String)"blockAllocate");
        this(minBitsPerBlock, maxBitsPerBlock, blockAllocate, null, 8, null);
    }

    @JvmOverloads
    public ByteBuffersDataOutput(int minBitsPerBlock, int maxBitsPerBlock) {
        this(minBitsPerBlock, maxBitsPerBlock, null, null, 12, null);
    }

    @JvmOverloads
    public ByteBuffersDataOutput(int minBitsPerBlock) {
        this(minBitsPerBlock, 0, null, null, 14, null);
    }

    @JvmOverloads
    public ByteBuffersDataOutput() {
        this(0, 0, null, null, 15, null);
    }

    private static final ByteBuffer ALLOCATE_BB_ON_HEAP$lambda$7(int capacity) {
        return ByteBuffer.Companion.allocate(capacity);
    }

    private static final Unit NO_REUSE$lambda$8(ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"<unused var>");
        throw new RuntimeException("reset() is not allowed on this buffer.");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput$ByteBufferRecycler;", "", "delegate", "Lkotlin/Function1;", "", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "reuse", "Lkotlin/collections/ArrayDeque;", "allocate", "size", "", "buffer", "core"})
    public static final class ByteBufferRecycler {
        @NotNull
        private final ArrayDeque<ByteBuffer> reuse;
        @NotNull
        private final Function1<Integer, ByteBuffer> delegate;

        public ByteBufferRecycler(@NotNull Function1<? super Integer, ? extends ByteBuffer> delegate) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.reuse = new ArrayDeque();
            this.delegate = delegate;
        }

        @NotNull
        public final ByteBuffer allocate(int size2) {
            while (!this.reuse.isEmpty()) {
                ByteBuffer bb = (ByteBuffer)this.reuse.removeFirst();
                if (bb.remaining() != size2) continue;
                return bb;
            }
            return (ByteBuffer)this.delegate.invoke((Object)size2);
        }

        public final void reuse(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.rewind();
            this.reuse.addLast((Object)buffer);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "EMPTY_BYTE_ARRAY", "", "ALLOCATE_BB_ON_HEAP", "Lkotlin/Function1;", "", "getALLOCATE_BB_ON_HEAP", "()Lkotlin/jvm/functions/Function1;", "NO_REUSE", "", "getNO_REUSE", "DEFAULT_MIN_BITS_PER_BLOCK", "DEFAULT_MAX_BITS_PER_BLOCK", "LIMIT_MIN_BITS_PER_BLOCK", "LIMIT_MAX_BITS_PER_BLOCK", "MAX_BLOCKS_BEFORE_BLOCK_EXPANSION", "MAX_CHARS_PER_WINDOW", "COPY_BUFFER_SIZE", "newResettableInstance", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "computeBlockSizeBitsFor", "bytes", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Integer, ByteBuffer> getALLOCATE_BB_ON_HEAP() {
            return ALLOCATE_BB_ON_HEAP;
        }

        @NotNull
        public final Function1<ByteBuffer, Unit> getNO_REUSE() {
            return NO_REUSE;
        }

        @NotNull
        public final ByteBuffersDataOutput newResettableInstance() {
            ByteBufferRecycler reuser = new ByteBufferRecycler(this.getALLOCATE_BB_ON_HEAP());
            return new ByteBuffersDataOutput(10, 26, (Function1<? super Integer, ? extends ByteBuffer>)((Function1)arg_0 -> Companion.newResettableInstance$lambda$0(reuser, arg_0)), (Function1<? super ByteBuffer, Unit>)((Function1)arg_0 -> Companion.newResettableInstance$lambda$1(reuser, arg_0)));
        }

        private final int computeBlockSizeBitsFor(long bytes) {
            long powerOfTwo = BitUtil.INSTANCE.nextHighestPowerOfTwo(bytes / (long)100);
            if (powerOfTwo == 0L) {
                return 10;
            }
            int blockBits = LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, powerOfTwo);
            blockBits = java.lang.Math.min(blockBits, 26);
            blockBits = java.lang.Math.max(blockBits, 10);
            return blockBits;
        }

        private static final ByteBuffer newResettableInstance$lambda$0(ByteBufferRecycler $reuser, int size2) {
            return $reuser.allocate(size2);
        }

        private static final Unit newResettableInstance$lambda$1(ByteBufferRecycler $reuser, ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            $reuser.reuse(buffer);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

