/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.jdkport.AccessDeniedException;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.jdkport.CRC32;
import org.gnit.lucenekmp.jdkport.FileAlreadyExistsException;
import org.gnit.lucenekmp.jdkport.NoSuchFileException;
import org.gnit.lucenekmp.store.BaseDirectory;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.ByteBuffersDirectory;
import org.gnit.lucenekmp.store.ByteBuffersIndexInput;
import org.gnit.lucenekmp.store.ByteBuffersIndexOutput;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.LockFactory;
import org.gnit.lucenekmp.store.SingleInstanceLockFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0005*\u0001\u0011\u0018\u0000 52\u00020\u0001:\u000256B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B9\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b\u0002\u0010\u000fJ\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\rJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0016J\u0016\u0010+\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-H\u0016J\b\u0010.\u001a\u00020\u001bH\u0016J\u0018\u0010/\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0016J\b\u00100\u001a\u00020\u001bH\u0016R\u0016\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u0012\u0004\b\u0012\u0010\u0003R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\r028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersDirectory;", "Lorg/gnit/lucenekmp/store/BaseDirectory;", "<init>", "()V", "lockFactory", "Lorg/gnit/lucenekmp/store/LockFactory;", "(Lorg/gnit/lucenekmp/store/LockFactory;)V", "factory", "bbOutputSupplier", "Lkotlin/Function0;", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "outputToInput", "Lkotlin/Function2;", "", "Lorg/gnit/lucenekmp/store/IndexInput;", "(Lorg/gnit/lucenekmp/store/LockFactory;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "tempFileName", "org/gnit/lucenekmp/store/ByteBuffersDirectory$tempFileName$1", "getTempFileName$annotations", "Lorg/gnit/lucenekmp/store/ByteBuffersDirectory$tempFileName$1;", "files", "", "Lorg/gnit/lucenekmp/store/ByteBuffersDirectory$FileEntry;", "listAll", "", "()[Ljava/lang/String;", "deleteFile", "", "name", "fileLength", "", "fileExists", "", "createOutput", "Lorg/gnit/lucenekmp/store/IndexOutput;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "createTempOutput", "prefix", "suffix", "rename", "source", "dest", "sync", "names", "", "syncMetaData", "openInput", "close", "pendingDeletions", "", "getPendingDeletions", "()Ljava/util/Set;", "Companion", "FileEntry", "core"})
@SourceDebugExtension(value={"SMAP\nByteBuffersDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBuffersDirectory.kt\norg/gnit/lucenekmp/store/ByteBuffersDirectory\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,185:1\n37#2:186\n36#2,3:187\n*S KotlinDebug\n*F\n+ 1 ByteBuffersDirectory.kt\norg/gnit/lucenekmp/store/ByteBuffersDirectory\n*L\n63#1:186\n63#1:187,3\n*E\n"})
public final class ByteBuffersDirectory
extends BaseDirectory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final tempFileName.1 tempFileName;
    @NotNull
    private final Map<String, FileEntry> files;
    @NotNull
    private final Function2<String, ByteBuffersDataOutput, IndexInput> outputToInput;
    @NotNull
    private final Function0<ByteBuffersDataOutput> bbOutputSupplier;
    @NotNull
    private static final Function2<String, ByteBuffersDataOutput, IndexInput> OUTPUT_AS_MANY_BUFFERS = ByteBuffersDirectory::OUTPUT_AS_MANY_BUFFERS$lambda$1;
    @NotNull
    private static final Function2<String, ByteBuffersDataOutput, IndexInput> OUTPUT_AS_ONE_BUFFER = ByteBuffersDirectory::OUTPUT_AS_ONE_BUFFER$lambda$2;
    @NotNull
    private static final Function2<String, ByteBuffersDataOutput, IndexInput> OUTPUT_AS_BYTE_ARRAY = OUTPUT_AS_ONE_BUFFER;

    private static /* synthetic */ void getTempFileName$annotations() {
    }

    public ByteBuffersDirectory() {
        this(new SingleInstanceLockFactory());
    }

    public ByteBuffersDirectory(@NotNull LockFactory lockFactory) {
        Intrinsics.checkNotNullParameter((Object)lockFactory, (String)"lockFactory");
        this(lockFactory, (Function0<ByteBuffersDataOutput>)((Function0)ByteBuffersDirectory::_init_$lambda$0), OUTPUT_AS_MANY_BUFFERS);
    }

    public ByteBuffersDirectory(@NotNull LockFactory factory, @NotNull Function0<ByteBuffersDataOutput> bbOutputSupplier, @NotNull Function2<? super String, ? super ByteBuffersDataOutput, ? extends IndexInput> outputToInput) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(bbOutputSupplier, (String)"bbOutputSupplier");
        Intrinsics.checkNotNullParameter(outputToInput, (String)"outputToInput");
        super(factory);
        this.tempFileName = new Function1<String, String>(){
            private final AtomicLong counter;
            {
                this.counter = new AtomicLong(0L);
            }

            public String invoke(String suffix) {
                Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
                String string = Long.toString(AtomicsKt.fetchAndIncrement((AtomicLong)this.counter), CharsKt.checkRadix((int)36));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return suffix + "_" + string;
            }
        };
        this.files = new LinkedHashMap();
        this.outputToInput = outputToInput;
        this.bbOutputSupplier = bbOutputSupplier;
    }

    @Override
    @NotNull
    public String[] listAll() throws IOException {
        this.ensureOpen();
        Collection $this$toTypedArray$iv = CollectionsKt.sorted((Iterable)this.files.keySet());
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    public void deleteFile(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureOpen();
        FileEntry removed = this.files.remove(name);
        if (removed == null) {
            throw new NoSuchFileException(name);
        }
    }

    @Override
    public long fileLength(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureOpen();
        FileEntry fileEntry = this.files.get(name);
        if (fileEntry == null) {
            throw new NoSuchFileException(name);
        }
        FileEntry file = fileEntry;
        return file.length();
    }

    public final boolean fileExists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureOpen();
        return this.files.containsKey(name);
    }

    @Override
    @NotNull
    public IndexOutput createOutput(@NotNull String name, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureOpen();
        if (this.files.containsKey(name)) {
            throw new FileAlreadyExistsException("File already exists: " + name);
        }
        FileEntry e = new FileEntry(name);
        this.files.put(name, e);
        return e.createOutput(this.outputToInput);
    }

    @Override
    @NotNull
    public IndexOutput createTempOutput(@NotNull String prefix, @NotNull String suffix, @NotNull IOContext context) throws IOException {
        String name;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureOpen();
        while (this.files.containsKey(name = IndexFileNames.INSTANCE.segmentFileName(prefix, this.tempFileName.invoke(suffix), "tmp"))) {
        }
        FileEntry e = new FileEntry(name);
        this.files.put(name, e);
        return e.createOutput(this.outputToInput);
    }

    @Override
    public void rename(@NotNull String source, @NotNull String dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.ensureOpen();
        FileEntry fileEntry = this.files.get(source);
        if (fileEntry == null) {
            throw new NoSuchFileException(source);
        }
        FileEntry file = fileEntry;
        if (this.files.containsKey(dest)) {
            throw new FileAlreadyExistsException(dest);
        }
        this.files.put(dest, file);
        if (this.files.get(source) != file) {
            throw new IllegalStateException("File was unexpectedly replaced: " + source);
        }
        this.files.remove(source);
    }

    @Override
    public void sync(@NotNull Collection<String> names) throws IOException {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        this.ensureOpen();
    }

    @Override
    public void syncMetaData() throws IOException {
        this.ensureOpen();
    }

    @Override
    @NotNull
    public IndexInput openInput(@NotNull String name, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureOpen();
        FileEntry fileEntry = this.files.get(name);
        if (fileEntry == null) {
            throw new NoSuchFileException(name);
        }
        FileEntry e = fileEntry;
        return e.openInput();
    }

    @Override
    public void close() throws IOException {
        this.setOpen(false);
        this.files.clear();
    }

    @Override
    @NotNull
    public Set<String> getPendingDeletions() {
        return new LinkedHashSet();
    }

    private static final ByteBuffersDataOutput _init_$lambda$0() {
        return new ByteBuffersDataOutput(0, 0, null, null, 15, null);
    }

    private static final ByteBuffersIndexInput OUTPUT_AS_MANY_BUFFERS$lambda$1(String fileName, ByteBuffersDataOutput output) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ByteBuffersDataInput dataInput = output.toDataInput();
        String inputName = Reflection.getOrCreateKotlinClass(ByteBuffersIndexInput.class).getSimpleName() + " (file=" + fileName + ", buffers=" + dataInput + ")";
        return new ByteBuffersIndexInput(dataInput, inputName);
    }

    private static final ByteBuffersIndexInput OUTPUT_AS_ONE_BUFFER$lambda$2(String fileName, ByteBuffersDataOutput output) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Object[] objectArray = new ByteBuffer[]{ByteBuffer.Companion.wrap$default(ByteBuffer.Companion, output.toArrayCopy(), 0, 0, 6, null).order(ByteOrder.Companion.getLITTLE_ENDIAN())};
        ByteBuffersDataInput dataInput = new ByteBuffersDataInput(CollectionsKt.mutableListOf((Object[])objectArray));
        String inputName = Reflection.getOrCreateKotlinClass(ByteBuffersIndexInput.class).getSimpleName() + " (file=" + fileName + ", buffers=" + dataInput + ")";
        return new ByteBuffersIndexInput(dataInput, inputName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersDirectory$Companion;", "", "<init>", "()V", "OUTPUT_AS_MANY_BUFFERS", "Lkotlin/Function2;", "", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "Lorg/gnit/lucenekmp/store/IndexInput;", "getOUTPUT_AS_MANY_BUFFERS", "()Lkotlin/jvm/functions/Function2;", "OUTPUT_AS_ONE_BUFFER", "getOUTPUT_AS_ONE_BUFFER", "OUTPUT_AS_BYTE_ARRAY", "getOUTPUT_AS_BYTE_ARRAY", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function2<String, ByteBuffersDataOutput, IndexInput> getOUTPUT_AS_MANY_BUFFERS() {
            return OUTPUT_AS_MANY_BUFFERS;
        }

        @NotNull
        public final Function2<String, ByteBuffersDataOutput, IndexInput> getOUTPUT_AS_ONE_BUFFER() {
            return OUTPUT_AS_ONE_BUFFER;
        }

        @NotNull
        public final Function2<String, ByteBuffersDataOutput, IndexInput> getOUTPUT_AS_BYTE_ARRAY() {
            return OUTPUT_AS_BYTE_ARRAY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\u0007J \u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/store/ByteBuffersDirectory$FileEntry;", "", "fileName", "", "<init>", "(Lorg/gnit/lucenekmp/store/ByteBuffersDirectory;Ljava/lang/String;)V", "content", "Lorg/gnit/lucenekmp/store/IndexInput;", "cachedLength", "", "length", "openInput", "createOutput", "Lorg/gnit/lucenekmp/store/IndexOutput;", "outputToInput", "Lkotlin/Function2;", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "core"})
    private final class FileEntry {
        @NotNull
        private final String fileName;
        @Nullable
        private volatile IndexInput content;
        private volatile long cachedLength;

        public FileEntry(String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            this.fileName = fileName;
        }

        public final long length() {
            return this.cachedLength;
        }

        @NotNull
        public final IndexInput openInput() throws IOException {
            IndexInput indexInput = this.content;
            if (indexInput == null) {
                throw new AccessDeniedException("Can't open a file still open for writing: " + this.fileName);
            }
            IndexInput local = indexInput;
            return local.clone();
        }

        @NotNull
        public final IndexOutput createOutput(@NotNull Function2<? super String, ? super ByteBuffersDataOutput, ? extends IndexInput> outputToInput) throws IOException {
            Intrinsics.checkNotNullParameter(outputToInput, (String)"outputToInput");
            if (this.content != null) {
                throw new IOException("Can only write to a file once: " + this.fileName);
            }
            String outputName = Reflection.getOrCreateKotlinClass(ByteBuffersDirectory.class).getSimpleName() + " output (file=" + this.fileName + ")";
            return new ByteBuffersIndexOutput((ByteBuffersDataOutput)ByteBuffersDirectory.this.bbOutputSupplier.invoke(), outputName, this.fileName, new CRC32(), (Function1<? super ByteBuffersDataOutput, Unit>)((Function1)arg_0 -> FileEntry.createOutput$lambda$0(this, outputToInput, arg_0)));
        }

        private static final Unit createOutput$lambda$0(FileEntry this$0, Function2 $outputToInput, ByteBuffersDataOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this$0.content = (IndexInput)$outputToInput.invoke((Object)this$0.fileName, (Object)output);
            this$0.cachedLength = output.size();
            return Unit.INSTANCE;
        }
    }
}

