/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.store.IndexInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/store/ChecksumIndexInput;", "Lorg/gnit/lucenekmp/store/IndexInput;", "resourceDescription", "", "<init>", "(Ljava/lang/String;)V", "skipBuffer", "", "checksum", "", "getChecksum", "()J", "seek", "", "pos", "skipByReading", "numBytes", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nChecksumIndexInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChecksumIndexInput.kt\norg/gnit/lucenekmp/store/ChecksumIndexInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public abstract class ChecksumIndexInput
extends IndexInput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private byte[] skipBuffer;
    private static final int SKIP_BUFFER_SIZE = 1024;

    protected ChecksumIndexInput(@NotNull String resourceDescription) {
        Intrinsics.checkNotNullParameter((Object)resourceDescription, (String)"resourceDescription");
        super(resourceDescription);
    }

    public abstract long getChecksum();

    @Override
    public void seek(long pos) throws IOException {
        long curFP = this.getFilePointer();
        long skip = pos - curFP;
        if (!(skip >= 0L)) {
            boolean bl = false;
            String string = Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + " cannot seek backwards (pos=" + pos + " getFilePointer()=" + curFP + ")";
            throw new IllegalStateException(string.toString());
        }
        this.skipByReading(skip);
    }

    private final void skipByReading(long numBytes) throws IOException {
        int step;
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[1024];
        }
        Intrinsics.checkNotNull((Object)this.skipBuffer);
        if (!(this.skipBuffer.length == 1024)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (long skipped = 0L; skipped < numBytes; skipped += (long)step) {
            step = (int)Math.min(1024L, numBytes - skipped);
            Intrinsics.checkNotNull((Object)this.skipBuffer);
            this.readBytes(this.skipBuffer, 0, step, false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/store/ChecksumIndexInput$Companion;", "", "<init>", "()V", "SKIP_BUFFER_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

