/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.GroupVIntUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b&\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0015H\u0002J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u001c\u0010!\u001a\u00020\u00072\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0#H\u0016J\u0016\u0010$\u001a\u00020\u00072\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&H\u0016J\u0016\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\fJ\u0016\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020+2\u0006\u0010*\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/store/DataOutput;", "", "<init>", "()V", "groupVIntBytes", "", "writeByte", "", "b", "", "writeBytes", "length", "", "offset", "writeInt", "i", "writeShort", "", "writeVInt", "writeZInt", "writeLong", "", "writeVLong", "writeSignedVLong", "writeZLong", "writeString", "s", "", "copyBuffer", "copyBytes", "input", "Lorg/gnit/lucenekmp/store/DataInput;", "numBytes", "writeMapOfStrings", "map", "", "writeSetOfStrings", "set", "", "writeGroupVInts", "values", "", "limit", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDataOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataOutput.kt\norg/gnit/lucenekmp/store/DataOutput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1#2:365\n*E\n"})
public abstract class DataOutput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] groupVIntBytes = new byte[17];
    @NotNull
    private byte[] copyBuffer = new byte[16384];
    private static final int COPY_BUFFER_SIZE = 16384;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(@NotNull byte[] b, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(@NotNull byte[] var1, int var2, int var3) throws IOException;

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)i);
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 24));
    }

    public void writeShort(short i) throws IOException {
        this.writeByte((byte)i);
        this.writeByte((byte)(i >> 8));
    }

    public final void writeVInt(int i) throws IOException {
        int i2 = i;
        while ((i2 & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i2 & 0x7F | 0x80));
            i2 >>>= 7;
        }
        this.writeByte((byte)i2);
    }

    public final void writeZInt(int i) throws IOException {
        this.writeVInt(BitUtil.INSTANCE.zigZagEncode(i));
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)i);
        this.writeInt((int)(i >> 32));
    }

    public final void writeVLong(long i) throws IOException {
        if (!(i >= 0L)) {
            boolean bl = false;
            String string = "cannot write negative vLong (got: " + i + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.writeSignedVLong(i);
    }

    private final void writeSignedVLong(long i) throws IOException {
        long i2 = i;
        while ((i2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i2 & 0x7FL | 0x80L));
            i2 >>>= 7;
        }
        this.writeByte((byte)i2);
    }

    public final void writeZLong(long i) throws IOException {
        this.writeSignedVLong(BitUtil.INSTANCE.zigZagEncode(i));
    }

    public void writeString(@NotNull String s) throws IOException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        BytesRef utf8Result = new BytesRef(s);
        this.writeVInt(utf8Result.getLength());
        this.writeBytes(utf8Result.getBytes(), utf8Result.getOffset(), utf8Result.getLength());
    }

    public void copyBytes(@NotNull DataInput input, long numBytes) throws IOException {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(numBytes >= 0L)) {
            boolean bl = false;
            String string = "numBytes=" + numBytes;
            throw new IllegalArgumentException(string.toString());
        }
        for (long left = numBytes; left > 0L; left -= (long)toCopy) {
            toCopy = 0;
            toCopy = left > 16384L ? 16384 : (int)left;
            input.readBytes(this.copyBuffer, 0, toCopy);
            this.writeBytes(this.copyBuffer, 0, toCopy);
        }
    }

    public void writeMapOfStrings(@NotNull Map<String, String> map2) throws IOException {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.writeVInt(map2.size());
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            this.writeString(entry.getKey());
            this.writeString(entry.getValue());
        }
    }

    public void writeSetOfStrings(@NotNull Set<String> set) throws IOException {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this.writeVInt(set.size());
        for (String value : set) {
            this.writeString(value);
        }
    }

    public final void writeGroupVInts(@NotNull long[] values2, int limit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        GroupVIntUtil.INSTANCE.writeGroupVInts(this, this.groupVIntBytes, values2, limit);
    }

    public final void writeGroupVInts(@NotNull int[] values2, int limit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        GroupVIntUtil.INSTANCE.writeGroupVInts(this, this.groupVIntBytes, values2, limit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/store/DataOutput$Companion;", "", "<init>", "()V", "COPY_BUFFER_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

