/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.HexExtensionsKt;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.BufferedChecksumIndexInput;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.Lock;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0004\b&\u0018\u0000 ,2\u00060\u0001j\u0002`\u0002:\u0001,B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H&\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0007H&J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0016\u0010\u0015\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H&J\b\u0010\u0018\u001a\u00020\nH&J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H&J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u0007H&J\b\u0010\"\u001a\u00020\nH&J(\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020\nH\u0016R\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070)X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/store/Directory;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "listAll", "", "", "()[Ljava/lang/String;", "deleteFile", "", "name", "fileLength", "", "createOutput", "Lorg/gnit/lucenekmp/store/IndexOutput;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "createTempOutput", "prefix", "suffix", "sync", "names", "", "syncMetaData", "rename", "source", "dest", "openInput", "Lorg/gnit/lucenekmp/store/IndexInput;", "openChecksumInput", "Lorg/gnit/lucenekmp/store/ChecksumIndexInput;", "obtainLock", "Lorg/gnit/lucenekmp/store/Lock;", "close", "copyFrom", "from", "src", "toString", "ensureOpen", "pendingDeletions", "", "getPendingDeletions", "()Ljava/util/Set;", "Companion", "core"})
public abstract class Directory
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String[] listAll() throws IOException;

    public abstract void deleteFile(@NotNull String var1) throws IOException;

    public abstract long fileLength(@NotNull String var1) throws IOException;

    @NotNull
    public abstract IndexOutput createOutput(@NotNull String var1, @NotNull IOContext var2) throws IOException;

    @NotNull
    public abstract IndexOutput createTempOutput(@NotNull String var1, @NotNull String var2, @NotNull IOContext var3) throws IOException;

    public abstract void sync(@NotNull Collection<String> var1) throws IOException;

    public abstract void syncMetaData() throws IOException;

    public abstract void rename(@NotNull String var1, @NotNull String var2) throws IOException;

    @NotNull
    public abstract IndexInput openInput(@NotNull String var1, @NotNull IOContext var2) throws IOException;

    @NotNull
    public final ChecksumIndexInput openChecksumInput(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new BufferedChecksumIndexInput(this.openInput(name, IOContext.Companion.getREADONCE()));
    }

    @NotNull
    public abstract Lock obtainLock(@NotNull String var1) throws IOException;

    @Override
    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(@NotNull Directory from, @NotNull String src, @NotNull String dest, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean success = false;
        try {
            AutoCloseable autoCloseable = from.openInput(src, IOContext.Companion.getREADONCE());
            Throwable throwable = null;
            try {
                IndexInput is = (IndexInput)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = this.createOutput(dest, context);
                Throwable throwable2 = null;
                try {
                    IndexOutput os = (IndexOutput)autoCloseable2;
                    boolean bl2 = false;
                    os.copyBytes(is, is.length());
                    success = true;
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable throwable) {
            if (!success) {
                String[] stringArray = new String[]{dest};
                IOUtils.INSTANCE.deleteFilesIgnoringExceptions(this, stringArray);
            }
            throw throwable;
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "@" + HexExtensionsKt.toHexString$default((int)this.hashCode(), null, (int)1, null);
    }

    public void ensureOpen() throws AlreadyClosedException {
    }

    @NotNull
    public abstract Set<String> getPendingDeletions();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/store/Directory$Companion;", "", "<init>", "()V", "getTempFileName", "", "prefix", "suffix", "counter", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTempFileName(@NotNull String prefix, @NotNull String suffix, long counter) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            String string = Long.toString(counter, CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return IndexFileNames.INSTANCE.segmentFileName(prefix, suffix + "_" + string, "tmp").toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

