/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import okio.Path;
import org.gnit.lucenekmp.jdkport.FileAlreadyExistsException;
import org.gnit.lucenekmp.jdkport.Files;
import org.gnit.lucenekmp.jdkport.FilesKt;
import org.gnit.lucenekmp.jdkport.FilterOutputStream;
import org.gnit.lucenekmp.jdkport.NoSuchFileException;
import org.gnit.lucenekmp.jdkport.OpenOption;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.StandardCopyOption;
import org.gnit.lucenekmp.jdkport.StandardOpenOption;
import org.gnit.lucenekmp.store.BaseDirectory;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.FSLockFactory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.LockFactory;
import org.gnit.lucenekmp.store.NIOFSDirectory;
import org.gnit.lucenekmp.store.OutputStreamIndexOutput;
import org.gnit.lucenekmp.util.Constants;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 ;2\u00020\u0001:\u0002:;B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\rH\u0004J\u0016\u0010'\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0)H\u0016J\u0018\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020&H\u0016J\b\u0010.\u001a\u00020&H\u0016J\b\u0010/\u001a\u00020\rH\u0016J\u0010\u00100\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\rH\u0004J\u0010\u00101\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0006\u00102\u001a\u00020&J\b\u00103\u001a\u00020&H\u0002J\u0018\u00104\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00105\u001a\u000206H\u0002R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u0012\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u0012\u0004\b\u0016\u0010\u0012R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lorg/gnit/lucenekmp/store/FSDirectory;", "Lorg/gnit/lucenekmp/store/BaseDirectory;", "path", "Lokio/Path;", "lockFactory", "Lorg/gnit/lucenekmp/store/LockFactory;", "<init>", "(Lokio/Path;Lorg/gnit/lucenekmp/store/LockFactory;)V", "directory", "getDirectory", "()Lokio/Path;", "pendingDeletes", "", "", "opsSinceLastDelete", "Lkotlin/concurrent/atomics/AtomicInt;", "Lorg/gnit/lucenekmp/jdkport/AtomicInteger;", "getOpsSinceLastDelete$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicInteger;", "nextTempFileCounter", "Lkotlin/concurrent/atomics/AtomicLong;", "getNextTempFileCounter$annotations", "Ljava/util/concurrent/atomic/AtomicLong;", "listAll", "", "()[Ljava/lang/String;", "fileLength", "", "name", "createOutput", "Lorg/gnit/lucenekmp/store/IndexOutput;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "createTempOutput", "prefix", "suffix", "ensureCanRead", "", "sync", "names", "", "rename", "source", "dest", "syncMetaData", "close", "toString", "fsync", "deleteFile", "deletePendingFiles", "maybeDeletePendingFiles", "privateDeleteFile", "isPendingDelete", "", "pendingDeletions", "getPendingDeletions", "()Ljava/util/Set;", "FSIndexOutput", "Companion", "core"})
public abstract class FSDirectory
extends BaseDirectory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    @NotNull
    private final Set<String> pendingDeletes;
    @NotNull
    private final AtomicInteger opsSinceLastDelete;
    @NotNull
    private final AtomicLong nextTempFileCounter;
    public static final int CHUNK_SIZE = 8192;

    protected FSDirectory(@NotNull Path path, @NotNull LockFactory lockFactory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)lockFactory, (String)"lockFactory");
        super(lockFactory);
        this.pendingDeletes = new LinkedHashSet();
        this.opsSinceLastDelete = new AtomicInteger(0);
        this.nextTempFileCounter = new AtomicLong(0L);
        if (!Files.INSTANCE.isDirectory(path)) {
            Files.INSTANCE.createDirectories(path);
        }
        this.directory = FilesKt.toRealPath(path);
    }

    @NotNull
    public final Path getDirectory() {
        return this.directory;
    }

    private static /* synthetic */ void getOpsSinceLastDelete$annotations() {
    }

    private static /* synthetic */ void getNextTempFileCounter$annotations() {
    }

    @Override
    @NotNull
    public String[] listAll() {
        this.ensureOpen();
        return FSDirectory.Companion.listAll(this.directory, this.pendingDeletes);
    }

    @Override
    public long fileLength(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureOpen();
        if (this.pendingDeletes.contains(name)) {
            throw new NoSuchFileException("file \"" + name + "\" is pending delete");
        }
        return Files.INSTANCE.size(Path.resolve$default((Path)this.directory, (String)name, (boolean)false, (int)2, null));
    }

    @Override
    @NotNull
    public IndexOutput createOutput(@NotNull String name, @NotNull IOContext context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureOpen();
        this.maybeDeletePendingFiles();
        if (this.pendingDeletes.remove(name)) {
            this.privateDeleteFile(name, true);
            this.pendingDeletes.remove(name);
        }
        return new FSIndexOutput(this, name);
    }

    @Override
    @NotNull
    public IndexOutput createTempOutput(@NotNull String prefix, @NotNull String suffix, @NotNull IOContext context) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureOpen();
        this.maybeDeletePendingFiles();
        while (true) {
            try {
                String name = Directory.Companion.getTempFileName(prefix, suffix, AtomicsKt.fetchAndIncrement((AtomicLong)this.nextTempFileCounter));
                if (this.pendingDeletes.contains(name)) continue;
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW};
                return new FSIndexOutput(this, name, openOptionArray);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    protected final void ensureCanRead(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.pendingDeletes.contains(name)) {
            throw new NoSuchFileException("file \"" + name + "\" is pending delete and cannot be opened for read");
        }
    }

    @Override
    public void sync(@NotNull Collection<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        this.ensureOpen();
        for (String name : names) {
            this.fsync(name);
        }
        this.maybeDeletePendingFiles();
    }

    @Override
    public void rename(@NotNull String source, @NotNull String dest) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.ensureOpen();
        if (this.pendingDeletes.contains(source)) {
            throw new NoSuchFileException("file \"" + source + "\" is pending delete and cannot be moved");
        }
        this.maybeDeletePendingFiles();
        if (this.pendingDeletes.remove(dest)) {
            this.privateDeleteFile(dest, true);
            this.pendingDeletes.remove(dest);
        }
        StandardCopyOption[] standardCopyOptionArray = new StandardCopyOption[]{StandardCopyOption.ATOMIC_MOVE};
        Files.INSTANCE.move(Path.resolve$default((Path)this.directory, (String)source, (boolean)false, (int)2, null), Path.resolve$default((Path)this.directory, (String)dest, (boolean)false, (int)2, null), standardCopyOptionArray);
    }

    @Override
    public void syncMetaData() {
        this.ensureOpen();
        IOUtils.INSTANCE.fsync(this.directory, true);
        this.maybeDeletePendingFiles();
    }

    @Override
    public void close() throws IOException {
        this.setOpen(false);
        this.deletePendingFiles();
    }

    @Override
    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "@" + this.directory + " lockFactory=" + this.getLockFactory();
    }

    protected final void fsync(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IOUtils.INSTANCE.fsync(Path.resolve$default((Path)this.directory, (String)name, (boolean)false, (int)2, null), false);
    }

    @Override
    public void deleteFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.pendingDeletes.contains(name)) {
            throw new NoSuchFileException("file \"" + name + "\" is already pending delete");
        }
        this.privateDeleteFile(name, false);
        this.maybeDeletePendingFiles();
    }

    public final void deletePendingFiles() throws IOException {
        if (!this.pendingDeletes.isEmpty()) {
            Iterator iterator2 = new HashSet(this.pendingDeletes).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                String name = (String)iterator3.next();
                this.privateDeleteFile(name, true);
            }
        }
    }

    private final void maybeDeletePendingFiles() throws IOException {
        int count;
        if (!this.pendingDeletes.isEmpty() && (count = AtomicsKt.incrementAndFetch((AtomicInteger)this.opsSinceLastDelete)) >= this.pendingDeletes.size()) {
            this.opsSinceLastDelete.addAndGet(-count);
            this.deletePendingFiles();
        }
    }

    private final void privateDeleteFile(String name, boolean isPendingDelete) throws IOException {
        try {
            Files.INSTANCE.delete(Path.resolve$default((Path)this.directory, (String)name, (boolean)false, (int)2, null));
            this.pendingDeletes.remove(name);
        }
        catch (NoSuchFileException e) {
            this.pendingDeletes.remove(name);
            if (!isPendingDelete || !Constants.INSTANCE.getWINDOWS()) {
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            this.pendingDeletes.remove(name);
            if (!isPendingDelete || !Constants.INSTANCE.getWINDOWS()) {
                throw e;
            }
        }
        catch (IOException ioe) {
            this.pendingDeletes.add(name);
        }
    }

    @Override
    @NotNull
    public Set<String> getPendingDeletions() {
        this.deletePendingFiles();
        if (this.pendingDeletes.isEmpty()) {
            return new LinkedHashSet();
        }
        return CollectionsKt.toMutableSet((Iterable)this.pendingDeletes);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010J)\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/store/FSDirectory$Companion;", "", "<init>", "()V", "CHUNK_SIZE", "", "open", "Lorg/gnit/lucenekmp/store/FSDirectory;", "path", "Lokio/Path;", "lockFactory", "Lorg/gnit/lucenekmp/store/LockFactory;", "listAll", "", "", "dir", "(Lokio/Path;)[Ljava/lang/String;", "skipNames", "", "(Lokio/Path;Ljava/util/Set;)[Ljava/lang/String;", "core"})
    @SourceDebugExtension(value={"SMAP\nFSDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSDirectory.kt\norg/gnit/lucenekmp/store/FSDirectory$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,418:1\n1321#2,2:419\n37#3:421\n36#3,3:422\n*S KotlinDebug\n*F\n+ 1 FSDirectory.kt\norg/gnit/lucenekmp/store/FSDirectory$Companion\n*L\n403#1:419,2\n410#1:421\n410#1:422,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final FSDirectory open(@NotNull Path path, @NotNull LockFactory lockFactory) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)lockFactory, (String)"lockFactory");
            return new NIOFSDirectory(path, lockFactory);
        }

        public static /* synthetic */ FSDirectory open$default(Companion companion, Path path, LockFactory lockFactory, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                lockFactory = FSLockFactory.Companion.getDefault();
            }
            return companion.open(path, lockFactory);
        }

        @NotNull
        public final String[] listAll(@NotNull Path dir) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            return this.listAll(dir, SetsKt.emptySet());
        }

        private final String[] listAll(Path dir, Set<String> skipNames) throws IOException {
            List entries2 = new ArrayList();
            Sequence<Path> $this$forEach$iv = Files.INSTANCE.newDirectoryStream(dir);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path path = (Path)element$iv;
                boolean bl = false;
                String name = path.name();
                if (!skipNames.isEmpty() && skipNames.contains(name)) continue;
                entries2.add(name);
            }
            Collection $this$toTypedArray$iv = entries2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] array = thisCollection$iv.toArray(new String[0]);
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort((Comparable[])array);
            return array;
        }

        @JvmOverloads
        @NotNull
        public final FSDirectory open(@NotNull Path path) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return org.gnit.lucenekmp.store.FSDirectory$Companion.open$default(this, path, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/store/FSDirectory$FSIndexOutput;", "Lorg/gnit/lucenekmp/store/OutputStreamIndexOutput;", "name", "", "options", "", "Lorg/gnit/lucenekmp/jdkport/OpenOption;", "<init>", "(Lorg/gnit/lucenekmp/store/FSDirectory;Ljava/lang/String;[Lorg/gnit/lucenekmp/jdkport/OpenOption;)V", "(Lorg/gnit/lucenekmp/store/FSDirectory;Ljava/lang/String;)V", "core"})
    public final class FSIndexOutput
    extends OutputStreamIndexOutput {
        final /* synthetic */ FSDirectory this$0;

        public FSIndexOutput(@NotNull FSDirectory this$0, @NotNull String name, OpenOption ... options) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            this.this$0 = this$0;
            OutputStream outputStream = Files.INSTANCE.newOutputStream(Path.resolve$default((Path)this$0.getDirectory(), (String)name, (boolean)false, (int)2, null), Arrays.copyOf(options, options.length));
            super("FSIndexOutput(path=\"" + Path.resolve$default((Path)this$0.getDirectory(), (String)name, (boolean)false, (int)2, null) + "\")", name, new FilterOutputStream(outputStream){

                @Override
                public void write(byte[] b, int offset, int length) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    int offset2 = offset;
                    int length2 = length;
                    while (length2 > 0) {
                        int chunk = Math.min(length2, 8192);
                        OutputStream outputStream = this.getOut();
                        Intrinsics.checkNotNull((Object)outputStream);
                        outputStream.write(b, offset2, chunk);
                        length2 -= chunk;
                        offset2 += chunk;
                    }
                }
            }, 8192);
        }

        public FSIndexOutput(@NotNull FSDirectory this$0, String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW};
            this(this$0, name, openOptionArray);
        }
    }
}

