/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Optional;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH&J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bH&J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000bH&J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016J \u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH&J&\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0004J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\"\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/store/IndexInput;", "Lorg/gnit/lucenekmp/store/DataInput;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "resourceDescription", "", "<init>", "(Ljava/lang/String;)V", "close", "", "filePointer", "", "getFilePointer", "()J", "seek", "pos", "skipBytes", "numBytes", "length", "toString", "clone", "slice", "sliceDescription", "offset", "readAdvice", "Lorg/gnit/lucenekmp/store/ReadAdvice;", "getFullSliceDescription", "randomAccessSlice", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "prefetch", "updateReadAdvice", "isLoaded", "Lorg/gnit/lucenekmp/jdkport/Optional;", "", "()Lorg/gnit/lucenekmp/jdkport/Optional;", "core"})
@SourceDebugExtension(value={"SMAP\nIndexInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexInput.kt\norg/gnit/lucenekmp/store/IndexInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1#2:245\n*E\n"})
public abstract class IndexInput
extends DataInput
implements AutoCloseable {
    @NotNull
    private final String resourceDescription;

    protected IndexInput(@NotNull String resourceDescription) {
        Intrinsics.checkNotNullParameter((Object)resourceDescription, (String)"resourceDescription");
        this.resourceDescription = resourceDescription;
    }

    @Override
    public abstract void close();

    public abstract long getFilePointer();

    public abstract void seek(long var1) throws IOException;

    @Override
    public void skipBytes(long numBytes) throws IOException {
        if (!(numBytes >= 0L)) {
            boolean bl = false;
            String string = "numBytes must be >= 0, got " + numBytes;
            throw new IllegalArgumentException(string.toString());
        }
        long skipTo = this.getFilePointer() + numBytes;
        this.seek(skipTo);
    }

    public abstract long length();

    @NotNull
    public String toString() {
        return this.resourceDescription;
    }

    @Override
    @NotNull
    public IndexInput clone() {
        long pos = this.getFilePointer();
        IndexInput clone = this.slice("clone", 0L, this.length());
        clone.seek(pos);
        return clone;
    }

    @NotNull
    public abstract IndexInput slice(@NotNull String var1, long var2, long var4) throws IOException;

    @NotNull
    public final IndexInput slice(@NotNull String sliceDescription, long offset, long length, @NotNull ReadAdvice readAdvice) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
        Intrinsics.checkNotNullParameter((Object)((Object)readAdvice), (String)"readAdvice");
        return this.slice(sliceDescription, offset, length);
    }

    @NotNull
    protected final String getFullSliceDescription(@Nullable String sliceDescription) {
        return sliceDescription == null ? this.toString() : this + " [slice=" + sliceDescription + "]";
    }

    @NotNull
    public final RandomAccessInput randomAccessSlice(long offset, long length) throws IOException {
        IndexInput slice = this.slice("randomaccess", offset, length);
        if (slice instanceof RandomAccessInput) {
            return (RandomAccessInput)((Object)slice);
        }
        return new RandomAccessInput(length, slice, this){
            final /* synthetic */ long $length;
            final /* synthetic */ IndexInput $slice;
            final /* synthetic */ IndexInput this$0;
            {
                this.$length = $length;
                this.$slice = $slice;
                this.this$0 = $receiver;
            }

            public long length() {
                if (!(this.$length == this.$slice.length())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return this.$slice.length();
            }

            public byte readByte(long pos) throws IOException {
                this.$slice.seek(pos);
                return this.$slice.readByte();
            }

            public void readBytes(long pos, byte[] bytes, int offset, int length) throws IOException {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                this.$slice.seek(pos);
                this.$slice.readBytes(bytes, offset, length);
            }

            public short readShort(long pos) throws IOException {
                this.$slice.seek(pos);
                return this.$slice.readShort();
            }

            public int readInt(long pos) throws IOException {
                this.$slice.seek(pos);
                return this.$slice.readInt();
            }

            public long readLong(long pos) throws IOException {
                this.$slice.seek(pos);
                return this.$slice.readLong();
            }

            public void prefetch(long offset, long length) throws IOException {
                this.$slice.prefetch(offset, length);
            }

            public String toString() {
                return "RandomAccessInput(" + this.this$0 + ")";
            }
        };
    }

    public void prefetch(long offset, long length) throws IOException {
    }

    public final void updateReadAdvice(@Nullable ReadAdvice readAdvice) throws IOException {
    }

    @NotNull
    public final Optional<Boolean> isLoaded() {
        return Optional.Companion.empty();
    }
}

