/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.InputStream;
import org.gnit.lucenekmp.store.DataInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/store/InputStreamDataInput;", "Lorg/gnit/lucenekmp/store/DataInput;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "is", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/InputStream;)V", "readByte", "", "readBytes", "", "b", "", "offset", "", "len", "close", "skipBytes", "numBytes", "", "core"})
@SourceDebugExtension(value={"SMAP\nInputStreamDataInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputStreamDataInput.kt\norg/gnit/lucenekmp/store/InputStreamDataInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public class InputStreamDataInput
extends DataInput
implements AutoCloseable {
    @NotNull
    private final InputStream is;

    public InputStreamDataInput(@NotNull InputStream is) {
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        this.is = is;
    }

    @Override
    public byte readByte() throws IOException {
        int v = this.is.read();
        if (v == -1) {
            throw new EOFException();
        }
        return (byte)v;
    }

    @Override
    public void readBytes(@NotNull byte[] b, int offset, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int offset2 = offset;
        int len2 = len;
        while (len2 > 0) {
            int cnt = this.is.read(b, offset2, len2);
            if (cnt < 0) {
                throw new EOFException();
            }
            len2 -= cnt;
            offset2 += cnt;
        }
    }

    @Override
    public void close() {
        this.is.close();
    }

    @Override
    public void skipBytes(long numBytes) throws IOException {
        if (!(numBytes >= 0L)) {
            boolean bl = false;
            String string = "numBytes must be >= 0, got " + numBytes;
            throw new IllegalArgumentException(string.toString());
        }
        long skipped = this.is.skip(numBytes);
        if (!(skipped <= numBytes)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (skipped < numBytes) {
            throw new EOFException();
        }
    }
}

