/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Optional;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.FSDirectory;
import org.gnit.lucenekmp.store.FSLockFactory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.LockFactory;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.Constants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0002$%B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ \u0010\u001b\u001a\u00020\u001c2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fJ \u0010\u001d\u001a\u00020\u001c2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00160\u0015J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000eH\u0016R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/store/MMapDirectory;", "Lorg/gnit/lucenekmp/store/FSDirectory;", "path", "Lokio/Path;", "lockFactory", "Lorg/gnit/lucenekmp/store/LockFactory;", "maxChunkSize", "", "<init>", "(Lokio/Path;Lorg/gnit/lucenekmp/store/LockFactory;J)V", "(Lokio/Path;J)V", "preload", "Lkotlin/Function2;", "", "Lorg/gnit/lucenekmp/store/IOContext;", "", "attachment", "", "getAttachment", "()Ljava/lang/Object;", "groupingFunction", "Lkotlin/Function1;", "Lorg/gnit/lucenekmp/jdkport/Optional;", "chunkSizePower", "", "getChunkSizePower", "()I", "setPreload", "", "setGroupingFunction", "getMaxChunkSize", "()J", "openInput", "Lorg/gnit/lucenekmp/store/IndexInput;", "name", "context", "MMapIndexInputProvider", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMMapDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MMapDirectory.kt\norg/gnit/lucenekmp/store/MMapDirectory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,404:1\n1#2:405\n3#3,8:406\n3#3,8:415\n10#4:414\n10#4:423\n*S KotlinDebug\n*F\n+ 1 MMapDirectory.kt\norg/gnit/lucenekmp/store/MMapDirectory\n*L\n248#1:406,8\n249#1:415,8\n248#1:414\n249#1:423\n*E\n"})
public final class MMapDirectory
extends FSDirectory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Function2<? super String, ? super IOContext, Boolean> preload;
    @Nullable
    private final Object attachment;
    @NotNull
    private Function1<? super String, Optional<String>> groupingFunction;
    private final int chunkSizePower;
    @NotNull
    private static final Function2<String, IOContext, Boolean> ALL_FILES = MMapDirectory::ALL_FILES$lambda$1;
    @NotNull
    private static final Function2<String, IOContext, Boolean> NO_FILES = MMapDirectory::NO_FILES$lambda$2;
    @NotNull
    public static final String SHARED_ARENA_MAX_PERMITS_SYSPROP = "org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits";
    @NotNull
    private static final Function1<String, Optional<String>> NO_GROUPING = MMapDirectory::NO_GROUPING$lambda$3;
    @NotNull
    private static final Function1<String, Optional<String>> GROUP_BY_SEGMENT = MMapDirectory::GROUP_BY_SEGMENT$lambda$4;
    @NotNull
    private static final Function2<String, IOContext, Boolean> BASED_ON_LOAD_IO_CONTEXT = MMapDirectory::BASED_ON_LOAD_IO_CONTEXT$lambda$5;
    private static final long DEFAULT_MAX_CHUNK_SIZE;
    @NotNull
    private static final MMapIndexInputProvider<Object> PROVIDER;
    @NotNull
    private static final KLogger logger;

    public MMapDirectory(@NotNull Path path, @NotNull LockFactory lockFactory, long maxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)lockFactory, (String)"lockFactory");
        super(path, lockFactory);
        this.preload = NO_FILES;
        this.attachment = PROVIDER.attachment();
        this.groupingFunction = GROUP_BY_SEGMENT;
        if (!(maxChunkSize > 0L)) {
            boolean bl = false;
            String string = "Maximum chunk size for mmap must be >0";
            throw new IllegalArgumentException(string.toString());
        }
        this.chunkSizePower = 63 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, maxChunkSize);
        boolean condition$iv = 1L << this.chunkSizePower <= maxChunkSize;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = 1L << this.chunkSizePower > maxChunkSize / (long)2;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ MMapDirectory(Path path, LockFactory lockFactory, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lockFactory = FSLockFactory.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            l = DEFAULT_MAX_CHUNK_SIZE;
        }
        this(path, lockFactory, l);
    }

    @Nullable
    public final Object getAttachment() {
        return this.attachment;
    }

    public final int getChunkSizePower() {
        return this.chunkSizePower;
    }

    public MMapDirectory(@NotNull Path path, long maxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, FSLockFactory.Companion.getDefault(), maxChunkSize);
    }

    public final void setPreload(@NotNull Function2<? super String, ? super IOContext, Boolean> preload) {
        Intrinsics.checkNotNullParameter(preload, (String)"preload");
        this.preload = preload;
    }

    public final void setGroupingFunction(@NotNull Function1<? super String, Optional<String>> groupingFunction) {
        Intrinsics.checkNotNullParameter(groupingFunction, (String)"groupingFunction");
        this.groupingFunction = groupingFunction;
    }

    public final long getMaxChunkSize() {
        return 1L << this.chunkSizePower;
    }

    @Override
    @NotNull
    public IndexInput openInput(@NotNull String name, @NotNull IOContext context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = Path.resolve$default((Path)this.getDirectory(), (String)name, (boolean)false, (int)2, null);
        return PROVIDER.openInput(path, context, this.chunkSizePower, (Boolean)this.preload.invoke((Object)name, (Object)context), (Optional)this.groupingFunction.invoke((Object)name), this.attachment);
    }

    private static final boolean ALL_FILES$lambda$1(String string, IOContext context) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    private static final boolean NO_FILES$lambda$2(String string, IOContext context) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return false;
    }

    private static final Optional NO_GROUPING$lambda$3(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return Optional.Companion.empty();
    }

    private static final Optional GROUP_BY_SEGMENT$lambda$4(String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (!IndexFileNames.INSTANCE.getCODEC_FILE_PATTERN().matches((CharSequence)filename)) {
            return Optional.Companion.empty();
        }
        String string = IndexFileNames.INSTANCE.parseSegmentName(filename).substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Object groupKey = string;
        try {
            if (IndexFileNames.INSTANCE.parseGeneration(filename) > 0L) {
                groupKey = (String)groupKey + "-g";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Optional.Companion.of(groupKey);
    }

    private static final boolean BASED_ON_LOAD_IO_CONTEXT$lambda$5(String string, IOContext context) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getReadAdvice() == ReadAdvice.RANDOM_PRELOAD;
    }

    private static final Unit logger$lambda$6() {
        return Unit.INSTANCE;
    }

    static {
        logger = KotlinLogging.INSTANCE.logger(MMapDirectory::logger$lambda$6);
        PROVIDER = MMapDirectory.Companion.lookupProvider();
        DEFAULT_MAX_CHUNK_SIZE = PROVIDER.getDefaultMaxChunkSize();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u0002H&0\u001c\"\u0004\b\u0000\u0010&H\u0002J\u0006\u0010'\u001a\u00020\bR#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R#\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R#\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/store/MMapDirectory$Companion;", "", "<init>", "()V", "ALL_FILES", "Lkotlin/Function2;", "", "Lorg/gnit/lucenekmp/store/IOContext;", "", "getALL_FILES", "()Lkotlin/jvm/functions/Function2;", "NO_FILES", "getNO_FILES", "SHARED_ARENA_MAX_PERMITS_SYSPROP", "NO_GROUPING", "Lkotlin/Function1;", "Lorg/gnit/lucenekmp/jdkport/Optional;", "getNO_GROUPING", "()Lkotlin/jvm/functions/Function1;", "GROUP_BY_SEGMENT", "getGROUP_BY_SEGMENT", "BASED_ON_LOAD_IO_CONTEXT", "getBASED_ON_LOAD_IO_CONTEXT", "DEFAULT_MAX_CHUNK_SIZE", "", "getDEFAULT_MAX_CHUNK_SIZE", "()J", "PROVIDER", "Lorg/gnit/lucenekmp/store/MMapDirectory$MMapIndexInputProvider;", "getPROVIDER", "()Lorg/gnit/lucenekmp/store/MMapDirectory$MMapIndexInputProvider;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "sharedArenaMaxPermitsSysprop", "", "getSharedArenaMaxPermitsSysprop", "()I", "lookupProvider", "A", "supportsMadvise", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function2<String, IOContext, Boolean> getALL_FILES() {
            return ALL_FILES;
        }

        @NotNull
        public final Function2<String, IOContext, Boolean> getNO_FILES() {
            return NO_FILES;
        }

        @NotNull
        public final Function1<String, Optional<String>> getNO_GROUPING() {
            return NO_GROUPING;
        }

        @NotNull
        public final Function1<String, Optional<String>> getGROUP_BY_SEGMENT() {
            return GROUP_BY_SEGMENT;
        }

        @NotNull
        public final Function2<String, IOContext, Boolean> getBASED_ON_LOAD_IO_CONTEXT() {
            return BASED_ON_LOAD_IO_CONTEXT;
        }

        public final long getDEFAULT_MAX_CHUNK_SIZE() {
            return DEFAULT_MAX_CHUNK_SIZE;
        }

        @NotNull
        public final MMapIndexInputProvider<Object> getPROVIDER() {
            return PROVIDER;
        }

        private final int getSharedArenaMaxPermitsSysprop() {
            int ret = 1024;
            try {
                String str = System.getProperty$default(System.INSTANCE, MMapDirectory.SHARED_ARENA_MAX_PERMITS_SYSPROP, null, 2, null);
                if (str != null) {
                    ret = Integer.parseInt(str);
                }
            }
            catch (NumberFormatException ignored) {
                logger.warn(Companion::_get_sharedArenaMaxPermitsSysprop_$lambda$0);
            }
            catch (Exception ignored) {
                logger.warn(Companion::_get_sharedArenaMaxPermitsSysprop_$lambda$1);
            }
            return ret;
        }

        private final <A> MMapIndexInputProvider<A> lookupProvider() {
            int maxPermits = this.getSharedArenaMaxPermitsSysprop();
            throw new UnsupportedOperationException("MMapDirectory is not supported in lucene-kmp, because it uses JDK 21+ APIs that are not available in KMP.");
        }

        public final boolean supportsMadvise() {
            return this.getPROVIDER().supportsMadvise();
        }

        private static final Object _get_sharedArenaMaxPermitsSysprop_$lambda$0() {
            return "Cannot read sysprop org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits, so the default value will be used.";
        }

        private static final Object _get_sharedArenaMaxPermitsSysprop_$lambda$1() {
            return "Cannot read sysprop org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits, so the default value will be used.";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002JE\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0016\u001a\u00020\fH&J\u000f\u0010\u0010\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J(\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u001b\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/store/MMapDirectory$MMapIndexInputProvider;", "A", "", "openInput", "Lorg/gnit/lucenekmp/store/IndexInput;", "path", "Lokio/Path;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "chunkSizePower", "", "preload", "", "group", "Lorg/gnit/lucenekmp/jdkport/Optional;", "", "attachment", "(Lokio/Path;Lorg/gnit/lucenekmp/store/IOContext;IZLorg/gnit/lucenekmp/jdkport/Optional;Ljava/lang/Object;)Lorg/gnit/lucenekmp/store/IndexInput;", "defaultMaxChunkSize", "", "getDefaultMaxChunkSize", "()J", "supportsMadvise", "()Ljava/lang/Object;", "convertMapFailedIOException", "Ljava/io/IOException;", "Lokio/IOException;", "ioe", "resourceDescription", "bufSize", "core"})
    public static interface MMapIndexInputProvider<A> {
        @NotNull
        public IndexInput openInput(@NotNull Path var1, @NotNull IOContext var2, int var3, boolean var4, @NotNull Optional<String> var5, @Nullable A var6) throws IOException;

        public long getDefaultMaxChunkSize();

        public boolean supportsMadvise();

        @Nullable
        default public A attachment() {
            return null;
        }

        @NotNull
        default public IOException convertMapFailedIOException(@NotNull IOException ioe, @NotNull String resourceDescription, long bufSize) {
            Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
            Intrinsics.checkNotNullParameter((Object)resourceDescription, (String)"resourceDescription");
            String originalMessage = null;
            Throwable originalCause = null;
            if (ioe.getCause() instanceof Error) {
                originalMessage = "Map failed";
                originalCause = null;
            } else {
                originalMessage = ioe.getMessage();
                originalCause = ioe.getCause();
            }
            String moreInfo = null;
            moreInfo = !Constants.INSTANCE.getJRE_IS_64BIT() ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.INSTANCE.getWINDOWS() ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.INSTANCE.getLINUX() ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
            IOException newIoe = new IOException(originalMessage + ": " + resourceDescription + " [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of " + bufSize + " bytes. " + moreInfo + " More information: https://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]" + ExceptionsKt.stackTraceToString((Throwable)ioe), originalCause);
            return newIoe;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            @Nullable
            public static <A> A attachment(@NotNull MMapIndexInputProvider<A> $this) {
                return (A)((MMapIndexInputProvider)$this).attachment();
            }

            @Deprecated
            @NotNull
            public static <A> IOException convertMapFailedIOException(@NotNull MMapIndexInputProvider<A> $this, @NotNull IOException ioe, @NotNull String resourceDescription, long bufSize) {
                Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
                Intrinsics.checkNotNullParameter((Object)resourceDescription, (String)"resourceDescription");
                return ((MMapIndexInputProvider)$this).convertMapFailedIOException(ioe, resourceDescription, bufSize);
            }
        }
    }
}

