/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.BufferedOutputStream;
import org.gnit.lucenekmp.jdkport.CRC32;
import org.gnit.lucenekmp.jdkport.CheckedOutputStream;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.BitUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0010H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020\u0010H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/store/OutputStreamIndexOutput;", "Lorg/gnit/lucenekmp/store/IndexOutput;", "resourceDescription", "", "name", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "bufferSize", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/gnit/lucenekmp/jdkport/OutputStream;I)V", "crc", "Lorg/gnit/lucenekmp/jdkport/CRC32;", "os", "Lorg/gnit/lucenekmp/store/OutputStreamIndexOutput$XBufferedOutputStream;", "filePointer", "", "getFilePointer", "()J", "setFilePointer", "(J)V", "flushedOnClose", "", "writeByte", "", "b", "", "writeBytes", "", "offset", "length", "writeShort", "i", "", "writeInt", "writeLong", "close", "getChecksum", "XBufferedOutputStream", "core"})
@SourceDebugExtension(value={"SMAP\nOutputStreamIndexOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutputStreamIndexOutput.kt\norg/gnit/lucenekmp/store/OutputStreamIndexOutput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public class OutputStreamIndexOutput
extends IndexOutput {
    @NotNull
    private final CRC32 crc;
    @NotNull
    private final XBufferedOutputStream os;
    private long filePointer;
    private boolean flushedOnClose;

    public OutputStreamIndexOutput(@NotNull String resourceDescription, @NotNull String name, @NotNull OutputStream out, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)resourceDescription, (String)"resourceDescription");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super(resourceDescription, name);
        this.crc = new CRC32();
        if (!(bufferSize >= 8)) {
            boolean bl = false;
            String string = "Buffer size too small, need: 8";
            throw new IllegalArgumentException(string.toString());
        }
        this.os = new XBufferedOutputStream(new CheckedOutputStream(out, this.crc), bufferSize);
    }

    @Override
    public long getFilePointer() {
        return this.filePointer;
    }

    public void setFilePointer(long l) {
        this.filePointer = l;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.os.write(b);
        long l = this.getFilePointer();
        this.setFilePointer(l + 1L);
    }

    @Override
    public void writeBytes(@NotNull byte[] b, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.os.write(b, offset, length);
        this.setFilePointer(this.getFilePointer() + (long)length);
    }

    @Override
    public void writeShort(short i) throws IOException {
        this.os.writeShort(i);
        this.setFilePointer(this.getFilePointer() + 2L);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.os.writeInt(i);
        this.setFilePointer(this.getFilePointer() + 4L);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.os.writeLong(i);
        this.setFilePointer(this.getFilePointer() + 8L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AutoCloseable autoCloseable = this.os;
        Throwable throwable = null;
        try {
            XBufferedOutputStream o = (XBufferedOutputStream)autoCloseable;
            boolean bl = false;
            if (!this.flushedOnClose) {
                this.flushedOnClose = true;
                o.flush();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public long getChecksum() {
        this.os.flush();
        return this.crc.getValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/store/OutputStreamIndexOutput$XBufferedOutputStream;", "Lorg/gnit/lucenekmp/jdkport/BufferedOutputStream;", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "size", "", "<init>", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;I)V", "flushIfNeeded", "", "len", "writeShort", "i", "", "writeInt", "writeLong", "", "write", "b", "core"})
    private static final class XBufferedOutputStream
    extends BufferedOutputStream {
        public XBufferedOutputStream(@NotNull OutputStream out, int size2) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super(out, size2);
        }

        public final void flushIfNeeded(int len) throws IOException {
            if (len > this.getBuf().length - this.getCount()) {
                this.flush();
            }
        }

        public final void writeShort(short i) throws IOException {
            this.flushIfNeeded(2);
            BitUtil.VH_LE_SHORT.INSTANCE.set(this.getBuf(), this.getCount(), i);
            this.setCount(this.getCount() + 2);
        }

        public final void writeInt(int i) throws IOException {
            this.flushIfNeeded(4);
            BitUtil.VH_LE_INT.INSTANCE.set(this.getBuf(), this.getCount(), i);
            this.setCount(this.getCount() + 4);
        }

        public final void writeLong(long i) throws IOException {
            this.flushIfNeeded(8);
            BitUtil.VH_LE_LONG.INSTANCE.set(this.getBuf(), this.getCount(), i);
            this.setCount(this.getCount() + 8);
        }

        @Override
        public void write(int b) throws IOException {
            byte[] buffer = this.getBuf();
            int count = this.getCount();
            if (count >= buffer.length) {
                super.write(b);
            } else {
                buffer[count] = (byte)b;
                this.setCount(count + 1);
            }
        }
    }
}

