/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.Lock;
import org.gnit.lucenekmp.store.LockFactory;
import org.gnit.lucenekmp.store.LockObtainFailedException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/store/SingleInstanceLockFactory;", "Lorg/gnit/lucenekmp/store/LockFactory;", "<init>", "()V", "locks", "", "", "obtainLock", "Lorg/gnit/lucenekmp/store/Lock;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "lockName", "SingleInstanceLock", "core"})
public final class SingleInstanceLockFactory
extends LockFactory {
    @NotNull
    private final Set<String> locks = new LinkedHashSet();

    @Override
    @NotNull
    public Lock obtainLock(@NotNull Directory dir, @NotNull String lockName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
        if (!this.locks.add(lockName)) {
            throw new LockObtainFailedException("lock instance already obtained: (dir=" + dir + ", lockName=" + lockName + ")");
        }
        return new SingleInstanceLock(lockName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/store/SingleInstanceLockFactory$SingleInstanceLock;", "Lorg/gnit/lucenekmp/store/Lock;", "lockName", "", "<init>", "(Lorg/gnit/lucenekmp/store/SingleInstanceLockFactory;Ljava/lang/String;)V", "closed", "", "ensureValid", "", "close", "toString", "core"})
    private final class SingleInstanceLock
    extends Lock {
        @NotNull
        private final String lockName;
        private volatile boolean closed;

        public SingleInstanceLock(String lockName) {
            Intrinsics.checkNotNullParameter((Object)lockName, (String)"lockName");
            this.lockName = lockName;
        }

        @Override
        public void ensureValid() throws IOException {
            if (this.closed) {
                throw new AlreadyClosedException("Lock instance already released: " + this);
            }
            if (!SingleInstanceLockFactory.this.locks.contains(this.lockName)) {
                throw new AlreadyClosedException("Lock instance was invalidated from map: " + this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            try {
                if (!SingleInstanceLockFactory.this.locks.remove(this.lockName)) {
                    throw new AlreadyClosedException("Lock was already released: " + this);
                }
            }
            finally {
                this.closed = true;
            }
        }

        @NotNull
        public String toString() {
            return super.toString() + ": " + this.lockName;
        }
    }
}

