/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.store;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.FilterDirectory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0006\u0010\u001c\u001a\u00020\nR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/store/TrackingDirectoryWrapper;", "Lorg/gnit/lucenekmp/store/FilterDirectory;", "in", "Lorg/gnit/lucenekmp/store/Directory;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;)V", "createdFileNames", "", "", "deleteFile", "", "name", "createOutput", "Lorg/gnit/lucenekmp/store/IndexOutput;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "createTempOutput", "prefix", "suffix", "copyFrom", "from", "src", "dest", "rename", "source", "createdFiles", "getCreatedFiles", "()Ljava/util/Set;", "clearCreatedFiles", "core"})
public final class TrackingDirectoryWrapper
extends FilterDirectory {
    @NotNull
    private final Set<String> createdFileNames;

    public TrackingDirectoryWrapper(@NotNull Directory in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        super(in);
        this.createdFileNames = new LinkedHashSet();
    }

    @Override
    public void deleteFile(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.getIn().deleteFile(name);
        this.createdFileNames.remove(name);
    }

    @Override
    @NotNull
    public IndexOutput createOutput(@NotNull String name, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IndexOutput output = this.getIn().createOutput(name, context);
        this.createdFileNames.add(name);
        return output;
    }

    @Override
    @NotNull
    public IndexOutput createTempOutput(@NotNull String prefix, @NotNull String suffix, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IndexOutput tempOutput = this.getIn().createTempOutput(prefix, suffix, context);
        this.createdFileNames.add(tempOutput.getName());
        return tempOutput;
    }

    @Override
    public void copyFrom(@NotNull Directory from, @NotNull String src, @NotNull String dest, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.getIn().copyFrom(from, src, dest, context);
        this.createdFileNames.add(dest);
    }

    @Override
    public void rename(@NotNull String source, @NotNull String dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.getIn().rename(source, dest);
        this.createdFileNames.add(dest);
        this.createdFileNames.remove(source);
    }

    @NotNull
    public final Set<String> getCreatedFiles() {
        return new HashSet(this.createdFileNames);
    }

    public final void clearCreatedFiles() {
        this.createdFileNames.clear();
    }
}

