/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.IntroSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\"\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/util/ArrayIntroSorter;", "T", "Lorg/gnit/lucenekmp/util/IntroSorter;", "arr", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "([Ljava/lang/Object;Ljava/util/Comparator;)V", "[Ljava/lang/Object;", "pivot", "Ljava/lang/Object;", "compare", "", "i", "j", "swap", "", "setPivot", "comparePivot", "core"})
public final class ArrayIntroSorter<T>
extends IntroSorter {
    @NotNull
    private final T[] arr;
    @NotNull
    private final Comparator<? super T> comparator;
    @Nullable
    private T pivot;

    public ArrayIntroSorter(@NotNull T[] arr, @NotNull Comparator<? super T> comparator2) {
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
        this.arr = arr;
        this.comparator = comparator2;
        this.pivot = null;
    }

    @Override
    protected int compare(int i, int j) {
        return this.comparator.compare(this.arr[i], this.arr[j]);
    }

    @Override
    protected void swap(int i, int j) {
        ArrayUtil.Companion.swap(this.arr, i, j);
    }

    @Override
    protected void setPivot(int i) {
        this.pivot = this.arr[i];
    }

    @Override
    protected int comparePivot(int i) {
        T t = this.pivot;
        Intrinsics.checkNotNull(t);
        return this.comparator.compare(t, this.arr[i]);
    }
}

