/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import dev.scottpierce.envvar.EnvVar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006'()*+,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\r2\u0006\u0010\"\u001a\u00020\rJ\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\rJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/util/BitUtil;", "", "<init>", "()V", "NATIVE_BYTE_ORDER", "Lorg/gnit/lucenekmp/jdkport/ByteOrder;", "getNATIVE_BYTE_ORDER", "()Lorg/gnit/lucenekmp/jdkport/ByteOrder;", "nativeByteOrder", "getNativeByteOrder", "nextHighestPowerOfTwo", "", "v", "", "MAGIC0", "MAGIC1", "MAGIC2", "MAGIC3", "MAGIC4", "MAGIC5", "MAGIC6", "SHIFT0", "SHIFT1", "SHIFT2", "SHIFT3", "SHIFT4", "interleave", "even", "odd", "deinterleave", "b", "flipFlop", "zigZagEncode", "i", "l", "zigZagDecode", "isZeroOrPowerOfTwo", "", "x", "VH_LE_SHORT", "VH_LE_INT", "VH_LE_LONG", "VH_NATIVE_INT", "VH_BE_SHORT", "VH_BE_INT", "core"})
public final class BitUtil {
    @NotNull
    public static final BitUtil INSTANCE = new BitUtil();
    @NotNull
    private static final ByteOrder NATIVE_BYTE_ORDER = INSTANCE.getNativeByteOrder();
    private static final long MAGIC0 = 0x5555555555555555L;
    private static final long MAGIC1 = 0x3333333333333333L;
    private static final long MAGIC2 = 0xF0F0F0F0F0F0F0FL;
    private static final long MAGIC3 = 0xFF00FF00FF00FFL;
    private static final long MAGIC4 = 0xFFFF0000FFFFL;
    private static final long MAGIC5 = 0xFFFFFFFFL;
    private static final long MAGIC6 = -6148914691236517206L;
    private static final long SHIFT0 = 1L;
    private static final long SHIFT1 = 2L;
    private static final long SHIFT2 = 4L;
    private static final long SHIFT3 = 8L;
    private static final long SHIFT4 = 16L;

    private BitUtil() {
    }

    @NotNull
    public final ByteOrder getNATIVE_BYTE_ORDER() {
        return NATIVE_BYTE_ORDER;
    }

    private final ByteOrder getNativeByteOrder() {
        try {
            String prop = EnvVar.INSTANCE.get("tests.seed");
            if (prop != null) {
                return prop.hashCode() % 2 == 0 ? ByteOrder.Companion.getLITTLE_ENDIAN() : ByteOrder.Companion.getBIG_ENDIAN();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ByteOrder.Companion.nativeOrder();
    }

    public final int nextHighestPowerOfTwo(int v) {
        int v2 = v;
        --v2;
        v2 |= v2 >> 1;
        v2 |= v2 >> 2;
        v2 |= v2 >> 4;
        v2 |= v2 >> 8;
        v2 |= v2 >> 16;
        return ++v2;
    }

    public final long nextHighestPowerOfTwo(long v) {
        long v2;
        long l = v2 = v;
        v2 = l + -1L;
        v2 |= v2 >> 1;
        v2 |= v2 >> 2;
        v2 |= v2 >> 4;
        v2 |= v2 >> 8;
        v2 |= v2 >> 16;
        v2 |= v2 >> 32;
        l = v2;
        v2 = l + 1L;
        return v2;
    }

    public final long interleave(int even, int odd) {
        long v1 = 0xFFFFFFFFL & (long)even;
        long v2 = 0xFFFFFFFFL & (long)odd;
        v1 = (v1 | v1 << 16) & 0xFFFF0000FFFFL;
        v1 = (v1 | v1 << 8) & 0xFF00FF00FF00FFL;
        v1 = (v1 | v1 << 4) & 0xF0F0F0F0F0F0F0FL;
        v1 = (v1 | v1 << 2) & 0x3333333333333333L;
        v1 = (v1 | v1 << 1) & 0x5555555555555555L;
        v2 = (v2 | v2 << 16) & 0xFFFF0000FFFFL;
        v2 = (v2 | v2 << 8) & 0xFF00FF00FF00FFL;
        v2 = (v2 | v2 << 4) & 0xF0F0F0F0F0F0F0FL;
        v2 = (v2 | v2 << 2) & 0x3333333333333333L;
        v2 = (v2 | v2 << 1) & 0x5555555555555555L;
        return v2 << 1 | v1;
    }

    public final long deinterleave(long b) {
        long b2 = b;
        b2 &= 0x5555555555555555L;
        b2 = (b2 ^ b2 >>> 1) & 0x3333333333333333L;
        b2 = (b2 ^ b2 >>> 2) & 0xF0F0F0F0F0F0F0FL;
        b2 = (b2 ^ b2 >>> 4) & 0xFF00FF00FF00FFL;
        b2 = (b2 ^ b2 >>> 8) & 0xFFFF0000FFFFL;
        b2 = (b2 ^ b2 >>> 16) & 0xFFFFFFFFL;
        return b2;
    }

    public final long flipFlop(long b) {
        return (b & 0xAAAAAAAAAAAAAAAAL) >>> 1 | (b & 0x5555555555555555L) << 1;
    }

    public final int zigZagEncode(int i) {
        return i >> 31 ^ i << 1;
    }

    public final long zigZagEncode(long l) {
        return l >> 63 ^ l << 1;
    }

    public final int zigZagDecode(int i) {
        return i >>> 1 ^ -(i & 1);
    }

    public final long zigZagDecode(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    public final boolean isZeroOrPowerOfTwo(int x) {
        return (x & x - 1) == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/BitUtil$VH_BE_INT;", "", "<init>", "()V", "get", "", "nextBlocks", "", "offset", "set", "", "i", "core"})
    public static final class VH_BE_INT {
        @NotNull
        public static final VH_BE_INT INSTANCE = new VH_BE_INT();

        private VH_BE_INT() {
        }

        public final int get(@NotNull byte[] nextBlocks, int offset) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            return BitUtilKt.getIntBE(nextBlocks, offset);
        }

        public final void set(@NotNull byte[] nextBlocks, int offset, int i) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            BitUtilKt.setIntBE(nextBlocks, offset, i);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/BitUtil$VH_BE_SHORT;", "", "<init>", "()V", "get", "", "nextBlocks", "", "offset", "", "set", "", "s", "core"})
    public static final class VH_BE_SHORT {
        @NotNull
        public static final VH_BE_SHORT INSTANCE = new VH_BE_SHORT();

        private VH_BE_SHORT() {
        }

        public final short get(@NotNull byte[] nextBlocks, int offset) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            return BitUtilKt.getShortBE(nextBlocks, offset);
        }

        public final void set(@NotNull byte[] nextBlocks, int offset, short s) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            BitUtilKt.setShortBE(nextBlocks, offset, s);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/BitUtil$VH_LE_INT;", "", "<init>", "()V", "get", "", "nextBlocks", "", "offset", "set", "", "i", "core"})
    public static final class VH_LE_INT {
        @NotNull
        public static final VH_LE_INT INSTANCE = new VH_LE_INT();

        private VH_LE_INT() {
        }

        public final int get(@NotNull byte[] nextBlocks, int offset) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            return BitUtilKt.getIntLE(nextBlocks, offset);
        }

        public final void set(@NotNull byte[] nextBlocks, int offset, int i) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            BitUtilKt.setIntLE(nextBlocks, offset, i);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/BitUtil$VH_LE_LONG;", "", "<init>", "()V", "get", "", "nextBlocks", "", "offset", "", "set", "", "l", "core"})
    public static final class VH_LE_LONG {
        @NotNull
        public static final VH_LE_LONG INSTANCE = new VH_LE_LONG();

        private VH_LE_LONG() {
        }

        public final long get(@NotNull byte[] nextBlocks, int offset) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            return BitUtilKt.getLongLE(nextBlocks, offset);
        }

        public final void set(@NotNull byte[] nextBlocks, int offset, long l) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            BitUtilKt.setLongLE(nextBlocks, offset, l);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/BitUtil$VH_LE_SHORT;", "", "<init>", "()V", "set", "", "nextBlocks", "", "offset", "", "s", "", "core"})
    public static final class VH_LE_SHORT {
        @NotNull
        public static final VH_LE_SHORT INSTANCE = new VH_LE_SHORT();

        private VH_LE_SHORT() {
        }

        public final void set(@NotNull byte[] nextBlocks, int offset, short s) {
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            BitUtilKt.setShortLE(nextBlocks, offset, s);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/util/BitUtil$VH_NATIVE_INT;", "", "<init>", "()V", "get", "", "nextBlocks", "", "offset", "core"})
    public static final class VH_NATIVE_INT {
        @NotNull
        public static final VH_NATIVE_INT INSTANCE = new VH_NATIVE_INT();

        private VH_NATIVE_INT() {
        }

        public final int get(@NotNull byte[] nextBlocks, int offset) {
            int n;
            Intrinsics.checkNotNullParameter((Object)nextBlocks, (String)"nextBlocks");
            ByteOrder byteOrder = INSTANCE.getNATIVE_BYTE_ORDER();
            if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
                n = BitUtilKt.getIntBE(nextBlocks, offset);
            } else if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getLITTLE_ENDIAN())) {
                n = BitUtilKt.getIntLE(nextBlocks, offset);
            } else {
                throw new IllegalStateException("Unknown byte order");
            }
            return n;
        }
    }
}

