/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0005\n\u0002\b\n\u0018\u0000 92\u00020\u0001:\u00046789B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001aJ&\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020#J\u001e\u0010'\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000bJ \u0010+\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000bH\u0002J$\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\b2\b\b\u0002\u0010$\u001a\u00020\u000b2\b\b\u0002\u0010&\u001a\u00020\u000bH\u0007J&\u0010,\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bJ\u000e\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020%J\b\u00101\u001a\u00020%H\u0016J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u00105\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u0011\u00102\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006:"}, d2={"Lorg/gnit/lucenekmp/util/ByteBlockPool;", "Lorg/gnit/lucenekmp/util/Accountable;", "allocator", "Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;", "<init>", "(Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;)V", "buffers", "", "", "[[B", "bufferUpto", "", "byteUpto", "getByteUpto", "()I", "setByteUpto", "(I)V", "buffer", "getBuffer", "()[B", "setBuffer", "([B)V", "byteOffset", "getByteOffset", "setByteOffset", "reset", "", "zeroFillBuffers", "", "reuseFirst", "nextBuffer", "setBytesRef", "builder", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "result", "Lorg/gnit/lucenekmp/util/BytesRef;", "offset", "", "length", "append", "bytes", "srcPool", "srcOffset", "appendBytesSingleBuffer", "readBytes", "bytesOffset", "bytesLength", "readByte", "", "ramBytesUsed", "position", "getPosition", "()J", "bufferIndex", "Allocator", "DirectAllocator", "DirectTrackingAllocator", "Companion", "core"})
public final class ByteBlockPool
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Allocator allocator;
    @NotNull
    private byte[][] buffers;
    private int bufferUpto;
    private int byteUpto;
    @Nullable
    private byte[] buffer;
    private int byteOffset;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(ByteBlockPool.class));
    public static final int BYTE_BLOCK_SHIFT = 15;
    public static final int BYTE_BLOCK_SIZE = 32768;
    public static final int BYTE_BLOCK_MASK = Short.MAX_VALUE;

    public ByteBlockPool(@NotNull Allocator allocator) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        this.allocator = allocator;
        this.buffers = new byte[10][];
        this.bufferUpto = -1;
        this.byteUpto = 32768;
        this.byteOffset = Short.MIN_VALUE;
    }

    public final int getByteUpto() {
        return this.byteUpto;
    }

    public final void setByteUpto(int n) {
        this.byteUpto = n;
    }

    @Nullable
    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@Nullable byte[] byArray) {
        this.buffer = byArray;
    }

    public final int getByteOffset() {
        return this.byteOffset;
    }

    public final void setByteOffset(int n) {
        this.byteOffset = n;
    }

    public final void reset(boolean zeroFillBuffers, boolean reuseFirst) {
        if (this.bufferUpto != -1) {
            if (zeroFillBuffers) {
                int n = this.bufferUpto;
                for (int i = 0; i < n; ++i) {
                    byte[] byArray = this.buffers[i];
                    Intrinsics.checkNotNull((Object)byArray);
                    Arrays.INSTANCE.fill(byArray, (byte)0);
                }
                byte[] byArray = this.buffers[this.bufferUpto];
                Intrinsics.checkNotNull((Object)byArray);
                Arrays.INSTANCE.fill(byArray, 0, this.byteUpto, (byte)0);
            }
            if (this.bufferUpto > 0 || !reuseFirst) {
                int offset = reuseFirst ? 1 : 0;
                this.allocator.recycleByteBlocks(this.buffers, offset, 1 + this.bufferUpto);
                Arrays.INSTANCE.fill(this.buffers, offset, 1 + this.bufferUpto, (byte[])null);
            }
            if (reuseFirst) {
                this.bufferUpto = 0;
                this.byteUpto = 0;
                this.byteOffset = 0;
                this.buffer = this.buffers[0];
            } else {
                this.bufferUpto = -1;
                this.byteUpto = 32768;
                this.byteOffset = Short.MIN_VALUE;
                this.buffer = null;
            }
        }
    }

    public final void nextBuffer() {
        if (1 + this.bufferUpto == ((Object[])this.buffers).length) {
            byte[][] newBuffers = new byte[ArrayUtil.Companion.oversize(((Object[])this.buffers).length + 1, 4)][];
            ArraysKt.copyInto((Object[])((Object[])this.buffers), (Object[])((Object[])newBuffers), (int)0, (int)0, (int)((Object[])this.buffers).length);
            this.buffers = newBuffers;
        }
        byte[] byArray = this.allocator.getByteBlock();
        Intrinsics.checkNotNull((Object)byArray);
        this.buffers[1 + this.bufferUpto] = byArray;
        this.buffer = this.buffers[1 + this.bufferUpto];
        int n = this.bufferUpto;
        this.bufferUpto = n + 1;
        this.byteUpto = 0;
        this.byteOffset = Math.INSTANCE.addExact(this.byteOffset, 32768);
    }

    public final void setBytesRef(@NotNull BytesRefBuilder builder, @NotNull BytesRef result, long offset, int length) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.setLength(length);
        int bufferIndex = Math.INSTANCE.toIntExact(offset >> 15);
        byte[] buffer = this.buffers[bufferIndex];
        int pos = (int)(offset & 0x7FFFL);
        if (pos + length <= 32768) {
            Intrinsics.checkNotNull((Object)buffer);
            result.setBytes(buffer);
            result.setOffset(pos);
        } else {
            builder.growNoCopy(length);
            result.setBytes(builder.get().getBytes());
            result.setOffset(0);
            this.readBytes(offset, result.getBytes(), 0, length);
        }
    }

    public final void append(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.append(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
    }

    public final void append(@NotNull ByteBlockPool srcPool, long srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)srcPool, (String)"srcPool");
        long srcOffset2 = srcOffset;
        int bytesLeft = length;
        while (bytesLeft > 0) {
            int bufferLeft = 32768 - this.byteUpto;
            if (bytesLeft < bufferLeft) {
                this.appendBytesSingleBuffer(srcPool, srcOffset2, bytesLeft);
                break;
            }
            if (bufferLeft > 0) {
                this.appendBytesSingleBuffer(srcPool, srcOffset2, bufferLeft);
                bytesLeft -= bufferLeft;
                srcOffset2 += (long)bufferLeft;
            }
            this.nextBuffer();
        }
    }

    private final void appendBytesSingleBuffer(ByteBlockPool srcPool, long srcOffset, int length) {
        long srcOffset2 = srcOffset;
        int length2 = length;
        if (!(length2 <= 32768 - this.byteUpto)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (length2 > 0) {
            byte[] srcBytes;
            Intrinsics.checkNotNull((Object)srcPool.buffers[Math.INSTANCE.toIntExact(srcOffset2 >> 15)]);
            int srcPos = Math.INSTANCE.toIntExact(srcOffset2 & 0x7FFFL);
            int bytesToCopy = java.lang.Math.min(length2, 32768 - srcPos);
            Intrinsics.checkNotNull((Object)this.buffer);
            ArraysKt.copyInto((byte[])srcBytes, (byte[])this.buffer, (int)this.byteUpto, (int)srcPos, (int)(srcPos + bytesToCopy));
            length2 -= bytesToCopy;
            srcOffset2 += (long)bytesToCopy;
            this.byteUpto += bytesToCopy;
        }
    }

    @JvmOverloads
    public final void append(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int offset2 = offset;
        int bytesLeft = length;
        while (bytesLeft > 0) {
            int bufferLeft = 32768 - this.byteUpto;
            if (bytesLeft < bufferLeft) {
                Intrinsics.checkNotNull((Object)this.buffer);
                ArraysKt.copyInto((byte[])bytes, (byte[])this.buffer, (int)this.byteUpto, (int)offset2, (int)(offset2 + bytesLeft));
                this.byteUpto += bytesLeft;
                break;
            }
            if (bufferLeft > 0) {
                Intrinsics.checkNotNull((Object)this.buffer);
                ArraysKt.copyInto((byte[])bytes, (byte[])this.buffer, (int)this.byteUpto, (int)offset2, (int)(offset2 + bufferLeft));
            }
            this.nextBuffer();
            bytesLeft -= bufferLeft;
            offset2 += bufferLeft;
        }
    }

    public static /* synthetic */ void append$default(ByteBlockPool byteBlockPool, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteBlockPool.append(byArray, n, n2);
    }

    public final void readBytes(long offset, @NotNull byte[] bytes, int bytesOffset, int bytesLength) {
        int chunk;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int bytesOffset2 = bytesOffset;
        int bufferIndex = Math.INSTANCE.toIntExact(offset >> 15);
        int pos = (int)(offset & 0x7FFFL);
        for (int bytesLeft = bytesLength; bytesLeft > 0; bytesLeft -= chunk) {
            byte[] buffer;
            if (this.buffers[bufferIndex++] == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            chunk = java.lang.Math.min(bytesLeft, 32768 - pos);
            ArraysKt.copyInto((byte[])buffer, (byte[])bytes, (int)bytesOffset2, (int)pos, (int)(pos + chunk));
            bytesOffset2 += chunk;
            pos = 0;
        }
    }

    public final byte readByte(long offset) {
        int bufferIndex = (int)(offset >> 15);
        int pos = (int)(offset & 0x7FFFL);
        byte[] byArray = this.buffers[bufferIndex];
        Intrinsics.checkNotNull((Object)byArray);
        return byArray[pos];
    }

    @Override
    public long ramBytesUsed() {
        long size2 = BASE_RAM_BYTES;
        size2 += RamUsageEstimator.Companion.shallowSizeOf(this.buffers);
        byte[][] byArray = this.buffers;
        int n = ((Object[])byArray).length;
        for (int i = 0; i < n; ++i) {
            byte[] buf = byArray[i];
            size2 += RamUsageEstimator.Companion.sizeOfObject(buf);
        }
        return size2;
    }

    public final long getPosition() {
        return this.bufferUpto * this.allocator.getBlockSize() + this.byteUpto;
    }

    @NotNull
    public final byte[] getBuffer(int bufferIndex) {
        byte[] byArray = this.buffers[bufferIndex];
        Intrinsics.checkNotNull((Object)byArray);
        return byArray;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public final void append(@NotNull byte[] bytes, int offset) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteBlockPool.append$default(this, bytes, offset, 0, 4, null);
    }

    @JvmOverloads
    public final void append(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteBlockPool.append$default(this, bytes, 0, 0, 6, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;", "", "blockSize", "", "<init>", "(I)V", "getBlockSize", "()I", "recycleByteBlocks", "", "blocks", "", "", "start", "end", "([[BII)V", "byteBlock", "getByteBlock", "()[B", "core"})
    public static abstract class Allocator {
        private final int blockSize;

        protected Allocator(int blockSize) {
            this.blockSize = blockSize;
        }

        public final int getBlockSize() {
            return this.blockSize;
        }

        public abstract void recycleByteBlocks(@NotNull byte[][] var1, int var2, int var3);

        @NotNull
        public byte[] getByteBlock() {
            return new byte[this.blockSize];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/util/ByteBlockPool$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "BYTE_BLOCK_SHIFT", "", "BYTE_BLOCK_SIZE", "BYTE_BLOCK_MASK", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/ByteBlockPool$DirectAllocator;", "Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;", "<init>", "()V", "recycleByteBlocks", "", "blocks", "", "", "start", "", "end", "([[BII)V", "core"})
    public static final class DirectAllocator
    extends Allocator {
        public DirectAllocator() {
            super(32768);
        }

        @Override
        public void recycleByteBlocks(@NotNull byte[][] blocks, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/util/ByteBlockPool$DirectTrackingAllocator;", "Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/util/Counter;)V", "byteBlock", "", "getByteBlock", "()[B", "recycleByteBlocks", "", "blocks", "", "start", "", "end", "([[BII)V", "core"})
    public static final class DirectTrackingAllocator
    extends Allocator {
        @NotNull
        private final Counter bytesUsed;

        public DirectTrackingAllocator(@NotNull Counter bytesUsed) {
            Intrinsics.checkNotNullParameter((Object)bytesUsed, (String)"bytesUsed");
            super(32768);
            this.bytesUsed = bytesUsed;
        }

        @Override
        @NotNull
        public byte[] getByteBlock() {
            this.bytesUsed.addAndGet(this.getBlockSize());
            return new byte[this.getBlockSize()];
        }

        @Override
        public void recycleByteBlocks(@NotNull byte[][] blocks, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
            this.bytesUsed.addAndGet(-((long)((end - start) * this.getBlockSize())));
            for (int i = start; i < end; ++i) {
                blocks[i] = null;
            }
        }
    }
}

