/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001(B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0002\u0010\u000fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\u0013\u0010\u001d\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020 H\u0016J\u0011\u0010\"\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010#\u001a\u00020\u0019J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010'\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\nR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\fR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0014\"\u0004\b\u0017\u0010\f\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/util/BytesRef;", "", "<init>", "()V", "bytes", "", "offset", "", "length", "([BII)V", "([B)V", "capacity", "(I)V", "text", "", "(Ljava/lang/CharSequence;)V", "getBytes", "()[B", "setBytes", "getOffset", "()I", "setOffset", "getLength", "setLength", "bytesEquals", "", "other", "clone", "hashCode", "equals", "", "utf8ToString", "", "toString", "compareTo", "isValid", "maxUTF8Length", "utf16Length", "utf16ToUTF8", "utf8BytesToString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBytesRef.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytesRef.kt\norg/gnit/lucenekmp/util/BytesRef\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n1#2:305\n*E\n"})
public final class BytesRef
implements Comparable<BytesRef> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] bytes;
    private int offset;
    private int length;
    @NotNull
    private static final byte[] EMPTY_BYTES = new byte[0];

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final void setBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.bytes = byArray;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public BytesRef() {
        this(EMPTY_BYTES);
    }

    public BytesRef(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        if (!this.isValid()) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public BytesRef(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this(bytes, 0, bytes.length);
    }

    public BytesRef(int capacity) {
        this.bytes = capacity == 0 ? EMPTY_BYTES : new byte[capacity];
        this.offset = 0;
        this.length = 0;
    }

    public BytesRef(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.bytes = new byte[this.maxUTF8Length(text.length())];
        this.offset = 0;
        this.length = this.utf16ToUTF8(text, this.bytes);
    }

    public final boolean bytesEquals(@NotNull BytesRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.length != other.length) {
            return false;
        }
        int n = this.length;
        for (int i = 0; i < n; ++i) {
            if (this.bytes[this.offset + i] == other.bytes[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final BytesRef clone() {
        return new BytesRef(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        int result = 1;
        int n = this.offset + this.length;
        for (int i = this.offset; i < n; ++i) {
            result = 31 * result + this.bytes[i];
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BytesRef) {
            return this.bytesEquals((BytesRef)other);
        }
        return false;
    }

    @NotNull
    public final String utf8ToString() {
        return this.utf8BytesToString(this.bytes, this.offset, this.length);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(2 + 3 * this.length);
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            String string = Integer.toString(this.bytes[i] & 0xFF, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            sb.append(string);
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int compareTo(@NotNull BytesRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int thisEnd = this.offset + this.length;
        int otherEnd = other.offset + other.length;
        int i = this.offset;
        for (int j = other.offset; i < thisEnd && j < otherEnd; ++i, ++j) {
            int a = this.bytes[i] & 0xFF;
            int b = other.bytes[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return this.length - other.length;
    }

    public final boolean isValid() {
        if (!(!(this.bytes.length == 0) || this.length == 0)) {
            boolean $i$a$-require-BytesRef$isValid$82 = false;
            String $i$a$-require-BytesRef$isValid$82 = "bytes is null or empty";
            throw new IllegalArgumentException($i$a$-require-BytesRef$isValid$82.toString());
        }
        if (!(this.length >= 0)) {
            boolean $i$a$-require-BytesRef$isValid$92 = false;
            String $i$a$-require-BytesRef$isValid$92 = "length is negative: " + this.length;
            throw new IllegalArgumentException($i$a$-require-BytesRef$isValid$92.toString());
        }
        if (!(this.length <= this.bytes.length)) {
            boolean $i$a$-require-BytesRef$isValid$102 = false;
            String $i$a$-require-BytesRef$isValid$102 = "length is out of bounds: " + this.length + ", bytes.size=" + this.bytes.length;
            throw new IllegalArgumentException($i$a$-require-BytesRef$isValid$102.toString());
        }
        if (!(this.offset >= 0)) {
            boolean $i$a$-require-BytesRef$isValid$112 = false;
            String $i$a$-require-BytesRef$isValid$112 = "offset is negative: " + this.offset;
            throw new IllegalArgumentException($i$a$-require-BytesRef$isValid$112.toString());
        }
        if (!(this.offset <= this.bytes.length)) {
            boolean $i$a$-require-BytesRef$isValid$122 = false;
            String $i$a$-require-BytesRef$isValid$122 = "offset out of bounds: " + this.offset + ", bytes.size=" + this.bytes.length;
            throw new IllegalArgumentException($i$a$-require-BytesRef$isValid$122.toString());
        }
        if (!(this.offset + this.length >= 0)) {
            boolean $i$a$-require-BytesRef$isValid$132 = false;
            String $i$a$-require-BytesRef$isValid$132 = "offset+length is negative: offset=" + this.offset + ", length=" + this.length;
            throw new IllegalArgumentException($i$a$-require-BytesRef$isValid$132.toString());
        }
        if (!(this.offset + this.length <= this.bytes.length)) {
            boolean bl = false;
            String string = "offset+length out of bounds: offset=" + this.offset + ", length=" + this.length + ", bytes.size=" + this.bytes.length;
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    private final int maxUTF8Length(int utf16Length) {
        return utf16Length * 4;
    }

    private final int utf16ToUTF8(CharSequence text, byte[] bytes) {
        int byteIndex = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            char codePoint = c;
            if (codePoint < '\u0080') {
                bytes[byteIndex++] = (byte)codePoint;
                ++i;
                continue;
            }
            if (codePoint < '\u0800') {
                bytes[byteIndex++] = (byte)(0xC0 | codePoint >> 6);
                bytes[byteIndex++] = (byte)(0x80 | codePoint & 0x3F);
                ++i;
                continue;
            }
            if (codePoint < '\u10000') {
                bytes[byteIndex++] = (byte)(0xE0 | codePoint >> 12);
                bytes[byteIndex++] = (byte)(0x80 | codePoint >> 6 & 0x3F);
                bytes[byteIndex++] = (byte)(0x80 | codePoint & 0x3F);
                ++i;
                continue;
            }
            if (i + 1 < text.length() && Character.isHighSurrogate(c) && Character.isLowSurrogate(text.charAt(i + 1))) {
                char highSurrogate = c;
                char lowSurrogate = text.charAt(i + 1);
                int codePoint2 = 65536 + (highSurrogate - 55296 << 10) + (lowSurrogate - 56320);
                bytes[byteIndex++] = (byte)(0xF0 | codePoint2 >> 18);
                bytes[byteIndex++] = (byte)(0x80 | codePoint2 >> 12 & 0x3F);
                bytes[byteIndex++] = (byte)(0x80 | codePoint2 >> 6 & 0x3F);
                bytes[byteIndex++] = (byte)(0x80 | codePoint2 & 0x3F);
                i += 2;
                continue;
            }
            ++i;
        }
        return byteIndex;
    }

    private final String utf8BytesToString(byte[] bytes, int offset, int length) {
        List chars = new ArrayList();
        int i = offset;
        int end = offset + length;
        while (i < end) {
            int byte3;
            int byte2;
            int n;
            if (((n = bytes[i++] & 0xFF) & 0x80) == 0) {
                chars.add(Character.valueOf((char)n));
                continue;
            }
            if ((n & 0xE0) == 192) {
                if (i >= end) break;
                byte2 = bytes[i++] & 0xFF;
                int codePoint = (n & 0x1F) << 6 | byte2 & 0x3F;
                chars.add(Character.valueOf((char)codePoint));
                continue;
            }
            if ((n & 0xF0) == 224) {
                if (i + 1 >= end) break;
                byte2 = bytes[i++] & 0xFF;
                byte3 = bytes[i++] & 0xFF;
                int codePoint = (n & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F;
                chars.add(Character.valueOf((char)codePoint));
                continue;
            }
            if ((n & 0xF8) != 240) continue;
            if (i + 2 >= end) break;
            byte2 = bytes[i++] & 0xFF;
            byte3 = bytes[i++] & 0xFF;
            int byte4 = bytes[i++] & 0xFF;
            int codePoint = (n & 7) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
            char highSurrogate = (char)((codePoint - 65536 >> 10) + 55296);
            char lowSurrogate = (char)((codePoint - 65536 & 0x3FF) + 56320);
            chars.add(Character.valueOf(highSurrogate));
            chars.add(Character.valueOf(lowSurrogate));
        }
        return CollectionsKt.joinToString$default((Iterable)chars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/BytesRef$Companion;", "", "<init>", "()V", "EMPTY_BYTES", "", "getEMPTY_BYTES", "()[B", "deepCopyOf", "Lorg/gnit/lucenekmp/util/BytesRef;", "other", "copyOfSubArray", "array", "start", "", "end", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getEMPTY_BYTES() {
            return EMPTY_BYTES;
        }

        @NotNull
        public final BytesRef deepCopyOf(@NotNull BytesRef other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new BytesRef(this.copyOfSubArray(other.getBytes(), other.getOffset(), other.getOffset() + other.getLength()), 0, other.getLength());
        }

        private final byte[] copyOfSubArray(byte[] array, int start, int end) {
            int length = end - start;
            byte[] result = new byte[length];
            ArraysKt.copyInto((byte[])array, (byte[])result, (int)0, (int)start, (int)end);
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

