/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.BytesRefIterator;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.SortableBytesRefArray;
import org.gnit.lucenekmp.util.StableStringSorter;
import org.gnit.lucenekmp.util.StringSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J&\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u001cj\b\u0012\u0004\u0012\u00020\u0011`\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J \u0010 \u001a\u00020!2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u001cj\b\u0012\u0004\u0012\u00020\u0011`\u001dH\u0016J\u0010\u0010 \u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefArray;", "Lorg/gnit/lucenekmp/util/SortableBytesRefArray;", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/util/Counter;)V", "pool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "offsets", "", "lastElement", "", "currentOffset", "clear", "", "append", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "size", "get", "spare", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "index", "setBytesRef", "result", "sort", "Lorg/gnit/lucenekmp/util/BytesRefArray$SortState;", "comp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "stable", "", "iterator", "Lorg/gnit/lucenekmp/util/BytesRefIterator;", "Lorg/gnit/lucenekmp/util/BytesRefArray$IndexedBytesRefIterator;", "sortState", "SortState", "IndexedBytesRefIterator", "core"})
@SourceDebugExtension(value={"SMAP\nBytesRefArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytesRefArray.kt\norg/gnit/lucenekmp/util/BytesRefArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public final class BytesRefArray
implements SortableBytesRefArray {
    @NotNull
    private final ByteBlockPool pool;
    @NotNull
    private int[] offsets;
    private int lastElement;
    private int currentOffset;
    @NotNull
    private final Counter bytesUsed;

    public BytesRefArray(@NotNull Counter bytesUsed) {
        Intrinsics.checkNotNullParameter((Object)bytesUsed, (String)"bytesUsed");
        this.pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
        this.offsets = new int[1];
        this.pool.nextBuffer();
        bytesUsed.addAndGet(32L);
        this.bytesUsed = bytesUsed;
    }

    @Override
    public void clear() {
        this.lastElement = 0;
        this.currentOffset = 0;
        Arrays.INSTANCE.fill(this.offsets, 0);
        this.pool.reset(false, true);
    }

    @Override
    public int append(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (this.lastElement >= this.offsets.length) {
            int oldLen = this.offsets.length;
            this.offsets = ArrayUtil.Companion.grow(this.offsets, this.offsets.length + 1);
            this.bytesUsed.addAndGet((long)(this.offsets.length - oldLen) * 4L);
        }
        this.pool.append(bytes);
        int n = this.lastElement;
        this.lastElement = n + 1;
        this.offsets[n] = this.currentOffset;
        this.currentOffset += bytes.getLength();
        return this.lastElement - 1;
    }

    @Override
    public int size() {
        return this.lastElement;
    }

    @NotNull
    public final BytesRef get(@NotNull BytesRefBuilder spare, int index) {
        Intrinsics.checkNotNullParameter((Object)spare, (String)"spare");
        Objects.INSTANCE.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        spare.growNoCopy(length);
        spare.setLength(length);
        this.pool.readBytes(offset, spare.bytes(), 0, spare.length());
        return spare.get();
    }

    private final void setBytesRef(BytesRefBuilder spare, BytesRef result, int index) {
        Objects.INSTANCE.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = 0;
        length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        this.pool.setBytesRef(spare, result, offset, length);
    }

    @NotNull
    public final SortState sort(@NotNull Comparator<BytesRef> comp, boolean stable) {
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        int[] orderedEntries = new int[this.size()];
        int n = orderedEntries.length;
        for (int i = 0; i < n; ++i) {
            orderedEntries[i] = i;
        }
        StringSorter sorter2 = null;
        sorter2 = stable ? (StringSorter)new StableStringSorter(this, comp, orderedEntries){
            private final int[] tmp;
            final /* synthetic */ BytesRefArray this$0;
            final /* synthetic */ int[] $orderedEntries;
            {
                this.this$0 = $receiver;
                this.$orderedEntries = $orderedEntries;
                super($comp);
                this.tmp = new int[$receiver.size()];
            }

            protected void get(BytesRefBuilder builder, BytesRef result, int i) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                BytesRefArray.access$setBytesRef(this.this$0, builder, result, this.$orderedEntries[i]);
            }

            protected void save(int i, int j) {
                this.tmp[j] = this.$orderedEntries[i];
            }

            protected void restore(int i, int j) {
                ArraysKt.copyInto((int[])this.tmp, (int[])this.$orderedEntries, (int)i, (int)i, (int)j);
            }

            protected void swap(int i, int j) {
                int o = this.$orderedEntries[i];
                this.$orderedEntries[i] = this.$orderedEntries[j];
                this.$orderedEntries[j] = o;
            }
        } : (StringSorter)new StringSorter(comp, this, orderedEntries){
            final /* synthetic */ BytesRefArray this$0;
            final /* synthetic */ int[] $orderedEntries;
            {
                this.this$0 = $receiver;
                this.$orderedEntries = $orderedEntries;
                super($comp);
            }

            protected void get(BytesRefBuilder builder, BytesRef result, int i) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                BytesRefArray.access$setBytesRef(this.this$0, builder, result, this.$orderedEntries[i]);
            }

            protected void swap(int i, int j) {
                int o = this.$orderedEntries[i];
                this.$orderedEntries[i] = this.$orderedEntries[j];
                this.$orderedEntries[j] = o;
            }
        };
        sorter2.sort(0, this.size());
        return new SortState(orderedEntries);
    }

    @NotNull
    public final BytesRefIterator iterator() {
        return this.iterator((SortState)null);
    }

    @Override
    @NotNull
    public BytesRefIterator iterator(@NotNull Comparator<BytesRef> comp) {
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        return this.iterator(this.sort(comp, false));
    }

    @NotNull
    public final IndexedBytesRefIterator iterator(@Nullable SortState sortState) {
        int size2 = this.size();
        SortState sortState2 = sortState;
        int[] indices = (int[])(sortState2 == null ? null : sortState2.getIndices$core());
        if (!(indices == null || indices.length == size2)) {
            boolean $i$a$-require-BytesRefArray$iterator$22 = false;
            Intrinsics.checkNotNull((Object)indices);
            String $i$a$-require-BytesRefArray$iterator$22 = indices.length + " != " + size2;
            throw new IllegalArgumentException($i$a$-require-BytesRefArray$iterator$22.toString());
        }
        BytesRefBuilder spare = new BytesRefBuilder();
        BytesRef result = new BytesRef();
        return new IndexedBytesRefIterator(size2, indices, this, spare, result){
            private int pos;
            private int ord;
            final /* synthetic */ int $size;
            final /* synthetic */ int[] $indices;
            final /* synthetic */ BytesRefArray this$0;
            final /* synthetic */ BytesRefBuilder $spare;
            final /* synthetic */ BytesRef $result;
            {
                this.$size = $size;
                this.$indices = $indices;
                this.this$0 = $receiver;
                this.$spare = $spare;
                this.$result = $result;
                this.pos = -1;
            }

            public final int getPos() {
                return this.pos;
            }

            public final void setPos(int n) {
                this.pos = n;
            }

            public final int getOrd() {
                return this.ord;
            }

            public final void setOrd(int n) {
                this.ord = n;
            }

            public BytesRef next() {
                ++this.pos;
                if (this.pos < this.$size) {
                    this.ord = this.$indices == null ? this.pos : this.$indices[this.pos];
                    BytesRefArray.access$setBytesRef(this.this$0, this.$spare, this.$result, this.ord);
                    return this.$result;
                }
                return null;
            }

            public int ord() {
                return this.ord;
            }
        };
    }

    public static final /* synthetic */ void access$setBytesRef(BytesRefArray $this, BytesRefBuilder spare, BytesRef result, int index) {
        $this.setBytesRef(spare, result, index);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefArray$IndexedBytesRefIterator;", "Lorg/gnit/lucenekmp/util/BytesRefIterator;", "ord", "", "core"})
    public static interface IndexedBytesRefIterator
    extends BytesRefIterator {
        public int ord();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefArray$SortState;", "Lorg/gnit/lucenekmp/util/Accountable;", "indices", "", "<init>", "([I)V", "getIndices$core", "()[I", "ramBytesUsed", "", "core"})
    public static final class SortState
    implements Accountable {
        @NotNull
        private final int[] indices;

        public SortState(@NotNull int[] indices) {
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            this.indices = indices;
        }

        @NotNull
        public final int[] getIndices$core() {
            return this.indices;
        }

        @Override
        public long ramBytesUsed() {
            return 8 + this.indices.length * 4;
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }
    }
}

