/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefHash;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefBlockPool;", "Lorg/gnit/lucenekmp/util/Accountable;", "<init>", "()V", "byteBlockPool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "(Lorg/gnit/lucenekmp/util/ByteBlockPool;)V", "reset", "", "fillBytesRef", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "start", "", "addBytesRef", "bytes", "hash", "equals", "", "b", "ramBytesUsed", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBytesRefBlockPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytesRefBlockPool.kt\norg/gnit/lucenekmp/util/BytesRefBlockPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class BytesRefBlockPool
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBlockPool byteBlockPool;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(BytesRefBlockPool.class));

    public BytesRefBlockPool() {
        this.byteBlockPool = new ByteBlockPool(new ByteBlockPool.DirectAllocator());
    }

    public BytesRefBlockPool(@NotNull ByteBlockPool byteBlockPool) {
        Intrinsics.checkNotNullParameter((Object)byteBlockPool, (String)"byteBlockPool");
        this.byteBlockPool = byteBlockPool;
    }

    public final void reset() {
        this.byteBlockPool.reset(false, false);
    }

    public final void fillBytesRef(@NotNull BytesRef term, int start) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        term.setBytes(this.byteBlockPool.getBuffer(start >> 15));
        byte[] bytes = term.getBytes();
        int pos = start & Short.MAX_VALUE;
        if ((bytes[pos] & 0x80) == 0) {
            term.setLength(bytes[pos]);
            term.setOffset(pos + 1);
        } else {
            short beShort = BitUtilKt.getShortBE(bytes, pos);
            term.setLength(beShort & Short.MAX_VALUE);
            term.setOffset(pos + 2);
        }
        if (!(term.getLength() >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int addBytesRef(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int length = bytes.getLength();
        int len2 = 2 + bytes.getLength();
        if (len2 + this.byteBlockPool.getByteUpto() > 32768) {
            if (len2 > 32768) {
                throw new BytesRefHash.MaxBytesLengthExceededException("bytes can be at most 32766 in length; got " + bytes.getLength());
            }
            this.byteBlockPool.nextBuffer();
        }
        byte[] byArray = this.byteBlockPool.getBuffer();
        Intrinsics.checkNotNull((Object)byArray);
        byte[] buffer = byArray;
        int bufferUpto = this.byteBlockPool.getByteUpto();
        int textStart = bufferUpto + this.byteBlockPool.getByteOffset();
        if (length < 128) {
            buffer[bufferUpto] = (byte)length;
            ByteBlockPool byteBlockPool = this.byteBlockPool;
            byteBlockPool.setByteUpto(byteBlockPool.getByteUpto() + (length + 1));
            if (!(length >= 0)) {
                boolean bl = false;
                String string = "Length must be positive: " + length;
                throw new IllegalArgumentException(string.toString());
            }
            v1 = ArraysKt.copyInto((byte[])bytes.getBytes(), (byte[])buffer, (int)(bufferUpto + 1), (int)bytes.getOffset(), (int)(bytes.getOffset() + length));
        } else {
            BitUtilKt.setShortBE(buffer, bufferUpto, (short)(length | 0x8000));
            ByteBlockPool byteBlockPool = this.byteBlockPool;
            byteBlockPool.setByteUpto(byteBlockPool.getByteUpto() + (length + 2));
            v1 = ArraysKt.copyInto((byte[])bytes.getBytes(), (byte[])buffer, (int)(bufferUpto + 2), (int)bytes.getOffset(), (int)(bytes.getOffset() + length));
        }
        return textStart;
    }

    public final int hash(int start) {
        int offset = start & Short.MAX_VALUE;
        byte[] bytes = this.byteBlockPool.getBuffer(start >> 15);
        int len = 0;
        int pos = 0;
        if ((bytes[offset] & 0x80) == 0) {
            len = bytes[offset];
            pos = offset + 1;
        } else {
            short beShort = BitUtilKt.getShortBE(bytes, offset);
            len = beShort & Short.MAX_VALUE;
            pos = offset + 2;
        }
        return BytesRefHash.Companion.doHash(bytes, pos, len);
    }

    public final boolean equals(int start, @NotNull BytesRef b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        byte[] bytes = this.byteBlockPool.getBuffer(start >> 15);
        int pos = start & Short.MAX_VALUE;
        int length = 0;
        int offset = 0;
        if ((bytes[pos] & 0x80) == 0) {
            length = bytes[pos];
            offset = pos + 1;
        } else {
            short beShort = BitUtilKt.getShortBE(bytes, pos);
            length = beShort & Short.MAX_VALUE;
            offset = pos + 2;
        }
        return Arrays.INSTANCE.equals(bytes, offset, offset + length, b.getBytes(), b.getOffset(), b.getOffset() + b.getLength());
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + this.byteBlockPool.ramBytesUsed();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefBlockPool$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

