/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b&\u0018\u0000 \u00112\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0005H&J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefComparator;", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/util/BytesRef;", "Lkotlin/Comparator;", "comparedBytesCount", "", "<init>", "(I)V", "getComparedBytesCount", "()I", "byteAt", "ref", "i", "compare", "o1", "o2", "k", "Companion", "core"})
public abstract class BytesRefComparator
implements Comparator<BytesRef> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int comparedBytesCount;
    @NotNull
    private static final BytesRefComparator NATURAL = new BytesRefComparator(){

        public int byteAt(BytesRef ref, int i) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            if (ref.getLength() <= i) {
                return -1;
            }
            return ref.getBytes()[ref.getOffset() + i] & 0xFF;
        }

        public int compare(BytesRef o1, BytesRef o2, int k) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return Arrays.INSTANCE.compareUnsigned(o1.getBytes(), o1.getOffset() + k, o1.getOffset() + o1.getLength(), o2.getBytes(), o2.getOffset() + k, o2.getOffset() + o2.getLength());
        }
    };

    protected BytesRefComparator(int comparedBytesCount) {
        this.comparedBytesCount = comparedBytesCount;
    }

    public final int getComparedBytesCount() {
        return this.comparedBytesCount;
    }

    public abstract int byteAt(@NotNull BytesRef var1, int var2);

    @Override
    public int compare(@NotNull BytesRef o1, @NotNull BytesRef o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return this.compare(o1, o2, 0);
    }

    public int compare(@NotNull BytesRef o1, @NotNull BytesRef o2, int k) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        int n = this.comparedBytesCount;
        for (int i = k; i < n; ++i) {
            int b2;
            int b1 = this.byteAt(o1, i);
            if (b1 != (b2 = this.byteAt(o2, i))) {
                return b1 - b2;
            }
            if (b1 == -1) break;
        }
        return 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/BytesRefComparator$Companion;", "", "<init>", "()V", "NATURAL", "Lorg/gnit/lucenekmp/util/BytesRefComparator;", "getNATURAL", "()Lorg/gnit/lucenekmp/util/BytesRefComparator;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BytesRefComparator getNATURAL() {
            return NATURAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

