/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Collections;
import org.gnit.lucenekmp.util.IntroSorter;
import org.gnit.lucenekmp.util.TimSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\u0004\b\u0000\u0010\f2\u0006\u0010\b\u001a\u00020\tJ2\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u0002H\u000f0\u0013j\b\u0012\u0004\u0012\u0002H\u000f`\u0014J$\u0010\r\u001a\u00020\u000e\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011J2\u0010\u0016\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u0002H\u000f0\u0013j\b\u0012\u0004\u0012\u0002H\u000f`\u0014J$\u0010\u0016\u001a\u00020\u000e\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/CollectionUtil;", "", "<init>", "()V", "newHashMap", "", "K", "V", "size", "", "newHashSet", "", "E", "introSort", "", "T", "list", "", "comp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "", "timSort", "ListIntroSorter", "ListTimSorter", "core"})
public final class CollectionUtil {
    @NotNull
    public static final CollectionUtil INSTANCE = new CollectionUtil();

    private CollectionUtil() {
    }

    @NotNull
    public final <K, V> Map<K, V> newHashMap(int size2) {
        return new LinkedHashMap();
    }

    @NotNull
    public final <E> Set<E> newHashSet(int size2) {
        return new LinkedHashSet();
    }

    public final <T> void introSort(@NotNull List<T> list, @NotNull Comparator<T> comp) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        int size2 = list.size();
        if (size2 <= 1) {
            return;
        }
        new ListIntroSorter<T>(list, comp).sort(0, size2);
    }

    public final <T extends Comparable<? super T>> void introSort(@NotNull List<T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        int size2 = list.size();
        if (size2 <= 1) {
            return;
        }
        this.introSort(list, ComparisonsKt.naturalOrder());
    }

    public final <T> void timSort(@NotNull List<T> list, @NotNull Comparator<T> comp) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        int size2 = list.size();
        if (size2 <= 1) {
            return;
        }
        new ListTimSorter<T>(list, comp, list.size() / 64).sort(0, size2);
    }

    public final <T extends Comparable<? super T>> void timSort(@NotNull List<T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        int size2 = list.size();
        if (size2 <= 1) {
            return;
        }
        this.timSort(list, ComparisonsKt.naturalOrder());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\r\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0014J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0014J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0014R\u001e\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R%\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/CollectionUtil$ListIntroSorter;", "T", "Lorg/gnit/lucenekmp/util/IntroSorter;", "list", "", "comp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Ljava/util/List;Ljava/util/Comparator;)V", "pivot", "getPivot", "()Ljava/lang/Object;", "setPivot", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getList", "()Ljava/util/List;", "getComp", "()Ljava/util/Comparator;", "", "i", "", "swap", "j", "compare", "comparePivot", "core"})
    @SourceDebugExtension(value={"SMAP\nCollectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionUtil.kt\norg/gnit/lucenekmp/util/CollectionUtil$ListIntroSorter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
    private static final class ListIntroSorter<T>
    extends IntroSorter {
        @Nullable
        private T pivot;
        @NotNull
        private final List<T> list;
        @NotNull
        private final Comparator<? super T> comp;

        public ListIntroSorter(@NotNull List<T> list, @NotNull Comparator<T> comp) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            if (!(list instanceof RandomAccess)) {
                boolean bl = false;
                String string = "CollectionUtil can only sort random access lists in-place.";
                throw new IllegalArgumentException(string.toString());
            }
            this.list = list;
            this.comp = comp;
        }

        @Nullable
        public final T getPivot() {
            return this.pivot;
        }

        public final void setPivot(@Nullable T t) {
            this.pivot = t;
        }

        @NotNull
        public final List<T> getList() {
            return this.list;
        }

        @NotNull
        public final Comparator<? super T> getComp() {
            return this.comp;
        }

        @Override
        protected void setPivot(int i) {
            this.pivot = this.list.get(i);
        }

        @Override
        protected void swap(int i, int j) {
            Collections.INSTANCE.swap(this.list, i, j);
        }

        @Override
        protected int compare(int i, int j) {
            return this.comp.compare(this.list.get(i), this.list.get(j));
        }

        @Override
        protected int comparePivot(int j) {
            T t = this.pivot;
            Intrinsics.checkNotNull(t);
            return this.comp.compare(t, this.list.get(j));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B5\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0014J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0014J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/util/CollectionUtil$ListTimSorter;", "T", "Lorg/gnit/lucenekmp/util/TimSorter;", "list", "", "comp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "maxTempSlots", "", "<init>", "(Ljava/util/List;Ljava/util/Comparator;I)V", "getList", "()Ljava/util/List;", "getComp", "()Ljava/util/Comparator;", "tmp", "", "getTmp", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "swap", "", "i", "j", "copy", "src", "dest", "save", "len", "restore", "compare", "compareSaved", "core"})
    @SourceDebugExtension(value={"SMAP\nCollectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionUtil.kt\norg/gnit/lucenekmp/util/CollectionUtil$ListTimSorter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
    private static final class ListTimSorter<T>
    extends TimSorter {
        @NotNull
        private final List<T> list;
        @NotNull
        private final Comparator<T> comp;
        @NotNull
        private final T[] tmp;

        public ListTimSorter(@NotNull List<T> list, @NotNull Comparator<T> comp, int maxTempSlots) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            super(maxTempSlots);
            if (!(list instanceof RandomAccess)) {
                boolean bl = false;
                String string = "CollectionUtil can only sort random access lists in-place.";
                throw new IllegalArgumentException(string.toString());
            }
            this.list = list;
            this.comp = comp;
            this.tmp = maxTempSlots > 0 ? new Object[maxTempSlots] : new Object[0];
        }

        @NotNull
        public final List<T> getList() {
            return this.list;
        }

        @NotNull
        public final Comparator<T> getComp() {
            return this.comp;
        }

        @NotNull
        public final T[] getTmp() {
            return this.tmp;
        }

        @Override
        protected void swap(int i, int j) {
            Collections.INSTANCE.swap(this.list, i, j);
        }

        @Override
        protected void copy(int src, int dest) {
            this.list.set(dest, this.list.get(src));
        }

        @Override
        protected void save(int i, int len) {
            for (int j = 0; j < len; ++j) {
                this.tmp[j] = this.list.get(i + j);
            }
        }

        @Override
        protected void restore(int i, int j) {
            this.list.set(j, this.tmp[i]);
        }

        @Override
        protected int compare(int i, int j) {
            return this.comp.compare(this.list.get(i), this.list.get(j));
        }

        @Override
        protected int compareSaved(int i, int j) {
            return this.comp.compare(this.tmp[i], this.list.get(j));
        }
    }
}

