/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import dev.scottpierce.envvar.EnvVar;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.jdkport.PrivilegedAction;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010'\u001a\u00020\u000eH\u0002J\b\u00100\u001a\u00020\u000eH\u0002J\b\u00101\u001a\u00020\u000eH\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u00052\u0006\u00107\u001a\u00020\u0005H\u0002J\u0018\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u00107\u001a\u00020\u0005H\u0002J!\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0>H\u0002\u00a2\u0006\u0002\u0010?R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u0011\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\bR\u0011\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0010R\u0014\u0010!\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0010R\u0014\u0010#\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0010R\u0011\u0010%\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0010R\u000e\u0010(\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0010R\u0011\u0010.\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0010R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006@"}, d2={"Lorg/gnit/lucenekmp/util/Constants;", "", "<init>", "()V", "UNKNOWN", "", "JVM_VENDOR", "getJVM_VENDOR", "()Ljava/lang/String;", "JVM_NAME", "getJVM_NAME", "OS_NAME", "getOS_NAME", "LINUX", "", "getLINUX", "()Z", "WINDOWS", "getWINDOWS", "SUN_OS", "getSUN_OS", "MAC_OS_X", "getMAC_OS_X", "FREE_BSD", "getFREE_BSD", "OS_ARCH", "getOS_ARCH", "OS_VERSION", "getOS_VERSION", "JAVA_VENDOR", "getJAVA_VENDOR", "IS_CLIENT_VM", "getIS_CLIENT_VM", "IS_HOTSPOT_VM", "getIS_HOTSPOT_VM", "IS_JVMCI_VM", "getIS_JVMCI_VM", "JRE_IS_64BIT", "getJRE_IS_64BIT", "is64Bit", "HAS_FMA", "MAX_VECTOR_SIZE", "", "HAS_SSE4A", "HAS_FAST_VECTOR_FMA", "getHAS_FAST_VECTOR_FMA", "HAS_FAST_SCALAR_FMA", "getHAS_FAST_SCALAR_FMA", "hasFastVectorFMA", "hasFastScalarFMA", "DEFAULT_READADVICE", "Lorg/gnit/lucenekmp/store/ReadAdvice;", "getDEFAULT_READADVICE", "()Lorg/gnit/lucenekmp/store/ReadAdvice;", "getSysProp", "property", "def", "logSecurityWarning", "", "doPrivileged", "T", "action", "Lorg/gnit/lucenekmp/jdkport/PrivilegedAction;", "(Lorg/gnit/lucenekmp/jdkport/PrivilegedAction;)Ljava/lang/Object;", "core"})
@SourceDebugExtension(value={"SMAP\nConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Constants.kt\norg/gnit/lucenekmp/util/Constants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
public final class Constants {
    @NotNull
    public static final Constants INSTANCE = new Constants();
    @NotNull
    private static final String UNKNOWN = "Unknown";
    @NotNull
    private static final String JVM_VENDOR = Constants.INSTANCE.getSysProp("java.vm.vendor", "Unknown");
    @NotNull
    private static final String JVM_NAME = Constants.INSTANCE.getSysProp("java.vm.name", "Unknown");
    @NotNull
    private static final String OS_NAME = Constants.INSTANCE.getSysProp("os.name", "Unknown");
    private static final boolean LINUX = StringsKt.startsWith$default((String)Constants.OS_NAME, (String)"Linux", (boolean)false, (int)2, null);
    private static final boolean WINDOWS = StringsKt.startsWith$default((String)Constants.OS_NAME, (String)"Windows", (boolean)false, (int)2, null);
    private static final boolean SUN_OS = StringsKt.startsWith$default((String)Constants.OS_NAME, (String)"SunOS", (boolean)false, (int)2, null);
    private static final boolean MAC_OS_X = StringsKt.startsWith$default((String)Constants.OS_NAME, (String)"Mac OS X", (boolean)false, (int)2, null);
    private static final boolean FREE_BSD = StringsKt.startsWith$default((String)Constants.OS_NAME, (String)"FreeBSD", (boolean)false, (int)2, null);
    @NotNull
    private static final String OS_ARCH = Constants.INSTANCE.getSysProp("os.arch", "Unknown");
    @NotNull
    private static final String OS_VERSION = Constants.INSTANCE.getSysProp("os.version", "Unknown");
    @NotNull
    private static final String JAVA_VENDOR = Constants.INSTANCE.getSysProp("java.vendor", "Unknown");
    private static final boolean IS_CLIENT_VM = StringsKt.contains$default((CharSequence)Constants.INSTANCE.getSysProp("java.vm.info", ""), (CharSequence)"emulated-client", (boolean)false, (int)2, null);
    private static final boolean IS_HOTSPOT_VM;
    private static final boolean IS_JVMCI_VM;
    private static final boolean JRE_IS_64BIT;
    private static final boolean HAS_FMA;
    private static final int MAX_VECTOR_SIZE;
    private static final boolean HAS_SSE4A;
    private static final boolean HAS_FAST_VECTOR_FMA;
    private static final boolean HAS_FAST_SCALAR_FMA;
    @NotNull
    private static final ReadAdvice DEFAULT_READADVICE;

    private Constants() {
    }

    @NotNull
    public final String getJVM_VENDOR() {
        return JVM_VENDOR;
    }

    @NotNull
    public final String getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getOS_NAME() {
        return OS_NAME;
    }

    public final boolean getLINUX() {
        return LINUX;
    }

    public final boolean getWINDOWS() {
        return WINDOWS;
    }

    public final boolean getSUN_OS() {
        return SUN_OS;
    }

    public final boolean getMAC_OS_X() {
        return MAC_OS_X;
    }

    public final boolean getFREE_BSD() {
        return FREE_BSD;
    }

    @NotNull
    public final String getOS_ARCH() {
        return OS_ARCH;
    }

    @NotNull
    public final String getOS_VERSION() {
        return OS_VERSION;
    }

    @NotNull
    public final String getJAVA_VENDOR() {
        return JAVA_VENDOR;
    }

    public final boolean getIS_CLIENT_VM() {
        return IS_CLIENT_VM;
    }

    public final boolean getIS_HOTSPOT_VM() {
        return IS_HOTSPOT_VM;
    }

    public final boolean getIS_JVMCI_VM() {
        return IS_JVMCI_VM;
    }

    public final boolean getJRE_IS_64BIT() {
        return JRE_IS_64BIT;
    }

    private final boolean is64Bit() {
        String datamodel;
        String string = datamodel = this.getSysProp("sun.arch.data.model");
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"64", (boolean)false, (int)2, null) : !Intrinsics.areEqual((Object)OS_ARCH, (Object)UNKNOWN) && StringsKt.contains$default((CharSequence)OS_ARCH, (CharSequence)"64", (boolean)false, (int)2, null);
    }

    public final boolean getHAS_FAST_VECTOR_FMA() {
        return HAS_FAST_VECTOR_FMA;
    }

    public final boolean getHAS_FAST_SCALAR_FMA() {
        return HAS_FAST_SCALAR_FMA;
    }

    private final boolean hasFastVectorFMA() {
        if (HAS_FMA) {
            String value = this.getSysProp("lucene.useVectorFMA", "auto");
            if (Intrinsics.areEqual((Object)"auto", (Object)value)) {
                if (Intrinsics.areEqual((Object)OS_ARCH, (Object)"aarch64") && !MAC_OS_X) {
                    return true;
                }
                if (HAS_SSE4A && MAX_VECTOR_SIZE >= 32) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)OS_ARCH, (Object)"amd64") && !HAS_SSE4A) {
                    return true;
                }
            } else {
                return Boolean.parseBoolean(value);
            }
        }
        return false;
    }

    private final boolean hasFastScalarFMA() {
        if (HAS_FMA) {
            String value = this.getSysProp("lucene.useScalarFMA", "auto");
            if (Intrinsics.areEqual((Object)"auto", (Object)value)) {
                if (Intrinsics.areEqual((Object)OS_ARCH, (Object)"aarch64") && !MAC_OS_X) {
                    return true;
                }
                if (HAS_SSE4A && MAX_VECTOR_SIZE >= 64) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)OS_ARCH, (Object)"amd64") && !HAS_SSE4A) {
                    return true;
                }
            } else {
                return Boolean.parseBoolean(value);
            }
        }
        return false;
    }

    @NotNull
    public final ReadAdvice getDEFAULT_READADVICE() {
        return DEFAULT_READADVICE;
    }

    private final String getSysProp(String property) {
        return EnvVar.INSTANCE.get(property);
    }

    private final String getSysProp(String property, String def) {
        String string = EnvVar.INSTANCE.get(property);
        if (string == null) {
            string = def;
        }
        return string;
    }

    private final void logSecurityWarning(String property) {
        KLogger logger = KotlinLogging.INSTANCE.logger(Constants::logSecurityWarning$lambda$1);
        logger.warn(() -> Constants.logSecurityWarning$lambda$2(property));
    }

    private final <T> T doPrivileged(PrivilegedAction<T> action) {
        throw new NotImplementedError(null, 1, null);
    }

    private static final Unit logSecurityWarning$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final Object logSecurityWarning$lambda$2(String $property) {
        return "SecurityManager prevented access to system property: " + $property;
    }

    /*
     * Unable to fully structure code
     */
    static {
        Constants.JRE_IS_64BIT = Constants.INSTANCE.is64Bit();
        Constants.HAS_FAST_VECTOR_FMA = Constants.INSTANCE.hasFastVectorFMA();
        Constants.HAS_FAST_SCALAR_FMA = Constants.INSTANCE.hasFastScalarFMA();
        var0 = Constants.INSTANCE.getSysProp("org.apache.lucene.store.defaultReadAdvice");
        if (var0 == null) ** GOTO lbl-1000
        a = var0;
        $i$a$-let-Constants$DEFAULT_READADVICE$1 = false;
        v0 = a.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toUpperCase(...)");
        var1_3 = ReadAdvice.valueOf(v0);
        if (var1_3 != null) {
            v1 = var1_3;
        } else lbl-1000:
        // 2 sources

        {
            v1 = ReadAdvice.RANDOM;
        }
        Constants.DEFAULT_READADVICE = v1;
    }
}

