/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/DocBaseBitSetIterator;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "bits", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "cost", "", "docBase", "", "<init>", "(Lorg/gnit/lucenekmp/util/FixedBitSet;JI)V", "bitSet", "getBitSet", "()Lorg/gnit/lucenekmp/util/FixedBitSet;", "length", "getDocBase", "()I", "doc", "docID", "nextDoc", "advance", "target", "intoBitSet", "", "upTo", "offset", "core"})
@SourceDebugExtension(value={"SMAP\nDocBaseBitSetIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocBaseBitSetIterator.kt\norg/gnit/lucenekmp/util/DocBaseBitSetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class DocBaseBitSetIterator
extends DocIdSetIterator {
    @NotNull
    private final FixedBitSet bitSet;
    private final int length;
    private final long cost;
    private final int docBase;
    private int doc;

    public DocBaseBitSetIterator(@NotNull FixedBitSet bits, long cost, int docBase) {
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        this.doc = -1;
        if (!(cost >= 0L)) {
            boolean $i$a$-require-DocBaseBitSetIterator$32 = false;
            String $i$a$-require-DocBaseBitSetIterator$32 = "cost must be >= 0, got " + cost;
            throw new IllegalArgumentException($i$a$-require-DocBaseBitSetIterator$32.toString());
        }
        if (!((docBase & 0x3F) == 0)) {
            boolean bl = false;
            String string = "docBase need to be a multiple of 64, got " + docBase;
            throw new IllegalArgumentException(string.toString());
        }
        this.bitSet = bits;
        this.length = bits.length() + docBase;
        this.cost = cost;
        this.docBase = docBase;
    }

    @NotNull
    public final FixedBitSet getBitSet() {
        return this.bitSet;
    }

    public final int getDocBase() {
        return this.docBase;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) {
        int n;
        if (target >= this.length) {
            int n2;
            int it = n2 = Integer.MAX_VALUE;
            boolean bl = false;
            this.doc = it;
            return n2;
        }
        int next = this.bitSet.nextSetBit(Math.max(0, target - this.docBase));
        if (next == Integer.MAX_VALUE) {
            int n3;
            int it = n3 = Integer.MAX_VALUE;
            boolean bl = false;
            this.doc = it;
            n = n3;
        } else {
            int n4;
            int it = n4 = next + this.docBase;
            boolean bl = false;
            this.doc = it;
            n = n4;
        }
        return n;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public void intoBitSet(int upTo, @NotNull FixedBitSet bitSet, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
        int actualUpto = Math.min(upTo, this.length);
        actualUpto = Math.min(actualUpto, offset + bitSet.length());
        if (actualUpto > this.doc) {
            FixedBitSet.Companion.orRange(this.bitSet, this.doc - this.docBase, bitSet, this.doc - offset, actualUpto - this.doc);
            this.advance(actualUpto);
        }
        super.intoBitSet(upTo, bitSet, offset);
    }
}

