/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.search.DocIdSet;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitDocIdSet;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IntArrayDocIdSet;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.LSBRadixSorter;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u000534567B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0007\u0010\u000fJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0003J\u0010\u0010*\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0018\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0003H\u0002J\b\u00100\u001a\u00020%H\u0002J\u0006\u00101\u001a\u000202R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/gnit/lucenekmp/util/DocIdSetBuilder;", "", "maxDoc", "", "docCount", "valueCount", "", "<init>", "(IIJ)V", "(I)V", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "(ILorg/gnit/lucenekmp/index/Terms;)V", "values", "Lorg/gnit/lucenekmp/index/PointValues;", "(ILorg/gnit/lucenekmp/index/PointValues;)V", "threshold", "multivalued", "", "getMultivalued", "()Z", "numValuesPerDoc", "", "getNumValuesPerDoc", "()D", "setNumValuesPerDoc", "(D)V", "buffers", "", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder$Buffer;", "totalAllocated", "bitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "counter", "adder", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder$BulkAdder;", "add", "", "iter", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "grow", "numDocs", "ensureBufferCapacity", "additionalCapacity", "addBuffer", "len", "growBuffer", "buffer", "upgradeToBitSet", "build", "Lorg/gnit/lucenekmp/search/DocIdSet;", "BulkAdder", "FixedBitSetAdder", "Buffer", "BufferAdder", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocIdSetBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocIdSetBuilder.kt\norg/gnit/lucenekmp/util/DocIdSetBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1#2:345\n*E\n"})
public final class DocIdSetBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxDoc;
    private final int threshold;
    private final boolean multivalued;
    private double numValuesPerDoc;
    @NotNull
    private List<Buffer> buffers;
    private int totalAllocated;
    @Nullable
    private FixedBitSet bitSet;
    private long counter;
    private BulkAdder adder;

    public DocIdSetBuilder(int maxDoc, int docCount, long valueCount) {
        this.maxDoc = maxDoc;
        this.buffers = new ArrayList();
        this.counter = -1L;
        this.multivalued = docCount < 0 || (long)docCount != valueCount;
        this.numValuesPerDoc = docCount <= 0 || valueCount < 0L ? 1.0 : (double)valueCount / (double)docCount;
        if (!(this.numValuesPerDoc >= 1.0)) {
            boolean bl = false;
            String string = "valueCount=" + valueCount + " docCount=" + docCount;
            throw new IllegalArgumentException(string.toString());
        }
        this.threshold = this.maxDoc >>> 7;
        this.bitSet = null;
    }

    public final boolean getMultivalued() {
        return this.multivalued;
    }

    public final double getNumValuesPerDoc() {
        return this.numValuesPerDoc;
    }

    public final void setNumValuesPerDoc(double d) {
        this.numValuesPerDoc = d;
    }

    public DocIdSetBuilder(int maxDoc) {
        this(maxDoc, -1, -1L);
    }

    public DocIdSetBuilder(int maxDoc, @NotNull Terms terms) {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        this(maxDoc, terms.getDocCount(), terms.getSumDocFreq());
    }

    public DocIdSetBuilder(int maxDoc, @NotNull PointValues values2) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        this(maxDoc, values2.getDocCount(), values2.size());
    }

    public final void add(@NotNull DocIdSetIterator iter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)iter, (String)"iter");
        int cost = (int)Math.min(Integer.MAX_VALUE, iter.cost());
        BulkAdder adder = this.grow(cost);
        if (this.bitSet != null) {
            FixedBitSet fixedBitSet = this.bitSet;
            Intrinsics.checkNotNull((Object)fixedBitSet);
            fixedBitSet.or(iter);
            return;
        }
        for (int i = 0; i < cost; ++i) {
            int doc = iter.nextDoc();
            if (doc == Integer.MAX_VALUE) {
                return;
            }
            adder.add(doc);
        }
        int doc = iter.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            this.grow(1).add(doc);
            doc = iter.nextDoc();
        }
    }

    @NotNull
    public final BulkAdder grow(int numDocs) {
        BulkAdder bulkAdder;
        if (this.bitSet == null) {
            if ((long)this.totalAllocated + (long)numDocs <= (long)this.threshold) {
                this.ensureBufferCapacity(numDocs);
            } else {
                this.upgradeToBitSet();
                this.counter += (long)numDocs;
            }
        } else {
            this.counter += (long)numDocs;
        }
        if ((bulkAdder = this.adder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adder");
            bulkAdder = null;
        }
        return bulkAdder;
    }

    private final void ensureBufferCapacity(int numDocs) {
        if (this.buffers.isEmpty()) {
            this.addBuffer(this.additionalCapacity(numDocs));
            return;
        }
        Buffer current = this.buffers.get(this.buffers.size() - 1);
        if (current.getArray().length - current.getLength() >= numDocs) {
            return;
        }
        if (current.getLength() < current.getArray().length - (current.getArray().length >>> 3)) {
            this.growBuffer(current, this.additionalCapacity(numDocs));
        } else {
            this.addBuffer(this.additionalCapacity(numDocs));
        }
    }

    private final int additionalCapacity(int numDocs) {
        int c = this.totalAllocated;
        c = Math.max(numDocs + 1, c);
        c = Math.max(32, c);
        c = Math.min(this.threshold - this.totalAllocated, c);
        return c;
    }

    private final Buffer addBuffer(int len) {
        Buffer buffer = new Buffer(len);
        this.buffers.add(buffer);
        this.adder = new BufferAdder(buffer);
        this.totalAllocated += buffer.getArray().length;
        return buffer;
    }

    private final void growBuffer(Buffer buffer, int additionalCapacity) {
        buffer.setArray(ArrayUtil.Companion.growExact(buffer.getArray(), buffer.getArray().length + additionalCapacity));
        this.totalAllocated += additionalCapacity;
    }

    private final void upgradeToBitSet() {
        if (!(this.bitSet == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        FixedBitSet bitSet = new FixedBitSet(this.maxDoc);
        long counter = 0L;
        for (Buffer buffer : this.buffers) {
            int[] array = buffer.getArray();
            int length = buffer.getLength();
            counter += (long)length;
            for (int i = 0; i < length; ++i) {
                bitSet.set(array[i]);
            }
        }
        this.bitSet = bitSet;
        this.counter = counter;
        this.buffers = new ArrayList();
        this.adder = new FixedBitSetAdder(bitSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DocIdSet build() {
        try {
            if (this.bitSet != null) {
                if (!(this.counter >= 0L)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                long cost = (long)Math.rint((double)this.counter / this.numValuesPerDoc);
                FixedBitSet fixedBitSet = this.bitSet;
                Intrinsics.checkNotNull((Object)fixedBitSet);
                DocIdSet docIdSet = new BitDocIdSet(fixedBitSet, cost);
                return docIdSet;
            }
            Buffer concatenated = DocIdSetBuilder.Companion.concat(this.buffers);
            LSBRadixSorter sorter2 = new LSBRadixSorter();
            sorter2.sort(PackedInts.INSTANCE.bitsRequired((long)this.maxDoc - 1L), concatenated.getArray(), concatenated.getLength());
            int l = 0;
            if (this.multivalued) {
                l = DocIdSetBuilder.Companion.dedup(concatenated.getArray(), concatenated.getLength());
            } else {
                if (!DocIdSetBuilder.Companion.noDups(concatenated.getArray(), concatenated.getLength())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                l = concatenated.getLength();
            }
            if (!(l <= concatenated.getLength())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            concatenated.getArray()[l] = Integer.MAX_VALUE;
            DocIdSet docIdSet = new IntArrayDocIdSet(concatenated.getArray(), l);
            return docIdSet;
        }
        finally {
            this.buffers = new ArrayList();
            this.bitSet = null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/DocIdSetBuilder$Buffer;", "", "length", "", "<init>", "(I)V", "array", "", "([II)V", "getArray", "()[I", "setArray", "([I)V", "getLength", "()I", "setLength", "core"})
    private static final class Buffer {
        @NotNull
        private int[] array;
        private int length;

        @NotNull
        public final int[] getArray() {
            return this.array;
        }

        public final void setArray(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.array = nArray;
        }

        public final int getLength() {
            return this.length;
        }

        public final void setLength(int n) {
            this.length = n;
        }

        public Buffer(int length) {
            this.array = new int[length];
            this.length = 0;
        }

        public Buffer(@NotNull int[] array, int length) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.array = array;
            this.length = length;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/DocIdSetBuilder$BufferAdder;", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder$BulkAdder;", "buffer", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder$Buffer;", "<init>", "(Lorg/gnit/lucenekmp/util/DocIdSetBuilder$Buffer;)V", "getBuffer", "()Lorg/gnit/lucenekmp/util/DocIdSetBuilder$Buffer;", "add", "", "doc", "", "docs", "Lorg/gnit/lucenekmp/util/IntsRef;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "core"})
    @SourceDebugExtension(value={"SMAP\nDocIdSetBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocIdSetBuilder.kt\norg/gnit/lucenekmp/util/DocIdSetBuilder$BufferAdder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1#2:345\n*E\n"})
    private static final class BufferAdder
    implements BulkAdder {
        @NotNull
        private final Buffer buffer;

        public BufferAdder(@NotNull Buffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.buffer = buffer;
        }

        @NotNull
        public final Buffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void add(int doc) {
            int[] nArray = this.buffer.getArray();
            Buffer buffer = this.buffer;
            int n = buffer.getLength();
            buffer.setLength(n + 1);
            nArray[n] = doc;
        }

        @Override
        public void add(@NotNull IntsRef docs) {
            Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
            ArraysKt.copyInto((int[])docs.getInts(), (int[])this.buffer.getArray(), (int)this.buffer.getLength(), (int)docs.getOffset(), (int)(docs.getOffset() + docs.getLength()));
            Buffer buffer = this.buffer;
            buffer.setLength(buffer.getLength() + docs.getLength());
        }

        @Override
        public void add(@NotNull DocIdSetIterator iterator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            int docID = 0;
            while (true) {
                int n;
                int it = n = iterator2.nextDoc();
                boolean bl = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                this.add(docID);
            }
        }

        @NotNull
        public final Buffer component1() {
            return this.buffer;
        }

        @NotNull
        public final BufferAdder copy(@NotNull Buffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return new BufferAdder(buffer);
        }

        public static /* synthetic */ BufferAdder copy$default(BufferAdder bufferAdder, Buffer buffer, int n, Object object) {
            if ((n & 1) != 0) {
                buffer = bufferAdder.buffer;
            }
            return bufferAdder.copy(buffer);
        }

        @NotNull
        public String toString() {
            return "BufferAdder(buffer=" + this.buffer + ")";
        }

        public int hashCode() {
            return this.buffer.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BufferAdder)) {
                return false;
            }
            BufferAdder bufferAdder = (BufferAdder)other;
            return Intrinsics.areEqual((Object)this.buffer, (Object)bufferAdder.buffer);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/DocIdSetBuilder$BulkAdder;", "", "add", "", "doc", "", "docs", "Lorg/gnit/lucenekmp/util/IntsRef;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "core"})
    public static interface BulkAdder {
        public void add(int var1);

        public void add(@NotNull IntsRef var1);

        public void add(@NotNull DocIdSetIterator var1) throws IOException;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/util/DocIdSetBuilder$Companion;", "", "<init>", "()V", "concat", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder$Buffer;", "buffers", "", "dedup", "", "arr", "", "length", "noDups", "", "a", "len", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final Buffer concat(List<Buffer> buffers) {
            int totalLength = 0;
            Buffer largestBuffer = null;
            for (Buffer buffer : buffers) {
                totalLength += buffer.getLength();
                if (largestBuffer != null && buffer.getArray().length <= largestBuffer.getArray().length) continue;
                largestBuffer = buffer;
            }
            if (largestBuffer == null) {
                return new Buffer(1);
            }
            int[] docs = largestBuffer.getArray();
            if (docs.length < totalLength + 1) {
                docs = ArrayUtil.Companion.growExact(docs, totalLength + 1);
            }
            totalLength = largestBuffer.getLength();
            for (Buffer buffer : buffers) {
                if (buffer == largestBuffer) continue;
                ArraysKt.copyInto((int[])buffer.getArray(), (int[])docs, (int)totalLength, (int)0, (int)buffer.getLength());
                totalLength += buffer.getLength();
            }
            return new Buffer(docs, totalLength);
        }

        private final int dedup(int[] arr, int length) {
            if (length == 0) {
                return 0;
            }
            int l = 1;
            int previous = arr[0];
            for (int i = 1; i < length; ++i) {
                int value = arr[i];
                if (!(value >= previous)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (value == previous) continue;
                arr[l++] = value;
                previous = value;
            }
            return l;
        }

        private final boolean noDups(int[] a, int len) {
            for (int i = 1; i < len; ++i) {
                if (a[i - 1] < a[i]) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/DocIdSetBuilder$FixedBitSetAdder;", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder$BulkAdder;", "bitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "<init>", "(Lorg/gnit/lucenekmp/util/FixedBitSet;)V", "getBitSet", "()Lorg/gnit/lucenekmp/util/FixedBitSet;", "add", "", "doc", "", "docs", "Lorg/gnit/lucenekmp/util/IntsRef;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "core"})
    private static final class FixedBitSetAdder
    implements BulkAdder {
        @NotNull
        private final FixedBitSet bitSet;

        public FixedBitSetAdder(@NotNull FixedBitSet bitSet) {
            Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
            this.bitSet = bitSet;
        }

        @NotNull
        public final FixedBitSet getBitSet() {
            return this.bitSet;
        }

        @Override
        public void add(int doc) {
            FixedBitSet fixedBitSet = this.bitSet;
            Intrinsics.checkNotNull((Object)fixedBitSet);
            fixedBitSet.set(doc);
        }

        @Override
        public void add(@NotNull IntsRef docs) {
            Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
            int n = docs.getLength();
            for (int i = 0; i < n; ++i) {
                FixedBitSet fixedBitSet = this.bitSet;
                Intrinsics.checkNotNull((Object)fixedBitSet);
                fixedBitSet.set(docs.getInts()[docs.getOffset() + i]);
            }
        }

        @Override
        public void add(@NotNull DocIdSetIterator iterator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            this.bitSet.or(iterator2);
        }

        @NotNull
        public final FixedBitSet component1() {
            return this.bitSet;
        }

        @NotNull
        public final FixedBitSetAdder copy(@NotNull FixedBitSet bitSet) {
            Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
            return new FixedBitSetAdder(bitSet);
        }

        public static /* synthetic */ FixedBitSetAdder copy$default(FixedBitSetAdder fixedBitSetAdder, FixedBitSet fixedBitSet, int n, Object object) {
            if ((n & 1) != 0) {
                fixedBitSet = fixedBitSetAdder.bitSet;
            }
            return fixedBitSetAdder.copy(fixedBitSet);
        }

        @NotNull
        public String toString() {
            return "FixedBitSetAdder(bitSet=" + this.bitSet + ")";
        }

        public int hashCode() {
            return this.bitSet.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FixedBitSetAdder)) {
                return false;
            }
            FixedBitSetAdder fixedBitSetAdder = (FixedBitSetAdder)other;
            return Intrinsics.areEqual((Object)this.bitSet, (Object)fixedBitSetAdder.bitSet);
        }
    }
}

