/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer;", "Lorg/gnit/lucenekmp/util/Accountable;", "maxSize", "", "sentinel", "<init>", "(II)V", "buffer", "", "position", "frequencies", "Lorg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer$IntBag;", "ramBytesUsed", "", "add", "", "i", "frequency", "key", "asFrequencyMap", "", "IntBag", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFrequencyTrackingRingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrequencyTrackingRingBuffer.kt\norg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,207:1\n1#2:208\n3#3,8:209\n3#3,8:218\n10#4:217\n10#4:226\n*S KotlinDebug\n*F\n+ 1 FrequencyTrackingRingBuffer.kt\norg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer\n*L\n38#1:209,8\n53#1:218,8\n38#1:217\n53#1:226\n*E\n"})
public final class FrequencyTrackingRingBuffer
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSize;
    @NotNull
    private final int[] buffer;
    private int position;
    @NotNull
    private final IntBag frequencies;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(FrequencyTrackingRingBuffer.class));

    public FrequencyTrackingRingBuffer(int maxSize, int sentinel) {
        if (!(maxSize >= 2)) {
            boolean bl = false;
            String string = "maxSize must be at least 2";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxSize = maxSize;
        this.buffer = new int[maxSize];
        this.position = 0;
        this.frequencies = new IntBag(maxSize);
        Arrays.INSTANCE.fill(this.buffer, sentinel);
        for (int i = 0; i < maxSize; ++i) {
            this.frequencies.add(sentinel);
        }
        boolean condition$iv = this.frequencies.frequency(sentinel) == maxSize;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.frequencies.ramBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.buffer);
    }

    public final void add(int i) {
        boolean removedFromBag;
        int removed = this.buffer[this.position];
        boolean condition$iv = removedFromBag = this.frequencies.remove(removed);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.buffer[this.position] = i;
        this.frequencies.add(i);
        ++this.position;
        if (this.position == this.maxSize) {
            this.position = 0;
        }
    }

    public final int frequency(int key) {
        return this.frequencies.frequency(key);
    }

    @NotNull
    public final Map<Integer, Integer> asFrequencyMap() {
        return this.frequencies.asMap();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer$IntBag;", "Lorg/gnit/lucenekmp/util/Accountable;", "maxSize", "", "<init>", "(I)V", "keys", "", "freqs", "mask", "ramBytesUsed", "", "frequency", "key", "add", "remove", "", "relocateAdjacentKeys", "", "freeSlot", "asMap", "", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nFrequencyTrackingRingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrequencyTrackingRingBuffer.kt\norg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer$IntBag\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n3#2,8:208\n10#3:216\n1#4:217\n*S KotlinDebug\n*F\n+ 1 FrequencyTrackingRingBuffer.kt\norg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer$IntBag\n*L\n88#1:208,8\n88#1:216\n*E\n"})
    private static final class IntBag
    implements Accountable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final int[] keys;
        @NotNull
        private final int[] freqs;
        private final int mask;
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(IntBag.class));

        public IntBag(int maxSize) {
            int capacity = Math.max(2, maxSize * 3 / 2);
            capacity = IntExtKt.highestOneBit(IntCompanionObject.INSTANCE, capacity - 1) << 1;
            boolean condition$iv = capacity > maxSize;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.keys = new int[capacity];
            this.freqs = new int[capacity];
            this.mask = capacity - 1;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.keys) + RamUsageEstimator.Companion.sizeOf(this.freqs);
        }

        public final int frequency(int key) {
            int slot = key & this.mask;
            while (this.keys[slot] != key) {
                if (this.freqs[slot] == 0) {
                    return 0;
                }
                slot = slot + 1 & this.mask;
            }
            return this.freqs[slot];
        }

        public final int add(int key) {
            int slot = 0;
            slot = key & this.mask;
            while (true) {
                if (this.freqs[slot] == 0) {
                    int n;
                    this.keys[slot] = key;
                    int it = n = 1;
                    boolean bl = false;
                    this.freqs[slot] = it;
                    return n;
                }
                if (this.keys[slot] == key) {
                    int[] nArray = this.freqs;
                    int n = slot;
                    nArray[n] = nArray[n] + 1;
                    return nArray[n];
                }
                slot = slot + 1 & this.mask;
            }
        }

        public final boolean remove(int key) {
            int slot = key & this.mask;
            while (this.freqs[slot] != 0) {
                if (this.keys[slot] == key) {
                    int[] nArray = this.freqs;
                    int n = slot;
                    nArray[n] = nArray[n] + -1;
                    int newFreq = nArray[n];
                    if (newFreq == 0) {
                        this.relocateAdjacentKeys(slot);
                    }
                    return true;
                }
                slot = slot + 1 & this.mask;
            }
            return false;
        }

        public final void relocateAdjacentKeys(int freeSlot) {
            int freq;
            int freeSlot2 = freeSlot;
            int slot = freeSlot2 + 1 & this.mask;
            while ((freq = this.freqs[slot]) != 0) {
                int key = this.keys[slot];
                int expectedSlot = key & this.mask;
                if (IntBag.Companion.between(expectedSlot, slot, freeSlot2)) {
                    this.keys[freeSlot2] = key;
                    this.freqs[freeSlot2] = freq;
                    this.freqs[slot] = 0;
                    freeSlot2 = slot;
                }
                slot = slot + 1 & this.mask;
            }
        }

        @NotNull
        public final Map<Integer, Integer> asMap() {
            Map map2 = new HashMap();
            int n = this.keys.length;
            for (int i = 0; i < n; ++i) {
                if (this.freqs[i] <= 0) continue;
                map2.put(this.keys[i], this.freqs[i]);
            }
            return map2;
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer$IntBag$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "between", "", "chainStart", "", "chainEnd", "slot", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean between(int chainStart, int chainEnd, int slot) {
                return chainStart <= chainEnd ? chainStart <= slot && slot <= chainEnd : slot >= chainStart || slot <= chainEnd;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

