/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import org.gnit.lucenekmp.jdkport.BufferedReader;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.CodingErrorAction;
import org.gnit.lucenekmp.jdkport.Files;
import org.gnit.lucenekmp.jdkport.InputStream;
import org.gnit.lucenekmp.jdkport.InputStreamReader;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.util.IOConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J'\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\t2\u0006\u0010\f\u001a\u0002H\t\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\u00020\u000f2\u001a\u0010\u0010\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0012j\u0002`\u00130\u0011\"\u00060\u0012j\u0002`\u0013\u00a2\u0006\u0002\u0010\u0014J3\u0010\u000e\u001a\u00020\u000f2\"\u0010\u0010\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u00130\u0011\"\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u0016J'\u0010\u0017\u001a\u00020\u000f2\u001a\u0010\u0010\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0012j\u0002`\u00130\u0011\"\u00060\u0012j\u0002`\u0013\u00a2\u0006\u0002\u0010\u0014J3\u0010\u0017\u001a\u00020\u000f2\"\u0010\u0010\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u00130\u0011\"\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0018\u0010\u0017\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u0016J\u0012\u0010\u0017\u001a\u00020\u000f2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J'\u0010\"\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t2\b\u0010#\u001a\u0004\u0018\u0001H\t2\b\u0010$\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010%J\u001c\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*J'\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0011\"\u00020\u0007\u00a2\u0006\u0002\u0010+J\u001c\u0010,\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070*J\u001f\u0010&\u001a\u00020\u000f2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0\u0011\"\u00020.\u00a2\u0006\u0002\u0010/J\u0014\u0010&\u001a\u00020\u000f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020.0*J\u001f\u00100\u001a\u00020\u000f2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0\u0011\"\u00020.\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\u00020\u000f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020.0*J\u001f\u00101\u001a\u00020\u000f2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0\u0011\"\u00020.\u00a2\u0006\u0002\u0010/Je\u00101\u001a\u001e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\n03j\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\n`42\"\u00105\u001a\u001e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\n03j\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\n`42\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010.0\u0011\"\u0004\u0018\u00010.H\u0002\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\nJ\u0012\u0010:\u001a\u00020\u000f2\b\u00109\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010;\u001a\u00020\u000f2\b\u00109\u001a\u0004\u0018\u00010\nH\u0007J\u0016\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020?J1\u0010@\u001a\u00020\u000f\"\u0004\b\u0000\u0010\t2\u000e\u0010A\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\t0*2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H\t0CH\u0007\u00a2\u0006\u0002\bDJ(\u0010@\u001a\u00020\u000f\"\u0004\b\u0000\u0010\t2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H\t0*2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002H\t0CR\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/gnit/lucenekmp/util/IOUtils;", "", "<init>", "()V", "fs", "Lokio/FileSystem;", "UTF_8", "", "useOrSuppress", "T", "", "first", "second", "(Ljava/lang/Throwable;Ljava/lang/Throwable;)Ljava/lang/Throwable;", "close", "", "objects", "", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "([Ljava/lang/AutoCloseable;)V", "closeNullable", "", "closeWhileHandlingException", "closeWhileHandlingExceptionNullable", "closable", "Ljava/io/Closeable;", "Lokio/Closeable;", "getDecodingReader", "Lorg/gnit/lucenekmp/jdkport/Reader;", "stream", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "charSet", "Lorg/gnit/lucenekmp/jdkport/Charset;", "requireResourceNonNull", "resource", "name", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "deleteFilesIgnoringExceptions", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "files", "", "(Lorg/gnit/lucenekmp/store/Directory;[Ljava/lang/String;)V", "deleteFiles", "names", "Lokio/Path;", "([Lokio/Path;)V", "deleteFilesIfExist", "rm", "locations", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "unremoved", "(Ljava/util/LinkedHashMap;[Lokio/Path;)Ljava/util/LinkedHashMap;", "rethrowAlways", "", "th", "reThrow", "reThrowUnchecked", "fsync", "fileToSync", "isDir", "", "applyToAll", "collection", "consumer", "Lorg/gnit/lucenekmp/util/IOConsumer;", "applyToAllNullable", "core"})
public final class IOUtils {
    @NotNull
    public static final IOUtils INSTANCE = new IOUtils();
    @NotNull
    public static final String UTF_8 = "UTF-8";

    private IOUtils() {
    }

    private final FileSystem fs() {
        return Files.INSTANCE.getFileSystem();
    }

    @NotNull
    public final <T extends Throwable> T useOrSuppress(@Nullable T first, @NotNull T second) {
        Intrinsics.checkNotNullParameter(second, (String)"second");
        if (first == null) {
            return second;
        }
        ExceptionsKt.addSuppressed(first, second);
        return first;
    }

    public final void close(AutoCloseable ... objects) throws IOException {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.close(ArraysKt.asList((Object[])objects));
    }

    @JvmName(name="closeNullable")
    public final void closeNullable(AutoCloseable ... objects) throws IOException {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.close(CollectionsKt.filterNotNull((Iterable)ArraysKt.asList((Object[])objects)));
    }

    public final void close(@NotNull Iterable<? extends AutoCloseable> objects) throws IOException {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Throwable th = null;
        for (AutoCloseable autoCloseable : objects) {
            try {
                autoCloseable.close();
            }
            catch (Throwable t) {
                th = this.useOrSuppress(th, t);
            }
        }
        if (th != null) {
            this.rethrowAlways(th);
            throw new KotlinNothingValueException();
        }
    }

    public final void closeWhileHandlingException(AutoCloseable ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.closeWhileHandlingException(ArraysKt.asList((Object[])objects));
    }

    @JvmName(name="closeWhileHandlingExceptionNullable")
    public final void closeWhileHandlingExceptionNullable(AutoCloseable ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.closeWhileHandlingException(CollectionsKt.filterNotNull((Iterable)ArraysKt.asList((Object[])objects)));
    }

    public final void closeWhileHandlingException(@NotNull Iterable<? extends AutoCloseable> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Error firstError = null;
        Throwable firstThrowable = null;
        for (AutoCloseable autoCloseable : objects) {
            try {
                autoCloseable.close();
            }
            catch (Error e) {
                firstError = (Error)this.useOrSuppress((Throwable)firstError, (Throwable)e);
            }
            catch (Throwable t) {
                firstThrowable = this.useOrSuppress(firstThrowable, t);
            }
        }
        if (firstError != null) {
            if (firstThrowable != null) {
                ExceptionsKt.addSuppressed((Throwable)firstError, firstThrowable);
            }
            throw firstError;
        }
    }

    public final void closeWhileHandlingException(@NotNull Closeable closable) {
        Intrinsics.checkNotNullParameter((Object)closable, (String)"closable");
        try {
            closable.close();
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public final Reader getDecodingReader(@NotNull InputStream stream, @NotNull Charset charSet) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)charSet, (String)"charSet");
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.Companion.getREPORT()).onUnmappableCharacter(CodingErrorAction.Companion.getREPORT());
        return new BufferedReader(new InputStreamReader(stream, charSetDecoder), 0, 2, null);
    }

    @Nullable
    public final <T> T requireResourceNonNull(@Nullable T resource, @Nullable String name) throws IOException {
        if (resource == null) {
            throw new FileNotFoundException("The resource '" + name + "' was not found.");
        }
        return resource;
    }

    public final void deleteFilesIgnoringExceptions(@NotNull Directory dir, @NotNull Collection<String> files) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        for (String name : files) {
            try {
                dir.deleteFile(name);
            }
            catch (Throwable throwable) {}
        }
    }

    public final void deleteFilesIgnoringExceptions(@NotNull Directory dir, String ... files) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.deleteFilesIgnoringExceptions(dir, ArraysKt.asList((Object[])files));
    }

    public final void deleteFiles(@NotNull Directory dir, @NotNull Collection<String> names) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Throwable th = null;
        for (String name : names) {
            if (name == null) continue;
            try {
                dir.deleteFile(name);
            }
            catch (Throwable t) {
                th = this.useOrSuppress(th, t);
            }
        }
        if (th != null) {
            this.rethrowAlways(th);
            throw new KotlinNothingValueException();
        }
    }

    public final void deleteFilesIgnoringExceptions(Path ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.deleteFilesIgnoringExceptions(ArraysKt.asList((Object[])files));
    }

    public final void deleteFilesIgnoringExceptions(@NotNull Collection<Path> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        for (Path path : files) {
            if (path == null) continue;
            try {
                this.fs().delete(path, false);
            }
            catch (Throwable throwable) {}
        }
    }

    public final void deleteFilesIfExist(Path ... files) throws IOException {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.deleteFilesIfExist(ArraysKt.asList((Object[])files));
    }

    public final void deleteFilesIfExist(@NotNull Collection<Path> files) throws IOException {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Throwable th = null;
        for (Path file : files) {
            try {
                if (file == null) continue;
                this.fs().delete(file, false);
            }
            catch (Throwable t) {
                th = this.useOrSuppress(th, t);
            }
        }
        if (th != null) {
            this.rethrowAlways(th);
            throw new KotlinNothingValueException();
        }
    }

    public final void rm(Path ... locations) throws IOException {
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        LinkedHashMap<Path, Throwable> unremoved = this.rm(new LinkedHashMap<Path, Throwable>(), Arrays.copyOf(locations, locations.length));
        if (!((Map)unremoved).isEmpty()) {
            StringBuilder b = new StringBuilder("Could not remove the following files (in the order of attempts):\n");
            for (Map.Entry entry : ((Map)unremoved).entrySet()) {
                Path path = (Path)entry.getKey();
                Throwable cause = (Throwable)entry.getValue();
                b.append("   ").append(path.toString()).append(": ").append(cause).append("\n");
            }
            throw new IOException(b.toString());
        }
    }

    private final LinkedHashMap<Path, Throwable> rm(LinkedHashMap<Path, Throwable> unremoved, Path ... locations) {
        if (locations != null) {
            for (Path location : locations) {
                if (location == null) continue;
                try {
                    this.fs().delete(location, false);
                }
                catch (IOException e) {
                    ((Map)unremoved).put(location, e);
                }
                catch (Throwable t) {
                    ((Map)unremoved).put(location, t);
                }
            }
        }
        return unremoved;
    }

    @NotNull
    public final Void rethrowAlways(@NotNull Throwable th) throws IOException, RuntimeException {
        Intrinsics.checkNotNullParameter((Object)th, (String)"th");
        if (th instanceof IOException) {
            throw th;
        }
        if (th instanceof RuntimeException) {
            throw th;
        }
        if (th instanceof Error) {
            throw th;
        }
        throw new RuntimeException(th);
    }

    @Deprecated(message="Use rethrowAlways(Throwable) instead and guard against null", replaceWith=@ReplaceWith(expression="if (th != null) IOUtils.rethrowAlways(th)", imports={}))
    public final void reThrow(@Nullable Throwable th) throws IOException {
        if (th != null) {
            this.rethrowAlways(th);
            throw new KotlinNothingValueException();
        }
    }

    @Deprecated(message="Use rethrowAlways(Throwable) instead and guard against null")
    public final void reThrowUnchecked(@Nullable Throwable th) {
        if (th != null) {
            if (th instanceof Error) {
                throw th;
            }
            if (th instanceof RuntimeException) {
                throw th;
            }
            throw new RuntimeException(th);
        }
    }

    public final void fsync(@NotNull Path fileToSync, boolean isDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileToSync, (String)"fileToSync");
        FileSystem fileSystem = this.fs();
        if (isDir) {
            try {
                FileMetadata meta = fileSystem.metadataOrNull(fileToSync);
                if (meta == null) {
                    throw new FileNotFoundException("The directory '" + fileToSync + "' was not found.");
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (Throwable e) {
                // empty catch block
            }
            return;
        }
        FileMetadata fileMetadata = fileSystem.metadataOrNull(fileToSync);
        if (fileMetadata == null) {
            throw new FileNotFoundException("The file '" + fileToSync + "' was not found.");
        }
        FileMetadata meta = fileMetadata;
        if (meta.isDirectory()) {
            return;
        }
    }

    @JvmName(name="applyToAllNullable")
    public final <T> void applyToAllNullable(@NotNull Collection<? extends T> collection, @NotNull IOConsumer<T> consumer) throws IOException {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Throwable firstException = null;
        for (T item : collection) {
            if (item == null) continue;
            try {
                consumer.accept(item);
            }
            catch (Throwable t) {
                firstException = this.useOrSuppress(firstException, t);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public final <T> void applyToAll(@NotNull Collection<? extends T> collection, @NotNull IOConsumer<T> consumer) throws IOException {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Throwable firstException = null;
        for (T item : collection) {
            if (item == null) continue;
            try {
                consumer.accept(item);
            }
            catch (Throwable t) {
                firstException = this.useOrSuppress(firstException, t);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }
}

