/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.search.DocIdSet;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.VectorUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/IntArrayDocIdSet;", "Lorg/gnit/lucenekmp/search/DocIdSet;", "docs", "", "length", "", "<init>", "([II)V", "ramBytesUsed", "", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "IntArrayDocIdSetIterator", "Companion", "core"})
public final class IntArrayDocIdSet
extends DocIdSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] docs;
    private final int length;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(IntArrayDocIdSet.class));

    public IntArrayDocIdSet(@NotNull int[] docs, int length) {
        Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
        if (!(docs[length] == Integer.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.docs = docs;
        if (!IntArrayDocIdSet.Companion.assertArraySorted(docs, length)) {
            boolean bl = false;
            String string = "IntArrayDocIdSet need docs to be sorted" + Arrays.INSTANCE.toString(ArrayUtil.Companion.copyOfSubArray(docs, 0, length));
            throw new IllegalArgumentException(string.toString());
        }
        this.length = length;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.docs);
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        return new IntArrayDocIdSetIterator(this.docs, this.length);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/IntArrayDocIdSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "assertArraySorted", "", "docs", "", "length", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean assertArraySorted(int[] docs, int length) {
            for (int i = 1; i < length; ++i) {
                if (docs[i] >= docs[i - 1]) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/IntArrayDocIdSet$IntArrayDocIdSetIterator;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "docs", "", "length", "", "<init>", "([II)V", "i", "doc", "docID", "nextDoc", "advance", "target", "intoBitSet", "", "upTo", "bitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "offset", "cost", "", "core"})
    @SourceDebugExtension(value={"SMAP\nIntArrayDocIdSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntArrayDocIdSet.kt\norg/gnit/lucenekmp/util/IntArrayDocIdSet$IntArrayDocIdSetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
    public static final class IntArrayDocIdSetIterator
    extends DocIdSetIterator {
        @NotNull
        private final int[] docs;
        private final int length;
        private int i;
        private int doc;

        public IntArrayDocIdSetIterator(@NotNull int[] docs, int length) {
            Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
            this.docs = docs;
            this.length = length;
            this.doc = -1;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            int n = this.i;
            this.i = n + 1;
            int it = n = this.docs[n];
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public int advance(int target) throws IOException {
            int bound = 1;
            while (this.i + bound < this.length && this.docs[this.i + bound] < target) {
                bound *= 2;
            }
            this.i = Arrays.INSTANCE.binarySearch(this.docs, this.i + bound / 2, Math.min(this.i + bound + 1, this.length), target);
            if (this.i < 0) {
                this.i = -1 - this.i;
            }
            int n = this.i;
            this.i = n + 1;
            int it = n = this.docs[n];
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public void intoBitSet(int upTo, @NotNull FixedBitSet bitSet, int offset) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
            if (this.doc >= upTo) {
                return;
            }
            int from = this.i - 1;
            int to = VectorUtil.INSTANCE.findNextGEQ(this.docs, upTo, from, this.length);
            for (int idx = from; idx < to; ++idx) {
                bitSet.set(this.docs[idx] - offset);
            }
            this.doc = this.docs[to];
            this.i = to + 1;
        }

        @Override
        public long cost() {
            return this.length;
        }
    }
}

