/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\"B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007B!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\fJ\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0011\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0007R\u0011\u0010 \u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/util/IntsRef;", "", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "<init>", "()V", "capacity", "", "(I)V", "ints", "", "offset", "length", "([III)V", "getInts", "()[I", "setInts", "([I)V", "getOffset", "()I", "setOffset", "getLength", "setLength", "clone", "hashCode", "equals", "", "other", "", "intsEquals", "compareTo", "toString", "", "isValid", "()Z", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIntsRef.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntsRef.kt\norg/gnit/lucenekmp/util/IntsRef\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class IntsRef
implements Comparable<IntsRef>,
Cloneable<IntsRef> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private int[] ints;
    private int offset;
    private int length;
    @NotNull
    private static final int[] EMPTY_INTS = new int[0];

    @NotNull
    public final int[] getInts() {
        return this.ints;
    }

    public final void setInts(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.ints = nArray;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public IntsRef() {
        this.ints = EMPTY_INTS;
    }

    public IntsRef(int capacity) {
        this.ints = new int[capacity];
    }

    public IntsRef(@NotNull int[] ints, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        this.ints = ints;
        this.offset = offset;
        this.length = length;
        if (!this.isValid()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public IntsRef clone() {
        return new IntsRef(this.ints, this.offset, this.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            result = prime * result + this.ints[i];
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof IntsRef) {
            return this.intsEquals((IntsRef)other);
        }
        return false;
    }

    public final boolean intsEquals(@NotNull IntsRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Arrays.INSTANCE.equals(this.ints, this.offset, this.offset + this.length, other.ints, other.offset, other.offset + other.length);
    }

    @Override
    public int compareTo(@NotNull IntsRef other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Arrays.INSTANCE.compare(this.ints, this.offset, this.offset + this.length, other.ints, other.offset, other.offset + other.length);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(HexExtensionsKt.toHexString$default((int)this.ints[i], null, (int)1, null));
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean isValid() {
        int[] nArray = this.ints;
        if (this.ints == null) {
            boolean $i$a$-checkNotNull-IntsRef$isValid$22 = false;
            String $i$a$-checkNotNull-IntsRef$isValid$22 = "ints is null";
            throw new IllegalStateException($i$a$-checkNotNull-IntsRef$isValid$22.toString());
        }
        if (!(this.length >= 0)) {
            boolean $i$a$-check-IntsRef$isValid$82 = false;
            String $i$a$-check-IntsRef$isValid$82 = "length is negative: " + this.length;
            throw new IllegalStateException($i$a$-check-IntsRef$isValid$82.toString());
        }
        if (!(this.length <= this.ints.length)) {
            boolean $i$a$-check-IntsRef$isValid$92 = false;
            String $i$a$-check-IntsRef$isValid$92 = "length is out of bounds: " + this.length + ",ints.length=" + this.ints.length;
            throw new IllegalStateException($i$a$-check-IntsRef$isValid$92.toString());
        }
        if (!(this.offset >= 0)) {
            boolean $i$a$-check-IntsRef$isValid$102 = false;
            String $i$a$-check-IntsRef$isValid$102 = "offset is negative: " + this.offset;
            throw new IllegalStateException($i$a$-check-IntsRef$isValid$102.toString());
        }
        if (!(this.offset <= this.ints.length)) {
            boolean $i$a$-check-IntsRef$isValid$112 = false;
            String $i$a$-check-IntsRef$isValid$112 = "offset out of bounds: " + this.offset + ",ints.length=" + this.ints.length;
            throw new IllegalStateException($i$a$-check-IntsRef$isValid$112.toString());
        }
        if (!(this.offset + this.length >= 0)) {
            boolean $i$a$-check-IntsRef$isValid$122 = false;
            String $i$a$-check-IntsRef$isValid$122 = "offset+length is negative: offset=" + this.offset + ",length=" + this.length;
            throw new IllegalStateException($i$a$-check-IntsRef$isValid$122.toString());
        }
        if (!(this.offset + this.length <= this.ints.length)) {
            boolean bl = false;
            String string = "offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",ints.length=" + this.ints.length;
            throw new IllegalStateException(string.toString());
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/IntsRef$Companion;", "", "<init>", "()V", "EMPTY_INTS", "", "getEMPTY_INTS", "()[I", "deepCopyOf", "Lorg/gnit/lucenekmp/util/IntsRef;", "other", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getEMPTY_INTS() {
            return EMPTY_INTS;
        }

        @NotNull
        public final IntsRef deepCopyOf(@NotNull IntsRef other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new IntsRef(ArrayUtil.Companion.copyOfSubArray(other.getInts(), other.getOffset(), other.getOffset() + other.getLength()), 0, other.getLength());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

