/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.UnicodeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tJ\u001e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u0005J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\"\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "", "<init>", "()V", "ref", "Lorg/gnit/lucenekmp/util/IntsRef;", "ints", "", "length", "", "setLength", "", "clear", "intAt", "offset", "setIntAt", "b", "append", "i", "grow", "newLength", "growNoCopy", "copyInts", "otherInts", "otherOffset", "otherLength", "copyUTF8Bytes", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "get", "toIntsRef", "equals", "", "obj", "hashCode", "core"})
@SourceDebugExtension(value={"SMAP\nIntsRefBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntsRefBuilder.kt\norg/gnit/lucenekmp/util/IntsRefBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class IntsRefBuilder {
    @NotNull
    private final IntsRef ref = new IntsRef();

    @NotNull
    public final int[] ints() {
        return this.ref.getInts();
    }

    public final int length() {
        return this.ref.getLength();
    }

    public final void setLength(int length) {
        this.ref.setLength(length);
    }

    public final void clear() {
        this.setLength(0);
    }

    public final int intAt(int offset) {
        return this.ref.getInts()[offset];
    }

    public final void setIntAt(int offset, int b) {
        this.ref.getInts()[offset] = b;
    }

    public final void append(int i) {
        this.grow(this.ref.getLength() + 1);
        int[] nArray = this.ref.getInts();
        IntsRef intsRef = this.ref;
        int n = intsRef.getLength();
        intsRef.setLength(n + 1);
        nArray[n] = i;
    }

    public final void grow(int newLength) {
        this.ref.setInts(ArrayUtil.Companion.grow(this.ref.getInts(), newLength));
    }

    public final void growNoCopy(int newLength) {
        this.ref.setInts(ArrayUtil.Companion.growNoCopy(this.ref.getInts(), newLength));
    }

    public final void copyInts(@NotNull int[] otherInts, int otherOffset, int otherLength) {
        Intrinsics.checkNotNullParameter((Object)otherInts, (String)"otherInts");
        this.growNoCopy(otherLength);
        ArraysKt.copyInto((int[])otherInts, (int[])this.ref.getInts(), (int)0, (int)otherOffset, (int)(otherOffset + otherLength));
        this.ref.setLength(otherLength);
    }

    public final void copyInts(@NotNull IntsRef ints) {
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        this.copyInts(ints.getInts(), ints.getOffset(), ints.getLength());
    }

    public final void copyUTF8Bytes(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.growNoCopy(bytes.getLength());
        this.ref.setLength(UnicodeUtil.INSTANCE.UTF8toUTF32(bytes, this.ref.getInts()));
    }

    @NotNull
    public final IntsRef get() {
        if (!(this.ref.getOffset() == 0)) {
            boolean bl = false;
            String string = "Modifying the offset of the returned ref is illegal";
            throw new IllegalArgumentException(string.toString());
        }
        return this.ref;
    }

    @NotNull
    public final IntsRef toIntsRef() {
        return IntsRef.Companion.deepCopyOf(this.get());
    }

    public boolean equals(@Nullable Object obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

