/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/LSBRadixSorter;", "", "<init>", "()V", "histogram", "", "buffer", "sort", "", "numBits", "", "array", "len", "Companion", "core"})
public final class LSBRadixSorter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] histogram = new int[256];
    @NotNull
    private int[] buffer = new int[0];
    private static final int INSERTION_SORT_THRESHOLD = 30;
    private static final int HISTOGRAM_SIZE = 256;

    public final void sort(int numBits, @NotNull int[] array, int len) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (len < 30) {
            LSBRadixSorter.Companion.insertionSort(array, 0, len);
            return;
        }
        this.buffer = ArrayUtil.Companion.growNoCopy(this.buffer, len);
        int[] arr = array;
        int[] buf = this.buffer;
        for (int shift = 0; shift < numBits; shift += 8) {
            if (!LSBRadixSorter.Companion.sort(arr, len, this.histogram, shift, buf)) continue;
            int[] tmp = arr;
            arr = buf;
            buf = tmp;
        }
        if (Intrinsics.areEqual((Object)array, (Object)buf)) {
            ArraysKt.copyInto((int[])arr, (int[])array, (int)0, (int)0, (int)len);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J0\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\nH\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/util/LSBRadixSorter$Companion;", "", "<init>", "()V", "INSERTION_SORT_THRESHOLD", "", "HISTOGRAM_SIZE", "buildHistogram", "", "array", "", "len", "histogram", "shift", "sumHistogram", "reorder", "dest", "sort", "", "insertionSort", "off", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void buildHistogram(int[] array, int len, int[] histogram, int shift) {
            for (int i = 0; i < len; ++i) {
                int b = array[i] >>> shift & 0xFF;
                histogram[b] = histogram[b] + 1;
            }
        }

        private final void sumHistogram(int[] histogram) {
            int accum = 0;
            for (int i = 0; i < 256; ++i) {
                int count = histogram[i];
                histogram[i] = accum;
                accum += count;
            }
        }

        private final void reorder(int[] array, int len, int[] histogram, int shift, int[] dest) {
            for (int i = 0; i < len; ++i) {
                int v = array[i];
                int b = v >>> shift & 0xFF;
                int n = histogram[b];
                histogram[b] = n + 1;
                dest[n] = v;
            }
        }

        private final boolean sort(int[] array, int len, int[] histogram, int shift, int[] dest) {
            ArraysKt.fill$default((int[])histogram, (int)0, (int)0, (int)0, (int)6, null);
            this.buildHistogram(array, len, histogram, shift);
            if (histogram[0] == len) {
                return false;
            }
            this.sumHistogram(histogram);
            this.reorder(array, len, histogram, shift, dest);
            return true;
        }

        private final void insertionSort(int[] array, int off, int len) {
            int end = off + len;
            block0: for (int i = off + 1; i < end; ++i) {
                int n = off + 1;
                int j = i;
                if (n > j) continue;
                while (array[j - 1] > array[j]) {
                    int tmp = array[j - 1];
                    array[j - 1] = array[j];
                    array[j] = tmp;
                    if (j == n) continue block0;
                    --j;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

