/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010!\u001a\u00020\u000fJ\u0016\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u0000J\u0013\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/util/LongBitSet;", "Lorg/gnit/lucenekmp/util/Accountable;", "numBits", "", "<init>", "(J)V", "storedBits", "", "([JJ)V", "bits", "getBits", "()[J", "numWords", "", "verifyGhostBitsClear", "", "length", "cardinality", "get", "index", "set", "", "getAndSet", "clear", "getAndClear", "nextSetBit", "prevSetBit", "or", "other", "xor", "intersects", "and", "andNot", "scanIsEmpty", "flip", "startIndex", "endIndex", "clone", "equals", "o", "", "hashCode", "ramBytesUsed", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLongBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongBitSet.kt\norg/gnit/lucenekmp/util/LongBitSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,450:1\n1#2:451\n*E\n"})
public final class LongBitSet
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] bits;
    private final long numBits;
    private final int numWords;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(LongBitSet.class));
    private static final long MAX_NUM_BITS = 64L * (long)ArrayUtil.Companion.getMAX_ARRAY_LENGTH();

    @NotNull
    public final long[] getBits() {
        return this.bits;
    }

    public LongBitSet(long numBits) {
        this.numBits = numBits;
        this.bits = new long[Companion.bits2words(numBits)];
        this.numWords = this.bits.length;
    }

    public LongBitSet(@NotNull long[] storedBits, long numBits) {
        Intrinsics.checkNotNullParameter((Object)storedBits, (String)"storedBits");
        this.numWords = Companion.bits2words(numBits);
        if (!(this.numWords <= storedBits.length)) {
            boolean bl = false;
            String string = "The given long array is too small  to hold " + numBits + " bits";
            throw new IllegalArgumentException(string.toString());
        }
        this.numBits = numBits;
        this.bits = storedBits;
        if (!this.verifyGhostBitsClear()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final boolean verifyGhostBitsClear() {
        int n = this.bits.length;
        for (int i = this.numWords; i < n; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        if ((this.numBits & 0x3FL) == 0L) {
            return true;
        }
        long mask = -1L << (int)this.numBits;
        return (this.bits[this.numWords - 1] & mask) == 0L;
    }

    public final long length() {
        return this.numBits;
    }

    public final long cardinality() {
        long tot = 0L;
        int n = this.numWords;
        for (int i = 0; i < n; ++i) {
            tot += (long)LongExtKt.bitCount(LongCompanionObject.INSTANCE, this.bits[i]);
        }
        return tot;
    }

    public final boolean get(long index) {
        if (!(index >= 0L && index < this.numBits)) {
            boolean $i$a$-require-LongBitSet$get$22 = false;
            String $i$a$-require-LongBitSet$get$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$get$22.toString());
        }
        int i = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        return (this.bits[i] & bitmask) != 0L;
    }

    public final void set(long index) {
        if (!(index >= 0L && index < this.numBits)) {
            boolean $i$a$-require-LongBitSet$set$22 = false;
            String $i$a$-require-LongBitSet$set$22 = "index=" + index + " numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$set$22.toString());
        }
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        this.bits[wordNum] = this.bits[wordNum] | bitmask;
    }

    public final boolean getAndSet(long index) {
        if (!(index >= 0L && index < this.numBits)) {
            boolean $i$a$-require-LongBitSet$getAndSet$22 = false;
            String $i$a$-require-LongBitSet$getAndSet$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$getAndSet$22.toString());
        }
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        this.bits[wordNum] = this.bits[wordNum] | bitmask;
        return val;
    }

    public final void clear(long index) {
        if (!(index >= 0L && index < this.numBits)) {
            boolean $i$a$-require-LongBitSet$clear$22 = false;
            String $i$a$-require-LongBitSet$clear$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$clear$22.toString());
        }
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        this.bits[wordNum] = this.bits[wordNum] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final boolean getAndClear(long index) {
        if (!(index >= 0L && index < this.numBits)) {
            boolean $i$a$-require-LongBitSet$getAndClear$22 = false;
            String $i$a$-require-LongBitSet$getAndClear$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$getAndClear$22.toString());
        }
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        this.bits[wordNum] = this.bits[wordNum] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    public final long nextSetBit(long index) {
        if (!(index >= 0L && index < this.numBits)) {
            boolean $i$a$-require-LongBitSet$nextSetBit$22 = false;
            String $i$a$-require-LongBitSet$nextSetBit$22 = "index=" + index + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$nextSetBit$22.toString());
        }
        int i = (int)(index >> 6);
        long word = this.bits[i] >> (int)index;
        if (word != 0L) {
            return index + (long)LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
        }
        while (++i < this.numWords) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
        }
        return -1L;
    }

    public final long prevSetBit(long index) {
        if (!(index >= 0L && index < this.numBits)) {
            boolean $i$a$-require-LongBitSet$prevSetBit$22 = false;
            String $i$a$-require-LongBitSet$prevSetBit$22 = "index=" + index + " numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$prevSetBit$22.toString());
        }
        int i = (int)(index >> 6);
        int subIndex = (int)(index & 0x3FL);
        long word = this.bits[i] << 63 - subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, word);
        }
        while (--i >= 0) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + 63 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, word);
        }
        return -1L;
    }

    public final void or(@NotNull LongBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other.numWords <= this.numWords)) {
            boolean bl = false;
            String string = "numWords=" + this.numWords + ", other.numWords=" + other.numWords;
            throw new IllegalArgumentException(string.toString());
        }
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            this.bits[pos] = this.bits[pos] | other.bits[pos];
        }
    }

    public final void xor(@NotNull LongBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other.numWords <= this.numWords)) {
            boolean bl = false;
            String string = "numWords=" + this.numWords + ", other.numWords=" + other.numWords;
            throw new IllegalArgumentException(string.toString());
        }
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            this.bits[pos] = this.bits[pos] ^ other.bits[pos];
        }
    }

    public final boolean intersects(@NotNull LongBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            if ((this.bits[pos] & other.bits[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public final void and(@NotNull LongBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            this.bits[pos] = this.bits[pos] & other.bits[pos];
        }
        if (this.numWords > other.numWords) {
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.bits, other.numWords, this.numWords, 0L);
        }
    }

    public final void andNot(@NotNull LongBitSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            this.bits[pos] = this.bits[pos] & (other.bits[pos] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public final boolean scanIsEmpty() {
        int count = this.numWords;
        for (int i = 0; i < count; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public final void flip(long startIndex, long endIndex) {
        if (!(startIndex >= 0L && startIndex < this.numBits)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(endIndex >= 0L && endIndex <= this.numBits)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> -((int)endIndex);
        if (startWord == endWord) {
            this.bits[startWord] = this.bits[startWord] ^ startmask & endmask;
            return;
        }
        this.bits[startWord] = this.bits[startWord] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.bits[endWord] = this.bits[endWord] ^ endmask;
    }

    public final void flip(long index) {
        if (!(index >= 0L && index < this.numBits)) {
            boolean $i$a$-require-LongBitSet$flip$22 = false;
            String $i$a$-require-LongBitSet$flip$22 = "index=" + index + " numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$flip$22.toString());
        }
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        this.bits[wordNum] = this.bits[wordNum] ^ bitmask;
    }

    public final void set(long startIndex, long endIndex) {
        if (!(startIndex >= 0L && startIndex < this.numBits)) {
            boolean $i$a$-require-LongBitSet$set$42 = false;
            String $i$a$-require-LongBitSet$set$42 = "startIndex=" + startIndex + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$set$42.toString());
        }
        if (!(endIndex >= 0L && endIndex <= this.numBits)) {
            boolean $i$a$-require-LongBitSet$set$52 = false;
            String $i$a$-require-LongBitSet$set$52 = "endIndex=" + endIndex + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$set$52.toString());
        }
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> -((int)endIndex);
        if (startWord == endWord) {
            this.bits[startWord] = this.bits[startWord] | startmask & endmask;
            return;
        }
        this.bits[startWord] = this.bits[startWord] | startmask;
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.bits, startWord + 1, endWord, -1L);
        this.bits[endWord] = this.bits[endWord] | endmask;
    }

    public final void clear(long startIndex, long endIndex) {
        if (!(startIndex >= 0L && startIndex < this.numBits)) {
            boolean $i$a$-require-LongBitSet$clear$42 = false;
            String $i$a$-require-LongBitSet$clear$42 = "startIndex=" + startIndex + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$clear$42.toString());
        }
        if (!(endIndex >= 0L && endIndex <= this.numBits)) {
            boolean $i$a$-require-LongBitSet$clear$52 = false;
            String $i$a$-require-LongBitSet$clear$52 = "endIndex=" + endIndex + ", numBits=" + this.numBits;
            throw new IllegalArgumentException($i$a$-require-LongBitSet$clear$52.toString());
        }
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> -((int)endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            this.bits[startWord] = this.bits[startWord] & (startmask | endmask);
            return;
        }
        this.bits[startWord] = this.bits[startWord] & startmask;
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.bits, startWord + 1, endWord, 0L);
        this.bits[endWord] = this.bits[endWord] & endmask;
    }

    @NotNull
    public final LongBitSet clone() {
        long[] bits = new long[this.bits.length];
        ArraysKt.copyInto((long[])this.bits, (long[])bits, (int)0, (int)0, (int)this.numWords);
        return new LongBitSet(bits, this.numBits);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongBitSet)) {
            return false;
        }
        Object other = o;
        if (this.numBits != ((LongBitSet)other).numBits) {
            return false;
        }
        return Arrays.equals(this.bits, ((LongBitSet)other).bits);
    }

    public int hashCode() {
        long h = 0L;
        int i = this.numWords;
        while (--i >= 0) {
            h ^= this.bits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.Companion.sizeOfObject(this.bits);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/util/LongBitSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "ensureCapacity", "Lorg/gnit/lucenekmp/util/LongBitSet;", "bits", "numBits", "MAX_NUM_BITS", "getMAX_NUM_BITS", "()J", "bits2words", "", "core"})
    @SourceDebugExtension(value={"SMAP\nLongBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongBitSet.kt\norg/gnit/lucenekmp/util/LongBitSet$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,450:1\n1#2:451\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongBitSet ensureCapacity(@NotNull LongBitSet bits, long numBits) {
            long[] arr;
            Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
            if (numBits < bits.numBits) {
                return bits;
            }
            int numWords = this.bits2words(numBits);
            if (numWords >= (arr = bits.getBits()).length) {
                arr = ArrayUtil.Companion.grow(arr, numWords + 1);
            }
            return new LongBitSet(arr, (long)arr.length << 6);
        }

        public final long getMAX_NUM_BITS() {
            return MAX_NUM_BITS;
        }

        public final int bits2words(long numBits) {
            if (!(numBits >= 0L && numBits <= this.getMAX_NUM_BITS())) {
                boolean bl = false;
                String string = "numBits must be 0 .. " + Companion.getMAX_NUM_BITS() + "; got: " + numBits;
                throw new IllegalArgumentException(string.toString());
            }
            return (int)(numBits - 1L >> 6) + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

