/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010)\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0002\u001e\u001fB#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\b\u00a2\u0006\u0004\b\t\u0010\nB)\b\u0016\u0012\u001e\u0010\u0007\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\b\"\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\t\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\u0016\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00110\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/util/MergedIterator;", "T", "", "", "", "removeDuplicates", "", "iterators", "", "<init>", "(Z[Ljava/util/Iterator;)V", "([Ljava/util/Iterator;)V", "current", "Ljava/lang/Comparable;", "queue", "Lorg/gnit/lucenekmp/util/MergedIterator$TermMergeQueue;", "top", "Lorg/gnit/lucenekmp/util/MergedIterator$SubIterator;", "[Lorg/gnit/lucenekmp/util/MergedIterator$SubIterator;", "numTop", "", "hasNext", "next", "()Ljava/lang/Comparable;", "remove", "", "pullTop", "pushTop", "iterator", "", "SubIterator", "TermMergeQueue", "core"})
public final class MergedIterator<T extends Comparable<? super T>>
implements Iterator<T>,
Iterable<T>,
KMutableIterator,
KMappedMarker {
    private final boolean removeDuplicates;
    @Nullable
    private T current;
    @NotNull
    private final TermMergeQueue<T> queue;
    @NotNull
    private final SubIterator<T>[] top;
    private int numTop;

    public MergedIterator(boolean removeDuplicates, @NotNull Iterator<T>[] iterators) {
        Intrinsics.checkNotNullParameter(iterators, (String)"iterators");
        this.removeDuplicates = removeDuplicates;
        this.queue = new TermMergeQueue(iterators.length);
        this.top = new SubIterator[iterators.length];
        int index = 0;
        for (Iterator<T> iterator2 : iterators) {
            if (!iterator2.hasNext()) continue;
            SubIterator sub = new SubIterator();
            sub.setCurrent((Comparable)iterator2.next());
            sub.setIterator(iterator2);
            sub.setIndex(index++);
            this.queue.add(sub);
        }
    }

    public MergedIterator(Iterator<? extends T> ... iterators) {
        Intrinsics.checkNotNullParameter(iterators, (String)"iterators");
        this(true, iterators);
    }

    @Override
    public boolean hasNext() {
        if (this.queue.size() > 0) {
            return true;
        }
        int n = this.numTop;
        for (int i = 0; i < n; ++i) {
            SubIterator<T> subIterator = this.top[i];
            Intrinsics.checkNotNull(subIterator);
            Iterator<T> iterator2 = subIterator.getIterator();
            Intrinsics.checkNotNull(iterator2);
            if (!iterator2.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public T next() {
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        T t = this.current;
        Intrinsics.checkNotNull(t);
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private final void pullTop() {
        if (!(this.numTop == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.numTop;
        this.numTop = n + 1;
        Intrinsics.checkNotNull(this.queue.pop());
        if (this.removeDuplicates) {
            while (this.queue.size() != 0) {
                Object t = this.queue.top();
                Intrinsics.checkNotNull(t);
                Object i = ((SubIterator)t).getCurrent();
                Intrinsics.checkNotNull(i);
                SubIterator<T> subIterator = this.top[0];
                Intrinsics.checkNotNull(subIterator);
                if (!i.equals(subIterator.getCurrent())) break;
                n = this.numTop;
                this.numTop = n + 1;
                Intrinsics.checkNotNull(this.queue.pop());
            }
        }
        SubIterator<T> subIterator = this.top[0];
        Intrinsics.checkNotNull(subIterator);
        this.current = subIterator.getCurrent();
    }

    private final void pushTop() {
        int n = this.numTop;
        for (int i = 0; i < n; ++i) {
            SubIterator<T> subIterator = this.top[i];
            Intrinsics.checkNotNull(subIterator);
            Iterator<T> iterator2 = subIterator.getIterator();
            Intrinsics.checkNotNull(iterator2);
            if (iterator2.hasNext()) {
                SubIterator<T> subIterator2 = this.top[i];
                Intrinsics.checkNotNull(subIterator2);
                SubIterator<T> subIterator3 = this.top[i];
                Intrinsics.checkNotNull(subIterator3);
                Iterator<T> iterator3 = subIterator3.getIterator();
                Intrinsics.checkNotNull(iterator3);
                subIterator2.setCurrent((Comparable)iterator3.next());
                SubIterator<T> subIterator4 = this.top[i];
                Intrinsics.checkNotNull(subIterator4);
                this.queue.add(subIterator4);
                continue;
            }
            SubIterator<T> subIterator5 = this.top[i];
            Intrinsics.checkNotNull(subIterator5);
            subIterator5.setCurrent(null);
        }
        this.numTop = 0;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005R$\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/util/MergedIterator$SubIterator;", "I", "", "", "<init>", "()V", "iterator", "", "getIterator", "()Ljava/util/Iterator;", "setIterator", "(Ljava/util/Iterator;)V", "current", "getCurrent", "()Ljava/lang/Comparable;", "setCurrent", "(Ljava/lang/Comparable;)V", "Ljava/lang/Comparable;", "index", "", "getIndex", "()I", "setIndex", "(I)V", "core"})
    private static final class SubIterator<I extends Comparable<? super I>> {
        @Nullable
        private Iterator<? extends I> iterator;
        @Nullable
        private I current;
        private int index;

        @Nullable
        public final Iterator<I> getIterator() {
            return this.iterator;
        }

        public final void setIterator(@Nullable Iterator<? extends I> iterator2) {
            this.iterator = iterator2;
        }

        @Nullable
        public final I getCurrent() {
            return this.current;
        }

        public final void setCurrent(@Nullable I i) {
            this.current = i;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ$\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/MergedIterator$TermMergeQueue;", "C", "", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/util/MergedIterator$SubIterator;", "size", "", "<init>", "(I)V", "lessThan", "", "a", "b", "core"})
    private static final class TermMergeQueue<C extends Comparable<? super C>>
    extends PriorityQueue<SubIterator<C>> {
        public TermMergeQueue(int size2) {
            super(size2, null, 2, null);
        }

        @Override
        public boolean lessThan(@NotNull SubIterator<C> a, @NotNull SubIterator<C> b) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(b, (String)"b");
            C c = a.getCurrent();
            Intrinsics.checkNotNull(c);
            C c2 = b.getCurrent();
            Intrinsics.checkNotNull(c2);
            int cmp = c.compareTo(c2);
            if (cmp != 0) {
                return cmp < 0;
            }
            return a.getIndex() < b.getIndex();
        }
    }
}

