/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u0004./01B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eJ\b\u0010$\u001a\u00020\u0013H\u0016J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0015\u0010&\u001a\u00060'R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0015\u0010*\u001a\u00060+R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/util/PagedBytes;", "Lorg/gnit/lucenekmp/util/Accountable;", "blockBits", "", "<init>", "(I)V", "blocks", "", "", "[[B", "numBlocks", "blockSize", "blockMask", "didSkipBytes", "", "frozen", "upto", "currentBlock", "bytesUsedPerBlock", "", "addBlock", "", "block", "copy", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "byteCount", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "out", "freeze", "Lorg/gnit/lucenekmp/util/PagedBytes$Reader;", "trim", "pointer", "getPointer", "()J", "ramBytesUsed", "copyUsingLengthPrefix", "dataInput", "Lorg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataInput;", "getDataInput", "()Lorg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataInput;", "dataOutput", "Lorg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataOutput;", "getDataOutput", "()Lorg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataOutput;", "Reader", "PagedBytesDataInput", "PagedBytesDataOutput", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPagedBytes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagedBytes.kt\norg/gnit/lucenekmp/util/PagedBytes\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,421:1\n8#2,2:422\n3#2,8:435\n207#3,5:424\n180#3,5:429\n212#3:434\n10#4:443\n1#5:444\n*S KotlinDebug\n*F\n+ 1 PagedBytes.kt\norg/gnit/lucenekmp/util/PagedBytes\n*L\n137#1:422,2\n192#1:435,8\n148#1:424,5\n148#1:429,5\n148#1:434\n192#1:443\n*E\n"})
public final class PagedBytes
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[][] blocks;
    private int numBlocks;
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private boolean didSkipBytes;
    private boolean frozen;
    private int upto;
    @Nullable
    private byte[] currentBlock;
    private final long bytesUsedPerBlock;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(PagedBytes.class));
    @NotNull
    private static final byte[] EMPTY_BYTES = new byte[0];

    public PagedBytes(int blockBits) {
        int n = 0;
        byte[][] byArrayArray = new byte[16][];
        PagedBytes pagedBytes = this;
        while (n < 16) {
            int n2 = n++;
            byArrayArray[n2] = EMPTY_BYTES;
        }
        pagedBytes.blocks = byArrayArray;
        boolean condition$iv = blockBits > 0 && blockBits <= 31;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            Integer n3 = blockBits;
            throw new AssertionError(n3);
        }
        this.blockSize = 1 << blockBits;
        this.blockBits = blockBits;
        this.blockMask = this.blockSize - 1;
        this.upto = this.blockSize;
        this.bytesUsedPerBlock = RamUsageEstimator.Companion.alignObjectSize(this.blockSize + 8);
        this.numBlocks = 0;
    }

    /*
     * WARNING - void declaration
     */
    private final void addBlock(byte[] block2) {
        Object object;
        void array$iv;
        void minSize$iv;
        ArrayUtil.Companion companion = ArrayUtil.Companion;
        Object[] objectArray = (Object[])this.blocks;
        int n = this.numBlocks + 1;
        PagedBytes pagedBytes = this;
        boolean $i$f$grow = false;
        if (minSize$iv < 0) {
            throw new Exception("size must be positive (got " + (int)minSize$iv + "): likely integer overflow?");
        }
        if (((void)array$iv).length < minSize$iv) {
            void array$iv$iv;
            void this_$iv;
            int newLength$iv = this_$iv.oversize((int)minSize$iv, 4);
            void var7_9 = this_$iv;
            void var8_10 = array$iv;
            int newLength$iv$iv = newLength$iv;
            boolean $i$f$growExact = false;
            if (newLength$iv$iv < ((void)array$iv$iv).length) {
                throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
            }
            byte[][] byArrayArray = new byte[newLength$iv$iv][];
            for (int i = 0; i < newLength$iv$iv; ++i) {
                int n2 = i;
                byArrayArray[n2] = n2 < ((void)array$iv$iv).length ? array$iv$iv[n2] : null;
            }
            byte[][] newArray$iv$iv = byArrayArray;
            object = newArray$iv$iv;
        } else {
            object = objectArray;
        }
        pagedBytes.blocks = (byte[][])object;
        int n3 = this.numBlocks;
        this.numBlocks = n3 + 1;
        this.blocks[n3] = block2;
    }

    public final void copy(@NotNull IndexInput in, long byteCount) throws IOException {
        int left;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        for (long byteCount2 = byteCount; byteCount2 > 0L; byteCount2 -= (long)left) {
            left = this.blockSize - this.upto;
            if (left == 0) {
                if (this.currentBlock != null) {
                    Intrinsics.checkNotNull((Object)this.currentBlock);
                    this.addBlock(this.currentBlock);
                }
                this.currentBlock = new byte[this.blockSize];
                this.upto = 0;
                left = this.blockSize;
            }
            if ((long)left < byteCount2) {
                Intrinsics.checkNotNull((Object)this.currentBlock);
                in.readBytes(this.currentBlock, this.upto, left, false);
                this.upto = this.blockSize;
                continue;
            }
            Intrinsics.checkNotNull((Object)this.currentBlock);
            in.readBytes(this.currentBlock, this.upto, (int)byteCount2, false);
            this.upto += (int)byteCount2;
            break;
        }
    }

    public final void copy(@NotNull BytesRef bytes, @NotNull BytesRef out) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int left = this.blockSize - this.upto;
        if (bytes.getLength() > left || this.currentBlock == null) {
            if (this.currentBlock != null) {
                Intrinsics.checkNotNull((Object)this.currentBlock);
                this.addBlock(this.currentBlock);
                this.didSkipBytes = true;
            }
            this.currentBlock = new byte[this.blockSize];
            this.upto = 0;
            left = this.blockSize;
            boolean condition$iv = bytes.getLength() <= this.blockSize;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        Intrinsics.checkNotNull((Object)this.currentBlock);
        out.setBytes(this.currentBlock);
        out.setOffset(this.upto);
        out.setLength(bytes.getLength());
        byte[] byArray = bytes.getBytes();
        int n = bytes.getOffset();
        Intrinsics.checkNotNull((Object)this.currentBlock);
        System.INSTANCE.arraycopy(byArray, n, this.currentBlock, this.upto, bytes.getLength());
        this.upto += bytes.getLength();
    }

    @NotNull
    public final Reader freeze(boolean trim) {
        if (!(!this.frozen)) {
            boolean $i$a$-check-PagedBytes$freeze$32 = false;
            String $i$a$-check-PagedBytes$freeze$32 = "already frozen";
            throw new IllegalStateException($i$a$-check-PagedBytes$freeze$32.toString());
        }
        if (!(!this.didSkipBytes)) {
            boolean bl = false;
            String string = "cannot freeze when copy(BytesRef, BytesRef) was used";
            throw new IllegalStateException(string.toString());
        }
        if (trim && this.upto < this.blockSize) {
            byte[] newBlock = new byte[this.upto];
            Intrinsics.checkNotNull((Object)this.currentBlock);
            System.INSTANCE.arraycopy(this.currentBlock, 0, newBlock, 0, this.upto);
            this.currentBlock = newBlock;
        }
        if (this.currentBlock == null) {
            this.currentBlock = EMPTY_BYTES;
        }
        Intrinsics.checkNotNull((Object)this.currentBlock);
        this.addBlock(this.currentBlock);
        this.frozen = true;
        this.currentBlock = null;
        return new Reader(this);
    }

    public final long getPointer() {
        return this.currentBlock == null ? 0L : (long)this.numBlocks * (long)this.blockSize + (long)this.upto;
    }

    @Override
    public long ramBytesUsed() {
        long size2 = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.shallowSizeOf(this.blocks);
        if (this.numBlocks > 0) {
            size2 += (long)(this.numBlocks - 1) * this.bytesUsedPerBlock;
            size2 += RamUsageEstimator.Companion.sizeOf(this.blocks[this.numBlocks - 1]);
        }
        if (this.currentBlock != null) {
            Intrinsics.checkNotNull((Object)this.currentBlock);
            size2 += RamUsageEstimator.Companion.sizeOf(this.currentBlock);
        }
        return size2;
    }

    public final long copyUsingLengthPrefix(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (!(bytes.getLength() < 32768)) {
            boolean $i$a$-require-PagedBytes$copyUsingLengthPrefix$32 = false;
            String $i$a$-require-PagedBytes$copyUsingLengthPrefix$32 = "max length is 32767 (got " + bytes.getLength() + ")";
            throw new IllegalArgumentException($i$a$-require-PagedBytes$copyUsingLengthPrefix$32.toString());
        }
        if (this.upto + bytes.getLength() + 2 > this.blockSize) {
            if (!(bytes.getLength() + 2 <= this.blockSize)) {
                boolean bl = false;
                String string = "block size " + this.blockSize + " is too small to store length " + bytes.getLength() + " bytes";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.currentBlock != null) {
                Intrinsics.checkNotNull((Object)this.currentBlock);
                this.addBlock(this.currentBlock);
            }
            this.currentBlock = new byte[this.blockSize];
            this.upto = 0;
        }
        long pointer = this.getPointer();
        if (bytes.getLength() < 128) {
            Intrinsics.checkNotNull((Object)this.currentBlock);
            int n = this.upto;
            this.upto = n + 1;
            this.currentBlock[n] = (byte)bytes.getLength();
        } else {
            Intrinsics.checkNotNull((Object)this.currentBlock);
            BitUtil.VH_BE_SHORT.INSTANCE.set(this.currentBlock, this.upto, (short)(bytes.getLength() | 0x8000));
            this.upto += 2;
        }
        byte[] byArray = bytes.getBytes();
        int n = bytes.getOffset();
        Intrinsics.checkNotNull((Object)this.currentBlock);
        System.INSTANCE.arraycopy(byArray, n, this.currentBlock, this.upto, bytes.getLength());
        this.upto += bytes.getLength();
        return pointer;
    }

    @NotNull
    public final PagedBytesDataInput getDataInput() {
        if (!this.frozen) {
            boolean bl = false;
            String string = "must call freeze() before getDataInput";
            throw new IllegalStateException(string.toString());
        }
        return new PagedBytesDataInput();
    }

    @NotNull
    public final PagedBytesDataOutput getDataOutput() {
        if (!(!this.frozen)) {
            boolean bl = false;
            String string = "cannot get DataOutput after freeze()";
            throw new IllegalStateException(string.toString());
        }
        return new PagedBytesDataOutput();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/PagedBytes$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "EMPTY_BYTES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\u00060\u0000R\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataInput;", "Lorg/gnit/lucenekmp/store/DataInput;", "<init>", "(Lorg/gnit/lucenekmp/util/PagedBytes;)V", "currentBlockIndex", "", "currentBlockUpto", "currentBlock", "", "clone", "Lorg/gnit/lucenekmp/util/PagedBytes;", "pos", "", "position", "getPosition", "()J", "setPosition", "(J)V", "readByte", "", "readBytes", "", "b", "offset", "len", "skipBytes", "numBytes", "nextBlock", "core"})
    @SourceDebugExtension(value={"SMAP\nPagedBytes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagedBytes.kt\norg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataInput\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,421:1\n3#2,8:422\n10#3:430\n1#4:431\n*S KotlinDebug\n*F\n+ 1 PagedBytes.kt\norg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataInput\n*L\n309#1:422,8\n309#1:430\n*E\n"})
    public final class PagedBytesDataInput
    extends DataInput {
        private int currentBlockIndex;
        private int currentBlockUpto;
        @NotNull
        private byte[] currentBlock;

        public PagedBytesDataInput() {
            this.currentBlock = PagedBytes.this.blocks[0];
        }

        @Override
        @NotNull
        public PagedBytesDataInput clone() {
            PagedBytesDataInput clone = PagedBytes.this.getDataInput();
            clone.setPosition(this.getPosition());
            return clone;
        }

        public final long getPosition() {
            return (long)this.currentBlockIndex * (long)PagedBytes.this.blockSize + (long)this.currentBlockUpto;
        }

        public final void setPosition(long pos) {
            this.currentBlockIndex = (int)(pos >> PagedBytes.this.blockBits);
            this.currentBlock = PagedBytes.this.blocks[this.currentBlockIndex];
            this.currentBlockUpto = (int)(pos & (long)PagedBytes.this.blockMask);
        }

        @Override
        public byte readByte() {
            if (this.currentBlockUpto == PagedBytes.this.blockSize) {
                this.nextBlock();
            }
            int n = this.currentBlockUpto;
            this.currentBlockUpto = n + 1;
            return this.currentBlock[n];
        }

        @Override
        public void readBytes(@NotNull byte[] b, int offset, int len) {
            int left;
            int blockLeft;
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int offset2 = offset;
            boolean condition$iv = b.length >= offset2 + len;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            int offsetEnd = offset2 + len;
            while ((blockLeft = PagedBytes.this.blockSize - this.currentBlockUpto) < (left = offsetEnd - offset2)) {
                System.INSTANCE.arraycopy(this.currentBlock, this.currentBlockUpto, b, offset2, blockLeft);
                this.nextBlock();
                offset2 += blockLeft;
            }
            System.INSTANCE.arraycopy(this.currentBlock, this.currentBlockUpto, b, offset2, left);
            this.currentBlockUpto += left;
        }

        @Override
        public void skipBytes(long numBytes) {
            if (!(numBytes >= 0L)) {
                boolean bl = false;
                String string = "numBytes must be >= 0, got " + numBytes;
                throw new IllegalArgumentException(string.toString());
            }
            long skipTo = this.getPosition() + numBytes;
            this.setPosition(skipTo);
        }

        private final void nextBlock() {
            int n = this.currentBlockIndex;
            this.currentBlockIndex = n + 1;
            this.currentBlockUpto = 0;
            this.currentBlock = PagedBytes.this.blocks[this.currentBlockIndex];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataOutput;", "Lorg/gnit/lucenekmp/store/DataOutput;", "<init>", "(Lorg/gnit/lucenekmp/util/PagedBytes;)V", "writeByte", "", "b", "", "writeBytes", "", "offset", "", "length", "position", "", "getPosition", "()J", "core"})
    @SourceDebugExtension(value={"SMAP\nPagedBytes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagedBytes.kt\norg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataOutput\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n*L\n1#1,421:1\n8#2,2:422\n*S KotlinDebug\n*F\n+ 1 PagedBytes.kt\norg/gnit/lucenekmp/util/PagedBytes$PagedBytesDataOutput\n*L\n359#1:422,2\n*E\n"})
    public final class PagedBytesDataOutput
    extends DataOutput {
        @Override
        public void writeByte(byte b) {
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    byte[] byArray = PagedBytes.this.currentBlock;
                    Intrinsics.checkNotNull((Object)byArray);
                    PagedBytes.this.addBlock(byArray);
                }
                PagedBytes.this.currentBlock = new byte[PagedBytes.this.blockSize];
                PagedBytes.this.upto = 0;
            }
            byte[] byArray = PagedBytes.this.currentBlock;
            Intrinsics.checkNotNull((Object)byArray);
            int n = PagedBytes.this.upto;
            PagedBytes.this.upto = n + 1;
            byArray[n] = b;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeBytes(@NotNull byte[] b, int offset, int length) {
            int left;
            void condition$iv;
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int offset2 = 0;
            offset2 = offset;
            boolean bl = b.length >= offset2 + length;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && condition$iv == false) {
                boolean bl2 = false;
                String string = "b.length=" + b.length + " offset=" + offset2 + " length=" + length;
                throw new AssertionError((Object)string);
            }
            if (length == 0) {
                return;
            }
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    byte[] byArray = PagedBytes.this.currentBlock;
                    Intrinsics.checkNotNull((Object)byArray);
                    PagedBytes.this.addBlock(byArray);
                }
                PagedBytes.this.currentBlock = new byte[PagedBytes.this.blockSize];
                PagedBytes.this.upto = 0;
            }
            int offsetEnd = offset2 + length;
            while (true) {
                left = offsetEnd - offset2;
                int blockLeft = PagedBytes.this.blockSize - PagedBytes.this.upto;
                if (blockLeft >= left) break;
                byte[] byArray = PagedBytes.this.currentBlock;
                Intrinsics.checkNotNull((Object)byArray);
                System.INSTANCE.arraycopy(b, offset2, byArray, PagedBytes.this.upto, blockLeft);
                byte[] byArray2 = PagedBytes.this.currentBlock;
                Intrinsics.checkNotNull((Object)byArray2);
                PagedBytes.this.addBlock(byArray2);
                PagedBytes.this.currentBlock = new byte[PagedBytes.this.blockSize];
                PagedBytes.this.upto = 0;
                offset2 += blockLeft;
            }
            byte[] byArray = PagedBytes.this.currentBlock;
            Intrinsics.checkNotNull((Object)byArray);
            System.INSTANCE.arraycopy(b, offset2, byArray, PagedBytes.this.upto, left);
            PagedBytes.this.upto = PagedBytes.this.upto + left;
        }

        public final long getPosition() {
            return PagedBytes.this.getPointer();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fJ\u0016\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/util/PagedBytes$Reader;", "Lorg/gnit/lucenekmp/util/Accountable;", "pagedBytes", "Lorg/gnit/lucenekmp/util/PagedBytes;", "<init>", "(Lorg/gnit/lucenekmp/util/PagedBytes;)V", "blocks", "", "", "[[B", "blockBits", "", "blockMask", "blockSize", "bytesUsedPerBlock", "", "fillSlice", "", "b", "Lorg/gnit/lucenekmp/util/BytesRef;", "start", "length", "getByte", "", "o", "fill", "ramBytesUsed", "toString", "", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nPagedBytes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagedBytes.kt\norg/gnit/lucenekmp/util/PagedBytes$Reader\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,421:1\n759#2,2:422\n8#3,2:424\n8#3,2:426\n3#3,8:428\n10#4:436\n*S KotlinDebug\n*F\n+ 1 PagedBytes.kt\norg/gnit/lucenekmp/util/PagedBytes$Reader\n*L\n39#1:422,2\n56#1:424,2\n57#1:426,2\n111#1:428,8\n111#1:436\n*E\n"})
    public static final class Reader
    implements Accountable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[][] blocks;
        private final int blockBits;
        private final int blockMask;
        private final int blockSize;
        private final long bytesUsedPerBlock;
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(Reader.class));

        /*
         * WARNING - void declaration
         */
        public Reader(@NotNull PagedBytes pagedBytes) {
            void from$iv;
            void to$iv;
            Intrinsics.checkNotNullParameter((Object)pagedBytes, (String)"pagedBytes");
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            Object[] objectArray = (Object[])pagedBytes.blocks;
            boolean bl = false;
            int n = pagedBytes.numBlocks;
            Reader reader2 = this;
            boolean $i$f$copyOfSubArray = false;
            void subLength$iv = to$iv - from$iv;
            int n2 = 0;
            byte[][] byArrayArray = new byte[subLength$iv][];
            while (n2 < subLength$iv) {
                void array$iv;
                int n3 = n2++;
                byArrayArray[n3] = array$iv[from$iv + n3];
            }
            reader2.blocks = byArrayArray;
            this.blockBits = pagedBytes.blockBits;
            this.blockMask = pagedBytes.blockMask;
            this.blockSize = pagedBytes.blockSize;
            this.bytesUsedPerBlock = pagedBytes.bytesUsedPerBlock;
        }

        public final void fillSlice(@NotNull BytesRef b, long start, int length) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            boolean condition$iv = length >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "length=" + length;
                throw new AssertionError((Object)string);
            }
            condition$iv = length <= this.blockSize + 1;
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "length=" + length;
                throw new AssertionError((Object)string);
            }
            b.setLength(length);
            if (length == 0) {
                return;
            }
            int index = (int)(start >> this.blockBits);
            int offset = (int)(start & (long)this.blockMask);
            if (this.blockSize - offset >= length) {
                b.setBytes(this.blocks[index]);
                b.setOffset(offset);
            } else {
                b.setBytes(new byte[length]);
                b.setOffset(0);
                System.INSTANCE.arraycopy(this.blocks[index], offset, b.getBytes(), 0, this.blockSize - offset);
                System.INSTANCE.arraycopy(this.blocks[1 + index], 0, b.getBytes(), this.blockSize - offset, length - (this.blockSize - offset));
            }
        }

        public final byte getByte(long o) {
            int index = (int)(o >> this.blockBits);
            int offset = (int)(o & (long)this.blockMask);
            return this.blocks[index][offset];
        }

        public final void fill(@NotNull BytesRef b, long start) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int index = (int)(start >> this.blockBits);
            int offset = (int)(start & (long)this.blockMask);
            b.setBytes(this.blocks[index]);
            byte[] block2 = b.getBytes();
            if ((block2[offset] & 0x80) == 0) {
                b.setLength(block2[offset]);
                b.setOffset(offset + 1);
            } else {
                b.setLength(BitUtil.VH_BE_SHORT.INSTANCE.get(block2, offset) & Short.MAX_VALUE);
                b.setOffset(offset + 2);
                boolean condition$iv = b.getLength() > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        }

        @Override
        public long ramBytesUsed() {
            long size2 = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.shallowSizeOf(this.blocks);
            if (!(((Object[])this.blocks).length == 0)) {
                size2 += (long)(((Object[])this.blocks).length - 1) * this.bytesUsedPerBlock;
                size2 += RamUsageEstimator.Companion.sizeOf(this.blocks[((Object[])this.blocks).length - 1]);
            }
            return size2;
        }

        @NotNull
        public String toString() {
            return "PagedBytes(blocksize=" + this.blockSize + ")";
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/PagedBytes$Reader$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

