/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010(\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001bJ\u000b\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020\u000eJ\u0013\u0010 \u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0004H\u0002J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0096\u0002R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001c\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/util/PriorityQueue;", "T", "", "maxSize", "", "sentinelObjectSupplier", "Lkotlin/Function0;", "<init>", "(ILkotlin/jvm/functions/Function0;)V", "size", "heap", "", "[Ljava/lang/Object;", "addAll", "", "elements", "", "lessThan", "", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "add", "element", "(Ljava/lang/Object;)Ljava/lang/Object;", "insertWithOverflow", "top", "()Ljava/lang/Object;", "pop", "updateTop", "newTop", "clear", "remove", "(Ljava/lang/Object;)Z", "upHeap", "origPos", "downHeap", "i", "heapArray", "getHeapArray", "()[Ljava/lang/Object;", "iterator", "", "core"})
@SourceDebugExtension(value={"SMAP\nPriorityQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PriorityQueue.kt\norg/gnit/lucenekmp/util/PriorityQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
public abstract class PriorityQueue<T>
implements Iterable<T>,
KMappedMarker {
    private int size;
    private final int maxSize;
    @NotNull
    private final T[] heap;

    @JvmOverloads
    public PriorityQueue(int maxSize, @NotNull Function0<? extends T> sentinelObjectSupplier) {
        Intrinsics.checkNotNullParameter(sentinelObjectSupplier, (String)"sentinelObjectSupplier");
        int heapSize = 0;
        if (maxSize == 0) {
            heapSize = 2;
        } else {
            if (!(maxSize >= 0 && maxSize < ArrayUtil.Companion.getMAX_ARRAY_LENGTH())) {
                boolean $i$a$-require-PriorityQueue$32 = false;
                String $i$a$-require-PriorityQueue$32 = "maxSize must be >= 0 and < " + ArrayUtil.Companion.getMAX_ARRAY_LENGTH() + "; got: " + maxSize;
                throw new IllegalArgumentException($i$a$-require-PriorityQueue$32.toString());
            }
            heapSize = maxSize + 1;
        }
        Object[] h = new Object[heapSize];
        this.heap = h;
        this.maxSize = maxSize;
        Object sentinel = sentinelObjectSupplier.invoke();
        if (sentinel != null) {
            this.heap[1] = sentinel;
            int n = this.heap.length;
            for (int i = 2; i < n; ++i) {
                Intrinsics.checkNotNull((Object)sentinelObjectSupplier.invoke());
            }
            this.size = maxSize;
        }
    }

    public /* synthetic */ PriorityQueue(int n, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(n, function0);
    }

    public final void addAll(@NotNull Collection<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (this.size + elements.size() > this.maxSize) {
            throw new ArrayIndexOutOfBoundsException("Cannot add " + elements.size() + " elements to a queue with remaining capacity: " + (this.maxSize - this.size));
        }
        Iterator<T> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            this.heap[this.size + 1] = iterator2.next();
            int n = this.size;
            this.size = n + 1;
        }
        for (int i = this.size >>> 1; 0 < i; --i) {
            this.downHeap(i);
        }
    }

    public abstract boolean lessThan(T var1, T var2);

    @Nullable
    public final T add(T element) {
        int index = this.size + 1;
        this.heap[index] = element;
        this.size = index;
        this.upHeap(index);
        return this.heap[1];
    }

    @Nullable
    public final T insertWithOverflow(T element) {
        if (this.size < this.maxSize) {
            this.add(element);
            return null;
        }
        if (this.size > 0) {
            T t = this.heap[1];
            Intrinsics.checkNotNull(t);
            if (this.lessThan(t, element)) {
                T ret = this.heap[1];
                this.heap[1] = element;
                this.updateTop();
                return ret;
            }
        }
        return element;
    }

    public final T top() {
        T t = this.heap[1];
        Intrinsics.checkNotNull(t);
        return t;
    }

    @Nullable
    public final T pop() {
        if (this.size > 0) {
            T result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            int n = this.size;
            this.size = n + -1;
            this.downHeap(1);
            return result;
        }
        return null;
    }

    public final T updateTop() {
        this.downHeap(1);
        T t = this.heap[1];
        Intrinsics.checkNotNull(t);
        return t;
    }

    public final T updateTop(T newTop) {
        this.heap[1] = newTop;
        return this.updateTop();
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        int i = 0;
        int n = this.size;
        if (i <= n) {
            while (true) {
                this.heap[i] = null;
                if (i == n) break;
                ++i;
            }
        }
        this.size = 0;
    }

    public final boolean remove(T element) {
        int i = 1;
        int n = this.size;
        if (i <= n) {
            while (true) {
                if (Intrinsics.areEqual(this.heap[i], element)) {
                    this.heap[i] = this.heap[this.size];
                    this.heap[this.size] = null;
                    int n2 = this.size;
                    this.size = n2 + -1;
                    if (i <= this.size && !this.upHeap(i)) {
                        this.downHeap(i);
                    }
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    private final boolean upHeap(int origPos) {
        int i = origPos;
        T t = this.heap[i];
        Intrinsics.checkNotNull(t);
        T node = t;
        for (int j = i >>> 1; j > 0; j >>>= 1) {
            T t2 = this.heap[j];
            Intrinsics.checkNotNull(t2);
            if (!this.lessThan(node, t2)) break;
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
        return i != origPos;
    }

    private final void downHeap(int i) {
        int i2 = i;
        T t = this.heap[i2];
        if (t == null) {
            return;
        }
        T node = t;
        int j = i2 << 1;
        int k = j + 1;
        if (k <= this.size) {
            T t2 = this.heap[k];
            Intrinsics.checkNotNull(t2);
            T t3 = this.heap[j];
            Intrinsics.checkNotNull(t3);
            if (this.lessThan(t2, t3)) {
                j = k;
            }
        }
        while (j <= this.size) {
            T t4 = this.heap[j];
            Intrinsics.checkNotNull(t4);
            if (!this.lessThan(t4, node)) break;
            this.heap[i2] = this.heap[j];
            i2 = j;
            k = (j = i2 << 1) + 1;
            if (k > this.size) continue;
            T t5 = this.heap[k];
            Intrinsics.checkNotNull(t5);
            T t6 = this.heap[j];
            Intrinsics.checkNotNull(t6);
            if (!this.lessThan(t5, t6)) continue;
            j = k;
        }
        this.heap[i2] = node;
    }

    @NotNull
    protected final T[] getHeapArray() {
        return this.heap;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int i;
            final /* synthetic */ PriorityQueue<T> this$0;
            {
                this.this$0 = $receiver;
                this.i = 1;
            }

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i <= PriorityQueue.access$getSize$p(this.this$0);
            }

            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int n = this.i;
                this.i = n + 1;
                Object object = PriorityQueue.access$getHeap$p(this.this$0)[n];
                Intrinsics.checkNotNull((Object)object);
                return (T)object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @JvmOverloads
    public PriorityQueue(int maxSize) {
        this(maxSize, null, 2, null);
    }

    public static final /* synthetic */ int access$getSize$p(PriorityQueue $this) {
        return $this.size;
    }

    public static final /* synthetic */ Object[] access$getHeap$p(PriorityQueue $this) {
        return $this.heap;
    }
}

