/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.IntroSelector;
import org.gnit.lucenekmp.util.Selector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H$J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u0003H\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J0\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0017\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J(\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J0\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J8\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J(\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J8\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/util/RadixSelector;", "Lorg/gnit/lucenekmp/util/Selector;", "maxLength", "", "<init>", "(I)V", "histogram", "", "commonPrefix", "byteAt", "i", "k", "getFallbackSelector", "d", "select", "", "from", "to", "l", "radixSelect", "assertHistogram", "", "commonPrefixLength", "getBucket", "computeCommonPrefixLengthAndBuildHistogram", "computeInitialCommonPrefixLength", "computeCommonPrefixLengthAndBuildHistogramPart1", "computeCommonPrefixLengthAndBuildHistogramPart2", "buildHistogram", "partition", "bucket", "bucketFrom", "bucketTo", "Companion", "core"})
public abstract class RadixSelector
extends Selector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxLength;
    @NotNull
    private final int[] histogram;
    @NotNull
    private final int[] commonPrefix;
    private static final int LEVEL_THRESHOLD = 8;
    private static final int HISTOGRAM_SIZE = 257;
    private static final int LENGTH_THRESHOLD = 100;

    protected RadixSelector(int maxLength) {
        this.maxLength = maxLength;
        this.histogram = new int[257];
        this.commonPrefix = new int[Math.min(24, this.maxLength)];
    }

    protected abstract int byteAt(int var1, int var2);

    @Nullable
    protected Selector getFallbackSelector(int d) {
        return new IntroSelector(this, d){
            private final BytesRefBuilder pivot;
            final /* synthetic */ RadixSelector this$0;
            final /* synthetic */ int $d;
            {
                this.this$0 = $receiver;
                this.$d = $d;
                this.pivot = new BytesRefBuilder();
            }

            protected void swap(int i, int j) {
                this.this$0.swap(i, j);
            }

            protected int compare(int i, int j) {
                int n = RadixSelector.access$getMaxLength$p(this.this$0);
                for (int o = this.$d; o < n; ++o) {
                    int b2;
                    int b1 = this.this$0.byteAt(i, o);
                    if (b1 != (b2 = this.this$0.byteAt(j, o))) {
                        int ub1 = b1 == -1 ? -1 : b1 & 0xFF;
                        int ub2 = b2 == -1 ? -1 : b2 & 0xFF;
                        return ub1 - ub2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }

            protected void setPivot(int i) {
                int b;
                this.pivot.setLength(0);
                int n = RadixSelector.access$getMaxLength$p(this.this$0);
                for (int o = this.$d; o < n && (b = this.this$0.byteAt(i, o)) != -1; ++o) {
                    this.pivot.append((byte)(b & 0xFF));
                }
            }

            protected int comparePivot(int j) {
                int n = this.pivot.length();
                for (int o = 0; o < n; ++o) {
                    int ub2;
                    int b1 = this.pivot.byteAt(o) & 0xFF;
                    int b2 = this.this$0.byteAt(j, this.$d + o);
                    int n2 = ub2 = b2 == -1 ? -1 : b2 & 0xFF;
                    if (b1 == ub2) continue;
                    return b1 - ub2;
                }
                if (this.$d + this.pivot.length() == RadixSelector.access$getMaxLength$p(this.this$0)) {
                    return 0;
                }
                return -1 - this.this$0.byteAt(j, this.$d + this.pivot.length());
            }
        };
    }

    @Override
    public void select(int from, int to, int k) {
        this.checkArgs(from, to, k);
        this.select(from, to, k, 0, 0);
    }

    private final void select(int from, int to, int k, int d, int l) {
        if (to - from <= 100 || l >= 8) {
            Selector selector = this.getFallbackSelector(d);
            Intrinsics.checkNotNull((Object)selector);
            selector.select(from, to, k);
        } else {
            this.radixSelect(from, to, k, d, l);
        }
    }

    private final void radixSelect(int from, int to, int k, int d, int l) {
        int[] histogram = this.histogram;
        Arrays.INSTANCE.fill(histogram, 0);
        int commonPrefixLength = this.computeCommonPrefixLengthAndBuildHistogram(from, to, d, histogram);
        if (commonPrefixLength > 0) {
            if (d + commonPrefixLength < this.maxLength && histogram[0] < to - from) {
                this.radixSelect(from, to, k, d + commonPrefixLength, l);
            }
            return;
        }
        if (!this.assertHistogram(commonPrefixLength, histogram)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int bucketFrom = from;
        for (int bucket = 0; bucket < 257; ++bucket) {
            int bucketTo = bucketFrom + histogram[bucket];
            if (bucketTo > k) {
                this.partition(from, to, bucket, bucketFrom, bucketTo, d);
                if (bucket != 0 && d + 1 < this.maxLength) {
                    this.select(bucketFrom, bucketTo, k, d + 1, l + 1);
                }
                return;
            }
            bucketFrom = bucketTo;
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    private final boolean assertHistogram(int commonPrefixLength, int[] histogram) {
        int numberOfUniqueBytes = 0;
        for (int freq : histogram) {
            if (freq <= 0) continue;
            ++numberOfUniqueBytes;
        }
        if (numberOfUniqueBytes == 1) {
            if (!(commonPrefixLength >= 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        } else if (!(commonPrefixLength == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    private final int getBucket(int i, int k) {
        int b = this.byteAt(i, k);
        return b == -1 ? 0 : (b & 0xFF) + 1;
    }

    private final int computeCommonPrefixLengthAndBuildHistogram(int from, int to, int k, int[] histogram) {
        int commonPrefixLength = this.computeInitialCommonPrefixLength(from, k);
        return this.computeCommonPrefixLengthAndBuildHistogramPart1(from, to, k, histogram, commonPrefixLength);
    }

    private final int computeInitialCommonPrefixLength(int from, int k) {
        int[] commonPrefix = this.commonPrefix;
        int commonPrefixLength = Math.min(commonPrefix.length, this.maxLength - k);
        for (int j = 0; j < commonPrefixLength; ++j) {
            int b = this.byteAt(from, k + j);
            int n = commonPrefix[j] = b == -1 ? -1 : b & 0xFF;
            if (b != -1) continue;
            commonPrefixLength = j + 1;
            break;
        }
        return commonPrefixLength;
    }

    private final int computeCommonPrefixLengthAndBuildHistogramPart1(int from, int to, int k, int[] histogram, int commonPrefixLength) {
        int i;
        int commonPrefixLength2 = commonPrefixLength;
        int[] commonPrefix = this.commonPrefix;
        block0: for (i = from + 1; i < to; ++i) {
            int n = commonPrefixLength2;
            for (int j = 0; j < n; ++j) {
                int ub;
                int b = this.byteAt(i, k + j);
                int n2 = ub = b == -1 ? -1 : b & 0xFF;
                if (ub == commonPrefix[j]) continue;
                commonPrefixLength2 = j;
                if (commonPrefixLength2 != 0) continue block0;
                histogram[commonPrefix[0] + 1] = i - from;
                histogram[ub + 1] = 1;
                break block0;
            }
        }
        return this.computeCommonPrefixLengthAndBuildHistogramPart2(from, to, k, histogram, commonPrefixLength2, i);
    }

    private final int computeCommonPrefixLengthAndBuildHistogramPart2(int from, int to, int k, int[] histogram, int commonPrefixLength, int i) {
        if (i < to) {
            if (!(commonPrefixLength == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.buildHistogram(i + 1, to, k, histogram);
        } else {
            if (!(commonPrefixLength > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            histogram[this.commonPrefix[0] + 1] = to - from;
        }
        return commonPrefixLength;
    }

    private final void buildHistogram(int from, int to, int k, int[] histogram) {
        for (int i = from; i < to; ++i) {
            int n = this.getBucket(i, k);
            int n2 = histogram[n];
            histogram[n] = n2 + 1;
        }
    }

    private final void partition(int from, int to, int bucket, int bucketFrom, int bucketTo, int d) {
        int left = from;
        int right = to - 1;
        int slot = bucketFrom;
        while (true) {
            int leftBucket = this.getBucket(left, d);
            int rightBucket = this.getBucket(right, d);
            while (leftBucket <= bucket && left < bucketFrom) {
                if (leftBucket == bucket) {
                    this.swap(left, slot++);
                } else {
                    ++left;
                }
                leftBucket = this.getBucket(left, d);
            }
            while (rightBucket >= bucket && right >= bucketTo) {
                if (rightBucket == bucket) {
                    this.swap(right, slot++);
                } else {
                    --right;
                }
                rightBucket = this.getBucket(right, d);
            }
            if (left >= bucketFrom || right < bucketTo) break;
            this.swap(left++, right--);
        }
        if (!(left == bucketFrom)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(right == bucketTo - 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ int access$getMaxLength$p(RadixSelector $this) {
        return $this.maxLength;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/RadixSelector$Companion;", "", "<init>", "()V", "LEVEL_THRESHOLD", "", "HISTOGRAM_SIZE", "LENGTH_THRESHOLD", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

