/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.DocIdSet;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitDocIdSet;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.NotDocIdSet;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u001f\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/RoaringDocIdSet;", "Lorg/gnit/lucenekmp/search/DocIdSet;", "docIdSets", "", "cardinality", "", "<init>", "([Lorg/gnit/lucenekmp/search/DocIdSet;I)V", "[Lorg/gnit/lucenekmp/search/DocIdSet;", "ramBytesUsed", "", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "toString", "", "Builder", "ShortArrayDocIdSet", "Iterator", "Companion", "core"})
public final class RoaringDocIdSet
extends DocIdSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocIdSet[] docIdSets;
    private final int cardinality;
    private final long ramBytesUsed;
    private static final int BLOCK_SIZE = 65536;
    private static final int MAX_ARRAY_LENGTH = 4096;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(RoaringDocIdSet.class));

    private RoaringDocIdSet(DocIdSet[] docIdSets, int cardinality) {
        this.docIdSets = docIdSets;
        long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.shallowSizeOf((Object)docIdSets);
        for (DocIdSet set : this.docIdSets) {
            if (set == null) continue;
            ramBytesUsed += set.ramBytesUsed();
        }
        this.ramBytesUsed = ramBytesUsed;
        this.cardinality = cardinality;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        if (this.cardinality == 0) {
            return DocIdSetIterator.Companion.empty();
        }
        return new Iterator();
    }

    public final int cardinality() {
        return this.cardinality;
    }

    @NotNull
    public String toString() {
        return "RoaringDocIdSet(cardinality=" + this.cardinality + ")";
    }

    public /* synthetic */ RoaringDocIdSet(DocIdSet[] docIdSets, int cardinality, DefaultConstructorMarker $constructor_marker) {
        this(docIdSets, cardinality);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/util/RoaringDocIdSet$Builder;", "", "maxDoc", "", "<init>", "(I)V", "sets", "", "Lorg/gnit/lucenekmp/search/DocIdSet;", "[Lorg/gnit/lucenekmp/search/DocIdSet;", "cardinality", "lastDocId", "currentBlock", "currentBlockCardinality", "buffer", "", "denseBuffer", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "flush", "", "add", "docId", "disi", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "build", "Lorg/gnit/lucenekmp/util/RoaringDocIdSet;", "core"})
    @SourceDebugExtension(value={"SMAP\nRoaringDocIdSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoaringDocIdSet.kt\norg/gnit/lucenekmp/util/RoaringDocIdSet$Builder\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n3#2,8:347\n3#2,8:356\n3#2,8:365\n3#2,8:374\n3#2,8:383\n10#3:355\n10#3:364\n10#3:373\n10#3:382\n10#3:391\n1#4:392\n*S KotlinDebug\n*F\n+ 1 RoaringDocIdSet.kt\norg/gnit/lucenekmp/util/RoaringDocIdSet$Builder\n*L\n46#1:347,8\n49#1:356,8\n62#1:365,8\n72#1:374,8\n75#1:383,8\n46#1:355\n49#1:364\n62#1:373\n72#1:382\n75#1:391\n*E\n"})
    public static final class Builder {
        private final int maxDoc;
        @NotNull
        private final DocIdSet[] sets;
        private int cardinality;
        private int lastDocId;
        private int currentBlock;
        private int currentBlockCardinality;
        @NotNull
        private final short[] buffer;
        @Nullable
        private FixedBitSet denseBuffer;

        public Builder(int maxDoc) {
            this.maxDoc = maxDoc;
            this.sets = new DocIdSet[this.maxDoc + 65536 - 1 >>> 16];
            this.lastDocId = -1;
            this.currentBlock = -1;
            this.buffer = new short[4096];
        }

        /*
         * Unable to fully structure code
         */
        private final void flush() {
            block11: {
                block13: {
                    block12: {
                        block10: {
                            condition$iv = this.currentBlockCardinality <= 65536;
                            $i$f$assert = false;
                            if (_Assertions.ENABLED && !condition$iv) {
                                $i$a$-assert-AssertKt$assert$1 = false;
                                $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                            }
                            if (this.currentBlockCardinality > 4096) break block10;
                            condition$iv = this.denseBuffer == null;
                            $i$f$assert = false;
                            if (_Assertions.ENABLED && !condition$iv) {
                                $i$a$-assert-AssertKt$assert$1 = false;
                                $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                            }
                            if (this.currentBlockCardinality > 0) {
                                this.sets[this.currentBlock] = new ShortArrayDocIdSet(ArrayUtil.Companion.copyOfSubArray(this.buffer, 0, this.currentBlockCardinality));
                            }
                            break block11;
                        }
                        if (this.denseBuffer == null) {
                            var2_11 = "Required value was null.";
                            throw new IllegalStateException(var2_11.toString());
                        }
                        v0 = this.denseBuffer;
                        Intrinsics.checkNotNull((Object)v0);
                        condition$iv = v0.cardinality() == this.currentBlockCardinality;
                        $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            $i$a$-assert-AssertKt$assert$1 = false;
                            var4_9 = "assertion failed";
                            throw new AssertionError((Object)var4_9);
                        }
                        v1 = this.denseBuffer;
                        Intrinsics.checkNotNull((Object)v1);
                        if (v1.length() != 65536 || 65536 - this.currentBlockCardinality >= 4096) break block12;
                        excludedDocs = new short[65536 - this.currentBlockCardinality];
                        v2 = this.denseBuffer;
                        Intrinsics.checkNotNull((Object)v2);
                        v3 = this.denseBuffer;
                        Intrinsics.checkNotNull((Object)v3);
                        v2.flip(0, v3.length());
                        excludedDoc = -1;
                        var4_10 = excludedDocs.length;
                        for (i = 0; i < var4_10; ++i) {
                            v4 = this.denseBuffer;
                            Intrinsics.checkNotNull((Object)v4);
                            excludedDoc = v4.nextSetBit(excludedDoc + 1);
                            condition$iv = excludedDoc != 0x7FFFFFFF;
                            $i$f$assert = false;
                            if (_Assertions.ENABLED && !condition$iv) {
                                $i$a$-assert-AssertKt$assert$1 = false;
                                var8_16 = "assertion failed";
                                throw new AssertionError((Object)var8_16);
                            }
                            excludedDocs[i] = (short)excludedDoc;
                        }
                        v5 = this.denseBuffer;
                        Intrinsics.checkNotNull((Object)v5);
                        if (excludedDoc + 1 == v5.length()) ** GOTO lbl-1000
                        v6 = this.denseBuffer;
                        Intrinsics.checkNotNull((Object)v6);
                        if (v6.nextSetBit(excludedDoc + 1) == 0x7FFFFFFF) lbl-1000:
                        // 2 sources

                        {
                            v7 = true;
                        } else {
                            v7 = false;
                        }
                        condition$iv = v7;
                        $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            $i$a$-assert-AssertKt$assert$1 = false;
                            var6_18 = "assertion failed";
                            throw new AssertionError((Object)var6_18);
                        }
                        this.sets[this.currentBlock] = new NotDocIdSet(65536, new ShortArrayDocIdSet(excludedDocs));
                        break block13;
                    }
                    v8 = this.denseBuffer;
                    Intrinsics.checkNotNull((Object)v8);
                    this.sets[this.currentBlock] = new BitDocIdSet(v8, this.currentBlockCardinality);
                }
                this.denseBuffer = null;
            }
            this.cardinality += this.currentBlockCardinality;
            this.denseBuffer = null;
            this.currentBlockCardinality = 0;
        }

        @NotNull
        public final Builder add(int docId) {
            if (!(docId > this.lastDocId)) {
                boolean $i$a$-require-RoaringDocIdSet$Builder$add$22 = false;
                String $i$a$-require-RoaringDocIdSet$Builder$add$22 = "Doc ids must be added in-order, got " + docId + " which is <= lastDocID=" + this.lastDocId;
                throw new IllegalArgumentException($i$a$-require-RoaringDocIdSet$Builder$add$22.toString());
            }
            int block2 = docId >>> 16;
            if (block2 != this.currentBlock) {
                this.flush();
                this.currentBlock = block2;
            }
            if (this.currentBlockCardinality < 4096) {
                this.buffer[this.currentBlockCardinality] = (short)docId;
            } else {
                if (this.denseBuffer == null) {
                    int numBits = Math.min(65536, this.maxDoc - (block2 << 16));
                    this.denseBuffer = new FixedBitSet(numBits);
                    for (short doc : this.buffer) {
                        FixedBitSet fixedBitSet = this.denseBuffer;
                        Intrinsics.checkNotNull((Object)fixedBitSet);
                        fixedBitSet.set(doc & 0xFFFF);
                    }
                }
                FixedBitSet fixedBitSet = this.denseBuffer;
                Intrinsics.checkNotNull((Object)fixedBitSet);
                fixedBitSet.set(docId & 0xFFFF);
            }
            this.lastDocId = docId;
            ++this.currentBlockCardinality;
            return this;
        }

        @NotNull
        public final Builder add(@NotNull DocIdSetIterator disi) throws IOException {
            Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
            int doc = disi.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                this.add(doc);
                doc = disi.nextDoc();
            }
            return this;
        }

        @NotNull
        public final RoaringDocIdSet build() {
            this.flush();
            return new RoaringDocIdSet(this.sets, this.cardinality, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/util/RoaringDocIdSet$Companion;", "", "<init>", "()V", "BLOCK_SIZE", "", "MAX_ARRAY_LENGTH", "BASE_RAM_BYTES_USED", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0006\u0010\u0016\u001a\u00020\u0005J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\t\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/util/RoaringDocIdSet$Iterator;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "(Lorg/gnit/lucenekmp/util/RoaringDocIdSet;)V", "block", "", "getBlock", "()I", "setBlock", "(I)V", "sub", "getSub", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "setSub", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "doc", "getDoc", "setDoc", "docID", "nextDoc", "advance", "target", "firstDocFromNextBlock", "intoBitSet", "", "upTo", "bitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "offset", "cost", "", "core"})
    @SourceDebugExtension(value={"SMAP\nRoaringDocIdSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoaringDocIdSet.kt\norg/gnit/lucenekmp/util/RoaringDocIdSet$Iterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,346:1\n1#2:347\n3#3,8:348\n10#4:356\n*S KotlinDebug\n*F\n+ 1 RoaringDocIdSet.kt\norg/gnit/lucenekmp/util/RoaringDocIdSet$Iterator\n*L\n296#1:348,8\n296#1:356\n*E\n"})
    private final class Iterator
    extends DocIdSetIterator {
        private int block = -1;
        @Nullable
        private DocIdSetIterator sub = DocIdSetIterator.Companion.empty();
        private int doc = -1;

        public final int getBlock() {
            return this.block;
        }

        public final void setBlock(int n) {
            this.block = n;
        }

        @Nullable
        public final DocIdSetIterator getSub() {
            return this.sub;
        }

        public final void setSub(@Nullable DocIdSetIterator docIdSetIterator) {
            this.sub = docIdSetIterator;
        }

        public final int getDoc() {
            return this.doc;
        }

        public final void setDoc(int n) {
            this.doc = n;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            int n;
            DocIdSetIterator docIdSetIterator = this.sub;
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            int subNext = docIdSetIterator.nextDoc();
            if (subNext == Integer.MAX_VALUE) {
                return this.firstDocFromNextBlock();
            }
            int it = n = this.block << 16 | subNext;
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public int advance(int target) throws IOException {
            int n;
            int targetBlock = target >>> 16;
            if (targetBlock != this.block) {
                this.block = targetBlock;
                if (this.block >= RoaringDocIdSet.this.docIdSets.length) {
                    int n2;
                    this.sub = null;
                    int it = n2 = Integer.MAX_VALUE;
                    boolean bl = false;
                    this.doc = it;
                    return n2;
                }
                if (RoaringDocIdSet.this.docIdSets[this.block] == null) {
                    return this.firstDocFromNextBlock();
                }
                this.sub = RoaringDocIdSet.this.docIdSets[this.block].iterator();
            }
            DocIdSetIterator docIdSetIterator = this.sub;
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            int subNext = docIdSetIterator.advance(target & 0xFFFF);
            if (subNext == Integer.MAX_VALUE) {
                return this.firstDocFromNextBlock();
            }
            int it = n = this.block << 16 | subNext;
            boolean bl = false;
            this.doc = it;
            return n;
        }

        public final int firstDocFromNextBlock() throws IOException {
            int n;
            do {
                int n2;
                ++this.block;
                if (this.block < RoaringDocIdSet.this.docIdSets.length) continue;
                this.sub = null;
                int it = n2 = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n2;
            } while (RoaringDocIdSet.this.docIdSets[this.block] == null);
            DocIdSetIterator docIdSetIterator = this.sub = RoaringDocIdSet.this.docIdSets[this.block].iterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            int subNext = docIdSetIterator.nextDoc();
            boolean condition$iv = subNext != Integer.MAX_VALUE;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            int it = n = this.block << 16 | subNext;
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public void intoBitSet(int upTo, @NotNull FixedBitSet bitSet, int offset) throws IOException {
            int subUpto;
            Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
            while ((subUpto = upTo - (this.block << 16)) >= 0) {
                int subOffset = offset - (this.block << 16);
                DocIdSetIterator docIdSetIterator = this.sub;
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                docIdSetIterator.intoBitSet(subUpto, bitSet, subOffset);
                DocIdSetIterator docIdSetIterator2 = this.sub;
                Intrinsics.checkNotNull((Object)docIdSetIterator2);
                if (docIdSetIterator2.docID() == Integer.MAX_VALUE) {
                    if (this.firstDocFromNextBlock() != Integer.MAX_VALUE) continue;
                    break;
                }
                DocIdSetIterator docIdSetIterator3 = this.sub;
                Intrinsics.checkNotNull((Object)docIdSetIterator3);
                this.doc = this.block << 16 | docIdSetIterator3.docID();
                break;
            }
        }

        @Override
        public long cost() {
            return RoaringDocIdSet.this.cardinality;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/RoaringDocIdSet$ShortArrayDocIdSet;", "Lorg/gnit/lucenekmp/search/DocIdSet;", "docIDs", "", "<init>", "([S)V", "ramBytesUsed", "", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "Companion", "core"})
    private static final class ShortArrayDocIdSet
    extends DocIdSet {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final short[] docIDs;
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(ShortArrayDocIdSet.class));

        public ShortArrayDocIdSet(@NotNull short[] docIDs) {
            Intrinsics.checkNotNullParameter((Object)docIDs, (String)"docIDs");
            this.docIDs = docIDs;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.docIDs);
        }

        @Override
        @NotNull
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(this){
                private int i;
                private int doc;
                final /* synthetic */ ShortArrayDocIdSet this$0;
                {
                    this.this$0 = $receiver;
                    this.i = -1;
                    this.doc = -1;
                }

                public final int getI() {
                    return this.i;
                }

                public final void setI(int n) {
                    this.i = n;
                }

                public final int getDoc() {
                    return this.doc;
                }

                public final void setDoc(int n) {
                    this.doc = n;
                }

                public final int docId(int i) {
                    return ShortArrayDocIdSet.access$getDocIDs$p(this.this$0)[i] & 0xFFFF;
                }

                public int nextDoc() {
                    int n;
                    ++this.i;
                    if (this.i >= ShortArrayDocIdSet.access$getDocIDs$p(this.this$0).length) {
                        int n2;
                        int it = n2 = Integer.MAX_VALUE;
                        boolean bl = false;
                        this.doc = it;
                        return n2;
                    }
                    int it = n = this.docId(this.i);
                    boolean bl = false;
                    this.doc = it;
                    return n;
                }

                public int docID() {
                    return this.doc;
                }

                public long cost() {
                    return ShortArrayDocIdSet.access$getDocIDs$p(this.this$0).length;
                }

                public int advance(int target) {
                    int it;
                    int n;
                    int lo = this.i + 1;
                    int hi = ShortArrayDocIdSet.access$getDocIDs$p(this.this$0).length - 1;
                    while (lo <= hi) {
                        int mid = lo + hi >>> 1;
                        int midDoc = this.docId(mid);
                        if (midDoc < target) {
                            lo = mid + 1;
                            continue;
                        }
                        hi = mid - 1;
                    }
                    if (lo == ShortArrayDocIdSet.access$getDocIDs$p(this.this$0).length) {
                        this.i = ShortArrayDocIdSet.access$getDocIDs$p(this.this$0).length;
                        it = n = Integer.MAX_VALUE;
                        boolean bl = false;
                        this.doc = it;
                        return n;
                    }
                    this.i = lo;
                    it = n = this.docId(this.i);
                    boolean bl = false;
                    this.doc = it;
                    return n;
                }

                public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) {
                    Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
                    if (this.doc >= upTo) {
                        return;
                    }
                    int from = this.i;
                    this.advance(upTo);
                    int to = this.i;
                    for (int i = from; i < to; ++i) {
                        bitSet.set(this.docId(i) - offset);
                    }
                }
            };
        }

        public static final /* synthetic */ short[] access$getDocIDs$p(ShortArrayDocIdSet $this) {
            return $this.docIDs;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/RoaringDocIdSet$ShortArrayDocIdSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

