/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/SmallFloat;", "", "<init>", "()V", "floatToByte", "", "f", "", "numMantissaBits", "", "zeroExp", "byteToFloat", "b", "floatToByte315", "byte315ToFloat", "longToInt4", "i", "", "int4ToLong", "MAX_INT4", "NUM_FREE_VALUES", "intToByte4", "byte4ToInt", "core"})
@SourceDebugExtension(value={"SMAP\nSmallFloat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmallFloat.kt\norg/gnit/lucenekmp/util/SmallFloat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class SmallFloat {
    @NotNull
    public static final SmallFloat INSTANCE = new SmallFloat();
    private static final int MAX_INT4 = INSTANCE.longToInt4(Integer.MAX_VALUE);
    private static final int NUM_FREE_VALUES = 255 - MAX_INT4;

    private SmallFloat() {
    }

    public final byte floatToByte(float f, int numMantissaBits, int zeroExp) {
        int fzero = 63 - zeroExp << numMantissaBits;
        int bits = FloatExtKt.floatToRawIntBits(FloatCompanionObject.INSTANCE, f);
        int smallfloat = bits >> 24 - numMantissaBits;
        if (smallfloat <= fzero) {
            return bits <= 0 ? (byte)0 : 1;
        }
        if (smallfloat >= fzero + 256) {
            return -1;
        }
        return (byte)(smallfloat - fzero);
    }

    public final float byteToFloat(byte b, int numMantissaBits, int zeroExp) {
        if (b == 0) {
            return 0.0f;
        }
        int bits = (b & 0xFF) << 24 - numMantissaBits;
        return FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, bits += 63 - zeroExp << 24);
    }

    public final byte floatToByte315(float f) {
        int bits = FloatExtKt.floatToRawIntBits(FloatCompanionObject.INSTANCE, f);
        int smallfloat = bits >> 21;
        if (smallfloat <= 384) {
            return bits <= 0 ? (byte)0 : 1;
        }
        if (smallfloat >= 640) {
            return -1;
        }
        return (byte)(smallfloat - 384);
    }

    public final float byte315ToFloat(byte b) {
        if (b == 0) {
            return 0.0f;
        }
        int bits = (b & 0xFF) << 21;
        return FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, bits += 0x30000000);
    }

    public final int longToInt4(long i) {
        if (!(i >= 0L)) {
            boolean $i$a$-require-SmallFloat$longToInt4$22 = false;
            String $i$a$-require-SmallFloat$longToInt4$22 = "Only supports positive values, got " + i;
            throw new IllegalArgumentException($i$a$-require-SmallFloat$longToInt4$22.toString());
        }
        int numBits = 64 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, i);
        if (numBits < 4) {
            return Math.INSTANCE.toIntExact(i);
        }
        int shift = numBits - 4;
        int encoded = Math.INSTANCE.toIntExact(i >>> shift);
        encoded &= 7;
        return encoded |= shift + 1 << 3;
    }

    public final long int4ToLong(int i) {
        long bits = i & 7;
        int shift = (i >>> 3) - 1;
        long decoded = 0L;
        decoded = shift == -1 ? bits : (bits | 8L) << shift;
        return decoded;
    }

    public final byte intToByte4(int i) {
        if (!(i >= 0)) {
            boolean bl = false;
            String string = "Only supports positive values, got " + i;
            throw new IllegalArgumentException(string.toString());
        }
        if (i < NUM_FREE_VALUES) {
            return (byte)i;
        }
        return (byte)(NUM_FREE_VALUES + this.longToInt4(i - NUM_FREE_VALUES));
    }

    public final int byte4ToInt(byte b) {
        int i = ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, b);
        if (i < NUM_FREE_VALUES) {
            return i;
        }
        long decoded = (long)NUM_FREE_VALUES + this.int4ToLong(i - NUM_FREE_VALUES);
        return Math.INSTANCE.toIntExact(decoded);
    }
}

