/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.Sorter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u001f\b&\u0018\u0000 :2\u00020\u0001:\u0001:B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u001cJ\u0016\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0003J\u001e\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J \u0010+\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0016J\u001e\u0010,\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\u001e\u0010-\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003J\u001e\u0010.\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u001e\u00100\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u001e\u00101\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u001e\u00102\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u0018\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H$J\u0018\u00106\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H$J\u0018\u00107\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H$J\u0018\u00109\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u0005R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\u0005R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006;"}, d2={"Lorg/gnit/lucenekmp/util/TimSorter;", "Lorg/gnit/lucenekmp/util/Sorter;", "maxTempSlots", "", "<init>", "(I)V", "getMaxTempSlots", "()I", "minRun", "getMinRun", "setMinRun", "to", "getTo", "setTo", "stackSize", "getStackSize", "setStackSize", "runEnds", "", "getRunEnds", "()[I", "setRunEnds", "([I)V", "runLen", "i", "runBase", "runEnd", "setRunEnd", "", "pushRunLen", "len", "nextRun", "ensureInvariants", "exhaustStack", "reset", "from", "mergeAt", "n", "merge", "lo", "mid", "hi", "sort", "doRotate", "mergeLo", "mergeHi", "lowerSaved", "val", "upperSaved", "lowerSaved3", "upperSaved3", "copy", "src", "dest", "save", "restore", "j", "compareSaved", "Companion", "core"})
public abstract class TimSorter
extends Sorter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxTempSlots;
    private int minRun;
    private int to;
    private int stackSize;
    @NotNull
    private int[] runEnds;
    public static final int MINRUN = 32;
    public static final int THRESHOLD = 64;
    public static final int STACKSIZE = 49;
    public static final int MIN_GALLOP = 7;

    protected TimSorter(int maxTempSlots) {
        this.maxTempSlots = maxTempSlots;
        this.runEnds = new int[50];
    }

    public final int getMaxTempSlots() {
        return this.maxTempSlots;
    }

    public final int getMinRun() {
        return this.minRun;
    }

    public final void setMinRun(int n) {
        this.minRun = n;
    }

    public final int getTo() {
        return this.to;
    }

    public final void setTo(int n) {
        this.to = n;
    }

    public final int getStackSize() {
        return this.stackSize;
    }

    public final void setStackSize(int n) {
        this.stackSize = n;
    }

    @NotNull
    public final int[] getRunEnds() {
        return this.runEnds;
    }

    public final void setRunEnds(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.runEnds = nArray;
    }

    public final int runLen(int i) {
        int off = this.stackSize - i;
        return this.runEnds[off] - this.runEnds[off - 1];
    }

    public final int runBase(int i) {
        return this.runEnds[this.stackSize - i - 1];
    }

    public final int runEnd(int i) {
        return this.runEnds[this.stackSize - i];
    }

    public final void setRunEnd(int i, int runEnd) {
        this.runEnds[this.stackSize - i] = runEnd;
    }

    public final void pushRunLen(int len) {
        this.runEnds[this.stackSize + 1] = this.runEnds[this.stackSize] + len;
        ++this.stackSize;
    }

    public final int nextRun() {
        int o;
        int runBase = this.runEnd(0);
        if (!(runBase < this.to)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (runBase == this.to - 1) {
            return 1;
        }
        if (this.compare(runBase, runBase + 1) > 0) {
            for (o = runBase + 2; o < this.to && this.compare(o - 1, o) > 0; ++o) {
            }
            this.reverse(runBase, o);
        } else {
            while (o < this.to && this.compare(o - 1, o) <= 0) {
                ++o;
            }
        }
        int runHi = Math.max(o, Math.min(this.to, runBase + this.minRun));
        this.binarySort(runBase, runHi, o);
        return runHi - runBase;
    }

    public final void ensureInvariants() {
        while (this.stackSize > 1) {
            int runLen2;
            int runLen0 = this.runLen(0);
            int runLen1 = this.runLen(1);
            if (this.stackSize > 2 && (runLen2 = this.runLen(2)) <= runLen1 + runLen0) {
                if (runLen2 < runLen0) {
                    this.mergeAt(1);
                    continue;
                }
                this.mergeAt(0);
                continue;
            }
            if (runLen1 > runLen0) break;
            this.mergeAt(0);
        }
    }

    public final void exhaustStack() {
        while (this.stackSize > 1) {
            this.mergeAt(0);
        }
    }

    public final void reset(int from, int to) {
        this.stackSize = 0;
        ArraysKt.fill$default((int[])this.runEnds, (int)0, (int)0, (int)0, (int)6, null);
        this.runEnds[0] = from;
        this.to = to;
        int length = to - from;
        this.minRun = length <= 64 ? length : Companion.minRun(length);
    }

    public final void mergeAt(int n) {
        if (!(this.stackSize >= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.merge(this.runBase(n + 1), this.runBase(n), this.runEnd(n));
        for (int j = n + 1; 0 < j; --j) {
            this.setRunEnd(j, this.runEnd(j - 1));
        }
        this.stackSize += -1;
    }

    public final void merge(int lo, int mid, int hi) {
        int lo2 = lo;
        int hi2 = hi;
        if (this.compare(mid - 1, mid) <= 0) {
            return;
        }
        lo2 = this.upper2(lo2, mid, mid);
        if ((hi2 = this.lower2(mid, hi2, mid - 1)) - mid <= mid - lo2 && hi2 - mid <= this.maxTempSlots) {
            this.mergeHi(lo2, mid, hi2);
        } else if (mid - lo2 <= this.maxTempSlots) {
            this.mergeLo(lo2, mid, hi2);
        } else {
            this.mergeInPlace(lo2, mid, hi2);
        }
    }

    @Override
    public void sort(int from, int to) {
        this.checkRange(from, to);
        if (to - from <= 1) {
            return;
        }
        this.reset(from, to);
        do {
            this.ensureInvariants();
            this.pushRunLen(this.nextRun());
        } while (this.runEnd(0) < to);
        this.exhaustStack();
        if (!(this.runEnd(0) == to)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void doRotate(int lo, int mid, int hi) {
        int lo2 = 0;
        lo2 = lo;
        int mid2 = 0;
        mid2 = mid;
        int len1 = mid2 - lo2;
        int len2 = hi - mid2;
        if (len1 == len2) {
            while (mid2 < hi) {
                int n = lo2;
                lo2 = n + 1;
                int n2 = n;
                n = mid2;
                mid2 = n + 1;
                this.swap(n2, n);
            }
        } else if (len2 < len1 && len2 <= this.maxTempSlots) {
            this.save(mid2, len2);
            TimSorter $this$doRotate_u24lambda_u240 = this;
            boolean bl = false;
            int i = lo2 + len1 - 1;
            int j = hi - 1;
            while (i >= lo2) {
                $this$doRotate_u24lambda_u240.copy(i, j);
                --i;
                --j;
            }
            int i2 = 0;
            int j2 = lo2;
            while (i2 < len2) {
                this.restore(i2, j2);
                ++i2;
                ++j2;
            }
        } else if (len1 <= this.maxTempSlots) {
            this.save(lo2, len1);
            TimSorter $this$doRotate_u24lambda_u241 = this;
            boolean bl = false;
            int i = mid2;
            int j = lo2;
            while (i < hi) {
                $this$doRotate_u24lambda_u241.copy(i, j);
                ++i;
                ++j;
            }
            int i3 = 0;
            for (int j3 = lo2 + len2; j3 < hi; ++j3) {
                this.restore(i3, j3);
                ++i3;
            }
        } else {
            this.reverse(lo2, mid2);
            this.reverse(mid2, hi);
            this.reverse(lo2, hi);
        }
    }

    public final void mergeLo(int lo, int mid, int hi) {
        if (!(this.compare(lo, mid) > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int len1 = mid - lo;
        this.save(lo, len1);
        this.copy(mid, lo);
        int i = 0;
        int j = mid + 1;
        int dest = lo + 1;
        block0: while (true) {
            int count = 0;
            while (count < 7) {
                if (i >= len1 || j >= hi) break block0;
                if (this.compareSaved(i, j) <= 0) {
                    this.restore(i++, dest++);
                    count = 0;
                    continue;
                }
                this.copy(j++, dest++);
                ++count;
            }
            int next = this.lowerSaved3(j, hi, i);
            while (j < next) {
                this.copy(j++, dest);
                ++dest;
            }
            this.restore(i++, dest++);
        }
        while (i < len1) {
            this.restore(i++, dest);
            ++dest;
        }
        if (!(j == dest)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void mergeHi(int lo, int mid, int hi) {
        if (!(this.compare(mid - 1, hi - 1) > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int len2 = hi - mid;
        this.save(mid, len2);
        this.copy(mid - 1, hi - 1);
        int i = mid - 2;
        int j = len2 - 1;
        int dest = hi - 2;
        block0: while (true) {
            int count = 0;
            while (count < 7) {
                if (i < lo || j < 0) break block0;
                if (this.compareSaved(j, i) >= 0) {
                    this.restore(j--, dest--);
                    count = 0;
                    continue;
                }
                this.copy(i--, dest--);
                ++count;
            }
            int next = this.upperSaved3(lo, i + 1, j);
            while (i >= next) {
                this.copy(i--, dest--);
            }
            this.restore(j--, dest--);
        }
        while (j >= 0) {
            this.restore(j--, dest);
            --dest;
        }
        if (!(i == dest)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int lowerSaved(int from, int to, int val) {
        int from2 = from;
        int len = to - from2;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from2 + half;
            if (this.compareSaved(val, mid) > 0) {
                from2 = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from2;
    }

    public final int upperSaved(int from, int to, int val) {
        int from2 = from;
        int len = to - from2;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from2 + half;
            if (this.compareSaved(val, mid) < 0) {
                len = half;
                continue;
            }
            from2 = mid + 1;
            len = len - half - 1;
        }
        return from2;
    }

    public final int lowerSaved3(int from, int to, int val) {
        int delta;
        int f = from;
        for (int t = f + 1; t < to; t += delta << 1) {
            if (this.compareSaved(val, t) <= 0) {
                return this.lowerSaved(f, t, val);
            }
            delta = t - f;
            f = t;
        }
        return this.lowerSaved(f, to, val);
    }

    public final int upperSaved3(int from, int to, int val) {
        int delta;
        int t = to;
        for (int f = to - 1; f > from; f -= delta << 1) {
            if (this.compareSaved(val, f) >= 0) {
                return this.upperSaved(f, t, val);
            }
            delta = t - f;
            t = f;
        }
        return this.upperSaved(from, t, val);
    }

    protected abstract void copy(int var1, int var2);

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    protected abstract int compareSaved(int var1, int var2);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/TimSorter$Companion;", "", "<init>", "()V", "MINRUN", "", "THRESHOLD", "STACKSIZE", "MIN_GALLOP", "minRun", "length", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int minRun(int length) {
            int n;
            if (!(length >= 32)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int r = 0;
            for (n = length; n >= 64; n >>>= 1) {
                r |= n & 1;
            }
            int minRun = n + r;
            if (!(minRun >= 32 && minRun <= 64)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return minRun;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

