/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/util/ToStringUtils;", "", "<init>", "()V", "byteArray", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bytes", "", "HEX", "", "longHex", "", "x", "", "bytesRefToString", "b", "Lorg/gnit/lucenekmp/util/BytesRef;", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "core"})
public final class ToStringUtils {
    @NotNull
    public static final ToStringUtils INSTANCE = new ToStringUtils();
    @NotNull
    private static final char[] HEX;

    private ToStringUtils() {
    }

    public final void byteArray(@NotNull StringBuilder buffer, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            buffer.append("b[").append(i).append("]=").append(bytes[i]);
            if (i >= bytes.length - 1) continue;
            buffer.append(',');
        }
    }

    @NotNull
    public final String longHex(long x) {
        long x2 = x;
        char[] asHex = new char[16];
        int i = 16;
        while (--i >= 0) {
            asHex[i] = HEX[(int)x2 & 0xF];
            x2 >>>= 4;
        }
        return "0x" + asHex;
    }

    @NotNull
    public final String bytesRefToString(@Nullable BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (AssertionError t) {
            return b.toString();
        }
        catch (RuntimeException t) {
            return b.toString();
        }
    }

    @NotNull
    public final String bytesRefToString(@NotNull BytesRefBuilder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.bytesRefToString(b.get());
    }

    @NotNull
    public final String bytesRefToString(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.bytesRefToString(new BytesRef(b));
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX = cArray;
    }
}

