/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import org.gnit.lucenekmp.internal.hppc.IntHashSet;
import org.gnit.lucenekmp.jdkport.BitSet;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.InPlaceMergeSorter;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.Sorter;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.gnit.lucenekmp.util.automaton.TransitionAccessor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0002EFB\u001d\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0011J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u000e\u0010\r\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0004J\u001e\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J&\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004J\u0016\u0010)\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0000J\b\u0010,\u001a\u00020\u0016H\u0002J\u0006\u0010-\u001a\u00020\u0016J\u0010\u00100\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u00101\u001a\u00020\u0016H\u0002J\b\u00102\u001a\u00020\u0016H\u0002J\u0018\u00106\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u001dH\u0016J\u0010\u00108\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u001dH\u0016J\u0010\u00109\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u001dH\u0002J \u0010:\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u001dH\u0016J\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020\fJ\u0016\u0010?\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u0016\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0004J*\u0010@\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\b\u0010A\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010C\u001a\u00020DH\u0016R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b0\u0010/R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/gnit/lucenekmp/util/automaton/Automaton;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/util/automaton/TransitionAccessor;", "numStates", "", "numTransitions", "<init>", "(II)V", "nextState", "nextTransition", "curState", "states", "", "isAccept", "Lorg/gnit/lucenekmp/jdkport/BitSet;", "transitions", "value", "", "isDeterministic", "()Z", "createState", "setAccept", "", "state", "accept", "ensureAcceptCapacity", "size", "sortedTransitions", "", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "getSortedTransitions", "()[[Lorg/gnit/lucenekmp/util/automaton/Transition;", "acceptStates", "getAcceptStates", "()Lorg/gnit/lucenekmp/jdkport/BitSet;", "addTransition", "source", "dest", "label", "min", "max", "addEpsilon", "copy", "other", "finishCurrentState", "finishState", "getNumStates", "()I", "getNumTransitions", "growStates", "growTransitions", "destMinMaxSorter", "Lorg/gnit/lucenekmp/util/Sorter;", "minMaxDestSorter", "initTransition", "t", "getNextTransition", "transitionSorted", "getTransition", "index", "toDot", "", "getStartPoints", "step", "next", "transition", "fromTransitionIndex", "ramBytesUsed", "", "Builder", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nAutomaton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Automaton.kt\norg/gnit/lucenekmp/util/automaton/Automaton\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,945:1\n3#2,8:946\n3#2,8:956\n3#2,8:965\n3#2,8:974\n3#2,8:983\n8#2,2:992\n3#2,8:994\n3#2,8:1003\n3#2,8:1012\n3#2,8:1021\n3#2,8:1030\n10#3:954\n10#3:964\n10#3:973\n10#3:982\n10#3:991\n10#3:1002\n10#3:1011\n10#3:1020\n10#3:1029\n10#3:1038\n1#4:955\n*S KotlinDebug\n*F\n+ 1 Automaton.kt\norg/gnit/lucenekmp/util/automaton/Automaton\n*L\n146#1:946,8\n161#1:956,8\n249#1:965,8\n343#1:974,8\n344#1:983,8\n482#1:992,2\n491#1:994,8\n494#1:1003,8\n588#1:1012,8\n677#1:1021,8\n678#1:1030,8\n146#1:954\n161#1:964\n249#1:973\n343#1:982\n344#1:991\n491#1:1002\n494#1:1011\n588#1:1020\n677#1:1029\n678#1:1038\n*E\n"})
public final class Automaton
implements Accountable,
TransitionAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int nextState;
    private int nextTransition;
    private int curState;
    @NotNull
    private int[] states;
    @NotNull
    private BitSet isAccept;
    @NotNull
    private int[] transitions;
    private boolean isDeterministic;
    @NotNull
    private final Sorter destMinMaxSorter;
    @NotNull
    private final Sorter minMaxDestSorter;

    @JvmOverloads
    public Automaton(int numStates, int numTransitions) {
        this.curState = -1;
        this.isDeterministic = true;
        this.destMinMaxSorter = new InPlaceMergeSorter(this){
            final /* synthetic */ Automaton this$0;
            {
                this.this$0 = $receiver;
            }

            private final void swapOne(int i, int j) {
                int x = Automaton.access$getTransitions$p(this.this$0)[i];
                Automaton.access$getTransitions$p((Automaton)this.this$0)[i] = Automaton.access$getTransitions$p(this.this$0)[j];
                Automaton.access$getTransitions$p((Automaton)this.this$0)[j] = x;
            }

            protected void swap(int i, int j) {
                int iStart = 3 * i;
                int jStart = 3 * j;
                this.swapOne(iStart, jStart);
                this.swapOne(iStart + 1, jStart + 1);
                this.swapOne(iStart + 2, jStart + 2);
            }

            protected int compare(int i, int j) {
                int jMax;
                int jMin;
                int jDest;
                int iStart = 3 * i;
                int jStart = 3 * j;
                int iDest = Automaton.access$getTransitions$p(this.this$0)[iStart];
                if (iDest < (jDest = Automaton.access$getTransitions$p(this.this$0)[jStart])) {
                    return -1;
                }
                if (iDest > jDest) {
                    return 1;
                }
                int iMin = Automaton.access$getTransitions$p(this.this$0)[iStart + 1];
                if (iMin < (jMin = Automaton.access$getTransitions$p(this.this$0)[jStart + 1])) {
                    return -1;
                }
                if (iMin > jMin) {
                    return 1;
                }
                int iMax = Automaton.access$getTransitions$p(this.this$0)[iStart + 2];
                if (iMax < (jMax = Automaton.access$getTransitions$p(this.this$0)[jStart + 2])) {
                    return -1;
                }
                if (iMax > jMax) {
                    return 1;
                }
                return 0;
            }
        };
        this.minMaxDestSorter = new InPlaceMergeSorter(this){
            final /* synthetic */ Automaton this$0;
            {
                this.this$0 = $receiver;
            }

            private final void swapOne(int i, int j) {
                int x = Automaton.access$getTransitions$p(this.this$0)[i];
                Automaton.access$getTransitions$p((Automaton)this.this$0)[i] = Automaton.access$getTransitions$p(this.this$0)[j];
                Automaton.access$getTransitions$p((Automaton)this.this$0)[j] = x;
            }

            protected void swap(int i, int j) {
                int iStart = 3 * i;
                int jStart = 3 * j;
                this.swapOne(iStart, jStart);
                this.swapOne(iStart + 1, jStart + 1);
                this.swapOne(iStart + 2, jStart + 2);
            }

            protected int compare(int i, int j) {
                int jDest;
                int jMax;
                int jMin;
                int iStart = 3 * i;
                int jStart = 3 * j;
                int iMin = Automaton.access$getTransitions$p(this.this$0)[iStart + 1];
                if (iMin < (jMin = Automaton.access$getTransitions$p(this.this$0)[jStart + 1])) {
                    return -1;
                }
                if (iMin > jMin) {
                    return 1;
                }
                int iMax = Automaton.access$getTransitions$p(this.this$0)[iStart + 2];
                if (iMax < (jMax = Automaton.access$getTransitions$p(this.this$0)[jStart + 2])) {
                    return -1;
                }
                if (iMax > jMax) {
                    return 1;
                }
                int iDest = Automaton.access$getTransitions$p(this.this$0)[iStart];
                if (iDest < (jDest = Automaton.access$getTransitions$p(this.this$0)[jStart])) {
                    return -1;
                }
                if (iDest > jDest) {
                    return 1;
                }
                return 0;
            }
        };
        this.states = new int[numStates * 2];
        this.isAccept = new BitSet(numStates);
        this.transitions = new int[numTransitions * 3];
    }

    public /* synthetic */ Automaton(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        this(n, n2);
    }

    public final boolean isDeterministic() {
        return this.isDeterministic;
    }

    public final int createState() {
        this.growStates();
        this.ensureAcceptCapacity(this.nextState / 2 + 1);
        int state2 = this.nextState / 2;
        this.states[this.nextState] = -1;
        this.nextState += 2;
        return state2;
    }

    public final void setAccept(int state2, boolean accept) {
        Objects.INSTANCE.checkIndex(state2, this.getNumStates());
        this.ensureAcceptCapacity(this.getNumStates());
        this.isAccept.set(state2, accept);
    }

    private final void ensureAcceptCapacity(int size2) {
        if (this.isAccept.size() < size2) {
            int newSize;
            for (newSize = Math.max(1, this.isAccept.size()); newSize < size2; newSize *= 2) {
            }
            BitSet newBits = new BitSet(newSize);
            newBits.or(this.isAccept);
            this.isAccept = newBits;
        }
    }

    @NotNull
    public final Transition[][] getSortedTransitions() {
        int numStates = this.getNumStates();
        Transition[][] transitions = new Transition[numStates][];
        for (int s = 0; s < numStates; ++s) {
            int numTransitions = this.getNumTransitions(s);
            transitions[s] = new Transition[numTransitions];
            for (int t = 0; t < numTransitions; ++t) {
                Transition transition = new Transition();
                this.getTransition(s, t, transition);
                Transition[] transitionArray = transitions[s];
                Intrinsics.checkNotNull((Object)transitionArray);
                transitionArray[t] = transition;
            }
        }
        return transitions;
    }

    @NotNull
    public final BitSet getAcceptStates() {
        return this.isAccept;
    }

    public final boolean isAccept(int state2) {
        return this.isAccept.get(state2);
    }

    public final void addTransition(int source, int dest, int label) {
        this.addTransition(source, dest, label, label);
    }

    public final void addTransition(int source, int dest, int min, int max) {
        boolean condition$iv = this.nextTransition % 3 == 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        int bounds = this.nextState / 2;
        Objects.INSTANCE.checkIndex(source, bounds);
        Objects.INSTANCE.checkIndex(dest, bounds);
        this.growTransitions();
        if (this.curState != source) {
            if (this.curState != -1) {
                this.finishCurrentState();
            }
            this.curState = source;
            if (!(this.states[2 * this.curState] == -1)) {
                boolean bl = false;
                String string = "from state (" + source + ") already had transitions added";
                throw new IllegalStateException(string.toString());
            }
            boolean condition$iv2 = this.states[2 * this.curState + 1] == 0;
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.states[2 * this.curState] = this.nextTransition;
        }
        int n = this.nextTransition;
        this.nextTransition = n + 1;
        this.transitions[n] = dest;
        n = this.nextTransition;
        this.nextTransition = n + 1;
        this.transitions[n] = min;
        n = this.nextTransition;
        this.nextTransition = n + 1;
        this.transitions[n] = max;
        int[] nArray = this.states;
        int n2 = 2 * this.curState + 1;
        int n3 = nArray[n2];
        nArray[n2] = n3 + 1;
    }

    public final void addEpsilon(int source, int dest) {
        Transition t = new Transition();
        int count = this.initTransition(dest, t);
        for (int i = 0; i < count; ++i) {
            this.getNextTransition(t);
            this.addTransition(source, t.getDest(), t.getMin(), t.getMax());
        }
        if (this.isAccept(dest)) {
            this.setAccept(source, true);
        }
    }

    public final void copy(@NotNull Automaton other) {
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int stateOffset = this.getNumStates();
        this.states = ArrayUtil.Companion.grow(this.states, this.nextState + other.nextState);
        ArraysKt.copyInto((int[])other.states, (int[])this.states, (int)this.nextState, (int)0, (int)other.nextState);
        Automaton $this$copy_u24lambda_u241 = this;
        boolean bl = false;
        for (i = 0; i < other.nextState; i += 2) {
            if ($this$copy_u24lambda_u241.states[$this$copy_u24lambda_u241.nextState + i] == -1) continue;
            int[] nArray = $this$copy_u24lambda_u241.states;
            n = $this$copy_u24lambda_u241.nextState + i;
            nArray[n] = nArray[n] + $this$copy_u24lambda_u241.nextTransition;
        }
        this.nextState += other.nextState;
        int otherNumStates = other.getNumStates();
        BitSet otherAcceptStates = other.getAcceptStates();
        int state2 = 0;
        while (state2 < otherNumStates) {
            int it = i = otherAcceptStates.nextSetBit(state2);
            boolean bl2 = false;
            state2 = it;
            if (i == -1) break;
            this.setAccept(stateOffset + state2, true);
            i = state2;
            state2 = i + 1;
        }
        this.transitions = ArrayUtil.Companion.grow(this.transitions, this.nextTransition + other.nextTransition);
        ArraysKt.copyInto((int[])other.transitions, (int[])this.transitions, (int)this.nextTransition, (int)0, (int)other.nextTransition);
        for (i = 0; i < other.nextTransition; i += 3) {
            int[] nArray = this.transitions;
            n = this.nextTransition + i;
            nArray[n] = nArray[n] + stateOffset;
        }
        this.nextTransition += other.nextTransition;
        if (!other.isDeterministic) {
            this.isDeterministic = false;
        }
    }

    private final void finishCurrentState() {
        int numTransitions = this.states[2 * this.curState + 1];
        boolean condition$iv = numTransitions > 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        int offset = this.states[2 * this.curState];
        int start = offset / 3;
        this.destMinMaxSorter.sort(start, start + numTransitions);
        int upto = 0;
        int min = -1;
        int max = -1;
        int dest = -1;
        for (int i = 0; i < numTransitions; ++i) {
            int tDest = this.transitions[offset + 3 * i];
            int tMin = this.transitions[offset + 3 * i + 1];
            int tMax = this.transitions[offset + 3 * i + 2];
            if (dest == tDest) {
                if (tMin <= max + 1) {
                    if (tMax <= max) continue;
                    max = tMax;
                    continue;
                }
                if (dest != -1) {
                    this.transitions[offset + 3 * upto] = dest;
                    this.transitions[offset + 3 * upto + 1] = min;
                    this.transitions[offset + 3 * upto + 2] = max;
                    ++upto;
                }
                min = tMin;
                max = tMax;
                continue;
            }
            if (dest != -1) {
                this.transitions[offset + 3 * upto] = dest;
                this.transitions[offset + 3 * upto + 1] = min;
                this.transitions[offset + 3 * upto + 2] = max;
                ++upto;
            }
            dest = tDest;
            min = tMin;
            max = tMax;
        }
        if (dest != -1) {
            this.transitions[offset + 3 * upto] = dest;
            this.transitions[offset + 3 * upto + 1] = min;
            this.transitions[offset + 3 * upto + 2] = max;
            ++upto;
        }
        this.nextTransition -= (numTransitions - upto) * 3;
        this.states[2 * this.curState + 1] = upto;
        this.minMaxDestSorter.sort(start, start + upto);
        if (this.isDeterministic && upto > 1) {
            int lastMax = this.transitions[offset + 2];
            int n = upto;
            for (int i = 1; i < n; ++i) {
                min = this.transitions[offset + 3 * i + 1];
                if (min <= lastMax) {
                    this.isDeterministic = false;
                    break;
                }
                lastMax = this.transitions[offset + 3 * i + 2];
            }
        }
    }

    public final void finishState() {
        if (this.curState != -1) {
            this.finishCurrentState();
            this.curState = -1;
        }
    }

    public final int getNumStates() {
        return this.nextState / 2;
    }

    public final int getNumTransitions() {
        return this.nextTransition / 3;
    }

    @Override
    public int getNumTransitions(int state2) {
        boolean condition$iv = state2 >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = state2 < this.getNumStates();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int count = this.states[2 * state2 + 1];
        if (count == -1) {
            return 0;
        }
        return count;
    }

    private final void growStates() {
        if (this.nextState + 2 > this.states.length) {
            this.states = ArrayUtil.Companion.grow(this.states, this.nextState + 2);
        }
    }

    private final void growTransitions() {
        if (this.nextTransition + 3 > this.transitions.length) {
            this.transitions = ArrayUtil.Companion.grow(this.transitions, this.nextTransition + 3);
        }
    }

    @Override
    public int initTransition(int state2, @NotNull Transition t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        boolean condition$iv = state2 < this.nextState / 2;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "state=" + state2 + " nextState=" + this.nextState;
            throw new AssertionError((Object)string);
        }
        t.setSource(state2);
        t.setTransitionUpto(this.states[2 * state2]);
        return this.getNumTransitions(state2);
    }

    @Override
    public void getNextTransition(@NotNull Transition t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        boolean condition$iv = t.getTransitionUpto() + 3 - this.states[2 * t.getSource()] <= 3 * this.states[2 * t.getSource() + 1];
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = this.transitionSorted(t);
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int n = t.getTransitionUpto();
        t.setTransitionUpto(n + 1);
        t.setDest(this.transitions[n]);
        n = t.getTransitionUpto();
        t.setTransitionUpto(n + 1);
        t.setMin(this.transitions[n]);
        n = t.getTransitionUpto();
        t.setTransitionUpto(n + 1);
        t.setMax(this.transitions[n]);
    }

    private final boolean transitionSorted(Transition t) {
        int upto = t.getTransitionUpto();
        if (upto == this.states[2 * t.getSource()]) {
            return true;
        }
        int nextDest = this.transitions[upto];
        int nextMin = this.transitions[upto + 1];
        int nextMax = this.transitions[upto + 2];
        if (nextMin > t.getMin()) {
            return true;
        }
        if (nextMin < t.getMin()) {
            return false;
        }
        if (nextMax > t.getMax()) {
            return true;
        }
        if (nextMax < t.getMax()) {
            return false;
        }
        if (nextDest > t.getDest()) {
            return true;
        }
        if (nextDest < t.getDest()) {
            return false;
        }
        return false;
    }

    @Override
    public void getTransition(int state2, int index, @NotNull Transition t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        int i = this.states[2 * state2] + 3 * index;
        t.setSource(state2);
        t.setDest(this.transitions[i++]);
        t.setMin(this.transitions[i++]);
        t.setMax(this.transitions[i++]);
    }

    @NotNull
    public final String toDot() {
        StringBuilder b = new StringBuilder();
        b.append("digraph Automaton {\n");
        b.append("  rankdir = LR\n");
        b.append("  node [width=0.2, height=0.2, fontsize=8]\n");
        int numStates = this.getNumStates();
        if (numStates > 0) {
            b.append("  initial [shape=plaintext,label=\"\"]\n");
            b.append("  initial -> 0\n");
        }
        Transition t = new Transition();
        for (int state2 = 0; state2 < numStates; ++state2) {
            b.append("  ");
            b.append(state2);
            StringBuilder stringBuilder = this.isAccept(state2) ? b.append(" [shape=doublecircle,label=\"").append(state2).append("\"]\n") : b.append(" [shape=circle,label=\"").append(state2).append("\"]\n");
            int numTransitions = this.initTransition(state2, t);
            for (int i = 0; i < numTransitions; ++i) {
                this.getNextTransition(t);
                boolean condition$iv = t.getMax() >= t.getMin();
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                b.append("  ");
                b.append(state2);
                b.append(" -> ");
                b.append(t.getDest());
                b.append(" [label=\"");
                Companion.appendCharString(t.getMin(), b);
                if (t.getMax() != t.getMin()) {
                    b.append('-');
                    Companion.appendCharString(t.getMax(), b);
                }
                b.append("\"]\n");
            }
        }
        b.append('}');
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final int[] getStartPoints() {
        IntHashSet pointset = new IntHashSet();
        pointset.add(0);
        for (int s = 0; s < this.nextState; s += 2) {
            int trans;
            int limit = trans + 3 * this.states[s + 1];
            for (trans = this.states[s]; trans < limit; trans += 3) {
                int min = this.transitions[trans + 1];
                int max = this.transitions[trans + 2];
                pointset.add(min);
                if (max >= 0x10FFFF) continue;
                pointset.add(max + 1);
            }
        }
        int[] points2 = pointset.toArray();
        ArraysKt.sort((int[])points2);
        return points2;
    }

    public final int step(int state2, int label) {
        return this.next(state2, 0, label, null);
    }

    public final int next(@NotNull Transition transition, int label) {
        Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
        return this.next(transition.getSource(), transition.getTransitionUpto(), label, transition);
    }

    private final int next(int state2, int fromTransitionIndex, int label, Transition transition) {
        boolean condition$iv = state2 >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = label >= 0;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        int stateIndex = 2 * state2;
        int firstTransitionIndex = this.states[stateIndex];
        int numTransitions = this.states[stateIndex + 1];
        int low = Math.max(fromTransitionIndex, 0);
        int high = numTransitions - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int transitionIndex = firstTransitionIndex + 3 * mid;
            int minLabel = this.transitions[transitionIndex + 1];
            if (minLabel > label) {
                high = mid - 1;
                continue;
            }
            int maxLabel = this.transitions[transitionIndex + 2];
            if (maxLabel < label) {
                low = mid + 1;
                continue;
            }
            int destState = this.transitions[transitionIndex];
            if (transition != null) {
                transition.setDest(destState);
                transition.setMin(minLabel);
                transition.setMax(maxLabel);
                transition.setTransitionUpto(mid);
            }
            return destState;
        }
        int destState = -1;
        if (transition != null) {
            transition.setDest(destState);
            transition.setTransitionUpto(low);
        }
        return destState;
    }

    @Override
    public long ramBytesUsed() {
        return (long)8 + RamUsageEstimator.Companion.sizeOf(this.states) + RamUsageEstimator.Companion.sizeOf(this.transitions) + (long)8 + (long)(this.isAccept.size() / 8) + (long)4 + 8L + (long)12 + 1L;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public Automaton(int numStates) {
        this(numStates, 0, 2, null);
    }

    @JvmOverloads
    public Automaton() {
        this(0, 0, 3, null);
    }

    public static final /* synthetic */ int[] access$getTransitions$p(Automaton $this) {
        return $this.transitions;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0003J\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\n\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001aJ\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u001aR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/util/automaton/Automaton$Builder;", "", "numStates", "", "numTransitions", "<init>", "(II)V", "value", "getNumStates", "()I", "isAccept", "Lorg/gnit/lucenekmp/jdkport/BitSet;", "transitions", "", "nextTransition", "addTransition", "", "source", "dest", "label", "min", "max", "addEpsilon", "sorter", "Lorg/gnit/lucenekmp/util/Sorter;", "finish", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "createState", "setAccept", "state", "accept", "", "copy", "other", "copyStates", "core"})
    public static final class Builder {
        private int numStates;
        @NotNull
        private final BitSet isAccept;
        @NotNull
        private int[] transitions;
        private int nextTransition;
        @NotNull
        private final Sorter sorter;

        @JvmOverloads
        public Builder(int numStates, int numTransitions) {
            this.sorter = new InPlaceMergeSorter(this){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                }

                private final void swapOne(int i, int j) {
                    int x = Builder.access$getTransitions$p(this.this$0)[i];
                    Builder.access$getTransitions$p((Builder)this.this$0)[i] = Builder.access$getTransitions$p(this.this$0)[j];
                    Builder.access$getTransitions$p((Builder)this.this$0)[j] = x;
                }

                protected void swap(int i, int j) {
                    int iStart = 4 * i;
                    int jStart = 4 * j;
                    this.swapOne(iStart, jStart);
                    this.swapOne(iStart + 1, jStart + 1);
                    this.swapOne(iStart + 2, jStart + 2);
                    this.swapOne(iStart + 3, jStart + 3);
                }

                protected int compare(int i, int j) {
                    int jDest;
                    int jMax;
                    int jMin;
                    int jSrc;
                    int iStart = 4 * i;
                    int jStart = 4 * j;
                    int iSrc = Builder.access$getTransitions$p(this.this$0)[iStart];
                    if (iSrc < (jSrc = Builder.access$getTransitions$p(this.this$0)[jStart])) {
                        return -1;
                    }
                    if (iSrc > jSrc) {
                        return 1;
                    }
                    int iMin = Builder.access$getTransitions$p(this.this$0)[iStart + 2];
                    if (iMin < (jMin = Builder.access$getTransitions$p(this.this$0)[jStart + 2])) {
                        return -1;
                    }
                    if (iMin > jMin) {
                        return 1;
                    }
                    int iMax = Builder.access$getTransitions$p(this.this$0)[iStart + 3];
                    if (iMax < (jMax = Builder.access$getTransitions$p(this.this$0)[jStart + 3])) {
                        return -1;
                    }
                    if (iMax > jMax) {
                        return 1;
                    }
                    int iDest = Builder.access$getTransitions$p(this.this$0)[iStart + 1];
                    if (iDest < (jDest = Builder.access$getTransitions$p(this.this$0)[jStart + 1])) {
                        return -1;
                    }
                    if (iDest > jDest) {
                        return 1;
                    }
                    return 0;
                }
            };
            this.isAccept = new BitSet(numStates);
            this.transitions = new int[numTransitions * 4];
        }

        public /* synthetic */ Builder(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 16;
            }
            if ((n3 & 2) != 0) {
                n2 = 16;
            }
            this(n, n2);
        }

        public final int getNumStates() {
            return this.numStates;
        }

        public final void addTransition(int source, int dest, int label) {
            this.addTransition(source, dest, label, label);
        }

        public final void addTransition(int source, int dest, int min, int max) {
            if (this.transitions.length < this.nextTransition + 4) {
                this.transitions = ArrayUtil.Companion.grow(this.transitions, this.nextTransition + 4);
            }
            int n = this.nextTransition;
            this.nextTransition = n + 1;
            this.transitions[n] = source;
            n = this.nextTransition;
            this.nextTransition = n + 1;
            this.transitions[n] = dest;
            n = this.nextTransition;
            this.nextTransition = n + 1;
            this.transitions[n] = min;
            n = this.nextTransition;
            this.nextTransition = n + 1;
            this.transitions[n] = max;
        }

        public final void addEpsilon(int source, int dest) {
            for (int upto = 0; upto < this.nextTransition; upto += 4) {
                if (this.transitions[upto] != dest) continue;
                this.addTransition(source, this.transitions[upto + 1], this.transitions[upto + 2], this.transitions[upto + 3]);
            }
            if (this.isAccept(dest)) {
                this.setAccept(source, true);
            }
        }

        @NotNull
        public final Automaton finish() {
            int numStates = this.numStates;
            int numTransitions = this.nextTransition / 4;
            Automaton a = new Automaton(numStates, numTransitions);
            for (int state2 = 0; state2 < numStates; ++state2) {
                a.createState();
                a.setAccept(state2, this.isAccept(state2));
            }
            this.sorter.sort(0, numTransitions);
            for (int upto = 0; upto < this.nextTransition; upto += 4) {
                a.addTransition(this.transitions[upto], this.transitions[upto + 1], this.transitions[upto + 2], this.transitions[upto + 3]);
            }
            a.finishState();
            return a;
        }

        public final int createState() {
            int n = this.numStates;
            this.numStates = n + 1;
            return n;
        }

        public final void setAccept(int state2, boolean accept) {
            Objects.INSTANCE.checkIndex(state2, this.numStates);
            this.isAccept.set(state2, accept);
        }

        public final boolean isAccept(int state2) {
            return this.isAccept.get(state2);
        }

        public final void copy(@NotNull Automaton other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int offset = this.numStates;
            int otherNumStates = other.getNumStates();
            this.copyStates(other);
            Transition t = new Transition();
            for (int s = 0; s < otherNumStates; ++s) {
                int count = other.initTransition(s, t);
                for (int i = 0; i < count; ++i) {
                    other.getNextTransition(t);
                    this.addTransition(offset + s, offset + t.getDest(), t.getMin(), t.getMax());
                }
            }
        }

        public final void copyStates(@NotNull Automaton other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int otherNumStates = other.getNumStates();
            for (int s = 0; s < otherNumStates; ++s) {
                int newState = this.createState();
                this.setAccept(newState, other.isAccept(s));
            }
        }

        @JvmOverloads
        public Builder(int numStates) {
            this(numStates, 0, 2, null);
        }

        @JvmOverloads
        public Builder() {
            this(0, 0, 3, null);
        }

        public static final /* synthetic */ int[] access$getTransitions$p(Builder $this) {
            return $this.transitions;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/util/automaton/Automaton$Companion;", "", "<init>", "()V", "appendCharString", "", "c", "", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void appendCharString(int c, @NotNull StringBuilder b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (c >= 33 && c <= 126 && c != 92 && c != 34) {
                v0 = b.appendCodePoint(c);
            } else {
                b.append("\\\\U");
                String s = HexExtensionsKt.toHexString$default((int)c, null, (int)1, null);
                v0 = c < 16 ? b.append("0000000").append(s) : (c < 256 ? b.append("000000").append(s) : (c < 4096 ? b.append("00000").append(s) : (c < 65536 ? b.append("0000").append(s) : (c < 0x100000 ? b.append("000").append(s) : (c < 0x1000000 ? b.append("00").append(s) : (c < 0x10000000 ? b.append("0").append(s) : b.append(s)))))));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

