/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b&\u0018\u0000 +2\u00020\u0001:\u0001+B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005J\u0016\u0010$\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005J\b\u0010%\u001a\u00020\u0005H\u0016J\u0013\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0013\u0010 \u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0016\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/util/automaton/RunAutomaton;", "Lorg/gnit/lucenekmp/util/Accountable;", "a", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "alphabetSize", "", "<init>", "(Lorg/gnit/lucenekmp/util/automaton/Automaton;I)V", "automaton", "getAutomaton", "()Lorg/gnit/lucenekmp/util/automaton/Automaton;", "getAlphabetSize", "()I", "size", "getSize", "accept", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "getAccept", "()Lorg/gnit/lucenekmp/util/FixedBitSet;", "transitions", "", "getTransitions", "()[I", "points", "getPoints", "classmap", "getClassmap", "toString", "", "isAccept", "", "state", "charIntervals", "getCharIntervals", "getCharClass", "c", "step", "hashCode", "equals", "obj", "", "ramBytesUsed", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nRunAutomaton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunAutomaton.kt\norg/gnit/lucenekmp/util/automaton/RunAutomaton\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public abstract class RunAutomaton
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Automaton automaton;
    private final int alphabetSize;
    private final int size;
    @NotNull
    private final FixedBitSet accept;
    @NotNull
    private final int[] transitions;
    @NotNull
    private final int[] points;
    @NotNull
    private final int[] classmap;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(RunAutomaton.class));

    protected RunAutomaton(@NotNull Automaton a, int alphabetSize) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this.alphabetSize = alphabetSize;
        if (!a.isDeterministic()) {
            boolean $i$a$-require-RunAutomaton$22 = false;
            String $i$a$-require-RunAutomaton$22 = "Automaton must be deterministic";
            throw new IllegalArgumentException($i$a$-require-RunAutomaton$22.toString());
        }
        this.automaton = a;
        this.points = a.getStartPoints();
        this.size = Math.max(1, a.getNumStates());
        this.accept = new FixedBitSet(this.size);
        this.transitions = new int[this.size * this.points.length];
        ArraysKt.fill$default((int[])this.transitions, (int)-1, (int)0, (int)0, (int)6, null);
        Transition transition = new Transition();
        int n = this.size;
        for (int n2 = 0; n2 < n; ++n2) {
            if (a.isAccept(n2)) {
                this.accept.set(n2);
            }
            transition.setSource(n2);
            transition.setTransitionUpto(-1);
            int n3 = this.points.length;
            for (int c = 0; c < n3; ++c) {
                int dest = a.next(transition, this.points[c]);
                if (!(dest == -1 || dest < this.size)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.transitions[n2 * this.points.length + c] = dest;
            }
        }
        this.classmap = new int[Math.min(256, alphabetSize)];
        int i = 0;
        int n4 = this.classmap.length;
        for (int j = 0; j < n4; ++j) {
            if (i + 1 >= this.points.length || j == this.points[i + 1]) {
                // empty if block
            }
            this.classmap[j] = ++i;
        }
    }

    @NotNull
    public final Automaton getAutomaton() {
        return this.automaton;
    }

    public final int getAlphabetSize() {
        return this.alphabetSize;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final FixedBitSet getAccept() {
        return this.accept;
    }

    @NotNull
    public final int[] getTransitions() {
        return this.transitions;
    }

    @NotNull
    public final int[] getPoints() {
        return this.points;
    }

    @NotNull
    public final int[] getClassmap() {
        return this.classmap;
    }

    @NotNull
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("initial state: 0\n");
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            b.append("state ").append(i);
            StringBuilder stringBuilder = this.accept.get(i) ? b.append(" [accept]:\n") : b.append(" [reject]:\n");
            int n2 = this.points.length;
            for (int j = 0; j < n2; ++j) {
                int k = this.transitions[i * this.points.length + j];
                if (k == -1) continue;
                int min = this.points[j];
                int max = 0;
                max = j + 1 < this.points.length ? this.points[j + 1] - 1 : this.alphabetSize;
                b.append(" ");
                Automaton.Companion.appendCharString(min, b);
                if (min != max) {
                    b.append("-");
                    Automaton.Companion.appendCharString(max, b);
                }
                b.append(" -> ").append(k).append("\n");
            }
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean isAccept(int state2) {
        return this.accept.get(state2);
    }

    @Nullable
    public final int[] getCharIntervals() {
        int[] nArray = Arrays.copyOf(this.points, this.points.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        return nArray;
    }

    public final int getCharClass(int c) {
        int a = 0;
        int b = this.points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (this.points[d] > c) {
                b = d;
                continue;
            }
            if (this.points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    public final int step(int state2, int c) {
        if (!(c < this.alphabetSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (c >= this.classmap.length) {
            return this.transitions[state2 * this.points.length + this.getCharClass(c)];
        }
        return this.transitions[state2 * this.points.length + this.classmap[c]];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.alphabetSize;
        result = prime * result + this.points.length;
        result = prime * result + this.size;
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunAutomaton other = (RunAutomaton)obj;
        if (this.alphabetSize != other.alphabetSize) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (!Arrays.equals(this.points, other.points)) {
            return false;
        }
        if (!this.accept.equals(other.accept)) {
            return false;
        }
        return Arrays.equals(this.transitions, other.transitions);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + this.accept.ramBytesUsed() + RamUsageEstimator.Companion.sizeOfObject(this.automaton) + RamUsageEstimator.Companion.sizeOfObject(this.classmap) + RamUsageEstimator.Companion.sizeOfObject(this.points) + RamUsageEstimator.Companion.sizeOfObject(this.transitions);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/automaton/RunAutomaton$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

