/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.automaton;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.IntCursor;
import org.gnit.lucenekmp.internal.hppc.IntIntHashMap;
import org.gnit.lucenekmp.util.automaton.FrozenIntSet;
import org.gnit.lucenekmp.util.automaton.IntSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/util/automaton/StateSet;", "Lorg/gnit/lucenekmp/util/automaton/IntSet;", "capacity", "", "<init>", "(I)V", "inner", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;", "hashCode", "", "hashUpdated", "", "arrayUpdated", "arrayCache", "", "incr", "", "state", "decr", "reset", "freeze", "Lorg/gnit/lucenekmp/util/automaton/FrozenIntSet;", "keyChanged", "array", "getArray", "()[I", "size", "longHashCode", "core"})
public final class StateSet
extends IntSet {
    @NotNull
    private final IntIntHashMap inner;
    private long hashCode;
    private boolean hashUpdated = true;
    private boolean arrayUpdated = true;
    @NotNull
    private int[] arrayCache = new int[0];

    public StateSet(int capacity) {
        this.inner = new IntIntHashMap(capacity, 0.0, 2, null);
    }

    public final void incr(int state2) {
        if (this.inner.addTo(state2, 1) == 1) {
            this.keyChanged();
        }
    }

    public final void decr(int state2) {
        if (!this.inner.containsKey(state2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int keyIndex = this.inner.indexOf(state2);
        int count = this.inner.indexGet(keyIndex) - 1;
        if (count == 0) {
            this.inner.indexRemove(keyIndex);
            this.keyChanged();
        } else {
            this.inner.indexReplace(keyIndex, count);
        }
    }

    public final void reset() {
        this.inner.clear();
        this.keyChanged();
    }

    @NotNull
    public final FrozenIntSet freeze(int state2) {
        return new FrozenIntSet(this.getArray(), this.longHashCode(), state2);
    }

    private final void keyChanged() {
        this.hashUpdated = false;
        this.arrayUpdated = false;
    }

    @Override
    @NotNull
    public int[] getArray() {
        if (this.arrayUpdated) {
            return this.arrayCache;
        }
        this.arrayCache = new int[this.inner.size()];
        int i = 0;
        for (IntCursor key : this.inner.keys()) {
            this.arrayCache[i++] = key.getValue();
        }
        ArraysKt.sort((int[])this.arrayCache);
        this.arrayUpdated = true;
        return this.arrayCache;
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public long longHashCode() {
        if (this.hashUpdated) {
            return this.hashCode;
        }
        this.hashCode = this.inner.size();
        for (IntCursor key : this.inner.keys()) {
            this.hashCode += (long)BitMixer.INSTANCE.mix(key.getValue());
        }
        this.hashUpdated = true;
        return this.hashCode;
    }
}

