/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "", "numDims", "", "numIndexDims", "bytesPerDim", "maxPointsInLeafNode", "<init>", "(IIII)V", "getNumDims", "()I", "getNumIndexDims", "getBytesPerDim", "getMaxPointsInLeafNode", "packedBytesLength", "packedIndexBytesLength", "bytesPerDoc", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBKDConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BKDConfig.kt\norg/gnit/lucenekmp/util/bkd/BKDConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class BKDConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int numDims;
    private final int numIndexDims;
    private final int bytesPerDim;
    private final int maxPointsInLeafNode;
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 512;
    public static final int MAX_DIMS = 16;
    public static final int MAX_INDEX_DIMS = 8;

    public BKDConfig(int numDims, int numIndexDims, int bytesPerDim, int maxPointsInLeafNode) {
        this.numDims = numDims;
        this.numIndexDims = numIndexDims;
        this.bytesPerDim = bytesPerDim;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        if (!(this.numDims >= 1 && this.numDims <= 16)) {
            boolean $i$a$-require-BKDConfig$72 = false;
            String $i$a$-require-BKDConfig$72 = "numDims must be 1 .. 16 (got: " + this.numDims + ")";
            throw new IllegalArgumentException($i$a$-require-BKDConfig$72.toString());
        }
        if (!(this.numIndexDims >= 1 && this.numIndexDims <= 8)) {
            boolean $i$a$-require-BKDConfig$82 = false;
            String $i$a$-require-BKDConfig$82 = "numIndexDims must be 1 .. 8 (got: " + this.numIndexDims + ")";
            throw new IllegalArgumentException($i$a$-require-BKDConfig$82.toString());
        }
        if (!(this.numIndexDims <= this.numDims)) {
            boolean $i$a$-require-BKDConfig$92 = false;
            String $i$a$-require-BKDConfig$92 = "numIndexDims cannot exceed numDims (" + this.numDims + ") (got: " + this.numIndexDims + ")";
            throw new IllegalArgumentException($i$a$-require-BKDConfig$92.toString());
        }
        if (!(this.bytesPerDim > 0)) {
            boolean $i$a$-require-BKDConfig$102 = false;
            String $i$a$-require-BKDConfig$102 = "bytesPerDim must be > 0; got " + this.bytesPerDim;
            throw new IllegalArgumentException($i$a$-require-BKDConfig$102.toString());
        }
        if (!(this.maxPointsInLeafNode > 0)) {
            boolean $i$a$-require-BKDConfig$112 = false;
            String $i$a$-require-BKDConfig$112 = "maxPointsInLeafNode must be > 0; got " + this.maxPointsInLeafNode;
            throw new IllegalArgumentException($i$a$-require-BKDConfig$112.toString());
        }
        if (!(this.maxPointsInLeafNode <= ArrayUtil.Companion.getMAX_ARRAY_LENGTH())) {
            boolean bl = false;
            String string = "maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.Companion.getMAX_ARRAY_LENGTH() + "); got " + this.maxPointsInLeafNode;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getNumDims() {
        return this.numDims;
    }

    public final int getNumIndexDims() {
        return this.numIndexDims;
    }

    public final int getBytesPerDim() {
        return this.bytesPerDim;
    }

    public final int getMaxPointsInLeafNode() {
        return this.maxPointsInLeafNode;
    }

    public final int packedBytesLength() {
        return this.numDims * this.bytesPerDim;
    }

    public final int packedIndexBytesLength() {
        return this.numIndexDims * this.bytesPerDim;
    }

    public final int bytesPerDoc() {
        return this.packedBytesLength() + 4;
    }

    public final int component1() {
        return this.numDims;
    }

    public final int component2() {
        return this.numIndexDims;
    }

    public final int component3() {
        return this.bytesPerDim;
    }

    public final int component4() {
        return this.maxPointsInLeafNode;
    }

    @NotNull
    public final BKDConfig copy(int numDims, int numIndexDims, int bytesPerDim, int maxPointsInLeafNode) {
        return new BKDConfig(numDims, numIndexDims, bytesPerDim, maxPointsInLeafNode);
    }

    public static /* synthetic */ BKDConfig copy$default(BKDConfig bKDConfig, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = bKDConfig.numDims;
        }
        if ((n5 & 2) != 0) {
            n2 = bKDConfig.numIndexDims;
        }
        if ((n5 & 4) != 0) {
            n3 = bKDConfig.bytesPerDim;
        }
        if ((n5 & 8) != 0) {
            n4 = bKDConfig.maxPointsInLeafNode;
        }
        return bKDConfig.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "BKDConfig(numDims=" + this.numDims + ", numIndexDims=" + this.numIndexDims + ", bytesPerDim=" + this.bytesPerDim + ", maxPointsInLeafNode=" + this.maxPointsInLeafNode + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.numDims);
        result = result * 31 + Integer.hashCode(this.numIndexDims);
        result = result * 31 + Integer.hashCode(this.bytesPerDim);
        result = result * 31 + Integer.hashCode(this.maxPointsInLeafNode);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BKDConfig)) {
            return false;
        }
        BKDConfig bKDConfig = (BKDConfig)other;
        if (this.numDims != bKDConfig.numDims) {
            return false;
        }
        if (this.numIndexDims != bKDConfig.numIndexDims) {
            return false;
        }
        if (this.bytesPerDim != bKDConfig.bytesPerDim) {
            return false;
        }
        return this.maxPointsInLeafNode == bKDConfig.maxPointsInLeafNode;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDConfig$Companion;", "", "<init>", "()V", "DEFAULT_MAX_POINTS_IN_LEAF_NODE", "", "MAX_DIMS", "MAX_INDEX_DIMS", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

