/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IntroSelector;
import org.gnit.lucenekmp.util.IntroSorter;
import org.gnit.lucenekmp.util.MSBRadixSorter;
import org.gnit.lucenekmp.util.RadixSelector;
import org.gnit.lucenekmp.util.Selector;
import org.gnit.lucenekmp.util.Sorter;
import org.gnit.lucenekmp.util.bkd.BKDConfig;
import org.gnit.lucenekmp.util.bkd.HeapPointWriter;
import org.gnit.lucenekmp.util.bkd.OfflinePointReader;
import org.gnit.lucenekmp.util.bkd.OfflinePointWriter;
import org.gnit.lucenekmp.util.bkd.PointValue;
import org.gnit.lucenekmp.util.bkd.PointWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 A2\u00020\u0001:\u0002@AB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJK\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aJ0\u0010\"\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J \u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0002JP\u0010)\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002JR\u0010/\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u00010+2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u001aH\u0002J\b\u00103\u001a\u00020\u0010H\u0002JH\u00104\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u0002052\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005H\u0002J8\u00107\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0002J.\u00109\u001a\u00020!2\u0006\u0010\u0015\u001a\u0002052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005J(\u0010:\u001a\u00020+2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0005H\u0002J\u0018\u0010<\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J\u0016\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDRadixSelector;", "", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "maxPointsSortInHeap", "", "tempDir", "Lorg/gnit/lucenekmp/store/Directory;", "tempFileNamePrefix", "", "<init>", "(Lorg/gnit/lucenekmp/util/bkd/BKDConfig;ILorg/gnit/lucenekmp/store/Directory;Ljava/lang/String;)V", "histogram", "", "bytesSorted", "offlineBuffer", "", "partitionBucket", "", "scratch", "select", "points", "Lorg/gnit/lucenekmp/util/bkd/BKDRadixSelector$PathSlice;", "partitionSlices", "", "from", "", "to", "partitionPoint", "dim", "dimCommonPrefix", "(Lorg/gnit/lucenekmp/util/bkd/BKDRadixSelector$PathSlice;[Lorg/gnit/lucenekmp/util/bkd/BKDRadixSelector$PathSlice;JJJII)[B", "checkArgs", "", "findCommonPrefixAndHistogram", "Lorg/gnit/lucenekmp/util/bkd/OfflinePointWriter;", "getBucket", "offset", "commonPrefixPosition", "pointValue", "Lorg/gnit/lucenekmp/util/bkd/PointValue;", "buildHistogramAndPartition", "left", "Lorg/gnit/lucenekmp/util/bkd/PointWriter;", "right", "iteration", "baseCommonPrefix", "offlinePartition", "deltaPoints", "bytePosition", "numDocsTiebreak", "partitionPointFromCommonPrefix", "heapPartition", "Lorg/gnit/lucenekmp/util/bkd/HeapPointWriter;", "commonPrefix", "heapRadixSelect", "commonPrefixLength", "heapRadixSort", "getDeltaPointWriter", "delta", "getMaxPointsSortInHeap", "getPointWriter", "count", "desc", "PathSlice", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBKDRadixSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BKDRadixSelector.kt\norg/gnit/lucenekmp/util/bkd/BKDRadixSelector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,581:1\n1#2:582\n*E\n"})
public final class BKDRadixSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BKDConfig config;
    private int maxPointsSortInHeap;
    @NotNull
    private final long[] histogram;
    private final int bytesSorted;
    @NotNull
    private final byte[] offlineBuffer;
    @NotNull
    private final int[] partitionBucket;
    @NotNull
    private final byte[] scratch;
    @NotNull
    private final Directory tempDir;
    @NotNull
    private final String tempFileNamePrefix;
    private static final int HISTOGRAM_SIZE = 256;
    private static final int MAX_SIZE_OFFLINE_BUFFER = 8192;

    public BKDRadixSelector(@NotNull BKDConfig config, int maxPointsSortInHeap, @NotNull Directory tempDir, @NotNull String tempFileNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)tempFileNamePrefix, (String)"tempFileNamePrefix");
        this.config = config;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
        this.maxPointsSortInHeap = this.maxPointsSortInHeap;
        this.tempDir = tempDir;
        this.tempFileNamePrefix = tempFileNamePrefix;
        this.bytesSorted = this.config.getBytesPerDim() + (this.config.getNumDims() - this.config.getNumIndexDims()) * this.config.getBytesPerDim() + 4;
        int numberOfPointsOffline = 8192 / this.config.bytesPerDoc();
        this.offlineBuffer = new byte[numberOfPointsOffline * this.config.bytesPerDoc()];
        this.partitionBucket = new int[this.bytesSorted];
        this.histogram = new long[256];
        this.scratch = new byte[this.bytesSorted];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] select(@NotNull PathSlice points2, @NotNull PathSlice[] partitionSlices, long from, long to, long partitionPoint, int dim, int dimCommonPrefix) throws IOException {
        Intrinsics.checkNotNullParameter((Object)points2, (String)"points");
        Intrinsics.checkNotNullParameter((Object)partitionSlices, (String)"partitionSlices");
        this.checkArgs(from, to, partitionPoint);
        if (!(partitionSlices.length > 1)) {
            boolean bl = false;
            String string = "[partition alices] must be > 1, got " + partitionSlices.length;
            throw new IllegalArgumentException(string.toString());
        }
        if (points2.getWriter() instanceof HeapPointWriter) {
            byte[] partition2 = this.heapRadixSelect((HeapPointWriter)points2.getWriter(), dim, Math.INSTANCE.toIntExact(from), Math.INSTANCE.toIntExact(to), Math.INSTANCE.toIntExact(partitionPoint), dimCommonPrefix);
            partitionSlices[0] = new PathSlice(points2.getWriter(), from, partitionPoint - from);
            partitionSlices[1] = new PathSlice(points2.getWriter(), partitionPoint, to - partitionPoint);
            return partition2;
        }
        PointWriter pointWriter = points2.getWriter();
        Intrinsics.checkNotNull((Object)pointWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.bkd.OfflinePointWriter");
        OfflinePointWriter offlinePointWriter = (OfflinePointWriter)pointWriter;
        AutoCloseable autoCloseable = this.getPointWriter(partitionPoint - from, "left" + dim);
        Throwable throwable = null;
        try {
            byte[] byArray;
            PointWriter left = (PointWriter)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = this.getPointWriter(to - partitionPoint, "right" + dim);
            Throwable throwable2 = null;
            try {
                PointWriter right = (PointWriter)autoCloseable2;
                boolean bl2 = false;
                partitionSlices[0] = new PathSlice(left, 0L, partitionPoint - from);
                partitionSlices[1] = new PathSlice(right, 0L, to - partitionPoint);
                byArray = this.buildHistogramAndPartition(offlinePointWriter, left, right, from, to, partitionPoint, 0, dimCommonPrefix, dim);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void checkArgs(long from, long to, long partitionPoint) {
        if (!(partitionPoint >= from)) {
            boolean $i$a$-require-BKDRadixSelector$checkArgs$32 = false;
            String $i$a$-require-BKDRadixSelector$checkArgs$32 = "partitionPoint must be >= from";
            throw new IllegalArgumentException($i$a$-require-BKDRadixSelector$checkArgs$32.toString());
        }
        if (!(partitionPoint < to)) {
            boolean bl = false;
            String string = "partitionPoint must be < to";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int findCommonPrefixAndHistogram(OfflinePointWriter points2, long from, long to, int dim, int dimCommonPrefix) throws IOException {
        int commonPrefixPosition = 0;
        commonPrefixPosition = this.bytesSorted;
        int offset = dim * this.config.getBytesPerDim();
        AutoCloseable autoCloseable = points2.getReader(from, to - from, this.offlineBuffer);
        Throwable throwable = null;
        try {
            OfflinePointReader reader2 = (OfflinePointReader)autoCloseable;
            boolean bl = false;
            if (!(commonPrefixPosition > dimCommonPrefix)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            reader2.next();
            PointValue pointValue = reader2.pointValue();
            BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
            System.INSTANCE.arraycopy(packedValueDocID.getBytes(), packedValueDocID.getOffset() + offset, this.scratch, 0, this.config.getBytesPerDim());
            System.INSTANCE.arraycopy(packedValueDocID.getBytes(), packedValueDocID.getOffset() + this.config.packedIndexBytesLength(), this.scratch, this.config.getBytesPerDim(), (this.config.getNumDims() - this.config.getNumIndexDims()) * this.config.getBytesPerDim() + 4);
            for (long i = from + 1L; i < to; ++i) {
                int endIndex;
                reader2.next();
                pointValue = reader2.pointValue();
                if (commonPrefixPosition == dimCommonPrefix) {
                    long[] lArray = this.histogram;
                    int n = this.getBucket(offset, commonPrefixPosition, pointValue);
                    long l = lArray[n];
                    lArray[n] = l + 1L;
                    for (long j = i + 1L; j < to; ++j) {
                        reader2.next();
                        pointValue = reader2.pointValue();
                        long[] lArray2 = this.histogram;
                        int n2 = this.getBucket(offset, commonPrefixPosition, pointValue);
                        long l2 = lArray2[n2];
                        lArray2[n2] = l2 + 1L;
                    }
                    break;
                }
                int startIndex = java.lang.Math.min(dimCommonPrefix, this.config.getBytesPerDim());
                int j = Arrays.INSTANCE.mismatch(this.scratch, startIndex, endIndex = java.lang.Math.min(commonPrefixPosition, this.config.getBytesPerDim()), (packedValueDocID = pointValue.packedValueDocIDBytes()).getBytes(), packedValueDocID.getOffset() + offset + startIndex, packedValueDocID.getOffset() + offset + endIndex);
                if (j == -1) {
                    if (commonPrefixPosition > this.config.getBytesPerDim()) {
                        int startTieBreak = this.config.packedIndexBytesLength();
                        int endTieBreak = startTieBreak + commonPrefixPosition - this.config.getBytesPerDim();
                        int k = Arrays.INSTANCE.mismatch(this.scratch, this.config.getBytesPerDim(), commonPrefixPosition, packedValueDocID.getBytes(), packedValueDocID.getOffset() + startTieBreak, packedValueDocID.getOffset() + endTieBreak);
                        if (k != -1) {
                            commonPrefixPosition = this.config.getBytesPerDim() + k;
                            Arrays.INSTANCE.fill(this.histogram, 0L);
                            this.histogram[this.scratch[commonPrefixPosition] & 0xFF] = i - from;
                        }
                    }
                } else {
                    commonPrefixPosition = dimCommonPrefix + j;
                    Arrays.INSTANCE.fill(this.histogram, 0L);
                    this.histogram[this.scratch[commonPrefixPosition] & 0xFF] = i - from;
                }
                if (commonPrefixPosition == this.bytesSorted) continue;
                long[] lArray = this.histogram;
                int n = this.getBucket(offset, commonPrefixPosition, pointValue);
                long l = lArray[n];
                lArray[n] = l + 1L;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        int n = commonPrefixPosition;
        for (int i = 0; i < n; ++i) {
            this.partitionBucket[i] = this.scratch[i] & 0xFF;
        }
        return commonPrefixPosition;
    }

    private final int getBucket(int offset, int commonPrefixPosition, PointValue pointValue) {
        int bucket = 0;
        if (commonPrefixPosition < this.config.getBytesPerDim()) {
            BytesRef packedValue = pointValue.packedValue();
            bucket = packedValue.getBytes()[packedValue.getOffset() + offset + commonPrefixPosition] & 0xFF;
        } else {
            BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
            bucket = packedValueDocID.getBytes()[packedValueDocID.getOffset() + this.config.packedIndexBytesLength() + commonPrefixPosition - this.config.getBytesPerDim()] & 0xFF;
        }
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] buildHistogramAndPartition(OfflinePointWriter points2, PointWriter left, PointWriter right, long from, long to, long partitionPoint, int iteration, int baseCommonPrefix, int dim) throws IOException {
        int i;
        int iteration2 = iteration;
        int commonPrefix = 0;
        commonPrefix = this.findCommonPrefixAndHistogram(points2, from, to, dim, baseCommonPrefix);
        if (commonPrefix == this.bytesSorted) {
            this.offlinePartition(points2, left, right, null, from, to, dim, commonPrefix - 1, partitionPoint);
            return this.partitionPointFromCommonPrefix();
        }
        long leftCount = 0L;
        long rightCount = 0L;
        for (i = 0; i < 256; ++i) {
            long size2 = this.histogram[i];
            if (leftCount + size2 > partitionPoint - from) {
                this.partitionBucket[commonPrefix] = i;
                break;
            }
            leftCount += size2;
        }
        for (i = this.partitionBucket[commonPrefix] + 1; i < 256; ++i) {
            rightCount += this.histogram[i];
        }
        long delta = this.histogram[this.partitionBucket[commonPrefix]];
        if (!(leftCount + rightCount + delta == to - from)) {
            boolean $i$a$-require-BKDRadixSelector$buildHistogramAndPartition$22 = false;
            String $i$a$-require-BKDRadixSelector$buildHistogramAndPartition$22 = leftCount + rightCount + delta + " / " + (to - from);
            throw new IllegalArgumentException($i$a$-require-BKDRadixSelector$buildHistogramAndPartition$22.toString());
        }
        if (commonPrefix == this.bytesSorted - 1) {
            long tieBreakCount = partitionPoint - from - leftCount;
            this.offlinePartition(points2, left, right, null, from, to, dim, commonPrefix, tieBreakCount);
            return this.partitionPointFromCommonPrefix();
        }
        PointWriter deltaPoints = null;
        AutoCloseable $i$a$-require-BKDRadixSelector$buildHistogramAndPartition$22 = this.getDeltaPointWriter(left, right, delta, iteration2);
        Throwable throwable = null;
        try {
            PointWriter tempDeltaPoints = (PointWriter)$i$a$-require-BKDRadixSelector$buildHistogramAndPartition$22;
            boolean bl = false;
            this.offlinePartition(points2, left, right, tempDeltaPoints, from, to, dim, commonPrefix, 0L);
            deltaPoints = tempDeltaPoints;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$i$a$-require-BKDRadixSelector$buildHistogramAndPartition$22, (Throwable)throwable);
        }
        long newPartitionPoint = partitionPoint - from - leftCount;
        if (deltaPoints instanceof HeapPointWriter) {
            return this.heapPartition((HeapPointWriter)deltaPoints, left, right, dim, 0, (int)((HeapPointWriter)deltaPoints).count(), Math.INSTANCE.toIntExact(newPartitionPoint), ++commonPrefix);
        }
        PointWriter pointWriter = deltaPoints;
        Intrinsics.checkNotNull((Object)pointWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.bkd.OfflinePointWriter");
        return this.buildHistogramAndPartition((OfflinePointWriter)pointWriter, left, right, 0L, ((OfflinePointWriter)deltaPoints).count(), newPartitionPoint, ++iteration2, ++commonPrefix, dim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void offlinePartition(OfflinePointWriter points2, PointWriter left, PointWriter right, PointWriter deltaPoints, long from, long to, int dim, int bytePosition, long numDocsTiebreak) throws IOException {
        if (!(bytePosition == this.bytesSorted - 1 || deltaPoints != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int offset = dim * this.config.getBytesPerDim();
        long tiebreakCounter = 0L;
        AutoCloseable autoCloseable = points2.getReader(from, to - from, this.offlineBuffer);
        Throwable throwable = null;
        try {
            OfflinePointReader reader2 = (OfflinePointReader)autoCloseable;
            boolean bl = false;
            while (reader2.next()) {
                PointValue pointValue = reader2.pointValue();
                int bucket = this.getBucket(offset, bytePosition, pointValue);
                if (bucket < this.partitionBucket[bytePosition]) {
                    left.append(pointValue);
                    continue;
                }
                if (bucket > this.partitionBucket[bytePosition]) {
                    right.append(pointValue);
                    continue;
                }
                if (bytePosition == this.bytesSorted - 1) {
                    if (tiebreakCounter < numDocsTiebreak) {
                        left.append(pointValue);
                        long l = tiebreakCounter;
                        tiebreakCounter = l + 1L;
                        continue;
                    }
                    right.append(pointValue);
                    continue;
                }
                PointWriter pointWriter = deltaPoints;
                if (pointWriter == null) continue;
                pointWriter.append(pointValue);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        points2.destroy();
    }

    private final byte[] partitionPointFromCommonPrefix() {
        byte[] partition2 = new byte[this.config.getBytesPerDim()];
        int n = this.config.getBytesPerDim();
        for (int i = 0; i < n; ++i) {
            partition2[i] = (byte)this.partitionBucket[i];
        }
        return partition2;
    }

    private final byte[] heapPartition(HeapPointWriter points2, PointWriter left, PointWriter right, int dim, int from, int to, int partitionPoint, int commonPrefix) throws IOException {
        byte[] partition2 = this.heapRadixSelect(points2, dim, from, to, partitionPoint, commonPrefix);
        for (int i = from; i < to; ++i) {
            PointValue value = points2.getPackedValueSlice(i);
            if (i < partitionPoint) {
                PointValue pointValue = value;
                Intrinsics.checkNotNull((Object)pointValue);
                left.append(pointValue);
                continue;
            }
            PointValue pointValue = value;
            Intrinsics.checkNotNull((Object)pointValue);
            right.append(pointValue);
        }
        return partition2;
    }

    private final byte[] heapRadixSelect(HeapPointWriter points2, int dim, int from, int to, int partitionPoint, int commonPrefixLength) {
        PointValue pointValue;
        int dimOffset = dim * this.config.getBytesPerDim() + commonPrefixLength;
        int dimCmpBytes = this.config.getBytesPerDim() - commonPrefixLength;
        int dataOffset = this.config.packedIndexBytesLength() - dimCmpBytes;
        int n = this.bytesSorted - commonPrefixLength;
        new RadixSelector(points2, dimCmpBytes, dimOffset, dataOffset, commonPrefixLength, dim, this, n){
            final /* synthetic */ HeapPointWriter $points;
            final /* synthetic */ int $dimCmpBytes;
            final /* synthetic */ int $dimOffset;
            final /* synthetic */ int $dataOffset;
            final /* synthetic */ int $commonPrefixLength;
            final /* synthetic */ int $dim;
            final /* synthetic */ BKDRadixSelector this$0;
            {
                this.$points = $points;
                this.$dimCmpBytes = $dimCmpBytes;
                this.$dimOffset = $dimOffset;
                this.$dataOffset = $dataOffset;
                this.$commonPrefixLength = $commonPrefixLength;
                this.$dim = $dim;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void swap(int i, int j) {
                this.$points.swap(i, j);
            }

            protected int byteAt(int i, int k) {
                if (!(k >= 0)) {
                    boolean bl = false;
                    String string = "negative prefix " + k;
                    throw new IllegalArgumentException(string.toString());
                }
                return this.$points.byteAt(i, k < this.$dimCmpBytes ? this.$dimOffset + k : this.$dataOffset + k) & 0xFF;
            }

            protected Selector getFallbackSelector(int d) {
                int skypedBytes = d + this.$commonPrefixLength;
                int dimStart = this.$dim * BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim();
                return new IntroSelector(this.$points, skypedBytes, this.this$0, dimStart){
                    final /* synthetic */ HeapPointWriter $points;
                    final /* synthetic */ int $skypedBytes;
                    final /* synthetic */ BKDRadixSelector this$0;
                    final /* synthetic */ int $dimStart;
                    {
                        this.$points = $points;
                        this.$skypedBytes = $skypedBytes;
                        this.this$0 = $receiver;
                        this.$dimStart = $dimStart;
                    }

                    protected void swap(int i, int j) {
                        this.$points.swap(i, j);
                    }

                    protected void setPivot(int i) {
                        if (this.$skypedBytes < BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim()) {
                            this.$points.copyDim(i, this.$dimStart, BKDRadixSelector.access$getScratch$p(this.this$0), 0);
                        }
                        this.$points.copyDataDimsAndDoc(i, BKDRadixSelector.access$getScratch$p(this.this$0), BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim());
                    }

                    protected int compare(int i, int j) {
                        int cmp;
                        if (this.$skypedBytes < BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim() && (cmp = this.$points.compareDim(i, j, this.$dimStart)) != 0) {
                            return cmp;
                        }
                        return this.$points.compareDataDimsAndDoc(i, j);
                    }

                    protected int comparePivot(int j) {
                        int cmp;
                        if (this.$skypedBytes < BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim() && (cmp = this.$points.compareDim(j, BKDRadixSelector.access$getScratch$p(this.this$0), 0, this.$dimStart)) != 0) {
                            return cmp;
                        }
                        return this.$points.compareDataDimsAndDoc(j, BKDRadixSelector.access$getScratch$p(this.this$0), BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim());
                    }
                };
            }
        }.select(from, to, partitionPoint);
        byte[] partition2 = new byte[this.config.getBytesPerDim()];
        PointValue pointValue2 = pointValue = points2.getPackedValueSlice(partitionPoint);
        Intrinsics.checkNotNull((Object)pointValue2);
        BytesRef packedValue = pointValue2.packedValue();
        System.INSTANCE.arraycopy(packedValue.getBytes(), packedValue.getOffset() + dim * this.config.getBytesPerDim(), partition2, 0, this.config.getBytesPerDim());
        return partition2;
    }

    public final void heapRadixSort(@NotNull HeapPointWriter points2, int from, int to, int dim, int commonPrefixLength) {
        Intrinsics.checkNotNullParameter((Object)points2, (String)"points");
        int dimOffset = dim * this.config.getBytesPerDim() + commonPrefixLength;
        int dimCmpBytes = this.config.getBytesPerDim() - commonPrefixLength;
        int dataOffset = this.config.packedIndexBytesLength() - dimCmpBytes;
        int n = this.bytesSorted - commonPrefixLength;
        new MSBRadixSorter(points2, dimCmpBytes, dimOffset, dataOffset, commonPrefixLength, dim, this, n){
            final /* synthetic */ HeapPointWriter $points;
            final /* synthetic */ int $dimCmpBytes;
            final /* synthetic */ int $dimOffset;
            final /* synthetic */ int $dataOffset;
            final /* synthetic */ int $commonPrefixLength;
            final /* synthetic */ int $dim;
            final /* synthetic */ BKDRadixSelector this$0;
            {
                this.$points = $points;
                this.$dimCmpBytes = $dimCmpBytes;
                this.$dimOffset = $dimOffset;
                this.$dataOffset = $dataOffset;
                this.$commonPrefixLength = $commonPrefixLength;
                this.$dim = $dim;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected int byteAt(int i, int k) {
                if (!(k >= 0)) {
                    boolean bl = false;
                    String string = "negative prefix " + k;
                    throw new IllegalArgumentException(string.toString());
                }
                return this.$points.byteAt(i, k < this.$dimCmpBytes ? this.$dimOffset + k : this.$dataOffset + k) & 0xFF;
            }

            protected void swap(int i, int j) {
                this.$points.swap(i, j);
            }

            protected Sorter getFallbackSorter(int k) {
                int skypedBytes = k + this.$commonPrefixLength;
                int dimStart = this.$dim * BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim();
                return new IntroSorter(this.$points, skypedBytes, this.this$0, dimStart){
                    final /* synthetic */ HeapPointWriter $points;
                    final /* synthetic */ int $skypedBytes;
                    final /* synthetic */ BKDRadixSelector this$0;
                    final /* synthetic */ int $dimStart;
                    {
                        this.$points = $points;
                        this.$skypedBytes = $skypedBytes;
                        this.this$0 = $receiver;
                        this.$dimStart = $dimStart;
                    }

                    protected void swap(int i, int j) {
                        this.$points.swap(i, j);
                    }

                    protected void setPivot(int i) {
                        if (this.$skypedBytes < BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim()) {
                            this.$points.copyDim(i, this.$dimStart, BKDRadixSelector.access$getScratch$p(this.this$0), 0);
                        }
                        this.$points.copyDataDimsAndDoc(i, BKDRadixSelector.access$getScratch$p(this.this$0), BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim());
                    }

                    protected int compare(int i, int j) {
                        int cmp;
                        if (this.$skypedBytes < BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim() && (cmp = this.$points.compareDim(i, j, this.$dimStart)) != 0) {
                            return cmp;
                        }
                        return this.$points.compareDataDimsAndDoc(i, j);
                    }

                    protected int comparePivot(int j) {
                        int cmp;
                        if (this.$skypedBytes < BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim() && (cmp = this.$points.compareDim(j, BKDRadixSelector.access$getScratch$p(this.this$0), 0, this.$dimStart)) != 0) {
                            return cmp;
                        }
                        return this.$points.compareDataDimsAndDoc(j, BKDRadixSelector.access$getScratch$p(this.this$0), BKDRadixSelector.access$getConfig$p(this.this$0).getBytesPerDim());
                    }
                };
            }
        }.sort(from, to);
    }

    private final PointWriter getDeltaPointWriter(PointWriter left, PointWriter right, long delta, int iteration) throws IOException {
        return delta <= (long)this.getMaxPointsSortInHeap(left, right) ? (PointWriter)new HeapPointWriter(this.config, Math.INSTANCE.toIntExact(delta)) : (PointWriter)new OfflinePointWriter(this.config, this.tempDir, this.tempFileNamePrefix, "delta" + iteration, delta);
    }

    private final int getMaxPointsSortInHeap(PointWriter left, PointWriter right) {
        int pointsUsed = 0;
        if (left instanceof HeapPointWriter) {
            pointsUsed += ((HeapPointWriter)left).getSize();
        }
        if (right instanceof HeapPointWriter) {
            pointsUsed += ((HeapPointWriter)right).getSize();
        }
        if (!(this.maxPointsSortInHeap >= pointsUsed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.maxPointsSortInHeap - pointsUsed;
    }

    @NotNull
    public final PointWriter getPointWriter(long count, @NotNull String desc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        if (count <= (long)(this.maxPointsSortInHeap / 2)) {
            int size2 = Math.INSTANCE.toIntExact(count);
            return new HeapPointWriter(this.config, size2);
        }
        return new OfflinePointWriter(this.config, this.tempDir, this.tempFileNamePrefix, desc, count);
    }

    public static final /* synthetic */ BKDConfig access$getConfig$p(BKDRadixSelector $this) {
        return $this.config;
    }

    public static final /* synthetic */ byte[] access$getScratch$p(BKDRadixSelector $this) {
        return $this.scratch;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDRadixSelector$Companion;", "", "<init>", "()V", "HISTOGRAM_SIZE", "", "MAX_SIZE_OFFLINE_BUFFER", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDRadixSelector$PathSlice;", "", "writer", "Lorg/gnit/lucenekmp/util/bkd/PointWriter;", "start", "", "count", "<init>", "(Lorg/gnit/lucenekmp/util/bkd/PointWriter;JJ)V", "getWriter", "()Lorg/gnit/lucenekmp/util/bkd/PointWriter;", "getStart", "()J", "getCount", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    public static final class PathSlice {
        @NotNull
        private final PointWriter writer;
        private final long start;
        private final long count;

        public PathSlice(@NotNull PointWriter writer, long start, long count) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            this.writer = writer;
            this.start = start;
            this.count = count;
        }

        @NotNull
        public final PointWriter getWriter() {
            return this.writer;
        }

        public final long getStart() {
            return this.start;
        }

        public final long getCount() {
            return this.count;
        }

        @NotNull
        public final PointWriter component1() {
            return this.writer;
        }

        public final long component2() {
            return this.start;
        }

        public final long component3() {
            return this.count;
        }

        @NotNull
        public final PathSlice copy(@NotNull PointWriter writer, long start, long count) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            return new PathSlice(writer, start, count);
        }

        public static /* synthetic */ PathSlice copy$default(PathSlice pathSlice, PointWriter pointWriter, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                pointWriter = pathSlice.writer;
            }
            if ((n & 2) != 0) {
                l = pathSlice.start;
            }
            if ((n & 4) != 0) {
                l2 = pathSlice.count;
            }
            return pathSlice.copy(pointWriter, l, l2);
        }

        @NotNull
        public String toString() {
            return "PathSlice(writer=" + this.writer + ", start=" + this.start + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = this.writer.hashCode();
            result = result * 31 + Long.hashCode(this.start);
            result = result * 31 + Long.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathSlice)) {
                return false;
            }
            PathSlice pathSlice = (PathSlice)other;
            if (!Intrinsics.areEqual((Object)this.writer, (Object)pathSlice.writer)) {
                return false;
            }
            if (this.start != pathSlice.start) {
                return false;
            }
            return this.count == pathSlice.count;
        }
    }
}

