/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.MathUtil;
import org.gnit.lucenekmp.util.bkd.BKDConfig;
import org.gnit.lucenekmp.util.bkd.DocIdsWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u000245B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010'\u001a\u00020(H\u0002J\b\u00103\u001a\u00020\u001aH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR\u0011\u0010\u001f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u001a\u0010!\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001c\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000fR\u0014\u0010/\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000fR\u0014\u00101\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000f\u00a8\u00066"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDReader;", "Lorg/gnit/lucenekmp/index/PointValues;", "metaIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "indexIn", "dataIn", "<init>", "(Lorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/store/IndexInput;)V", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "getConfig", "()Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "numLeaves", "", "getNumLeaves", "()I", "in", "getIn", "()Lorg/gnit/lucenekmp/store/IndexInput;", "minPackedValue", "", "getMinPackedValue", "()[B", "maxPackedValue", "getMaxPackedValue", "pointCount", "", "getPointCount", "()J", "docCount", "getDocCount", "version", "getVersion", "minLeafBlockFP", "getMinLeafBlockFP", "setMinLeafBlockFP", "(J)V", "indexStartPointer", "numIndexBytes", "isTreeBalanced", "", "pointTree", "Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "getPointTree", "()Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "numDimensions", "getNumDimensions", "numIndexDimensions", "getNumIndexDimensions", "bytesPerDimension", "getBytesPerDimension", "size", "BKDPointTree", "BKDReaderDocIDSetIterator", "core"})
public final class BKDReader
extends PointValues {
    @NotNull
    private final BKDConfig config;
    private final int numLeaves;
    @NotNull
    private final IndexInput in;
    @NotNull
    private final byte[] minPackedValue;
    @NotNull
    private final byte[] maxPackedValue;
    private final long pointCount;
    private final int docCount;
    private final int version;
    private long minLeafBlockFP;
    private long indexStartPointer;
    private final int numIndexBytes;
    @NotNull
    private final IndexInput indexIn;
    private final boolean isTreeBalanced;

    public BKDReader(@NotNull IndexInput metaIn, @NotNull IndexInput indexIn, @NotNull IndexInput dataIn) {
        Intrinsics.checkNotNullParameter((Object)metaIn, (String)"metaIn");
        Intrinsics.checkNotNullParameter((Object)indexIn, (String)"indexIn");
        Intrinsics.checkNotNullParameter((Object)dataIn, (String)"dataIn");
        this.version = CodecUtil.INSTANCE.checkHeader(metaIn, "BKD", 4, 9);
        int numDims = metaIn.readVInt();
        int numIndexDims = this.version >= 6 ? metaIn.readVInt() : numDims;
        int maxPointsInLeafNode = metaIn.readVInt();
        int bytesPerDim = metaIn.readVInt();
        this.config = new BKDConfig(numDims, numIndexDims, bytesPerDim, maxPointsInLeafNode);
        this.numLeaves = metaIn.readVInt();
        if (!(this.numLeaves > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.minPackedValue = new byte[this.config.packedIndexBytesLength()];
        this.maxPackedValue = new byte[this.config.packedIndexBytesLength()];
        metaIn.readBytes(this.getMinPackedValue(), 0, this.config.packedIndexBytesLength());
        metaIn.readBytes(this.getMaxPackedValue(), 0, this.config.packedIndexBytesLength());
        ArrayUtil.Companion.ByteArrayComparator comparator2 = ArrayUtil.Companion.getUnsignedComparator(this.config.getBytesPerDim());
        int n = this.config.getNumIndexDims();
        for (int dim = 0; dim < n; ++dim) {
            if (comparator2.compare(this.getMinPackedValue(), dim * this.config.getBytesPerDim(), this.getMaxPackedValue(), dim * this.config.getBytesPerDim()) <= 0) continue;
            throw new CorruptIndexException("minPackedValue " + new BytesRef(this.getMinPackedValue()) + " is > maxPackedValue " + new BytesRef(this.getMaxPackedValue()) + " for dim=" + dim, metaIn);
        }
        this.pointCount = metaIn.readVLong();
        this.docCount = metaIn.readVInt();
        this.numIndexBytes = metaIn.readVInt();
        if (this.version >= 9) {
            this.minLeafBlockFP = metaIn.readLong();
            this.indexStartPointer = metaIn.readLong();
        } else {
            this.indexStartPointer = indexIn.getFilePointer();
            this.minLeafBlockFP = indexIn.readVLong();
            indexIn.seek(this.indexStartPointer);
        }
        this.indexIn = indexIn;
        this.in = dataIn;
        this.isTreeBalanced = this.numLeaves != 1 && this.isTreeBalanced();
    }

    @NotNull
    public final BKDConfig getConfig() {
        return this.config;
    }

    public final int getNumLeaves() {
        return this.numLeaves;
    }

    @NotNull
    public final IndexInput getIn() {
        return this.in;
    }

    @Override
    @NotNull
    public byte[] getMinPackedValue() {
        return this.minPackedValue;
    }

    @Override
    @NotNull
    public byte[] getMaxPackedValue() {
        return this.maxPackedValue;
    }

    public final long getPointCount() {
        return this.pointCount;
    }

    @Override
    public int getDocCount() {
        return this.docCount;
    }

    public final int getVersion() {
        return this.version;
    }

    public final long getMinLeafBlockFP() {
        return this.minLeafBlockFP;
    }

    public final void setMinLeafBlockFP(long l) {
        this.minLeafBlockFP = l;
    }

    private final boolean isTreeBalanced() throws IOException {
        if (this.version >= 9) {
            return false;
        }
        if (this.config.getNumDims() > 1) {
            if (!(1 << MathUtil.INSTANCE.log(this.numLeaves, 2) == this.numLeaves)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return true;
        }
        if (1 << MathUtil.INSTANCE.log(this.numLeaves, 2) != this.numLeaves) {
            return false;
        }
        int lastLeafNodePointCount = Math.INSTANCE.toIntExact(this.pointCount % (long)this.config.getMaxPointsInLeafNode());
        PointValues.PointTree pointTree2 = this.getPointTree();
        while (pointTree2.moveToSibling() || pointTree2.moveToChild()) {
        }
        int[] nArray = new int[]{0};
        int[] count = nArray;
        pointTree2.visitDocIDs(new PointValues.IntersectVisitor(count){
            final /* synthetic */ int[] $count;
            {
                this.$count = $count;
            }

            public void visit(int docID) {
                int[] nArray = this.$count;
                int n = nArray[0];
                nArray[0] = n + 1;
            }

            public void visit(DocIdSetIterator iterator2) throws IOException {
                Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                int docID = 0;
                while (true) {
                    int n;
                    int it = n = iterator2.nextDoc();
                    boolean bl = false;
                    docID = it;
                    if (n == Integer.MAX_VALUE) break;
                    this.visit(docID);
                }
            }

            public void visit(IntsRef ref) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                int[] nArray = this.$count;
                nArray[0] = nArray[0] + ref.getLength();
            }

            public void visit(int docID, byte[] packedValue) {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                throw new AssertionError();
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                throw new AssertionError();
            }

            public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
            }

            public void grow(int count) {
                PointValues.IntersectVisitor.super.grow(count);
            }
        });
        return count[0] != lastLeafNodePointCount;
    }

    @Override
    @NotNull
    public PointValues.PointTree getPointTree() {
        return new BKDPointTree(this.indexIn.slice("packedIndex", this.indexStartPointer, this.numIndexBytes), this.in.clone(), this.config, this.numLeaves, this.version, this.pointCount, this.getMinPackedValue(), this.getMaxPackedValue(), this.isTreeBalanced);
    }

    @Override
    public int getNumDimensions() {
        return this.config.getNumDims();
    }

    @Override
    public int getNumIndexDimensions() {
        return this.config.getNumIndexDims();
    }

    @Override
    public int getBytesPerDimension() {
        return this.config.getBytesPerDim();
    }

    @Override
    public long size() {
        return this.pointCount;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u000f\u0012\u0006\u0010\u0015\u001a\u00020\u000f\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bBQ\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001cJ\b\u00103\u001a\u00020\u0001H\u0016J\b\u00104\u001a\u00020\u0019H\u0016J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000206J\u0006\u00108\u001a\u000206J\u0006\u00109\u001a\u000206J\u0006\u0010:\u001a\u000206J\b\u0010;\u001a\u00020\u0019H\u0016J\u0006\u0010<\u001a\u000206J\u000e\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\u000fJ\b\u0010?\u001a\u00020\u0019H\u0016J\u0006\u0010D\u001a\u00020\u0019J\b\u0010G\u001a\u00020\u000bH\u0016J\u0016\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\b2\u0006\u00100\u001a\u00020\bJ.\u0010J\u001a\u00020\b2\u0006\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010O\u001a\u0002062\u0006\u0010P\u001a\u00020QH\u0016J\u0016\u0010R\u001a\u0002062\u0006\u0010P\u001a\u00020Q2\u0006\u0010S\u001a\u00020\u0019J\u0010\u0010T\u001a\u0002062\u0006\u0010P\u001a\u00020QH\u0016J\u000e\u0010U\u001a\u0002062\u0006\u0010P\u001a\u00020QJ\u0016\u0010T\u001a\u0002062\u0006\u0010P\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u000bJ\u001e\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u00032\u0006\u0010Y\u001a\u00020\u000b2\u0006\u0010Z\u001a\u00020\u0012J\u000e\u0010[\u001a\u00020\b2\u0006\u0010M\u001a\u00020\bJ\u000e\u0010\\\u001a\u0002062\u0006\u0010]\u001a\u00020\u0019J\u000e\u0010^\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJF\u0010_\u001a\u0002062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010`\u001a\u00020\b2\u0006\u0010P\u001a\u00020QJF\u0010a\u001a\u0002062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010`\u001a\u00020\b2\u0006\u0010P\u001a\u00020QJ&\u0010b\u001a\u0002062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u0003J6\u0010c\u001a\u0002062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010d\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010`\u001a\u00020\b2\u0006\u0010P\u001a\u00020QJ&\u0010e\u001a\u0002062\u0006\u0010d\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010`\u001a\u00020\b2\u0006\u0010P\u001a\u00020QJ>\u0010f\u001a\u0002062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010d\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010`\u001a\u00020\b2\u0006\u0010P\u001a\u00020Q2\u0006\u0010g\u001a\u00020\bJ\u000e\u0010h\u001a\u00020\b2\u0006\u0010X\u001a\u00020\u0003J\u001e\u0010i\u001a\u0002062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010d\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u0003J\b\u0010j\u001a\u00020kH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\u0010\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0018\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u000e\u0010,\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010@\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\bB\u0010AR\u0011\u0010C\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\bC\u0010AR\u0011\u0010E\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010.\u00a8\u0006l"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDReader$BKDPointTree;", "Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "innerNodes", "Lorg/gnit/lucenekmp/store/IndexInput;", "leafNodes", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "numLeaves", "", "version", "pointCount", "", "nodeID", "level", "minPackedValue", "", "maxPackedValue", "scratchIterator", "Lorg/gnit/lucenekmp/util/bkd/BKDReader$BKDReaderDocIDSetIterator;", "scratchDataPackedValue", "scratchMinIndexPackedValue", "scratchMaxIndexPackedValue", "commonPrefixLengths", "", "isTreeBalanced", "", "<init>", "(Lorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/util/bkd/BKDConfig;IIJII[B[BLorg/gnit/lucenekmp/util/bkd/BKDReader$BKDReaderDocIDSetIterator;[B[B[B[IZ)V", "(Lorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/util/bkd/BKDConfig;IIJ[B[BZ)V", "nodeRoot", "leafBlockFPStack", "", "readNodeDataPositions", "rightNodePositions", "splitDimsPos", "negativeDeltas", "", "splitValuesStack", "", "[[B", "getMinPackedValue", "()[B", "getMaxPackedValue", "splitDimValueStack", "leafNodeOffset", "getPointCount", "()J", "lastLeafNodePointCount", "rightMostLeafNode", "docIdsWriter", "Lorg/gnit/lucenekmp/util/bkd/DocIdsWriter;", "clone", "moveToChild", "resetNodeDataPosition", "", "pushBoundsLeft", "pushLeft", "pushBoundsRight", "pushRight", "moveToSibling", "pop", "popBounds", "packedValue", "moveToParent", "isRootNode", "()Z", "isLeftNode", "isLeafNode", "nodeExists", "leafBlockFP", "getLeafBlockFP", "size", "sizeFromBalancedTree", "leftMostLeafNode", "balanceTreeNodePosition", "minNode", "maxNode", "node", "position", "visitDocIDs", "visitor", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "addAll", "grown", "visitDocValues", "visitLeavesOneByOne", "fp", "readDocIDs", "in", "blockFP", "iterator", "getNumLeavesSlow", "readNodeData", "isLeft", "getTreeDepth", "visitDocValuesNoCardinality", "count", "visitDocValuesWithCardinality", "readMinMax", "visitSparseRawDocValues", "scratchPackedValue", "visitUniqueRawDocValues", "visitCompressedDocValues", "compressedDim", "readCompressedDim", "readCommonPrefixes", "toString", "", "core"})
    @SourceDebugExtension(value={"SMAP\nBKDReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BKDReader.kt\norg/gnit/lucenekmp/util/bkd/BKDReader$BKDPointTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1050:1\n1#2:1051\n*E\n"})
    private static final class BKDPointTree
    implements PointValues.PointTree {
        @NotNull
        private final IndexInput innerNodes;
        @NotNull
        private final IndexInput leafNodes;
        @NotNull
        private final BKDConfig config;
        private final int version;
        private int nodeID;
        private int level;
        private final boolean isTreeBalanced;
        private final int nodeRoot;
        @NotNull
        private final long[] leafBlockFPStack;
        @NotNull
        private final int[] readNodeDataPositions;
        @NotNull
        private final int[] rightNodePositions;
        @NotNull
        private final int[] splitDimsPos;
        @NotNull
        private final boolean[] negativeDeltas;
        @NotNull
        private final byte[][] splitValuesStack;
        @NotNull
        private final byte[] minPackedValue;
        @NotNull
        private final byte[] maxPackedValue;
        @NotNull
        private final byte[][] splitDimValueStack;
        private final int leafNodeOffset;
        private final long pointCount;
        private final int lastLeafNodePointCount;
        private final int rightMostLeafNode;
        @NotNull
        private final byte[] scratchDataPackedValue;
        @NotNull
        private final byte[] scratchMinIndexPackedValue;
        @NotNull
        private final byte[] scratchMaxIndexPackedValue;
        @NotNull
        private final int[] commonPrefixLengths;
        @NotNull
        private final BKDReaderDocIDSetIterator scratchIterator;
        @NotNull
        private final DocIdsWriter docIdsWriter;

        public BKDPointTree(@NotNull IndexInput innerNodes, @NotNull IndexInput leafNodes2, @NotNull BKDConfig config, int numLeaves, int version, long pointCount2, int nodeID, int level, @NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue, @NotNull BKDReaderDocIDSetIterator scratchIterator, @NotNull byte[] scratchDataPackedValue, @NotNull byte[] scratchMinIndexPackedValue, @NotNull byte[] scratchMaxIndexPackedValue, @NotNull int[] commonPrefixLengths, boolean isTreeBalanced2) {
            Intrinsics.checkNotNullParameter((Object)innerNodes, (String)"innerNodes");
            Intrinsics.checkNotNullParameter((Object)leafNodes2, (String)"leafNodes");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            Intrinsics.checkNotNullParameter((Object)scratchIterator, (String)"scratchIterator");
            Intrinsics.checkNotNullParameter((Object)scratchDataPackedValue, (String)"scratchDataPackedValue");
            Intrinsics.checkNotNullParameter((Object)scratchMinIndexPackedValue, (String)"scratchMinIndexPackedValue");
            Intrinsics.checkNotNullParameter((Object)scratchMaxIndexPackedValue, (String)"scratchMaxIndexPackedValue");
            Intrinsics.checkNotNullParameter((Object)commonPrefixLengths, (String)"commonPrefixLengths");
            this.innerNodes = innerNodes;
            this.leafNodes = leafNodes2;
            this.config = config;
            this.version = version;
            this.nodeID = nodeID;
            this.level = level;
            this.isTreeBalanced = isTreeBalanced2;
            this.nodeRoot = this.nodeID;
            byte[] byArray = Arrays.copyOf(minPackedValue, minPackedValue.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            this.minPackedValue = byArray;
            byte[] byArray2 = Arrays.copyOf(maxPackedValue, maxPackedValue.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            this.maxPackedValue = byArray2;
            this.leafNodeOffset = numLeaves;
            int treeDepth = this.getTreeDepth(numLeaves);
            this.splitDimValueStack = new byte[treeDepth][];
            this.splitValuesStack = new byte[treeDepth][];
            this.splitValuesStack[0] = new byte[this.config.packedIndexBytesLength()];
            this.leafBlockFPStack = new long[treeDepth + 1];
            this.readNodeDataPositions = new int[treeDepth + 1];
            this.rightNodePositions = new int[treeDepth];
            this.splitDimsPos = new int[treeDepth];
            this.negativeDeltas = new boolean[this.config.getNumIndexDims() * treeDepth];
            this.pointCount = pointCount2;
            this.rightMostLeafNode = (1 << treeDepth - 1) - 1;
            int lastLeafNodePointCount = Math.INSTANCE.toIntExact(pointCount2 % (long)this.config.getMaxPointsInLeafNode());
            this.lastLeafNodePointCount = lastLeafNodePointCount == 0 ? this.config.getMaxPointsInLeafNode() : lastLeafNodePointCount;
            this.scratchIterator = scratchIterator;
            this.commonPrefixLengths = commonPrefixLengths;
            this.scratchDataPackedValue = scratchDataPackedValue;
            this.scratchMinIndexPackedValue = scratchMinIndexPackedValue;
            this.scratchMaxIndexPackedValue = scratchMaxIndexPackedValue;
            this.docIdsWriter = scratchIterator.getDocIdsWriter();
        }

        @Override
        @NotNull
        public byte[] getMinPackedValue() {
            return this.minPackedValue;
        }

        @Override
        @NotNull
        public byte[] getMaxPackedValue() {
            return this.maxPackedValue;
        }

        public final long getPointCount() {
            return this.pointCount;
        }

        public BKDPointTree(@NotNull IndexInput innerNodes, @NotNull IndexInput leafNodes2, @NotNull BKDConfig config, int numLeaves, int version, long pointCount2, @NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue, boolean isTreeBalanced2) {
            Intrinsics.checkNotNullParameter((Object)innerNodes, (String)"innerNodes");
            Intrinsics.checkNotNullParameter((Object)leafNodes2, (String)"leafNodes");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            this(innerNodes, leafNodes2, config, numLeaves, version, pointCount2, 1, 1, minPackedValue, maxPackedValue, new BKDReaderDocIDSetIterator(config.getMaxPointsInLeafNode()), new byte[config.packedBytesLength()], new byte[config.packedIndexBytesLength()], new byte[config.packedIndexBytesLength()], new int[config.getNumDims()], isTreeBalanced2);
            this.readNodeData(false);
        }

        @Override
        @NotNull
        public PointValues.PointTree clone() {
            BKDPointTree index = new BKDPointTree(this.innerNodes.clone(), this.leafNodes.clone(), this.config, this.leafNodeOffset, this.version, this.pointCount, this.nodeID, this.level, this.getMinPackedValue(), this.getMaxPackedValue(), this.scratchIterator, this.scratchDataPackedValue, this.scratchMinIndexPackedValue, this.scratchMaxIndexPackedValue, this.commonPrefixLengths, this.isTreeBalanced);
            index.leafBlockFPStack[index.level] = this.leafBlockFPStack[this.level];
            if (!this.isLeafNode()) {
                index.rightNodePositions[index.level] = this.rightNodePositions[this.level];
                index.readNodeDataPositions[index.level] = this.readNodeDataPositions[this.level];
                byte[][] byArray = index.splitValuesStack;
                int n = index.level;
                byte[] byArray2 = this.splitValuesStack[this.level];
                Intrinsics.checkNotNull((Object)byArray2);
                byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
                byArray[n] = byArray3;
                System.INSTANCE.arraycopy(this.negativeDeltas, this.level * this.config.getNumIndexDims(), index.negativeDeltas, this.level * this.config.getNumIndexDims(), this.config.getNumIndexDims());
                index.splitDimsPos[this.level] = this.splitDimsPos[this.level];
            }
            return index;
        }

        @Override
        public boolean moveToChild() throws IOException {
            if (this.isLeafNode()) {
                return false;
            }
            this.resetNodeDataPosition();
            this.pushBoundsLeft();
            this.pushLeft();
            return true;
        }

        public final void resetNodeDataPosition() throws IOException {
            if (!((long)this.readNodeDataPositions[this.level] <= this.innerNodes.getFilePointer())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.innerNodes.seek(this.readNodeDataPositions[this.level]);
        }

        public final void pushBoundsLeft() {
            int splitDimPos = this.splitDimsPos[this.level];
            if (this.splitDimValueStack[this.level] == null) {
                this.splitDimValueStack[this.level] = new byte[this.config.getBytesPerDim()];
            }
            byte[] byArray = this.getMaxPackedValue();
            byte[] byArray2 = this.splitDimValueStack[this.level];
            Intrinsics.checkNotNull((Object)byArray2);
            System.INSTANCE.arraycopy(byArray, splitDimPos, byArray2, 0, this.config.getBytesPerDim());
            ArrayUtil.Companion.ByteArrayComparator byteArrayComparator = ArrayUtil.Companion.getUnsignedComparator(this.config.getBytesPerDim());
            byte[] byArray3 = this.getMaxPackedValue();
            byte[] byArray4 = this.splitValuesStack[this.level];
            Intrinsics.checkNotNull((Object)byArray4);
            if (!(byteArrayComparator.compare(byArray3, splitDimPos, byArray4, splitDimPos) >= 0)) {
                boolean bl = false;
                String string = "config.bytesPerDim=" + this.config.getBytesPerDim() + " splitDimPos=" + this.splitDimsPos[this.level] + " config.numIndexDims=" + this.config.getNumIndexDims() + " config.numDims=" + this.config.getNumDims();
                throw new IllegalArgumentException(string.toString());
            }
            byte[] byArray5 = this.splitValuesStack[this.level];
            Intrinsics.checkNotNull((Object)byArray5);
            System.INSTANCE.arraycopy(byArray5, splitDimPos, this.getMaxPackedValue(), splitDimPos, this.config.getBytesPerDim());
        }

        public final void pushLeft() throws IOException {
            this.nodeID *= 2;
            int n = this.level;
            this.level = n + 1;
            this.readNodeData(true);
        }

        public final void pushBoundsRight() {
            int splitDimPos = this.splitDimsPos[this.level];
            if (this.splitDimValueStack[this.level] == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            byte[] byArray = this.getMinPackedValue();
            byte[] byArray2 = this.splitDimValueStack[this.level];
            Intrinsics.checkNotNull((Object)byArray2);
            System.INSTANCE.arraycopy(byArray, splitDimPos, byArray2, 0, this.config.getBytesPerDim());
            ArrayUtil.Companion.ByteArrayComparator byteArrayComparator = ArrayUtil.Companion.getUnsignedComparator(this.config.getBytesPerDim());
            byte[] byArray3 = this.getMinPackedValue();
            byte[] byArray4 = this.splitValuesStack[this.level];
            Intrinsics.checkNotNull((Object)byArray4);
            if (!(byteArrayComparator.compare(byArray3, splitDimPos, byArray4, splitDimPos) <= 0)) {
                boolean bl = false;
                String string = "config.bytesPerDim=" + this.config.getBytesPerDim() + " splitDimPos=" + this.splitDimsPos[this.level] + " config.numIndexDims=" + this.config.getNumIndexDims() + " config.numDims=" + this.config.getNumDims();
                throw new IllegalArgumentException(string.toString());
            }
            byte[] byArray5 = this.splitValuesStack[this.level];
            Intrinsics.checkNotNull((Object)byArray5);
            System.INSTANCE.arraycopy(byArray5, splitDimPos, this.getMinPackedValue(), splitDimPos, this.config.getBytesPerDim());
        }

        public final void pushRight() throws IOException {
            int nodePosition = this.rightNodePositions[this.level];
            if (!((long)nodePosition >= this.innerNodes.getFilePointer())) {
                boolean bl = false;
                String string = "nodePosition = " + nodePosition + " < currentPosition=" + this.innerNodes.getFilePointer();
                throw new IllegalArgumentException(string.toString());
            }
            this.innerNodes.seek(nodePosition);
            this.nodeID = 2 * this.nodeID + 1;
            int n = this.level;
            this.level = n + 1;
            this.readNodeData(false);
        }

        @Override
        public boolean moveToSibling() throws IOException {
            if (!this.isLeftNode() || this.isRootNode()) {
                return false;
            }
            this.pop();
            this.popBounds(this.getMaxPackedValue());
            this.pushBoundsRight();
            this.pushRight();
            if (!this.nodeExists()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return true;
        }

        public final void pop() {
            this.nodeID /= 2;
            int n = this.level;
            this.level = n + -1;
        }

        public final void popBounds(@NotNull byte[] packedValue) {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            byte[] byArray = this.splitDimValueStack[this.level];
            Intrinsics.checkNotNull((Object)byArray);
            System.INSTANCE.arraycopy(byArray, 0, packedValue, this.splitDimsPos[this.level], this.config.getBytesPerDim());
        }

        @Override
        public boolean moveToParent() {
            if (this.isRootNode()) {
                return false;
            }
            byte[] packedValue = this.isLeftNode() ? this.getMaxPackedValue() : this.getMinPackedValue();
            this.pop();
            this.popBounds(packedValue);
            return true;
        }

        public final boolean isRootNode() {
            return this.nodeID == this.nodeRoot;
        }

        public final boolean isLeftNode() {
            return (this.nodeID & 1) == 0;
        }

        public final boolean isLeafNode() {
            return this.nodeID >= this.leafNodeOffset;
        }

        public final boolean nodeExists() {
            return this.nodeID - this.leafNodeOffset < this.leafNodeOffset;
        }

        public final long getLeafBlockFP() {
            if (!this.isLeafNode()) {
                boolean bl = false;
                String string = "nodeID=" + this.nodeID + " is not a leaf";
                throw new IllegalArgumentException(string.toString());
            }
            return this.leafBlockFPStack[this.level];
        }

        @Override
        public long size() {
            int leftMostLeafNode;
            for (leftMostLeafNode = this.nodeID; leftMostLeafNode < this.leafNodeOffset; leftMostLeafNode *= 2) {
            }
            int rightMostLeafNode = this.nodeID;
            while (rightMostLeafNode < this.leafNodeOffset) {
                rightMostLeafNode = rightMostLeafNode * 2 + 1;
            }
            int numLeaves = rightMostLeafNode >= leftMostLeafNode ? rightMostLeafNode - leftMostLeafNode + 1 : rightMostLeafNode - leftMostLeafNode + 1 + this.leafNodeOffset;
            if (!(numLeaves == this.getNumLeavesSlow(this.nodeID))) {
                boolean bl = false;
                String string = numLeaves + " " + this.getNumLeavesSlow(this.nodeID);
                throw new IllegalArgumentException(string.toString());
            }
            if (this.isTreeBalanced) {
                return this.sizeFromBalancedTree(leftMostLeafNode, rightMostLeafNode);
            }
            return rightMostLeafNode == this.rightMostLeafNode ? (long)(numLeaves - 1) * (long)this.config.getMaxPointsInLeafNode() + (long)this.lastLeafNodePointCount : (long)numLeaves * (long)this.config.getMaxPointsInLeafNode();
        }

        public final long sizeFromBalancedTree(int leftMostLeafNode, int rightMostLeafNode) {
            int extraPoints = Math.INSTANCE.toIntExact((long)this.config.getMaxPointsInLeafNode() * (long)this.leafNodeOffset - this.pointCount);
            if (!(extraPoints < this.leafNodeOffset)) {
                boolean $i$a$-require-BKDReader$BKDPointTree$sizeFromBalancedTree$22 = false;
                String $i$a$-require-BKDReader$BKDPointTree$sizeFromBalancedTree$22 = "point excess should be lower than leafNodeOffset";
                throw new IllegalArgumentException($i$a$-require-BKDReader$BKDPointTree$sizeFromBalancedTree$22.toString());
            }
            int nodeOffset = this.leafNodeOffset - extraPoints;
            long count = 0L;
            int node = leftMostLeafNode;
            if (node <= rightMostLeafNode) {
                while (true) {
                    count += (long)(this.balanceTreeNodePosition(0, this.leafNodeOffset, node - this.leafNodeOffset, 0, 0) < nodeOffset ? this.config.getMaxPointsInLeafNode() : this.config.getMaxPointsInLeafNode() - 1);
                    if (node == rightMostLeafNode) break;
                    ++node;
                }
            }
            return count;
        }

        public final int balanceTreeNodePosition(int minNode, int maxNode, int node, int position, int level) {
            if (maxNode - minNode == 1) {
                return position;
            }
            int mid = minNode + maxNode + 1 >>> 1;
            return mid > node ? this.balanceTreeNodePosition(minNode, mid, node, position, level + 1) : this.balanceTreeNodePosition(mid, maxNode, node, position + (1 << level), level + 1);
        }

        @Override
        public void visitDocIDs(@NotNull PointValues.IntersectVisitor visitor2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            this.resetNodeDataPosition();
            this.addAll(visitor2, false);
        }

        public final void addAll(@NotNull PointValues.IntersectVisitor visitor2, boolean grown) throws IOException {
            long size2;
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            boolean grown2 = grown;
            if (!grown2 && (size2 = this.size()) <= Integer.MAX_VALUE) {
                visitor2.grow((int)size2);
                grown2 = true;
            }
            if (this.isLeafNode()) {
                this.leafNodes.seek(this.getLeafBlockFP());
                int count = this.leafNodes.readVInt();
                this.docIdsWriter.readInts(this.leafNodes, count, visitor2);
            } else {
                this.pushLeft();
                this.addAll(visitor2, grown2);
                this.pop();
                this.pushRight();
                this.addAll(visitor2, grown2);
                this.pop();
            }
        }

        @Override
        public void visitDocValues(@NotNull PointValues.IntersectVisitor visitor2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            this.resetNodeDataPosition();
            this.visitLeavesOneByOne(visitor2);
        }

        public final void visitLeavesOneByOne(@NotNull PointValues.IntersectVisitor visitor2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            if (this.isLeafNode()) {
                this.visitDocValues(visitor2, this.getLeafBlockFP());
            } else {
                this.pushLeft();
                this.visitLeavesOneByOne(visitor2);
                this.pop();
                this.pushRight();
                this.visitLeavesOneByOne(visitor2);
                this.pop();
            }
        }

        public final void visitDocValues(@NotNull PointValues.IntersectVisitor visitor2, long fp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            int count = this.readDocIDs(this.leafNodes, fp, this.scratchIterator);
            if (this.version >= 7) {
                this.visitDocValuesWithCardinality(this.commonPrefixLengths, this.scratchDataPackedValue, this.scratchMinIndexPackedValue, this.scratchMaxIndexPackedValue, this.leafNodes, this.scratchIterator, count, visitor2);
            } else {
                this.visitDocValuesNoCardinality(this.commonPrefixLengths, this.scratchDataPackedValue, this.scratchMinIndexPackedValue, this.scratchMaxIndexPackedValue, this.leafNodes, this.scratchIterator, count, visitor2);
            }
        }

        public final int readDocIDs(@NotNull IndexInput in, long blockFP, @NotNull BKDReaderDocIDSetIterator iterator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            in.seek(blockFP);
            int count = in.readVInt();
            this.docIdsWriter.readInts(in, count, iterator2.getDocIDs());
            return count;
        }

        public final int getNumLeavesSlow(int node) {
            if (node >= 2 * this.leafNodeOffset) {
                return 0;
            }
            if (node >= this.leafNodeOffset) {
                return 1;
            }
            int leftCount = this.getNumLeavesSlow(node * 2);
            int rightCount = this.getNumLeavesSlow(node * 2 + 1);
            return leftCount + rightCount;
        }

        public final void readNodeData(boolean isLeft) throws IOException {
            this.leafBlockFPStack[this.level] = this.leafBlockFPStack[this.level - 1];
            if (!isLeft) {
                long[] lArray = this.leafBlockFPStack;
                int n = this.level;
                lArray[n] = lArray[n] + this.innerNodes.readVLong();
            }
            if (!this.isLeafNode()) {
                System.INSTANCE.arraycopy(this.negativeDeltas, (this.level - 1) * this.config.getNumIndexDims(), this.negativeDeltas, this.level * this.config.getNumIndexDims(), this.config.getNumIndexDims());
                this.negativeDeltas[this.level * this.config.getNumIndexDims() + this.splitDimsPos[this.level - 1] / this.config.getBytesPerDim()] = isLeft;
                if (this.splitValuesStack[this.level] == null) {
                    byte[] byArray = this.splitValuesStack[this.level - 1];
                    Intrinsics.checkNotNull((Object)byArray);
                    Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(byArray, byArray.length), (String)"copyOf(...)");
                } else {
                    byte[] byArray = this.splitValuesStack[this.level - 1];
                    Intrinsics.checkNotNull((Object)byArray);
                    byte[] byArray2 = this.splitValuesStack[this.level];
                    Intrinsics.checkNotNull((Object)byArray2);
                    System.INSTANCE.arraycopy(byArray, 0, byArray2, 0, this.config.packedIndexBytesLength());
                }
                int code = this.innerNodes.readVInt();
                int splitDim = code % this.config.getNumIndexDims();
                this.splitDimsPos[this.level] = splitDim * this.config.getBytesPerDim();
                int prefix = (code /= this.config.getNumIndexDims()) % (1 + this.config.getBytesPerDim());
                int suffix = this.config.getBytesPerDim() - prefix;
                if (suffix > 0) {
                    int firstDiffByteDelta = code / (1 + this.config.getBytesPerDim());
                    if (this.negativeDeltas[this.level * this.config.getNumIndexDims() + splitDim]) {
                        firstDiffByteDelta = -firstDiffByteDelta;
                    }
                    int startPos = this.splitDimsPos[this.level] + prefix;
                    byte[] byArray = this.splitValuesStack[this.level];
                    Intrinsics.checkNotNull((Object)byArray);
                    int oldByte = byArray[startPos] & 0xFF;
                    byte[] byArray3 = this.splitValuesStack[this.level];
                    Intrinsics.checkNotNull((Object)byArray3);
                    byArray3[startPos] = (byte)(oldByte + firstDiffByteDelta);
                    byte[] byArray4 = this.splitValuesStack[this.level];
                    Intrinsics.checkNotNull((Object)byArray4);
                    this.innerNodes.readBytes(byArray4, startPos + 1, suffix - 1);
                }
                int leftNumBytes = this.nodeID * 2 < this.leafNodeOffset ? this.innerNodes.readVInt() : 0;
                this.rightNodePositions[this.level] = Math.INSTANCE.toIntExact(this.innerNodes.getFilePointer()) + leftNumBytes;
                this.readNodeDataPositions[this.level] = Math.INSTANCE.toIntExact(this.innerNodes.getFilePointer());
            }
        }

        public final int getTreeDepth(int numLeaves) {
            return MathUtil.INSTANCE.log(numLeaves, 2) + 2;
        }

        public final void visitDocValuesNoCardinality(@NotNull int[] commonPrefixLengths, @NotNull byte[] scratchDataPackedValue, @NotNull byte[] scratchMinIndexPackedValue, @NotNull byte[] scratchMaxIndexPackedValue, @NotNull IndexInput in, @NotNull BKDReaderDocIDSetIterator scratchIterator, int count, @NotNull PointValues.IntersectVisitor visitor2) throws IOException {
            int compressedDim;
            Intrinsics.checkNotNullParameter((Object)commonPrefixLengths, (String)"commonPrefixLengths");
            Intrinsics.checkNotNullParameter((Object)scratchDataPackedValue, (String)"scratchDataPackedValue");
            Intrinsics.checkNotNullParameter((Object)scratchMinIndexPackedValue, (String)"scratchMinIndexPackedValue");
            Intrinsics.checkNotNullParameter((Object)scratchMaxIndexPackedValue, (String)"scratchMaxIndexPackedValue");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)scratchIterator, (String)"scratchIterator");
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            this.readCommonPrefixes(commonPrefixLengths, scratchDataPackedValue, in);
            if (this.config.getNumIndexDims() != 1 && this.version >= 5) {
                byte[] minPackedValue = scratchMinIndexPackedValue;
                System.INSTANCE.arraycopy(scratchDataPackedValue, 0, minPackedValue, 0, this.config.packedIndexBytesLength());
                byte[] maxPackedValue = scratchMaxIndexPackedValue;
                System.INSTANCE.arraycopy(minPackedValue, 0, maxPackedValue, 0, this.config.packedIndexBytesLength());
                this.readMinMax(commonPrefixLengths, minPackedValue, maxPackedValue, in);
                PointValues.Relation r = visitor2.compare(minPackedValue, maxPackedValue);
                if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return;
                }
                visitor2.grow(count);
                if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
                    for (int i = 0; i < count; ++i) {
                        visitor2.visit(scratchIterator.getDocIDs()[i]);
                    }
                    return;
                }
            } else {
                visitor2.grow(count);
            }
            if ((compressedDim = this.readCompressedDim(in)) == -1) {
                this.visitUniqueRawDocValues(scratchDataPackedValue, scratchIterator, count, visitor2);
            } else {
                this.visitCompressedDocValues(commonPrefixLengths, scratchDataPackedValue, in, scratchIterator, count, visitor2, compressedDim);
            }
        }

        public final void visitDocValuesWithCardinality(@NotNull int[] commonPrefixLengths, @NotNull byte[] scratchDataPackedValue, @NotNull byte[] scratchMinIndexPackedValue, @NotNull byte[] scratchMaxIndexPackedValue, @NotNull IndexInput in, @NotNull BKDReaderDocIDSetIterator scratchIterator, int count, @NotNull PointValues.IntersectVisitor visitor2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)commonPrefixLengths, (String)"commonPrefixLengths");
            Intrinsics.checkNotNullParameter((Object)scratchDataPackedValue, (String)"scratchDataPackedValue");
            Intrinsics.checkNotNullParameter((Object)scratchMinIndexPackedValue, (String)"scratchMinIndexPackedValue");
            Intrinsics.checkNotNullParameter((Object)scratchMaxIndexPackedValue, (String)"scratchMaxIndexPackedValue");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)scratchIterator, (String)"scratchIterator");
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            this.readCommonPrefixes(commonPrefixLengths, scratchDataPackedValue, in);
            int compressedDim = this.readCompressedDim(in);
            if (compressedDim == -1) {
                visitor2.grow(count);
                this.visitUniqueRawDocValues(scratchDataPackedValue, scratchIterator, count, visitor2);
            } else {
                if (this.config.getNumIndexDims() != 1) {
                    byte[] minPackedValue = scratchMinIndexPackedValue;
                    System.INSTANCE.arraycopy(scratchDataPackedValue, 0, minPackedValue, 0, this.config.packedIndexBytesLength());
                    byte[] maxPackedValue = scratchMaxIndexPackedValue;
                    System.INSTANCE.arraycopy(minPackedValue, 0, maxPackedValue, 0, this.config.packedIndexBytesLength());
                    this.readMinMax(commonPrefixLengths, minPackedValue, maxPackedValue, in);
                    PointValues.Relation r = visitor2.compare(minPackedValue, maxPackedValue);
                    if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                        return;
                    }
                    visitor2.grow(count);
                    if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
                        for (int i = 0; i < count; ++i) {
                            visitor2.visit(scratchIterator.getDocIDs()[i]);
                        }
                        return;
                    }
                } else {
                    visitor2.grow(count);
                }
                if (compressedDim == -2) {
                    this.visitSparseRawDocValues(commonPrefixLengths, scratchDataPackedValue, in, scratchIterator, count, visitor2);
                } else {
                    this.visitCompressedDocValues(commonPrefixLengths, scratchDataPackedValue, in, scratchIterator, count, visitor2, compressedDim);
                }
            }
        }

        public final void readMinMax(@NotNull int[] commonPrefixLengths, @NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue, @NotNull IndexInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)commonPrefixLengths, (String)"commonPrefixLengths");
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            int n = this.config.getNumIndexDims();
            for (int dim = 0; dim < n; ++dim) {
                int prefix = commonPrefixLengths[dim];
                in.readBytes(minPackedValue, dim * this.config.getBytesPerDim() + prefix, this.config.getBytesPerDim() - prefix);
                in.readBytes(maxPackedValue, dim * this.config.getBytesPerDim() + prefix, this.config.getBytesPerDim() - prefix);
            }
        }

        public final void visitSparseRawDocValues(@NotNull int[] commonPrefixLengths, @NotNull byte[] scratchPackedValue, @NotNull IndexInput in, @NotNull BKDReaderDocIDSetIterator scratchIterator, int count, @NotNull PointValues.IntersectVisitor visitor2) throws IOException {
            int i;
            int length;
            Intrinsics.checkNotNullParameter((Object)commonPrefixLengths, (String)"commonPrefixLengths");
            Intrinsics.checkNotNullParameter((Object)scratchPackedValue, (String)"scratchPackedValue");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)scratchIterator, (String)"scratchIterator");
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            for (i = 0; i < count; i += length) {
                length = in.readVInt();
                int n = this.config.getNumDims();
                for (int dim = 0; dim < n; ++dim) {
                    int prefix = commonPrefixLengths[dim];
                    in.readBytes(scratchPackedValue, dim * this.config.getBytesPerDim() + prefix, this.config.getBytesPerDim() - prefix);
                }
                scratchIterator.reset(i, length);
                visitor2.visit(scratchIterator, scratchPackedValue);
            }
            if (i != count) {
                throw new CorruptIndexException("Sub blocks do not add up to the expected count: " + count + " != " + i, in);
            }
        }

        public final void visitUniqueRawDocValues(@NotNull byte[] scratchPackedValue, @NotNull BKDReaderDocIDSetIterator scratchIterator, int count, @NotNull PointValues.IntersectVisitor visitor2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scratchPackedValue, (String)"scratchPackedValue");
            Intrinsics.checkNotNullParameter((Object)scratchIterator, (String)"scratchIterator");
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            scratchIterator.reset(0, count);
            visitor2.visit(scratchIterator, scratchPackedValue);
        }

        public final void visitCompressedDocValues(@NotNull int[] commonPrefixLengths, @NotNull byte[] scratchPackedValue, @NotNull IndexInput in, @NotNull BKDReaderDocIDSetIterator scratchIterator, int count, @NotNull PointValues.IntersectVisitor visitor2, int compressedDim) throws IOException {
            int i;
            int runLen;
            Intrinsics.checkNotNullParameter((Object)commonPrefixLengths, (String)"commonPrefixLengths");
            Intrinsics.checkNotNullParameter((Object)scratchPackedValue, (String)"scratchPackedValue");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)scratchIterator, (String)"scratchIterator");
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            int compressedByteOffset = compressedDim * this.config.getBytesPerDim() + commonPrefixLengths[compressedDim];
            int n = commonPrefixLengths[compressedDim];
            commonPrefixLengths[compressedDim] = n + 1;
            for (i = 0; i < count; i += runLen) {
                scratchPackedValue[compressedByteOffset] = in.readByte();
                runLen = ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, in.readByte());
                for (int j = 0; j < runLen; ++j) {
                    int n2 = this.config.getNumDims();
                    for (int dim = 0; dim < n2; ++dim) {
                        int prefix = commonPrefixLengths[dim];
                        in.readBytes(scratchPackedValue, dim * this.config.getBytesPerDim() + prefix, this.config.getBytesPerDim() - prefix);
                    }
                    visitor2.visit(scratchIterator.getDocIDs()[i + j], scratchPackedValue);
                }
            }
            if (i != count) {
                throw new CorruptIndexException("Sub blocks do not add up to the expected count: " + count + " != " + i, in);
            }
        }

        public final int readCompressedDim(@NotNull IndexInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            byte compressedDim = in.readByte();
            if (compressedDim < -2 || compressedDim >= this.config.getNumDims() || this.version < 7 && compressedDim == -2) {
                throw new CorruptIndexException("Got compressedDim=" + compressedDim, in);
            }
            return compressedDim;
        }

        public final void readCommonPrefixes(@NotNull int[] commonPrefixLengths, @NotNull byte[] scratchPackedValue, @NotNull IndexInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)commonPrefixLengths, (String)"commonPrefixLengths");
            Intrinsics.checkNotNullParameter((Object)scratchPackedValue, (String)"scratchPackedValue");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            int n = this.config.getNumDims();
            for (int dim = 0; dim < n; ++dim) {
                int prefix;
                commonPrefixLengths[dim] = prefix = in.readVInt();
                if (prefix <= 0) continue;
                in.readBytes(scratchPackedValue, dim * this.config.getBytesPerDim(), prefix);
            }
        }

        @NotNull
        public String toString() {
            return "nodeID=" + this.nodeID;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDReader$BKDReaderDocIDSetIterator;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "maxPointsInLeafNode", "", "<init>", "(I)V", "idx", "length", "offset", "docID", "docIDs", "", "getDocIDs", "()[I", "docIdsWriter", "Lorg/gnit/lucenekmp/util/bkd/DocIdsWriter;", "getDocIdsWriter", "()Lorg/gnit/lucenekmp/util/bkd/DocIdsWriter;", "reset", "", "nextDoc", "advance", "target", "cost", "", "core"})
    private static final class BKDReaderDocIDSetIterator
    extends DocIdSetIterator {
        private int idx;
        private int length;
        private int offset;
        private int docID;
        @NotNull
        private final int[] docIDs;
        @NotNull
        private final DocIdsWriter docIdsWriter;

        public BKDReaderDocIDSetIterator(int maxPointsInLeafNode) {
            this.docIDs = new int[maxPointsInLeafNode];
            this.docIdsWriter = new DocIdsWriter(maxPointsInLeafNode);
        }

        @NotNull
        public final int[] getDocIDs() {
            return this.docIDs;
        }

        @NotNull
        public final DocIdsWriter getDocIdsWriter() {
            return this.docIdsWriter;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        public final void reset(int offset, int length) {
            this.offset = offset;
            this.length = length;
            if (!(offset + length <= this.docIDs.length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.docID = -1;
            this.idx = 0;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.idx == this.length) {
                this.docID = Integer.MAX_VALUE;
            } else {
                this.docID = this.docIDs[this.offset + this.idx];
                int n = this.idx;
                this.idx = n + 1;
            }
            return this.docID;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public long cost() {
            return this.length;
        }
    }
}

