/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J&\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J.\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J&\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDUtil;", "", "<init>", "()V", "getPrefixLengthComparator", "Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "numBytes", "", "commonPrefixLength8", "a", "", "aOffset", "b", "bOffset", "commonPrefixLength4", "commonPrefixLengthN", "getEqualsPredicate", "Lorg/gnit/lucenekmp/util/bkd/BKDUtil$ByteArrayPredicate;", "equals8", "", "equals4", "ByteArrayPredicate", "core"})
public final class BKDUtil {
    @NotNull
    public static final BKDUtil INSTANCE = new BKDUtil();

    private BKDUtil() {
    }

    @NotNull
    public final ArrayUtil.Companion.ByteArrayComparator getPrefixLengthComparator(int numBytes) {
        switch (numBytes) {
            case 8: {
                return BKDUtil::getPrefixLengthComparator$lambda$0;
            }
            case 4: {
                return BKDUtil::getPrefixLengthComparator$lambda$1;
            }
        }
        return (arg_0, arg_1, arg_2, arg_3) -> BKDUtil.getPrefixLengthComparator$lambda$2(numBytes, arg_0, arg_1, arg_2, arg_3);
    }

    public final int commonPrefixLength8(@NotNull byte[] a, int aOffset, @NotNull byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        long aLong = BitUtil.VH_LE_LONG.INSTANCE.get(a, aOffset);
        long bLong = BitUtil.VH_LE_LONG.INSTANCE.get(b, bOffset);
        int commonPrefixInBits = LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, LongExtKt.reverseBytes(LongCompanionObject.INSTANCE, aLong ^ bLong));
        return commonPrefixInBits >>> 3;
    }

    public final int commonPrefixLength4(@NotNull byte[] a, int aOffset, @NotNull byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int aInt = BitUtil.VH_LE_INT.INSTANCE.get(a, aOffset);
        int bInt = BitUtil.VH_LE_INT.INSTANCE.get(b, bOffset);
        int commonPrefixInBits = IntExtKt.numberOfLeadingZeros(IntCompanionObject.INSTANCE, IntExtKt.reverseBytes(IntCompanionObject.INSTANCE, aInt ^ bInt));
        return commonPrefixInBits >>> 3;
    }

    public final int commonPrefixLengthN(@NotNull byte[] a, int aOffset, @NotNull byte[] b, int bOffset, int numBytes) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int cmp = Arrays.INSTANCE.mismatch(a, aOffset, aOffset + numBytes, b, bOffset, bOffset + numBytes);
        return cmp == -1 ? numBytes : cmp;
    }

    @NotNull
    public final ByteArrayPredicate getEqualsPredicate(int numBytes) {
        switch (numBytes) {
            case 8: {
                return BKDUtil::getEqualsPredicate$lambda$3;
            }
            case 4: {
                return BKDUtil::getEqualsPredicate$lambda$4;
            }
        }
        return (arg_0, arg_1, arg_2, arg_3) -> BKDUtil.getEqualsPredicate$lambda$5(numBytes, arg_0, arg_1, arg_2, arg_3);
    }

    public final boolean equals8(@NotNull byte[] a, int aOffset, @NotNull byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        long aLong = BitUtil.VH_LE_LONG.INSTANCE.get(a, aOffset);
        long bLong = BitUtil.VH_LE_LONG.INSTANCE.get(b, bOffset);
        return aLong == bLong;
    }

    public final boolean equals4(@NotNull byte[] a, int aOffset, @NotNull byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int aInt = BitUtil.VH_LE_INT.INSTANCE.get(a, aOffset);
        int bInt = BitUtil.VH_LE_INT.INSTANCE.get(b, bOffset);
        return aInt == bInt;
    }

    private static final int getPrefixLengthComparator$lambda$0(byte[] a, int aOffset, byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return INSTANCE.commonPrefixLength8(a, aOffset, b, bOffset);
    }

    private static final int getPrefixLengthComparator$lambda$1(byte[] a, int aOffset, byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return INSTANCE.commonPrefixLength4(a, aOffset, b, bOffset);
    }

    private static final int getPrefixLengthComparator$lambda$2(int $numBytes, byte[] a, int aOffset, byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return INSTANCE.commonPrefixLengthN(a, aOffset, b, bOffset, $numBytes);
    }

    private static final boolean getEqualsPredicate$lambda$3(byte[] a, int aOffset, byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return INSTANCE.equals8(a, aOffset, b, bOffset);
    }

    private static final boolean getEqualsPredicate$lambda$4(byte[] a, int aOffset, byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return INSTANCE.equals4(a, aOffset, b, bOffset);
    }

    private static final boolean getEqualsPredicate$lambda$5(int $numBytes, byte[] a, int aOffset, byte[] b, int bOffset) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Arrays.INSTANCE.equals(a, aOffset, aOffset + $numBytes, b, bOffset, bOffset + $numBytes);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/bkd/BKDUtil$ByteArrayPredicate;", "", "test", "", "a", "", "aOffset", "", "b", "bOffset", "core"})
    public static interface ByteArrayPredicate {
        public boolean test(@NotNull byte[] var1, int var2, @NotNull byte[] var3, int var4);
    }
}

